/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.rdd.partitioner.RandomPartitionerTokenRangeSplitter;
import com.datastax.spark.connector.rdd.partitioner.dht.BigIntToken;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenRange;
import java.net.InetAddress;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.math.ScalaNumericAnyConversions;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001f\t9#+\u00198e_6\u0004\u0016M\u001d;ji&|g.\u001a:U_.,gNU1oO\u0016\u001c\u0006\u000f\\5ui\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014(BA\u0003\u0007\u0003\r\u0011H\r\u001a\u0006\u0003\u000f!\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003!!\u0017\r^1ti\u0006D(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005\u0015!A\u0004\u0001\u0001\u001e\u0005)!vn[3o%\u0006tw-\u001a\t\u0005=\u0005\u0012c&D\u0001 \u0015\t\u0001#!A\u0002eQRL!\u0001H\u0010\u0011\u0005\rZcB\u0001\u0013*\u001d\t)\u0003&D\u0001'\u0015\t9c\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0011!FE\u0001\ba\u0006\u001c7.Y4f\u0013\taSF\u0001\u0004CS\u001eLe\u000e\u001e\u0006\u0003UI\u0001\"AH\u0018\n\u0005Az\"a\u0003\"jO&sG\u000fV8lK:DQA\r\u0001\u0005\nM\nQ\"Y:tKJ$hj\u001c%pY\u0016\u001cHC\u0001\u001b8!\t\tR'\u0003\u00027%\t!QK\\5u\u0011\u0015A\u0014\u00071\u0001:\u0003-!xn[3o%\u0006tw-Z:\u0011\u0007\rRD(\u0003\u0002<[\t\u00191+Z9\u0011\u0005uZR\"\u0001\u0001\t\u000b}\u0002A\u0011\u0002!\u0002#\u0005\u001c8/\u001a:u'&l\u0017\u000e\\1s'&TX\r\u0006\u00025\u0003\")\u0001H\u0010a\u0001s!)1\t\u0001C\u0001\t\u0006IA/Z:u'Bd\u0017\u000e\u001e\u000b\u0002i!\u0012!I\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bQA[;oSRT\u0011aS\u0001\u0004_J<\u0017BA'I\u0005\u0011!Vm\u001d;\t\u000b=\u0003A\u0011\u0001#\u0002\u0017Q,7\u000f\u001e(p'Bd\u0017\u000e\u001e\u0015\u0003\u001d\u001aCQA\u0015\u0001\u0005\u0002\u0011\u000bA\u0002^3tij+'o\u001c*poND#!\u0015$\t\u000bU\u0003A\u0011\u0001#\u0002\u001dQ,7\u000f^,sCB\f%o\\;oI\"\u0012AK\u0012")
public class RandomPartitionerTokenRangeSplitterTest {
    private void assertNoHoles(Seq<TokenRange<BigInt, BigIntToken>> tokenRanges) {
        tokenRanges.sliding(2).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<TokenRange<BigInt, BigIntToken>> check$ifrefutable$1) {
                Seq<TokenRange<BigInt, BigIntToken>> seq = check$ifrefutable$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                boolean bl = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<TokenRange<BigInt, BigIntToken>> x$1) {
                Seq<TokenRange<BigInt, BigIntToken>> seq = x$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    TokenRange range1 = (TokenRange)((SeqLike)some.get()).apply(0);
                    TokenRange range2 = (TokenRange)((SeqLike)some.get()).apply(1);
                    Assert.assertEquals((Object)range1.end(), (Object)range2.start());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(seq);
            }
        });
    }

    private void assertSimilarSize(Seq<TokenRange<BigInt, BigIntToken>> tokenRanges) {
        Vector sizes = ((TraversableOnce)tokenRanges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BigInt apply(TokenRange<BigInt, BigIntToken> r) {
                return TokenFactory.RandomPartitionerTokenFactory$.MODULE$.distance((BigIntToken)r.start(), (BigIntToken)r.end());
            }
        }, Seq$.MODULE$.canBuildFrom())).toVector();
        double maxSize = ((ScalaNumericAnyConversions)sizes.max((Ordering)Ordering.BigInt$.MODULE$)).toDouble();
        double minSize = ((ScalaNumericAnyConversions)sizes.min((Ordering)Ordering.BigInt$.MODULE$)).toDouble();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxSize / minSize = ", " > 1.01"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(maxSize / minSize))})), (maxSize / minSize <= 1.01 ? 1 : 0) != 0);
    }

    @Test
    public void testSplit() {
        int dataSize = 1000;
        InetAddress node = InetAddress.getLocalHost();
        RandomPartitionerTokenRangeSplitter splitter = new RandomPartitionerTokenRangeSplitter((long)dataSize);
        BigInt rangeLeft = package$.MODULE$.BigInt().apply("0");
        BigInt rangeRight = package$.MODULE$.BigInt().apply("0");
        TokenRange range = new TokenRange((Token)new BigIntToken(rangeLeft), (Token)new BigIntToken(rangeRight), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{node})), (long)dataSize);
        Seq out = splitter.split(range, 100L);
        Assert.assertEquals((long)10L, (long)out.size());
        Assert.assertEquals((Object)rangeLeft, (Object)((BigIntToken)((TokenRange)out.head()).start()).value());
        Assert.assertEquals((Object)rangeRight, (Object)((BigIntToken)((TokenRange)out.last()).end()).value());
        Assert.assertTrue((boolean)out.forall((Function1)new Serializable(this, node){
            public static final long serialVersionUID = 0L;
            private final InetAddress node$1;

            public final boolean apply(TokenRange<BigInt, BigIntToken> x$2) {
                Set set = x$2.replicas();
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node$1}));
                return !(set != null ? !set.equals(genTraversable) : genTraversable != null);
            }
            {
                this.node$1 = node$1;
            }
        }));
        this.assertNoHoles((Seq<TokenRange<BigInt, BigIntToken>>)out);
        this.assertSimilarSize((Seq<TokenRange<BigInt, BigIntToken>>)out);
    }

    @Test
    public void testNoSplit() {
        RandomPartitionerTokenRangeSplitter splitter = new RandomPartitionerTokenRangeSplitter(1000L);
        BigInt rangeLeft = package$.MODULE$.BigInt().apply("0");
        BigInt rangeRight = package$.MODULE$.BigInt().apply("100");
        TokenRange range = new TokenRange((Token)new BigIntToken(rangeLeft), (Token)new BigIntToken(rangeRight), Predef$.MODULE$.Set().empty(), 0L);
        Seq out = splitter.split(range, 500L);
        Assert.assertEquals((long)1L, (long)out.size());
        Assert.assertEquals((Object)rangeLeft, (Object)((BigIntToken)((TokenRange)out.head()).start()).value());
        Assert.assertEquals((Object)rangeRight, (Object)((BigIntToken)((TokenRange)out.last()).end()).value());
    }

    @Test
    public void testZeroRows() {
        RandomPartitionerTokenRangeSplitter splitter = new RandomPartitionerTokenRangeSplitter(0L);
        BigInt rangeLeft = package$.MODULE$.BigInt().apply("0");
        BigInt rangeRight = package$.MODULE$.BigInt().apply("100");
        TokenRange range = new TokenRange((Token)new BigIntToken(rangeLeft), (Token)new BigIntToken(rangeRight), Predef$.MODULE$.Set().empty(), 0L);
        Seq out = splitter.split(range, 500L);
        Assert.assertEquals((long)1L, (long)out.size());
        Assert.assertEquals((Object)rangeLeft, (Object)((BigIntToken)((TokenRange)out.head()).start()).value());
        Assert.assertEquals((Object)rangeRight, (Object)((BigIntToken)((TokenRange)out.last()).end()).value());
    }

    @Test
    public void testWrapAround() {
        int dataSize = 2000;
        RandomPartitionerTokenRangeSplitter splitter = new RandomPartitionerTokenRangeSplitter((long)dataSize);
        BigInt totalTokenCount = TokenFactory.RandomPartitionerTokenFactory$.MODULE$.totalTokenCount();
        BigInt rangeLeft = TokenFactory.RandomPartitionerTokenFactory$.MODULE$.maxToken().value().$minus(totalTokenCount.$div(BigInt$.MODULE$.int2bigInt(4)));
        BigInt rangeRight = TokenFactory.RandomPartitionerTokenFactory$.MODULE$.minToken().value().$plus(totalTokenCount.$div(BigInt$.MODULE$.int2bigInt(4)));
        TokenRange range = new TokenRange((Token)new BigIntToken(rangeLeft), (Token)new BigIntToken(rangeRight), Predef$.MODULE$.Set().empty(), (long)(dataSize / 2));
        Seq out = splitter.split(range, 100L);
        Assert.assertEquals((long)10L, (long)out.size());
        Assert.assertEquals((Object)rangeLeft, (Object)((BigIntToken)((TokenRange)out.head()).start()).value());
        Assert.assertEquals((Object)rangeRight, (Object)((BigIntToken)((TokenRange)out.last()).end()).value());
        this.assertNoHoles((Seq<TokenRange<BigInt, BigIntToken>>)out);
        this.assertSimilarSize((Seq<TokenRange<BigInt, BigIntToken>>)out);
    }
}

