/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.rdd.partitioner.TokenRangeClusterer;
import com.datastax.spark.connector.rdd.partitioner.TokenRangeClusterer$;
import com.datastax.spark.connector.rdd.partitioner.dht.LongToken;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenRange;
import java.net.InetAddress;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u001f\t9Bk\\6f]J\u000bgnZ3DYV\u001cH/\u001a:feR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\u0002]1si&$\u0018n\u001c8fe*\u0011QAB\u0001\u0004e\u0012$'BA\u0004\t\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\tI\u0006$\u0018m\u001d;bq*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\u0006\tq\u0001\u0001!\b\u0002\u000b)>\\WM\u001c*b]\u001e,\u0007\u0003\u0002\u0010\"E\u0015j\u0011a\b\u0006\u0003A\t\t1\u0001\u001a5u\u0013\tar\u0004\u0005\u0002\u0012G%\u0011AE\u0005\u0002\u0005\u0019>tw\r\u0005\u0002\u001fM%\u0011qe\b\u0002\n\u0019>tw\rV8lK:Dq!\u000b\u0001C\u0002\u0013\u0005!&A\u0003o_\u0012,\u0017'F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&A\u0002oKRT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\tY\u0011J\\3u\u0003\u0012$'/Z:t\u0011\u0019!\u0004\u0001)A\u0005W\u00051an\u001c3fc\u0001BqA\u000e\u0001C\u0002\u0013\u0005!&A\u0003o_\u0012,'\u0007\u0003\u00049\u0001\u0001\u0006IaK\u0001\u0007]>$WM\r\u0011\t\u000fi\u0002!\u0019!C\u0001U\u0005)an\u001c3fg!1A\b\u0001Q\u0001\n-\naA\\8eKN\u0002\u0003b\u0002 \u0001\u0005\u0004%\tAK\u0001\u0006]>$W\r\u000e\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u0016\u0002\r9|G-\u001a\u001b!\u0011\u001d\u0011\u0005A1A\u0005\u0002)\nQA\\8eKVBa\u0001\u0012\u0001!\u0002\u0013Y\u0013A\u00028pI\u0016,\u0004\u0005C\u0003G\u0001\u0011%q)A\u0003u_.,g\u000e\u0006\u0002&\u0011\")\u0011*\u0012a\u0001E\u0005\t\u0001\u0010C\u0003L\u0001\u0011\u0005A*A\u0005uKN$X)\u001c9usR\tQ\n\u0005\u0002\u0012\u001d&\u0011qJ\u0005\u0002\u0005+:LG\u000f\u000b\u0002K#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002-\u0006\u0019qN]4\n\u0005a\u001b&\u0001\u0002+fgRDQA\u0017\u0001\u0005\u00021\u000bQ\u0003^3tiR\u0013\u0018N^5bY\u000ecWo\u001d;fe&tw\r\u000b\u0002Z#\")Q\f\u0001C\u0001\u0019\u0006yA/Z:u'Bd\u0017\u000e\u001e\"z\u0011>\u001cH\u000f\u000b\u0002]#\")\u0001\r\u0001C\u0001\u0019\u0006\u0001B/Z:u'Bd\u0017\u000e\u001e\"z\u0007>,h\u000e\u001e\u0015\u0003?FCQa\u0019\u0001\u0005\u00021\u000b!\u0003^3tiR{w\u000eT1sO\u0016\u0014\u0016M\\4fg\"\u0012!-\u0015\u0005\u0006M\u0002!\t\u0001T\u0001\u0016i\u0016\u001cH/T;mi&\u0004H.Z#oIB|\u0017N\u001c;tQ\t)\u0017\u000bC\u0003j\u0001\u0011\u0005A*\u0001\nuKN$X*\u0019=DYV\u001cH/\u001a:TSj,\u0007F\u00015R\u0001")
public class TokenRangeClustererTest {
    private final InetAddress node1 = InetAddress.getByName("192.168.123.1");
    private final InetAddress node2 = InetAddress.getByName("192.168.123.2");
    private final InetAddress node3 = InetAddress.getByName("192.168.123.3");
    private final InetAddress node4 = InetAddress.getByName("192.168.123.4");
    private final InetAddress node5 = InetAddress.getByName("192.168.123.5");

    public InetAddress node1() {
        return this.node1;
    }

    public InetAddress node2() {
        return this.node2;
    }

    public InetAddress node3() {
        return this.node3;
    }

    public InetAddress node4() {
        return this.node4;
    }

    public InetAddress node5() {
        return this.node5;
    }

    private LongToken token(long x) {
        return new LongToken(x);
    }

    @Test
    public void testEmpty() {
        TokenRangeClusterer trc = new TokenRangeClusterer(10L, TokenRangeClusterer$.MODULE$.$lessinit$greater$default$2());
        Iterable groups = trc.group((Seq)Seq$.MODULE$.empty());
        Assert.assertEquals((long)0L, (long)groups.size());
    }

    @Test
    public void testTrivialClustering() {
        TokenRange tr1 = new TokenRange((Token)this.token(0L), (Token)this.token(10L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 5L);
        TokenRange tr2 = new TokenRange((Token)this.token(10L), (Token)this.token(20L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 5L);
        TokenRangeClusterer trc = new TokenRangeClusterer(10L, TokenRangeClusterer$.MODULE$.$lessinit$greater$default$2());
        Iterable groups = trc.group((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1, tr2})));
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1, tr2})), (Object)((TraversableOnce)groups.head()).toSet());
    }

    @Test
    public void testSplitByHost() {
        TokenRange tr1 = new TokenRange((Token)this.token(0L), (Token)this.token(10L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 2L);
        TokenRange tr2 = new TokenRange((Token)this.token(10L), (Token)this.token(20L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 2L);
        TokenRange tr3 = new TokenRange((Token)this.token(20L), (Token)this.token(30L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node2()})), 2L);
        TokenRange tr4 = new TokenRange((Token)this.token(30L), (Token)this.token(40L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node2()})), 2L);
        TokenRangeClusterer trc = new TokenRangeClusterer(10L, TokenRangeClusterer$.MODULE$.$lessinit$greater$default$2());
        Set groups = ((TraversableOnce)trc.group((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1, tr2, tr3, tr4}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<TokenRange<Object, LongToken>> apply(Seq<TokenRange<Object, LongToken>> x$1) {
                return x$1.toSet();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertTrue((boolean)groups.contains((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1, tr2}))));
        Assert.assertTrue((boolean)groups.contains((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr3, tr4}))));
    }

    @Test
    public void testSplitByCount() {
        TokenRange tr1 = new TokenRange((Token)this.token(0L), (Token)this.token(10L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 5L);
        TokenRange tr2 = new TokenRange((Token)this.token(10L), (Token)this.token(20L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 5L);
        TokenRange tr3 = new TokenRange((Token)this.token(20L), (Token)this.token(30L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 5L);
        TokenRange tr4 = new TokenRange((Token)this.token(30L), (Token)this.token(40L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 5L);
        TokenRangeClusterer trc = new TokenRangeClusterer(10L, TokenRangeClusterer$.MODULE$.$lessinit$greater$default$2());
        Set groups = ((TraversableOnce)trc.group((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1, tr2, tr3, tr4}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<TokenRange<Object, LongToken>> apply(Seq<TokenRange<Object, LongToken>> x$2) {
                return x$2.toSet();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertTrue((boolean)groups.contains((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1, tr2}))));
        Assert.assertTrue((boolean)groups.contains((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr3, tr4}))));
    }

    @Test
    public void testTooLargeRanges() {
        TokenRange tr1 = new TokenRange((Token)this.token(0L), (Token)this.token(10L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 100000L);
        TokenRange tr2 = new TokenRange((Token)this.token(10L), (Token)this.token(20L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1()})), 100000L);
        TokenRangeClusterer trc = new TokenRangeClusterer(10L, TokenRangeClusterer$.MODULE$.$lessinit$greater$default$2());
        Set groups = ((TraversableOnce)trc.group((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1, tr2}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<TokenRange<Object, LongToken>> apply(Seq<TokenRange<Object, LongToken>> x$3) {
                return x$3.toSet();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertTrue((boolean)groups.contains((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1}))));
        Assert.assertTrue((boolean)groups.contains((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr2}))));
    }

    @Test
    public void testMultipleEndpoints() {
        TokenRange tr1 = new TokenRange((Token)this.token(0L), (Token)this.token(10L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node2(), this.node1(), this.node3()})), 1L);
        TokenRange tr2 = new TokenRange((Token)this.token(10L), (Token)this.token(20L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1(), this.node3(), this.node4()})), 1L);
        TokenRange tr3 = new TokenRange((Token)this.token(20L), (Token)this.token(30L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node3(), this.node1(), this.node5()})), 1L);
        TokenRange tr4 = new TokenRange((Token)this.token(30L), (Token)this.token(40L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node3(), this.node1(), this.node4()})), 1L);
        TokenRangeClusterer trc = new TokenRangeClusterer(10L, TokenRangeClusterer$.MODULE$.$lessinit$greater$default$2());
        Iterable groups = trc.group((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1, tr2, tr3, tr4})));
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)4L, (long)((SeqLike)groups.head()).size());
        Assert.assertFalse((boolean)((SetLike)((TraversableOnce)((TraversableLike)groups.head()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<InetAddress> apply(TokenRange<Object, LongToken> x$4) {
                return x$4.replicas();
            }
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<InetAddress> apply(Set<InetAddress> x$5, Set<InetAddress> x$6) {
                return (Set)x$5.intersect(x$6);
            }
        })).isEmpty());
    }

    @Test
    public void testMaxClusterSize() {
        TokenRange tr1 = new TokenRange((Token)this.token(0L), (Token)this.token(10L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1(), this.node2(), this.node3()})), 1L);
        TokenRange tr2 = new TokenRange((Token)this.token(10L), (Token)this.token(20L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1(), this.node2(), this.node3()})), 1L);
        TokenRange tr3 = new TokenRange((Token)this.token(20L), (Token)this.token(30L), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{this.node1(), this.node2(), this.node3()})), 1L);
        TokenRangeClusterer trc = new TokenRangeClusterer(10L, 1);
        Iterable groups = trc.group((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TokenRange[]{tr1, tr2, tr3})));
        Assert.assertEquals((long)3L, (long)groups.size());
    }
}

