/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.types;

import com.datastax.spark.connector.types.AsciiType$;
import com.datastax.spark.connector.types.BigIntType$;
import com.datastax.spark.connector.types.BooleanType$;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.CounterType$;
import com.datastax.spark.connector.types.DecimalType$;
import com.datastax.spark.connector.types.DoubleType$;
import com.datastax.spark.connector.types.FloatType$;
import com.datastax.spark.connector.types.InetType$;
import com.datastax.spark.connector.types.IntType$;
import com.datastax.spark.connector.types.ListType;
import com.datastax.spark.connector.types.MapType;
import com.datastax.spark.connector.types.SetType;
import com.datastax.spark.connector.types.TextType$;
import com.datastax.spark.connector.types.TimeUUIDType$;
import com.datastax.spark.connector.types.TimestampType$;
import com.datastax.spark.connector.types.UUIDType$;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u001b\t)B+\u001f9f'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u0015!\u0018\u0010]3t\u0015\t)a!A\u0005d_:tWm\u0019;pe*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\t\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0013Y\u0012!\u0005;fgR\u001cVM]5bY&T\u0018\r^5p]R\u0011Ad\b\t\u0003\u001fuI!A\b\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006Ae\u0001\r!I\u0001\u0002iB\u0012!e\n\t\u00041\r*\u0013B\u0001\u0013\u0003\u0005)\u0019u\u000e\\;n]RK\b/\u001a\t\u0003M\u001db\u0001\u0001B\u0005)?\u0005\u0005\t\u0011!B\u0001S\t\u0019q\fJ\u0019\u0012\u0005)j\u0003CA\b,\u0013\ta\u0003CA\u0004O_RD\u0017N\\4\u0011\u0005=q\u0013BA\u0018\u0011\u0005\r\te.\u001f\u0005\u0006c\u0001!\tAM\u0001\"i\u0016\u001cHoU3sS\u0006d\u0017N_1uS>twJ\u001a)sS6LG/\u001b<f)f\u0004Xm\u001d\u000b\u00029!\u0012\u0001\u0007\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\nQA[;oSRT\u0011!O\u0001\u0004_J<\u0017BA\u001e7\u0005\u0011!Vm\u001d;\t\u000bu\u0002A\u0011\u0001\u001a\u0002EQ,7\u000f^*fe&\fG.\u001b>bi&|gn\u00144D_2dWm\u0019;j_:$\u0016\u0010]3tQ\taD\u0007")
public class TypeSerializationTest {
    private void testSerialization(ColumnType<?> t) {
        Assert.assertEquals(t, (Object)SerializationUtils.roundtrip(t));
    }

    @Test
    public void testSerializationOfPrimitiveTypes() {
        this.testSerialization((ColumnType<?>)AsciiType$.MODULE$);
        this.testSerialization((ColumnType<?>)TextType$.MODULE$);
        this.testSerialization((ColumnType<?>)IntType$.MODULE$);
        this.testSerialization((ColumnType<?>)BigIntType$.MODULE$);
        this.testSerialization((ColumnType<?>)DoubleType$.MODULE$);
        this.testSerialization((ColumnType<?>)FloatType$.MODULE$);
        this.testSerialization((ColumnType<?>)BooleanType$.MODULE$);
        this.testSerialization((ColumnType<?>)UUIDType$.MODULE$);
        this.testSerialization((ColumnType<?>)TimeUUIDType$.MODULE$);
        this.testSerialization((ColumnType<?>)TimestampType$.MODULE$);
        this.testSerialization((ColumnType<?>)DecimalType$.MODULE$);
        this.testSerialization((ColumnType<?>)BigIntType$.MODULE$);
        this.testSerialization((ColumnType<?>)InetType$.MODULE$);
        this.testSerialization((ColumnType<?>)CounterType$.MODULE$);
    }

    @Test
    public void testSerializationOfCollectionTypes() {
        this.testSerialization((ColumnType<?>)new ListType((ColumnType)IntType$.MODULE$));
        this.testSerialization((ColumnType<?>)new ListType((ColumnType)new ListType((ColumnType)IntType$.MODULE$)));
        this.testSerialization((ColumnType<?>)new SetType((ColumnType)TextType$.MODULE$));
        this.testSerialization((ColumnType<?>)new MapType((ColumnType)BigIntType$.MODULE$, (ColumnType)TimestampType$.MODULE$));
    }
}

