/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.writer.AsyncExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!2A!\u0001\u0002\u0001\u001b\t\t\u0012i]=oG\u0016CXmY;u_J$Vm\u001d;\u000b\u0005\r!\u0011AB<sSR,'O\u0003\u0002\u0006\r\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\u0011\u0011\fG/Y:uCbT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0011!Xm\u001d;\u0015\u0003q\u0001\"aD\u000f\n\u0005y\u0001\"\u0001B+oSRD#!\u0007\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013!\u00026v]&$(\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(E\t!A+Z:u\u0001")
public class AsyncExecutorTest {
    @Test
    public void test() {
        int taskCount = 20;
        int maxParallel = 5;
        AtomicInteger currentlyRunningCounter = new AtomicInteger(0);
        AtomicInteger maxParallelCounter = new AtomicInteger(0);
        AtomicInteger totalFinishedExecutionsCounter = new AtomicInteger(0);
        Callable<String> task = new Callable<String>(this, currentlyRunningCounter, maxParallelCounter, totalFinishedExecutionsCounter){
            private final AtomicInteger currentlyRunningCounter$1;
            private final AtomicInteger maxParallelCounter$1;
            private final AtomicInteger totalFinishedExecutionsCounter$1;

            public String call() {
                int c = this.currentlyRunningCounter$1.incrementAndGet();
                int m = this.maxParallelCounter$1.get();
                while (m < c && !this.maxParallelCounter$1.compareAndSet(m, c)) {
                    m = this.maxParallelCounter$1.get();
                }
                Thread.sleep(100L);
                this.currentlyRunningCounter$1.decrementAndGet();
                this.totalFinishedExecutionsCounter$1.incrementAndGet();
                return "ok";
            }
            {
                this.currentlyRunningCounter$1 = currentlyRunningCounter$1;
                this.maxParallelCounter$1 = maxParallelCounter$1;
                this.totalFinishedExecutionsCounter$1 = totalFinishedExecutionsCounter$1;
            }
        };
        ListeningExecutorService underlyingExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        AsyncExecutor asyncExecutor = new AsyncExecutor((Function1)new Serializable(this, underlyingExecutor){
            public static final long serialVersionUID = 0L;
            private final ListeningExecutorService underlyingExecutor$1;

            public final ListenableFuture<String> apply(Callable<String> x$1) {
                return this.underlyingExecutor$1.submit(x$1);
            }
            {
                this.underlyingExecutor$1 = underlyingExecutor$1;
            }
        }, maxParallel, (Option)None$.MODULE$, (Option)None$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), taskCount).foreach((Function1)new Serializable(this, task, asyncExecutor){
            public static final long serialVersionUID = 0L;
            private final Callable task$1;
            private final AsyncExecutor asyncExecutor$1;

            public final ListenableFuture<String> apply(int i) {
                return this.asyncExecutor$1.executeAsync((Object)this.task$1);
            }
            {
                this.task$1 = task$1;
                this.asyncExecutor$1 = asyncExecutor$1;
            }
        });
        asyncExecutor.waitForCurrentlyExecutingTasks();
        Assert.assertEquals((long)maxParallel, (long)maxParallelCounter.get());
        Assert.assertEquals((long)taskCount, (long)totalFinishedExecutionsCounter.get());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)asyncExecutor.successful()));
    }
}

