/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.writer.PropertyExtractor;
import com.datastax.spark.connector.writer.PropertyExtractor$;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u001b\t)\u0002K]8qKJ$\u00180\u0012=ue\u0006\u001cGo\u001c:UKN$(BA\u0002\u0005\u0003\u00199(/\u001b;fe*\u0011QAB\u0001\nG>tg.Z2u_JT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003-\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!A\u0002\u0003\u001b\u0001\u0001Y\"!\u0003+fgR\u001cE.Y:t'\tIb\u0002\u0003\u0005\u001e3\t\u0015\r\u0011\"\u0001\u001f\u0003\u00191\u0017.\u001a7ecU\tq\u0004\u0005\u0002!G9\u0011q\"I\u0005\u0003EA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0013&\u0005\u0019\u0019FO]5oO*\u0011!\u0005\u0005\u0005\tOe\u0011\t\u0011)A\u0005?\u00059a-[3mIF\u0002\u0003\u0002C\u0015\u001a\u0005\u000b\u0007I\u0011\u0001\u0016\u0002\r\u0019LW\r\u001c33+\u0005Y\u0003CA\b-\u0013\ti\u0003CA\u0002J]RD\u0001bL\r\u0003\u0002\u0003\u0006IaK\u0001\bM&,G\u000e\u001a\u001a!\u0011\u0015)\u0012\u0004\"\u00012)\r\u0011D'\u000e\t\u0003gei\u0011\u0001\u0001\u0005\u0006;A\u0002\ra\b\u0005\u0006SA\u0002\ra\u000b\u0005\u0006o\u0001!\t\u0001O\u0001\u0015i\u0016\u001cHoU5na2,W\t\u001f;sC\u000e$\u0018n\u001c8\u0015\u0003e\u0002\"a\u0004\u001e\n\u0005m\u0002\"\u0001B+oSRD#AN\u001f\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015!\u00026v]&$(\"\u0001\"\u0002\u0007=\u0014x-\u0003\u0002E\u007f\t!A+Z:u\u0011\u00151\u0005\u0001\"\u00019\u0003]!Xm\u001d;Bm\u0006LG.\u00192mKB\u0013x\u000e]3si&,7\u000f\u000b\u0002F{!)\u0011\n\u0001C\u0001q\u0005)B/Z:u/J|gn\u001a)s_B,'\u000f^=OC6,\u0007\u0006\u0002%>\u00172\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u001bB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0005Y\u0006twMC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Q{%!\u0006(p'V\u001c\u0007.T3uQ>$W\t_2faRLwN\u001c")
public class PropertyExtractorTest {
    @Test
    public void testSimpleExtraction() {
        TestClass testObject = new TestClass(this, "a", 1);
        PropertyExtractor propertyExtractor = new PropertyExtractor(TestClass.class, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"field1", "field2"})));
        Object[] result = propertyExtractor.extract((Object)testObject);
        Assert.assertEquals((long)2L, (long)Predef$.MODULE$.refArrayOps(result).size());
        Assert.assertEquals((Object)"a", (Object)result[0]);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)result[1]);
    }

    @Test
    public void testAvailableProperties() {
        Seq triedProperties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"field1", "foo", "bar"}));
        Seq availableProperties = PropertyExtractor$.MODULE$.availablePropertyNames(TestClass.class, triedProperties);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"field1"})), (Object)availableProperties);
    }

    @Test(expected=NoSuchMethodException.class)
    public void testWrongPropertyName() {
        TestClass testObject = new TestClass(this, "a", 1);
        PropertyExtractor propertyExtractor = new PropertyExtractor(TestClass.class, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        propertyExtractor.extract((Object)testObject);
    }

    public class TestClass {
        private final String field1;
        private final int field2;
        public final /* synthetic */ PropertyExtractorTest $outer;

        public String field1() {
            return this.field1;
        }

        public int field2() {
            return this.field2;
        }

        public /* synthetic */ PropertyExtractorTest com$datastax$spark$connector$writer$PropertyExtractorTest$TestClass$$$outer() {
            return this.$outer;
        }

        public TestClass(PropertyExtractorTest $outer, String field1, int field2) {
            this.field1 = field1;
            this.field2 = field2;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

