/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.List;

public abstract class Clause
extends Utils.Appendeable {
    abstract String name();

    abstract Object firstValue();

    static class CompoundClause
    extends Clause {
        private String op;
        private final List<String> names;
        private final List<?> values;

        CompoundClause(List<String> names, String op, List<?> values) {
            assert (names.size() == values.size());
            this.op = op;
            this.names = names;
            this.values = values;
        }

        @Override
        String name() {
            return null;
        }

        @Override
        Object firstValue() {
            return null;
        }

        @Override
        boolean containsBindMarker() {
            for (Object value2 : this.values) {
                if (!Utils.containsBindMarker(value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            int i;
            sb.append("(");
            for (i = 0; i < this.names.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Utils.appendName(this.names.get(i), sb);
            }
            sb.append(")").append(this.op).append("(");
            for (i = 0; i < this.values.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Utils.appendValue(this.values.get(i), codecRegistry, sb, variables);
            }
            sb.append(")");
        }
    }

    static class ContainsKeyClause
    extends AbstractClause {
        private final Object value;

        ContainsKeyClause(String name, Object value2) {
            super(name);
            this.value = value2;
            if (value2 == null) {
                throw new IllegalArgumentException("Missing value for CONTAINS KEY clause");
            }
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            Utils.appendName(this.name, sb).append(" CONTAINS KEY ");
            Utils.appendValue(this.value, codecRegistry, sb, variables);
        }

        @Override
        Object firstValue() {
            return this.value;
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }
    }

    static class ContainsClause
    extends AbstractClause {
        private final Object value;

        ContainsClause(String name, Object value2) {
            super(name);
            this.value = value2;
            if (value2 == null) {
                throw new IllegalArgumentException("Missing value for CONTAINS clause");
            }
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            Utils.appendName(this.name, sb).append(" CONTAINS ");
            Utils.appendValue(this.value, codecRegistry, sb, variables);
        }

        @Override
        Object firstValue() {
            return this.value;
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }
    }

    static class InClause
    extends AbstractClause {
        private final List<?> values;

        InClause(String name, List<?> values) {
            super(name);
            this.values = values;
            if (values == null) {
                throw new IllegalArgumentException("Missing values for IN clause");
            }
            if (values.size() > 65535) {
                throw new IllegalArgumentException("Too many values for IN clause, the maximum allowed is 65535");
            }
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            if (this.values.size() == 1 && this.values.get(0) instanceof BindMarker) {
                Utils.appendName(this.name, sb).append(" IN ").append(this.values.get(0));
                return;
            }
            Utils.appendName(this.name, sb).append(" IN (");
            Utils.joinAndAppendValues(sb, codecRegistry, ",", this.values, variables).append(')');
        }

        @Override
        Object firstValue() {
            return this.values.isEmpty() ? null : this.values.get(0);
        }

        @Override
        boolean containsBindMarker() {
            for (Object value2 : this.values) {
                if (!Utils.containsBindMarker(value2)) continue;
                return true;
            }
            return false;
        }
    }

    static class SimpleClause
    extends AbstractClause {
        private final String op;
        private final Object value;

        SimpleClause(String name, String op, Object value2) {
            super(name);
            this.op = op;
            this.value = value2;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            Utils.appendName(this.name, sb).append(this.op);
            Utils.appendValue(this.value, codecRegistry, sb, variables);
        }

        @Override
        Object firstValue() {
            return this.value;
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }
    }

    private static abstract class AbstractClause
    extends Clause {
        final String name;

        private AbstractClause(String name) {
            this.name = name;
        }

        @Override
        String name() {
            return this.name;
        }
    }
}

