/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$class;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy$;
import com.datastax.spark.connector.cql.MultipleRetryPolicy;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class DefaultConnectionFactory$
implements CassandraConnectionFactory {
    public static final DefaultConnectionFactory$ MODULE$;

    static {
        new DefaultConnectionFactory$();
    }

    @Override
    public Set<String> properties() {
        return CassandraConnectionFactory$class.properties(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cluster.Builder clusterBuilder(CassandraConnectorConf conf) {
        Cluster.Builder builder;
        SocketOptions options = new SocketOptions().setConnectTimeoutMillis(conf.connectTimeoutMillis()).setReadTimeoutMillis(conf.readTimeoutMillis());
        Cluster.Builder builder2 = Cluster.builder().addContactPoints((InetAddress[])conf.hosts().toSeq().toArray(ClassTag$.MODULE$.apply(InetAddress.class))).withPort(conf.port()).withRetryPolicy(new MultipleRetryPolicy(conf.queryRetryCount())).withReconnectionPolicy(new ExponentialReconnectionPolicy(conf.minReconnectionDelayMillis(), conf.maxReconnectionDelayMillis())).withLoadBalancingPolicy(new LocalNodeFirstLoadBalancingPolicy(conf.hosts(), conf.localDC(), LocalNodeFirstLoadBalancingPolicy$.MODULE$.$lessinit$greater$default$3())).withAuthProvider(conf.authConf().authProvider()).withSocketOptions(options).withCompression(conf.compression()).withQueryOptions(new QueryOptions().setRefreshNodeIntervalMillis(0).setRefreshNodeListIntervalMillis(0).setRefreshSchemaIntervalMillis(0));
        if (conf.cassandraSSLConf().enabled()) {
            Cluster.Builder builder3;
            Option<SSLOptions> option = this.maybeCreateSSLOptions(conf.cassandraSSLConf());
            if (option instanceof Some) {
                Some some = (Some)option;
                SSLOptions sslOptions = (SSLOptions)some.x();
                builder3 = builder2.withSSL(sslOptions);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                builder3 = builder2.withSSL();
            }
            builder = builder3;
            return builder;
        } else {
            builder = builder2;
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private Option<KeyStore> getKeyStore(String ksType, Option<String> ksPassword, Option<Path> ksPath) {
        Option<Path> option;
        block6: {
            None$ none$;
            block5: {
                block4: {
                    Some some;
                    option = ksPath;
                    if (!(option instanceof Some)) break block4;
                    Some some2 = (Some)option;
                    Path path = (Path)some2.x();
                    InputStream ksIn = Files.newInputStream(path, new OpenOption[0]);
                    try {
                        KeyStore keyStore2 = KeyStore.getInstance(ksType);
                        keyStore2.load(ksIn, (char[])ksPassword.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final char[] apply(String x$1) {
                                return x$1.toCharArray();
                            }
                        }).orNull(Predef$.MODULE$.$conforms()));
                        some = new Some((Object)keyStore2);
                    }
                    catch (Throwable throwable) {
                        void var7_7;
                        IOUtils.closeQuietly((InputStream)var7_7);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)ksIn);
                    none$ = some;
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    private Option<SSLOptions> maybeCreateSSLOptions(CassandraConnectorConf.CassandraSSLConf conf) {
        None$ none$;
        ObjectRef trustStore$lzy = ObjectRef.zero();
        ObjectRef keyStore$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        if (conf.enabled()) {
            Option trustManagerFactory = this.trustStore$1(conf, trustStore$lzy, bitmap$0).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final TrustManagerFactory apply(KeyStore ts) {
                    void var2_2;
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ts);
                    return var2_2;
                }
            });
            None$ keyManagerFactory = conf.clientAuthEnabled() ? this.keyStore$1(conf, keyStore$lzy, bitmap$0).map((Function1)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final CassandraConnectorConf.CassandraSSLConf conf$1;

                /*
                 * WARNING - void declaration
                 */
                public final KeyManagerFactory apply(KeyStore ks) {
                    void var2_2;
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, (char[])this.conf$1.keyStorePassword().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final char[] apply(String x$4) {
                            return x$4.toCharArray();
                        }
                    }).orNull(Predef$.MODULE$.$conforms()));
                    return var2_2;
                }
                {
                    this.conf$1 = conf$1;
                }
            }) : None$.MODULE$;
            SSLContext context = SSLContext.getInstance(conf.protocol());
            context.init((KeyManager[])keyManagerFactory.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final KeyManager[] apply(KeyManagerFactory x$5) {
                    return x$5.getKeyManagers();
                }
            }).orNull(Predef$.MODULE$.$conforms()), (TrustManager[])trustManagerFactory.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TrustManager[] apply(TrustManagerFactory x$6) {
                    return x$6.getTrustManagers();
                }
            }).orNull(Predef$.MODULE$.$conforms()), new SecureRandom());
            none$ = new Some((Object)JdkSSLOptions.builder().withSSLContext(context).withCipherSuites((String[])conf.enabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class))).build());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Cluster createCluster(CassandraConnectorConf conf) {
        return this.clusterBuilder(conf).build();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Option trustStore$lzycompute$1(CassandraConnectorConf.CassandraSSLConf conf$1, ObjectRef trustStore$lzy$1, VolatileByteRef bitmap$0$1) {
        DefaultConnectionFactory$ defaultConnectionFactory$ = this;
        synchronized (defaultConnectionFactory$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                trustStore$lzy$1.elem = this.getKeyStore(conf$1.trustStoreType(), conf$1.trustStorePassword(), (Option<Path>)conf$1.trustStorePath().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(String x$2) {
                        return Paths.get(x$2, new String[0]);
                    }
                }));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Option)trustStore$lzy$1.elem;
        }
    }

    private final Option trustStore$1(CassandraConnectorConf.CassandraSSLConf conf$1, ObjectRef trustStore$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.trustStore$lzycompute$1(conf$1, trustStore$lzy$1, bitmap$0$1) : (Option)trustStore$lzy$1.elem;
    }

    private final Option keyStore$lzycompute$1(CassandraConnectorConf.CassandraSSLConf conf$1, ObjectRef keyStore$lzy$1, VolatileByteRef bitmap$0$1) {
        DefaultConnectionFactory$ defaultConnectionFactory$ = this;
        synchronized (defaultConnectionFactory$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                keyStore$lzy$1.elem = this.getKeyStore(conf$1.keyStoreType(), conf$1.keyStorePassword(), (Option<Path>)conf$1.keyStorePath().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(String x$3) {
                        return Paths.get(x$3, new String[0]);
                    }
                }));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (Option)keyStore$lzy$1.elem;
        }
    }

    private final Option keyStore$1(CassandraConnectorConf.CassandraSSLConf conf$1, ObjectRef keyStore$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.keyStore$lzycompute$1(conf$1, keyStore$lzy$1, bitmap$0$1) : (Option)keyStore$lzy$1.elem;
    }

    private DefaultConnectionFactory$() {
        MODULE$ = this;
        CassandraConnectionFactory$class.$init$(this);
    }
}

