/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Token;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartition;
import com.datastax.spark.connector.rdd.partitioner.TokenGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.net.InetAddress;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001=\u0011!CU3qY&\u001c\u0017\rU1si&$\u0018n\u001c8fe*\u00111\u0001B\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u0002\u0006\r\u0005\u0019!\u000f\u001a3\u000b\u0005\u001dA\u0011!C2p]:,7\r^8s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u0005AA-\u0019;bgR\f\u0007PC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001+\t\u0001ri\u0005\u0002\u0001#A\u0011!\u0003G\u0007\u0002')\u0011\u0011\u0002\u0006\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014x-\u0003\u0002\u001a'\tY\u0001+\u0019:uSRLwN\\3s\u0011!Y\u0002A!A!\u0002\u0013a\u0012!\u0002;bE2,\u0007CA\u000f$\u001d\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tz\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0011-,\u0017p\u001d9bG\u0016D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0018a\u0006\u0014H/\u001b;j_:\u001c\b+\u001a:SKBd\u0017nY1TKR\u0004\"AH\u0016\n\u00051z\"aA%oi\"Aa\u0006\u0001B\u0001B\u0003%q&\u0001\nqCJ$\u0018\u000e^5p].+\u00170T1qa\u0016\u0014\bC\u0001\u00192\u001b\u00051\u0011B\u0001\u001a\u0007\u00059\u0019u\u000e\\;n]N+G.Z2u_JD\u0001b\u0002\u0001\u0003\u0006\u0004%\t\u0001N\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001HB\u0001\u0004GFd\u0017B\u0001\u001e8\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\t\u0011q\u0002!\u0011!Q\u0001\nU\n!bY8o]\u0016\u001cGo\u001c:!\u0011!q\u0004A!A!\u0002\u0017y\u0014aC2veJ,g\u000e\u001e+za\u0016\u00042\u0001Q\"F\u001b\u0005\t%B\u0001\" \u0003\u001d\u0011XM\u001a7fGRL!\u0001R!\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"AR$\r\u0001\u0011)\u0001\n\u0001b\u0001\u0013\n\tA+\u0005\u0002K\u001bB\u0011adS\u0005\u0003\u0019~\u0011qAT8uQ&tw\r\u0005\u0002\u001f\u001d&\u0011qj\b\u0002\u0004\u0003:L\b\u0002C)\u0001\u0005\u0003\u0005\u000b1\u0002*\u0002\u0007I<h\rE\u0002T-\u0016k\u0011\u0001\u0016\u0006\u0003+\u001a\taa\u001e:ji\u0016\u0014\u0018BA,U\u0005A\u0011vn^,sSR,'OR1di>\u0014\u0018\u0010\u000b\u0002Q3B\u0011aDW\u0005\u00037~\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?)\u0019yF-\u001a4hQR\u0019\u0001MY2\u0011\u0007\u0005\u0004Q)D\u0001\u0003\u0011\u0015qD\fq\u0001@\u0011\u0015\tF\fq\u0001S\u0011\u0015YB\f1\u0001\u001d\u0011\u00159C\f1\u0001\u001d\u0011\u0015IC\f1\u0001+\u0011\u0015qC\f1\u00010\u0011\u00159A\f1\u00016\u0011\u001dQ\u0007A1A\u0005\u0002-\f\u0001\u0002^1cY\u0016$UMZ\u000b\u0002YB\u0011a'\\\u0005\u0003]^\u0012\u0001\u0002V1cY\u0016$UM\u001a\u0005\u0007a\u0002\u0001\u000b\u0011\u00027\u0002\u0013Q\f'\r\\3EK\u001a\u0004\u0003b\u0002:\u0001\u0005\u0004%\ta]\u0001\ne><xK]5uKJ,\u0012\u0001\u001e\t\u0004'V,\u0015B\u0001<U\u0005%\u0011vn^,sSR,'\u000f\u0003\u0004y\u0001\u0001\u0006I\u0001^\u0001\u000be><xK]5uKJ\u0004\u0003\u0002\u0003>\u0001\u0011\u000b\u0007I\u0011B>\u0002\u001dQ|7.\u001a8HK:,'/\u0019;peV\tA\u0010E\u0002b{\u0016K!A \u0002\u0003\u001dQ{7.\u001a8HK:,'/\u0019;pe\"I\u0011\u0011\u0001\u0001\t\u0002\u0003\u0006K\u0001`\u0001\u0010i>\\WM\\$f]\u0016\u0014\u0018\r^8sA!\u0012q0\u0017\u0005\u000b\u0003\u000f\u0001\u0001R1A\u0005\n\u0005%\u0011\u0001C7fi\u0006$\u0017\r^1\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005G>\u0014XMC\u0002\u0002\u0016)\ta\u0001\u001a:jm\u0016\u0014\u0018\u0002BA\r\u0003\u001f\u0011\u0001\"T3uC\u0012\fG/\u0019\u0005\u000b\u0003;\u0001\u0001\u0012!Q!\n\u0005-\u0011!C7fi\u0006$\u0017\r^1!Q\r\tY\"\u0017\u0005\u000b\u0003G\u0001\u0001R1A\u0005\n\u0005\u0015\u0012a\u00049s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005\u001d\u0002\u0003BA\u0007\u0003SIA!a\u000b\u0002\u0010\ty\u0001K]8u_\u000e|GNV3sg&|g\u000e\u0003\u0006\u00020\u0001A\t\u0011)Q\u0005\u0003O\t\u0001\u0003\u001d:pi>\u001cw\u000e\u001c,feNLwN\u001c\u0011)\u0007\u00055\u0012\f\u0003\u0006\u00026\u0001A)\u0019!C\u0005\u0003o\tQa\u00197buj,\"!!\u000f1\t\u0005m\u0012Q\n\t\u0007\u0003{\t9%a\u0013\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA\u0001\\1oO*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"!B\"mCN\u001c\bc\u0001$\u0002N\u0011Y\u0011qJA)\u0003\u0003\u0005\tQ!\u0001J\u0005\ryF%\r\u0005\u000b\u0003'\u0002\u0001\u0012!Q!\n\u0005e\u0012AB2mCjT\b\u0005K\u0002\u0002ReC\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0017\u0002\u000b!|7\u000f^:\u0016\u0005\u0005u\u0003CBA0\u0003K\nYGD\u0002\u001f\u0003CJ1!a\u0019 \u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001a\u0002j\t1a+Z2u_JT1!a\u0019 !\u0011\ti'a\u001d\u000e\u0005\u0005=$\u0002BA9\u0003\u0007\n1A\\3u\u0013\u0011\t)(a\u001c\u0003\u0017%sW\r^!eIJ,7o\u001d\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002^\u00051\u0001n\\:ug\u0002B\u0011\"! \u0001\u0005\u0004%I!a \u0002\u000f!|7\u000f^*fiV\u0011\u0011\u0011\u0011\t\u0006;\u0005\r\u00151N\u0005\u0004\u0003\u000b+#aA*fi\"A\u0011\u0011\u0012\u0001!\u0002\u0013\t\t)\u0001\u0005i_N$8+\u001a;!\u0011%\ti\t\u0001b\u0001\n\u0013\ty)\u0001\u0005ok6Dun\u001d;t+\u0005Q\u0003bBAJ\u0001\u0001\u0006IAK\u0001\n]Vl\u0007j\\:ug\u0002B\u0011\"a&\u0001\u0005\u0004%I!!'\u0002!A\f'\u000f^5uS>t\u0017J\u001c3fq\u0016\u001cXCAAN!\u0019\ty&!(\u0002\"&!\u0011qTA5\u0005\u0011a\u0015n\u001d;\u0011\u000b\u0005\r\u0016Q\u0016\u0016\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005-v$\u0001\u0006d_2dWm\u0019;j_:LA!a,\u0002&\nQ\u0011J\u001c3fq\u0016$7+Z9\t\u0011\u0005M\u0006\u0001)A\u0005\u00037\u000b\u0011\u0003]1si&$\u0018n\u001c8J]\u0012,\u00070Z:!\u0011%\t9\f\u0001b\u0001\n\u0013\tI,A\u0004i_N$X*\u00199\u0016\u0005\u0005m\u0006\u0003CAR\u0003{\u000bY'!)\n\t\u0005}\u0016Q\u0015\u0002\u0004\u001b\u0006\u0004\b\u0002CAb\u0001\u0001\u0006I!a/\u0002\u0011!|7\u000f^'ba\u0002B\u0011\"a2\u0001\u0005\u0004%I!!3\u0002\u0011%tG-\u001a=NCB,\"!a3\u0011\u000f\u0005\r\u0016Q\u0018\u0016\u0002l!A\u0011q\u001a\u0001!\u0002\u0013\tY-A\u0005j]\u0012,\u00070T1qA!9\u00111\u001b\u0001\u0005\n\u0005U\u0017!C1cg6{G-\u001e7p)\u0015Q\u0013q[An\u0011\u001d\tI.!5A\u0002)\n\u0001\u0002Z5wS\u0012,g\u000e\u001a\u0005\b\u0003;\f\t\u000e1\u0001+\u0003\u001d!\u0017N^5t_JDq!!9\u0001\t\u0013\t\u0019/\u0001\u0006sC:$w.\u001c%pgR$B!a\u001b\u0002f\"9\u0011q]Ap\u0001\u0004Q\u0013!B5oI\u0016D\bbBAv\u0001\u0011\u0005\u0013Q^\u0001\rO\u0016$\b+\u0019:uSRLwN\u001c\u000b\u0004U\u0005=\bbBAy\u0003S\u0004\r!T\u0001\u0004W\u0016L\bbBA{\u0001\u0011\u0005\u0013qR\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000f\u0005e\b\u0001\"\u0001\u0002|\u0006!r-\u001a;F]\u0012\u0004x.\u001b8u!\u0006\u0014H/\u001b;j_:$B!!@\u0003\u0004A\u0019\u0011-a@\n\u0007\t\u0005!A\u0001\tSKBd\u0017nY1QCJ$\u0018\u000e^5p]\"A!QAA|\u0001\u0004\u00119!A\u0005qCJ$\u0018\u000e^5p]B\u0019!C!\u0003\n\u0007\t-1CA\u0005QCJ$\u0018\u000e^5p]\u0002")
public class ReplicaPartitioner<T>
extends Partitioner {
    private final String keyspace;
    private final int partitionsPerReplicaSet;
    private final CassandraConnector connector;
    private final ClassTag<T> currentType;
    private final TableDef tableDef;
    private final RowWriter<T> rowWriter;
    private transient TokenGenerator<T> tokenGenerator;
    private transient Metadata metadata;
    private transient ProtocolVersion protocolVersion;
    private transient Class<?> clazz;
    private final Vector<InetAddress> hosts;
    private final scala.collection.immutable.Set<InetAddress> hostSet;
    private final int numHosts;
    private final List<IndexedSeq<Object>> partitionIndexes;
    private final Map<InetAddress, IndexedSeq<Object>> hostMap;
    private final Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    private volatile transient byte bitmap$trans$0;

    private TokenGenerator tokenGenerator$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.tokenGenerator = new TokenGenerator<T>(this.connector(), this.tableDef(), this.rowWriter());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.tokenGenerator;
        }
    }

    private Metadata metadata$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.metadata = (Metadata)this.connector().withClusterDo(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Metadata apply(Cluster x$1) {
                        return x$1.getMetadata();
                    }
                });
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.metadata;
        }
    }

    private ProtocolVersion protocolVersion$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.protocolVersion = (ProtocolVersion)((Object)this.connector().withClusterDo(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ProtocolVersion apply(Cluster x$2) {
                        return x$2.getConfiguration().getProtocolOptions().getProtocolVersion();
                    }
                }));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.protocolVersion;
        }
    }

    private Class clazz$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.currentType)).runtimeClass();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.clazz;
        }
    }

    public CassandraConnector connector() {
        return this.connector;
    }

    public TableDef tableDef() {
        return this.tableDef;
    }

    public RowWriter<T> rowWriter() {
        return this.rowWriter;
    }

    private TokenGenerator<T> tokenGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tokenGenerator$lzycompute() : this.tokenGenerator;
    }

    private Metadata metadata() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.metadata$lzycompute() : this.metadata;
    }

    private ProtocolVersion protocolVersion() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.protocolVersion$lzycompute() : this.protocolVersion;
    }

    private Class<?> clazz() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.clazz$lzycompute() : this.clazz;
    }

    private Vector<InetAddress> hosts() {
        return this.hosts;
    }

    private scala.collection.immutable.Set<InetAddress> hostSet() {
        return this.hostSet;
    }

    private int numHosts() {
        return this.numHosts;
    }

    private List<IndexedSeq<Object>> partitionIndexes() {
        return this.partitionIndexes;
    }

    private Map<InetAddress, IndexedSeq<Object>> hostMap() {
        return this.hostMap;
    }

    public Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap() {
        return this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    }

    private int absModulo(int dividend, int divisor) {
        return Math.abs(dividend % divisor);
    }

    private InetAddress randomHost(int index) {
        return (InetAddress)this.hosts().apply(this.absModulo(index, this.hosts().length()));
    }

    public int getPartition(Object key) {
        Object object = key;
        Option option = this.currentType.unapply(object);
        if (!option.isEmpty() && option.get() instanceof Object && this.clazz().isInstance(object)) {
            int n;
            Token token = this.tokenGenerator().getTokenFor(object);
            int tokenHash = Math.abs(token.hashCode());
            Set replicas = (Set)JavaConversions$.MODULE$.asScalaSet(this.metadata().getReplicas(this.keyspace, token.serialize(this.protocolVersion()))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final InetAddress apply(Host x$4) {
                    return x$4.getBroadcastAddress();
                }
            }, Set$.MODULE$.canBuildFrom());
            Vector replicaSetInDC = ((TraversableOnce)this.hostSet().$amp((GenSet)replicas)).toVector();
            if (replicaSetInDC.nonEmpty()) {
                InetAddress endpoint = (InetAddress)replicaSetInDC.apply(this.absModulo(tokenHash, replicaSetInDC.size()));
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)endpoint)).apply(this.absModulo(tokenHash, this.partitionsPerReplicaSet)));
            } else {
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)this.randomHost(tokenHash))).apply(this.absModulo(tokenHash, this.partitionsPerReplicaSet)));
            }
            int n2 = n;
            return n2;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"ReplicaPartitioner can only determine the partition of a tuple whose key is a non-empty Set[InetAddress]. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).toString());
    }

    public int numPartitions() {
        return this.partitionsPerReplicaSet * this.numHosts();
    }

    public ReplicaPartition getEndpointPartition(Partition partition) {
        InetAddress endpoints = (InetAddress)this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)partition.index()), (Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaPartitioner $outer;
            private final Partition partition$1;

            public final Nothing$ apply() {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : Can't get an endpoint for Partition ", ".index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap(), this.partition$1})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        });
        return new ReplicaPartition(partition.index(), (scala.collection.immutable.Set<InetAddress>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{endpoints}))));
    }

    public ReplicaPartitioner(String table, String keyspace, int partitionsPerReplicaSet, ColumnSelector partitionKeyMapper, CassandraConnector connector, ClassTag<T> currentType, RowWriterFactory<T> rwf) {
        this.keyspace = keyspace;
        this.partitionsPerReplicaSet = partitionsPerReplicaSet;
        this.connector = connector;
        this.currentType = currentType;
        this.tableDef = Schema$.MODULE$.tableFromCassandra(connector, keyspace, table);
        this.rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(rwf)).rowWriter(this.tableDef(), partitionKeyMapper.selectFrom(this.tableDef()));
        this.hosts = connector.hosts().toVector();
        this.hostSet = connector.hosts();
        this.numHosts = this.hosts().size();
        this.partitionIndexes = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionsPerReplicaSet * this.numHosts()).grouped(partitionsPerReplicaSet).toList();
        this.hostMap = ((TraversableOnce)this.hosts().zip(this.partitionIndexes(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap = (Map)this.hostMap().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<InetAddress, IndexedSeq<Object>> check$ifrefutable$1) {
                Tuple2<InetAddress, IndexedSeq<Object>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Tuple2<Object, InetAddress>> apply(Tuple2<InetAddress, IndexedSeq<Object>> x$3) {
                Tuple2<InetAddress, IndexedSeq<Object>> tuple2 = x$3;
                if (tuple2 != null) {
                    InetAddress ip = (InetAddress)tuple2._1();
                    IndexedSeq partitions2 = (IndexedSeq)tuple2._2();
                    IndexedSeq indexedSeq = (IndexedSeq)partitions2.map((Function1)new Serializable(this, ip){
                        public static final long serialVersionUID = 0L;
                        private final InetAddress ip$1;

                        public final Tuple2<Object, InetAddress> apply(int partition) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)this.ip$1);
                        }
                        {
                            this.ip$1 = ip$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return indexedSeq;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }
}

