/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.CollectionAppend$;
import com.datastax.spark.connector.CollectionBehavior;
import com.datastax.spark.connector.CollectionColumnName;
import com.datastax.spark.connector.CollectionOverwrite$;
import com.datastax.spark.connector.CollectionPrepend$;
import com.datastax.spark.connector.CollectionRemove$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$None$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.BatchGroupingKey$ReplicaSet$;
import com.datastax.spark.connector.writer.BatchStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.GroupingBatchBuilder;
import com.datastax.spark.connector.writer.PerRowWriteOptionValue;
import com.datastax.spark.connector.writer.QueryExecutor;
import com.datastax.spark.connector.writer.RateLimiter;
import com.datastax.spark.connector.writer.RateLimiter$;
import com.datastax.spark.connector.writer.RichStatement;
import com.datastax.spark.connector.writer.RoutingKeyGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.StaticWriteOptionValue;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TableWriter$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteOptionValue;
import java.io.IOException;
import org.apache.spark.Logging;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.OutputMetricsUpdater;
import org.apache.spark.metrics.OutputMetricsUpdater$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tuc\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016<&/\u001b;fe*\u00111\u0001B\u0001\u0007oJLG/\u001a:\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001+\tq\u0011i\u0005\u0003\u0001\u001fUA\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0011-%\u0011q#\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00033}i\u0011A\u0007\u0006\u0003\u000fmQ!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO&\u0011\u0001E\u0007\u0002\b\u0019><w-\u001b8h\u0011!)\u0001A!A!\u0002\u0013\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0005\u0003\r\u0019\u0017\u000f\\\u0005\u0003O\u0011\u0012!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\u0005uC\ndW\rR3g!\t\u00193&\u0003\u0002-I\tAA+\u00192mK\u0012+g\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u00039\u0019w\u000e\\;n]N+G.Z2u_J\u00042\u0001M\u001a6\u001b\u0005\t$B\u0001\u001a\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003iE\u0012!\"\u00138eKb,GmU3r!\t1t'D\u0001\u0005\u0013\tADAA\u0005D_2,XN\u001c*fM\"A!\b\u0001B\u0001B\u0003%1(A\u0005s_^<&/\u001b;feB\u0019A(P \u000e\u0003\tI!A\u0010\u0002\u0003\u0013I{wo\u0016:ji\u0016\u0014\bC\u0001!B\u0019\u0001!QA\u0011\u0001C\u0002\r\u0013\u0011\u0001V\t\u0003\t\u001e\u0003\"\u0001E#\n\u0005\u0019\u000b\"a\u0002(pi\"Lgn\u001a\t\u0003!!K!!S\t\u0003\u0007\u0005s\u0017\u0010\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0003%9(/\u001b;f\u0007>tg\r\u0005\u0002=\u001b&\u0011aJ\u0001\u0002\n/JLG/Z\"p]\u001aDQ\u0001\u0015\u0001\u0005\nE\u000ba\u0001P5oSRtDC\u0002*T)V3v\u000bE\u0002=\u0001}BQ!B(A\u0002\tBQ!K(A\u0002)BQAL(A\u0002=BQAO(A\u0002mBQaS(A\u00021Cq!\u0017\u0001C\u0002\u0013\u0005!,\u0001\u0007lKf\u001c\b/Y2f\u001d\u0006lW-F\u0001\\!\tavL\u0004\u0002\u0011;&\u0011a,E\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_#!11\r\u0001Q\u0001\nm\u000bQb[3zgB\f7-\u001a(b[\u0016\u0004\u0003bB3\u0001\u0005\u0004%\tAW\u0001\ni\u0006\u0014G.\u001a(b[\u0016Daa\u001a\u0001!\u0002\u0013Y\u0016A\u0003;bE2,g*Y7fA!9\u0011\u000e\u0001b\u0001\n\u0003Q\u0017aC2pYVlgNT1nKN,\u0012a\u001b\t\u0004a1\\\u0016BA72\u0005\r\u0019V-\u001d\u0005\u0007_\u0002\u0001\u000b\u0011B6\u0002\u0019\r|G.^7o\u001d\u0006lWm\u001d\u0011\t\u000fE\u0004!\u0019!C\u0001e\u000691m\u001c7v[:\u001cX#A:\u0011\u0007AbG\u000f\u0005\u0002$k&\u0011a\u000f\n\u0002\n\u0007>dW/\u001c8EK\u001aDa\u0001\u001f\u0001!\u0002\u0013\u0019\u0018\u0001C2pYVlgn\u001d\u0011\t\u0013i\u0004\u0001R1A\u0005\u0002\u0011Q\u0016\u0001G9vKJLH+Z7qY\u0006$X-V:j]\u001eLen]3si\"AA\u0010\u0001E\u0001B\u0003&1,A\rrk\u0016\u0014\u0018\u0010V3na2\fG/Z+tS:<\u0017J\\:feR\u0004\u0003\"\u0002@\u0001\t\u0013y\u0018a\u00053fY\u0016$X-U;fef$V-\u001c9mCR,GcA.\u0002\u0002!9\u00111A?A\u0002\u0005\u0015\u0011!\u00043fY\u0016$XmQ8mk6t7\u000fE\u00027\u0003\u000fI1!!\u0003\u0005\u00059\u0019u\u000e\\;n]N+G.Z2u_JD\u0011\"!\u0004\u0001\u0011\u000b\u0007I\u0011\u0002.\u00021E,XM]=UK6\u0004H.\u0019;f+NLgnZ+qI\u0006$X\rC\u0005\u0002\u0012\u0001A\t\u0011)Q\u00057\u0006I\u0012/^3ssR+W\u000e\u001d7bi\u0016,6/\u001b8h+B$\u0017\r^3!\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\"A\bjg\u000e{WO\u001c;feV\u0003H-\u0019;f+\t\tI\u0002E\u0002\u0011\u00037I1!!\b\u0012\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\t\u0001A\u0003%\u0011\u0011D\u0001\u0011SN\u001cu.\u001e8uKJ,\u0006\u000fZ1uK\u0002B\u0011\"!\n\u0001\u0005\u0004%I!a\u0006\u00027\r|g\u000e^1j]N\u001cu\u000e\u001c7fGRLwN\u001c\"fQ\u00064\u0018n\u001c:t\u0011!\tI\u0003\u0001Q\u0001\n\u0005e\u0011\u0001H2p]R\f\u0017N\\:D_2dWm\u0019;j_:\u0014U\r[1wS>\u00148\u000f\t\u0005\b\u0003[\u0001A\u0011BA\u0018\u0003A\u0001(/\u001a9be\u0016\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0004\u00022\u0005\u0005\u0013Q\t\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u0011\u0019wN]3\u000b\u0007\u0005m\u0002\"\u0001\u0004ee&4XM]\u0005\u0005\u0003\u007f\t)DA\tQe\u0016\u0004\u0018M]3e'R\fG/Z7f]RDq!a\u0011\u0002,\u0001\u00071,A\u0007rk\u0016\u0014\u0018\u0010V3na2\fG/\u001a\u0005\t\u0003\u000f\nY\u00031\u0001\u0002J\u000591/Z:tS>t\u0007\u0003BA\u001a\u0003\u0017JA!!\u0014\u00026\t91+Z:tS>t\u0007bBA)\u0001\u0011\u0005\u00111K\u0001\u0010E\u0006$8\r\u001b*pkRLgnZ&fsR1\u0011QKA1\u0003G\"2aRA,\u0011!\tI&a\u0014A\u0002\u0005m\u0013A\u00012t!\u0011\t\u0019$!\u0018\n\t\u0005}\u0013Q\u0007\u0002\u000f\u0005>,h\u000eZ*uCR,W.\u001a8u\u0011!\t9%a\u0014A\u0002\u0005%\u0003\u0002CA3\u0003\u001f\u0002\r!a\u001a\u0002'I|W\u000f^5oO.+\u0017pR3oKJ\fGo\u001c:\u0011\u0007q\nI'C\u0002\u0002l\t\u00111CU8vi&twmS3z\u000f\u0016tWM]1u_JDq!a\u001c\u0001\t\u0003\t\t(A\u0003xe&$X\r\u0006\u0004\u0002t\u0005e\u00141\u0011\t\u0004!\u0005U\u0014bAA<#\t!QK\\5u\u0011!\tY(!\u001cA\u0002\u0005u\u0014a\u0003;bg.\u001cuN\u001c;fqR\u00042!GA@\u0013\r\t\tI\u0007\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000f\u0003\u0005\u0002\u0006\u00065\u0004\u0019AAD\u0003\u0011!\u0017\r^1\u0011\tA\nIiP\u0005\u0004\u0003\u0017\u000b$\u0001C%uKJ\fGo\u001c:\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u00061Q\u000f\u001d3bi\u0016$b!a\u001d\u0002\u0014\u0006U\u0005\u0002CA>\u0003\u001b\u0003\r!! \t\u0011\u0005\u0015\u0015Q\u0012a\u0001\u0003\u000fCq!!'\u0001\t\u0003\tY*\u0001\u0004j]N,'\u000f\u001e\u000b\u0007\u0003g\ni*a(\t\u0011\u0005m\u0014q\u0013a\u0001\u0003{B\u0001\"!\"\u0002\u0018\u0002\u0007\u0011q\u0011\u0005\b\u0003G\u0003A\u0011AAS\u0003\u0019!W\r\\3uKR!\u0011qUAW)\u0019\t\u0019(!+\u0002,\"A\u00111PAQ\u0001\u0004\ti\b\u0003\u0005\u0002\u0006\u0006\u0005\u0006\u0019AAD\u0011\u001d\t\u0018\u0011\u0015a\u0001\u0003\u000bAq!!-\u0001\t\u0013\t\u0019,A\u0007xe&$X-\u00138uKJt\u0017\r\u001c\u000b\t\u0003g\n),a.\u0002:\"9\u00111IAX\u0001\u0004Y\u0006\u0002CA>\u0003_\u0003\r!! \t\u0011\u0005\u0015\u0015q\u0016a\u0001\u0003\u000f;q!!0\u0003\u0011\u0003\ty,A\u0006UC\ndWm\u0016:ji\u0016\u0014\bc\u0001\u001f\u0002B\u001a1\u0011A\u0001E\u0001\u0003\u0007\u001cB!!1\u0010+!9\u0001+!1\u0005\u0002\u0005\u001dGCAA`\u0011!\tY-!1\u0005\n\u00055\u0017aE2iK\u000e\\W*[:tS:<7i\u001c7v[:\u001cHCBA:\u0003\u001f\f\u0019\u000eC\u0004\u0002R\u0006%\u0007\u0019\u0001\u0016\u0002\u000bQ\f'\r\\3\t\r%\fI\r1\u0001l\u0011!\t9.!1\u0005\n\u0005e\u0017!H2iK\u000e\\W*[:tS:<\u0007K]5nCJL8*Z=D_2,XN\\:\u0015\r\u0005M\u00141\\Ao\u0011\u001d\t\t.!6A\u0002)Ba![Ak\u0001\u0004Y\u0007\u0002CAq\u0003\u0003$I!a9\u0002?\rDWmY6NSN\u001c\u0018N\\4QCJ$\u0018\u000e^5p].+\u0017pQ8mk6t7\u000f\u0006\u0004\u0002t\u0005\u0015\u0018q\u001d\u0005\b\u0003#\fy\u000e1\u0001+\u0011\u0019I\u0017q\u001ca\u0001W\"A\u00111^Aa\t\u0013\ti/\u0001\rdQ\u0016\u001c7nQ8mY\u0016\u001cG/[8o\u0005\u0016D\u0017M^5peN$b!a\u001d\u0002p\u0006E\bbBAi\u0003S\u0004\rA\u000b\u0005\b\u0003g\fI\u000f1\u00010\u0003)\u0019w\u000e\\;n]J+gm\u001d\u0005\t\u0003o\f\t\r\"\u0003\u0002z\u0006a1\r[3dW\u000e{G.^7ogRA\u00111OA~\u0003{\fy\u0010C\u0004\u0002R\u0006U\b\u0019\u0001\u0016\t\u000f\u0005M\u0018Q\u001fa\u0001_!A!\u0011AA{\u0001\u0004\tI\"A\tdQ\u0016\u001c7\u000eU1si&$\u0018n\u001c8LKfD\u0001B!\u0002\u0002B\u0012\u0005!qA\u0001\u0006CB\u0004H._\u000b\u0005\u0005\u0013\u0011\t\u0002\u0006\b\u0003\f\tu!q\u0004B\u0011\u0005G\u0011)Ca\n\u0015\t\t5!1\u0003\t\u0005y\u0001\u0011y\u0001E\u0002A\u0005#!aA\u0011B\u0002\u0005\u0004\u0019\u0005B\u0003B\u000b\u0005\u0007\t\t\u0011q\u0001\u0003\u0018\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u000bq\u0012IBa\u0004\n\u0007\tm!A\u0001\tS_^<&/\u001b;fe\u001a\u000b7\r^8ss\"1QAa\u0001A\u0002\tBa!\u0017B\u0002\u0001\u0004Y\u0006BB3\u0003\u0004\u0001\u00071\fC\u0004j\u0005\u0007\u0001\r!!\u0002\t\r-\u0013\u0019\u00011\u0001M\u0011)\u0011\tAa\u0001\u0011\u0002\u0003\u0007\u0011\u0011\u0004\u0005\u000b\u0005W\t\t-%A\u0005\u0002\t5\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\u0016\t\t=\"QI\u000b\u0003\u0005cQC!!\u0007\u00034-\u0012!Q\u0007\t\u0005\u0005o\u0011\t%\u0004\u0002\u0003:)!!1\bB\u001f\u0003%)hn\u00195fG.,GMC\u0002\u0003@E\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019E!\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004C\u0005S\u0011\ra\u0011\u0005\u000b\u0005\u0013\n\t-!A\u0005\n\t-\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0014\u0011\t\t=#\u0011L\u0007\u0003\u0005#RAAa\u0015\u0003V\u0005!A.\u00198h\u0015\t\u00119&\u0001\u0003kCZ\f\u0017\u0002\u0002B.\u0005#\u0012aa\u00142kK\u000e$\b")
public class TableWriter<T>
implements Serializable,
Logging {
    private final CassandraConnector connector;
    public final TableDef com$datastax$spark$connector$writer$TableWriter$$tableDef;
    private final IndexedSeq<ColumnRef> columnSelector;
    public final RowWriter<T> com$datastax$spark$connector$writer$TableWriter$$rowWriter;
    public final WriteConf com$datastax$spark$connector$writer$TableWriter$$writeConf;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private final Seq<ColumnDef> columns;
    private String queryTemplateUsingInsert;
    private String queryTemplateUsingUpdate;
    private final boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    private final boolean containsCollectionBehaviors;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    public static <T> boolean apply$default$6() {
        return TableWriter$.MODULE$.apply$default$6();
    }

    public static <T> TableWriter<T> apply(CassandraConnector cassandraConnector, String string, String string2, ColumnSelector columnSelector, WriteConf writeConf, boolean bl, RowWriterFactory<T> rowWriterFactory) {
        return TableWriter$.MODULE$.apply(cassandraConnector, string, string2, columnSelector, writeConf, bl, rowWriterFactory);
    }

    private String queryTemplateUsingInsert$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                WriteOptionValue<Object> writeOptionValue;
                None$ none$;
                WriteOptionValue<Object> writeOptionValue2;
                WriteOptionValue<Object> writeOptionValue3;
                None$ none$2;
                WriteOptionValue<Object> writeOptionValue4;
                Seq quotedColumnNames2 = (Seq)this.columnNames().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String name) {
                        return Quote$.MODULE$.quote(name);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String columnSpec = quotedColumnNames2.mkString(", ");
                String valueSpec = ((TraversableOnce)quotedColumnNames2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$1) {
                        return new StringBuilder().append((Object)":").append((Object)x$1).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String ifNotExistsSpec = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ifNotExists() ? "IF NOT EXISTS " : "";
                TTLOption tTLOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ttl();
                if (tTLOption != null && (writeOptionValue4 = tTLOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue4;
                    String placeholder2 = perRowWriteOptionValue.placeholder();
                    none$2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder2})));
                } else if (tTLOption != null && (writeOptionValue3 = tTLOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue3;
                    int value2 = BoxesRunTime.unboxToInt(staticWriteOptionValue.value());
                    none$2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)value2)})));
                } else {
                    none$2 = None$.MODULE$;
                }
                None$ ttlSpec = none$2;
                TimestampOption timestampOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.timestamp();
                if (timestampOption != null && (writeOptionValue2 = timestampOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue2;
                    String placeholder3 = perRowWriteOptionValue.placeholder();
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder3})));
                } else if (timestampOption != null && (writeOptionValue = timestampOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
                    long value3 = BoxesRunTime.unboxToLong(staticWriteOptionValue.value());
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)value3)})));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ timestampSpec = none$;
                List options = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{ttlSpec, timestampSpec})).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<String> apply(Option<String> xo) {
                        return Option$.MODULE$.option2Iterable(xo);
                    }
                });
                String optionsSpec = options.nonEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USING ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.mkString(" AND ")})) : "";
                this.queryTemplateUsingInsert = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", ".", " (", ") VALUES (", ") ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), columnSpec, valueSpec, ifNotExistsSpec, optionsSpec})).trim();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.queryTemplateUsingInsert;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String queryTemplateUsingUpdate$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Tuple2 tuple23 = this.columns().partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ColumnDef x$6) {
                        return x$6.isPrimaryKeyColumn();
                    }
                });
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Seq primaryKey = (Seq)tuple23._1();
                Seq regularColumns = (Seq)tuple23._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
                Seq primaryKey2 = (Seq)tuple24._1();
                Seq regularColumns2 = (Seq)tuple24._2();
                Tuple2 tuple25 = regularColumns2.partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ColumnDef x$8) {
                        return x$8.isCounterColumn();
                    }
                });
                if (tuple25 == null) throw new MatchError((Object)tuple25);
                Seq counterColumns = (Seq)tuple25._1();
                Seq nonCounterColumns = (Seq)tuple25._2();
                Tuple2 tuple26 = tuple2 = new Tuple2((Object)counterColumns, (Object)nonCounterColumns);
                Seq counterColumns2 = (Seq)tuple26._1();
                Seq nonCounterColumns2 = (Seq)tuple26._2();
                Map nameToBehavior = ((TraversableOnce)this.columnSelector.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof CollectionColumnName) {
                            CollectionColumnName collectionColumnName = (CollectionColumnName)A1;
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)collectionColumnName.columnName()), (Object)collectionColumnName.collectionBehavior());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(ColumnRef x1) {
                        ColumnRef columnRef = x1;
                        boolean bl = columnRef instanceof CollectionColumnName;
                        return bl;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Seq setNonCounterColumnsClause = (Seq)((TraversableLike)nonCounterColumns2.map((Function1)new Serializable(this, nameToBehavior){
                    public static final long serialVersionUID = 0L;
                    private final Map nameToBehavior$1;

                    public final Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> apply(ColumnDef colDef) {
                        String name = colDef.columnName();
                        Option collectionBehavior = this.nameToBehavior$1.get((Object)name);
                        String quotedName = Quote$.MODULE$.quote(name);
                        return new Tuple4((Object)colDef, (Object)name, (Object)collectionBehavior, (Object)quotedName);
                    }
                    {
                        this.nameToBehavior$1 = nameToBehavior$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> x$10) {
                        Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> tuple4;
                        block2: {
                            Option option;
                            block7: {
                                String string;
                                block4: {
                                    Some some;
                                    CollectionBehavior collectionBehavior;
                                    String quotedName;
                                    block6: {
                                        CollectionBehavior collectionBehavior2;
                                        Some some2;
                                        boolean bl;
                                        block5: {
                                            CollectionBehavior collectionBehavior3;
                                            block3: {
                                                tuple4 = x$10;
                                                if (tuple4 == null) break block2;
                                                Option collectionBehavior4 = (Option)tuple4._3();
                                                quotedName = (String)tuple4._4();
                                                bl = false;
                                                some2 = null;
                                                option = collectionBehavior4;
                                                if (!(option instanceof Some)) break block3;
                                                bl = true;
                                                some2 = (Some)option;
                                                CollectionBehavior collectionBehavior5 = (CollectionBehavior)some2.x();
                                                if (!CollectionAppend$.MODULE$.equals(collectionBehavior5)) break block3;
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                                break block4;
                                            }
                                            if (!bl || !CollectionPrepend$.MODULE$.equals(collectionBehavior3 = (CollectionBehavior)some2.x())) break block5;
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", " + ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                            break block4;
                                        }
                                        if (!bl || !CollectionRemove$.MODULE$.equals(collectionBehavior2 = (CollectionBehavior)some2.x())) break block6;
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " - :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                        break block4;
                                    }
                                    boolean bl = option instanceof Some && CollectionOverwrite$.MODULE$.equals(collectionBehavior = (CollectionBehavior)(some = (Some)option).x()) ? true : None$.MODULE$.equals(option);
                                    if (!bl) break block7;
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName}));
                                }
                                String string2 = string;
                                return string2;
                            }
                            throw new MatchError((Object)option);
                        }
                        throw new MatchError(tuple4);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq setCounterColumnsClause = (Seq)this.quotedColumnNames$2(counterColumns2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String setClause = ((TraversableOnce)setNonCounterColumnsClause.$plus$plus((GenTraversableOnce)setCounterColumnsClause, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String whereClause2 = ((TraversableOnce)this.quotedColumnNames$2(primaryKey2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
                this.queryTemplateUsingUpdate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", ".", " SET ", " WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), setClause, whereClause2}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.queryTemplateUsingUpdate;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public Seq<ColumnDef> columns() {
        return this.columns;
    }

    public String queryTemplateUsingInsert() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.queryTemplateUsingInsert$lzycompute() : this.queryTemplateUsingInsert;
    }

    private String deleteQueryTemplate(ColumnSelector deleteColumns) {
        Seq deleteColumnNames = (Seq)deleteColumns.selectFrom(this.com$datastax$spark$connector$writer$TableWriter$$tableDef).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$2) {
                return x$2.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = this.columns().partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnDef x$3) {
                return x$3.isPrimaryKeyColumn();
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq primaryKey = (Seq)tuple2._1();
            Seq regularColumns = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
            Seq primaryKey2 = (Seq)tuple23._1();
            Seq regularColumns2 = (Seq)tuple23._2();
            if (regularColumns2.nonEmpty()) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only primary key columns can be used in delete. Regular columns found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{regularColumns2.mkString(", ")})));
            }
            TableWriter$.MODULE$.com$datastax$spark$connector$writer$TableWriter$$checkMissingColumns(this.com$datastax$spark$connector$writer$TableWriter$$tableDef, (Seq<String>)deleteColumnNames);
            String deleteColumnsClause = ((TraversableOnce)deleteColumnNames.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String name) {
                    return Quote$.MODULE$.quote(name);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
            String whereClause2 = ((TraversableOnce)this.quotedColumnNames$1(primaryKey2).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String c) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE ", " FROM ", ".", " WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deleteColumnsClause, Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), whereClause2}));
        }
        throw new MatchError((Object)tuple2);
    }

    private String queryTemplateUsingUpdate() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.queryTemplateUsingUpdate$lzycompute() : this.queryTemplateUsingUpdate;
    }

    public boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() {
        return this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    }

    private boolean containsCollectionBehaviors() {
        return this.containsCollectionBehaviors;
    }

    public PreparedStatement com$datastax$spark$connector$writer$TableWriter$$prepareStatement(String queryTemplate, Session session) {
        try {
            return session.prepare(queryTemplate);
        }
        catch (Throwable throwable) {
            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to prepare statement ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryTemplate}))).append((Object)throwable.getMessage()).toString(), throwable);
        }
    }

    public Object batchRoutingKey(Session session, RoutingKeyGenerator routingKeyGenerator, BoundStatement bs) {
        BatchGroupingKey batchGroupingKey;
        block5: {
            Comparable<Integer> comparable;
            block3: {
                block4: {
                    block2: {
                        batchGroupingKey = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingKey();
                        if (!BatchGroupingKey$None$.MODULE$.equals(batchGroupingKey)) break block2;
                        comparable = BoxesRunTime.boxToInteger((int)0);
                        break block3;
                    }
                    if (!BatchGroupingKey$ReplicaSet$.MODULE$.equals(batchGroupingKey)) break block4;
                    Object object = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE) == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
                    comparable = BoxesRunTime.boxToInteger((int)((Object)session.getCluster().getMetadata().getReplicas(this.keyspaceName(), bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE))).hashCode());
                    break block3;
                }
                if (!BatchGroupingKey$Partition$.MODULE$.equals(batchGroupingKey)) break block5;
                Object object = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE) == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
                comparable = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE).duplicate();
            }
            return comparable;
        }
        throw new MatchError((Object)batchGroupingKey);
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        if (this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() || this.containsCollectionBehaviors()) {
            this.update(taskContext, data);
        } else {
            this.insert(taskContext, data);
        }
    }

    public void update(TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.queryTemplateUsingUpdate(), taskContext, data);
    }

    public void insert(TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.queryTemplateUsingInsert(), taskContext, data);
    }

    public void delete(ColumnSelector columns, TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.deleteQueryTemplate(columns), taskContext, data);
    }

    private void writeInternal(String queryTemplate, TaskContext taskContext, Iterator<T> data) {
        OutputMetricsUpdater updater = OutputMetricsUpdater$.MODULE$.apply(taskContext, this.com$datastax$spark$connector$writer$TableWriter$$writeConf);
        this.connector.withSessionDo(new Serializable(this, queryTemplate, data, updater){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final String queryTemplate$1;
            private final Iterator data$1;
            public final OutputMetricsUpdater updater$1;

            public final void apply(Session session) {
                ProtocolVersion protocolVersion2 = session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
                CountingIterator<T> rowIterator = new CountingIterator<T>(this.data$1, CountingIterator$.MODULE$.$lessinit$greater$default$2());
                PreparedStatement stmt = this.$outer.com$datastax$spark$connector$writer$TableWriter$$prepareStatement(this.queryTemplate$1, session).setConsistencyLevel(this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
                QueryExecutor queryExecutor = new QueryExecutor(session, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.parallelismLevel(), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                    public final void apply(RichStatement x$14, long x$15, long x$16) {
                        this.$outer.updater$1.batchFinished(true, x$14, x$15, x$16);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                    public final void apply(RichStatement x$17, long x$18, long x$19) {
                        this.$outer.updater$1.batchFinished(false, x$17, x$18, x$19);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                RoutingKeyGenerator routingKeyGenerator = new RoutingKeyGenerator(this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef, this.$outer.columnNames());
                BatchStatement.Type batchType = this.$outer.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() ? BatchStatement.Type.COUNTER : BatchStatement.Type.UNLOGGED;
                RowWriter<T> x$31 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$rowWriter;
                PreparedStatement x$32 = stmt;
                ProtocolVersion x$33 = protocolVersion2;
                boolean x$34 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.ignoreNulls();
                Seq<Object> x$35 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$3();
                BoundStatementBuilder<T> boundStmtBuilder = new BoundStatementBuilder<T>(x$31, x$32, x$35, x$34, x$33);
                BatchStatementBuilder batchStmtBuilder = new BatchStatementBuilder(batchType, routingKeyGenerator, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
                Serializable batchKeyGenerator = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;
                    private final RoutingKeyGenerator routingKeyGenerator$1;
                    private final Session session$1;

                    public final Object apply(BoundStatement bs) {
                        return this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().batchRoutingKey(this.session$1, this.routingKeyGenerator$1, bs);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.routingKeyGenerator$1 = routingKeyGenerator$1;
                        this.session$1 = session$1;
                    }
                };
                GroupingBatchBuilder<T> batchBuilder = new GroupingBatchBuilder<T>(boundStmtBuilder, batchStmtBuilder, (Function1<BoundStatement, Object>)batchKeyGenerator, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingBufferSize(), rowIterator);
                RateLimiter rateLimiter = new RateLimiter((long)(this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.throughputMiBPS() * (double)1024 * (double)1024), 0x100000L, RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing data partition to ", ".", " in batches of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                batchBuilder.foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final QueryExecutor queryExecutor$1;
                    private final RateLimiter rateLimiter$1;

                    public final void apply(RichStatement stmtToWrite) {
                        this.queryExecutor$1.executeAsync(stmtToWrite);
                        Predef$.MODULE$.assert(stmtToWrite.bytesCount() > 0);
                        this.rateLimiter$1.maybeSleep(stmtToWrite.bytesCount());
                    }
                    {
                        this.queryExecutor$1 = queryExecutor$1;
                        this.rateLimiter$1 = rateLimiter$1;
                    }
                });
                queryExecutor.waitForCurrentlyExecutingTasks();
                if (queryExecutor.successful()) {
                    double duration = (double)this.updater$1.finish() / 1.0E9;
                    this.$outer.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$writeInternal$1 $outer;
                        private final CountingIterator rowIterator$1;
                        private final double duration$1;

                        public final String apply() {
                            Integer arg$macro$11 = BoxesRunTime.boxToInteger((int)this.rowIterator$1.count());
                            String arg$macro$12 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName();
                            String arg$macro$13 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName();
                            double arg$macro$14 = this.duration$1;
                            return new StringOps("Wrote %s rows to %s.%s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$11, arg$macro$12, arg$macro$13, BoxesRunTime.boxToDouble((double)arg$macro$14)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rowIterator$1 = rowIterator$1;
                            this.duration$1 = duration$1;
                        }
                    });
                    if (boundStmtBuilder.logUnsetToNullWarning()) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this, boundStmtBuilder){
                            public static final long serialVersionUID = 0L;
                            private final BoundStatementBuilder boundStmtBuilder$1;

                            public final String apply() {
                                return this.boundStmtBuilder$1.UnsetToNullWarning();
                            }
                            {
                                this.boundStmtBuilder$1 = boundStmtBuilder$1;
                            }
                        });
                    }
                    return;
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write statements to ", ".", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.keyspaceName(), this.$outer.tableName()})));
            }

            public /* synthetic */ TableWriter com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queryTemplate$1 = queryTemplate$1;
                this.data$1 = var3_3;
                this.updater$1 = var4_4;
            }
        });
    }

    private final Seq quotedColumnNames$1(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$5) {
                return x$5.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return Quote$.MODULE$.quote(name);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq quotedColumnNames$2(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$11) {
                return x$11.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return Quote$.MODULE$.quote(name);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public TableWriter(CassandraConnector connector, TableDef tableDef, IndexedSeq<ColumnRef> columnSelector, RowWriter<T> rowWriter, WriteConf writeConf) {
        this.connector = connector;
        this.com$datastax$spark$connector$writer$TableWriter$$tableDef = tableDef;
        this.columnSelector = columnSelector;
        this.com$datastax$spark$connector$writer$TableWriter$$rowWriter = rowWriter;
        this.com$datastax$spark$connector$writer$TableWriter$$writeConf = writeConf;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(!tableDef.isView(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is a Materialized View and Views are not writable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef.name()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = (Seq)rowWriter.columnNames().diff(writeConf.optionPlaceholders());
        this.columns = (Seq)this.columnNames().map(tableDef.columnByName(), Seq$.MODULE$.canBuildFrom());
        this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate = tableDef.columns().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnDef x$12) {
                return x$12.isCounterColumn();
            }
        });
        this.containsCollectionBehaviors = columnSelector.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnRef x$13) {
                return x$13 instanceof CollectionColumnName;
            }
        });
    }
}

