/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitionGenerator$;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteConf$;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceOptions$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.DefaultSource$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class CassandraSourceRelation$ {
    public static final CassandraSourceRelation$ MODULE$;
    private final String ReferenceSection;
    private final ConfigParameter<Option<Object>> TableSizeInBytesParam;
    private final ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam;
    private final Seq<ConfigParameter<? extends Product>> Properties;
    private final String defaultClusterName;

    static {
        new CassandraSourceRelation$();
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public ConfigParameter<Option<Object>> TableSizeInBytesParam() {
        return this.TableSizeInBytesParam;
    }

    public ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam() {
        return this.AdditionalCassandraPushDownRulesParam;
    }

    public Seq<ConfigParameter<? extends Product>> Properties() {
        return this.Properties;
    }

    public String defaultClusterName() {
        return this.defaultClusterName;
    }

    public CassandraSourceRelation apply(TableRef tableRef, SQLContext sqlContext, CassandraSourceOptions options, Option<StructType> schema2) {
        Option option;
        block4: {
            Option option2;
            CassandraConnector cassandraConnector;
            SparkConf conf;
            block3: {
                block2: {
                    SparkConf sparkConf = sqlContext.sparkContext().getConf();
                    Map sqlConf = sqlContext.getAllConfs();
                    conf = this.consolidateConfs(sparkConf, (Map<String, String>)sqlConf, tableRef, options.cassandraConfs());
                    Option tableSizeInBytesString = conf.getOption(this.TableSizeInBytesParam().name());
                    cassandraConnector = new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
                    option = tableSizeInBytesString;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String size = (String)some.x();
                    option2 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(size)).toLong()));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                TokenFactory<Object, Token> tokenFactory = CassandraPartitionGenerator$.MODULE$.getTokenFactory(cassandraConnector);
                long dataSizeInBytes2 = new DataSizeEstimates<Object, Token>(cassandraConnector, tableRef.keyspace(), tableRef.table(), tokenFactory).totalDataSizeInBytes();
                option2 = dataSizeInBytes2 <= 0L ? None$.MODULE$ : Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)dataSizeInBytes2));
            }
            Option tableSizeInBytes = option2;
            ReadConf readConf = ReadConf$.MODULE$.fromSparkConf(conf);
            WriteConf writeConf = WriteConf$.MODULE$.fromSparkConf(conf);
            return new CassandraSourceRelation(tableRef, schema2, options.pushdown(), (Option<Object>)tableSizeInBytes, cassandraConnector, readConf, writeConf, sqlContext);
        }
        throw new MatchError((Object)option);
    }

    public CassandraSourceOptions apply$default$3() {
        return new CassandraSourceOptions(CassandraSourceOptions$.MODULE$.apply$default$1(), CassandraSourceOptions$.MODULE$.apply$default$2());
    }

    public Option<StructType> apply$default$4() {
        return None$.MODULE$;
    }

    public SparkConf consolidateConfs(SparkConf sparkConf, Map<String, String> sqlConf, TableRef tableRef, Map<String, String> tableConf) {
        SparkConf conf = sparkConf.clone();
        String cluster = (String)tableRef.cluster().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return CassandraSourceRelation$.MODULE$.defaultClusterName();
            }
        });
        String ks = tableRef.keyspace();
        DefaultSource$.MODULE$.confProperties().foreach((Function1)new Serializable(sqlConf, tableConf, conf, cluster, ks){
            public static final long serialVersionUID = 0L;
            private final Map sqlConf$1;
            private final Map tableConf$1;
            public final SparkConf conf$1;
            private final String cluster$1;
            private final String ks$1;

            public final void apply(String prop) {
                Option value2 = ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{this.tableConf$1.get((Object)prop), this.sqlConf$1.get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cluster$1, this.ks$1, prop}))), this.sqlConf$1.get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cluster$1, prop}))), this.sqlConf$1.get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop})))})).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<String> apply(Option<String> xo) {
                        return Option$.MODULE$.option2Iterable(xo);
                    }
                })).headOption();
                value2.foreach((Function1)new Serializable(this, prop){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.consolidateConfs.1 $outer;
                    private final String prop$1;

                    public final SparkConf apply(String x$6) {
                        return this.$outer.conf$1.set(this.prop$1, x$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.prop$1 = prop$1;
                    }
                });
            }
            {
                this.sqlConf$1 = sqlConf$1;
                this.tableConf$1 = tableConf$1;
                this.conf$1 = conf$1;
                this.cluster$1 = cluster$1;
                this.ks$1 = ks$1;
            }
        });
        return conf;
    }

    private CassandraSourceRelation$() {
        MODULE$ = this;
        this.ReferenceSection = "Cassandra DataFrame Source Parameters";
        this.TableSizeInBytesParam = new ConfigParameter<None$>("spark.cassandra.table.size.in.bytes", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Used by DataFrames Internally, will be updated in a future release to\n        |retrieve size from C*. Can be set manually now")).stripMargin());
        this.AdditionalCassandraPushDownRulesParam = new ConfigParameter<List>("spark.cassandra.sql.pushdown.additionalClasses", this.ReferenceSection(), List$.MODULE$.empty(), new StringOps(Predef$.MODULE$.augmentString("A comma seperated list of classes to be used (in order) to apply additional\n        | pushdown rules for C* Dataframes. Classes must implement CassandraPredicateRules\n      ")).stripMargin());
        this.Properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigParameter[]{this.AdditionalCassandraPushDownRulesParam(), this.TableSizeInBytesParam()}));
        this.defaultClusterName = "default";
    }
}

