/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.FrameCompressor;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SSLOptions;
import shade.com.datastax.spark.connector.google.common.annotations.VisibleForTesting;

public class ProtocolOptions {
    public static final int DEFAULT_PORT = 9042;
    public static final int DEFAULT_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS = 10;
    private volatile Cluster.Manager manager;
    private final int port;
    final ProtocolVersion initialProtocolVersion;
    @VisibleForTesting
    volatile int maxSchemaAgreementWaitSeconds;
    private final SSLOptions sslOptions;
    private final AuthProvider authProvider;
    private volatile Compression compression = Compression.NONE;

    public ProtocolOptions() {
        this(9042);
    }

    public ProtocolOptions(int port) {
        this(port, null, 10, null, AuthProvider.NONE);
    }

    public ProtocolOptions(int port, ProtocolVersion protocolVersion2, int maxSchemaAgreementWaitSeconds, SSLOptions sslOptions, AuthProvider authProvider) {
        this.port = port;
        this.initialProtocolVersion = protocolVersion2;
        this.maxSchemaAgreementWaitSeconds = maxSchemaAgreementWaitSeconds;
        this.sslOptions = sslOptions;
        this.authProvider = authProvider;
    }

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public int getPort() {
        return this.port;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.manager.connectionFactory.protocolVersion;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public ProtocolOptions setCompression(Compression compression) {
        if (compression != Compression.NONE && compression.compressor() == null) {
            throw new IllegalStateException("The requested compression is not available (some compression require a JAR to be found in the classpath)");
        }
        this.compression = compression;
        return this;
    }

    public int getMaxSchemaAgreementWaitSeconds() {
        return this.maxSchemaAgreementWaitSeconds;
    }

    public SSLOptions getSSLOptions() {
        return this.sslOptions;
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public static enum Compression {
        NONE(""){

            @Override
            FrameCompressor compressor() {
                return null;
            }
        }
        ,
        SNAPPY("snappy"){

            @Override
            FrameCompressor compressor() {
                return FrameCompressor.SnappyCompressor.instance;
            }
        }
        ,
        LZ4("lz4"){

            @Override
            FrameCompressor compressor() {
                return FrameCompressor.LZ4Compressor.instance;
            }
        };

        final String protocolName;

        private Compression(String protocolName) {
            this.protocolName = protocolName;
        }

        abstract FrameCompressor compressor();

        static Compression fromString(String str2) {
            for (Compression c : Compression.values()) {
                if (!c.protocolName.equalsIgnoreCase(str2)) continue;
                return c;
            }
            return null;
        }

        public String toString() {
            return this.protocolName;
        }
    }
}

