/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.cql.DefaultConnectionFactory$;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy$;
import com.datastax.spark.connector.cql.NoAuthConf$;
import com.datastax.spark.connector.cql.PreparedStatementCache$;
import com.datastax.spark.connector.cql.RefCountedCache;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import com.datastax.spark.connector.util.SerialShutdownHooks$;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class CassandraConnector$
implements Logging,
Serializable {
    public static final CassandraConnector$ MODULE$;
    private final RefCountedCache<CassandraConnectorConf, Session> sessionCache;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new CassandraConnector$();
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public RefCountedCache<CassandraConnectorConf, Session> sessionCache() {
        return this.sessionCache;
    }

    public Session com$datastax$spark$connector$cql$CassandraConnector$$createSession(CassandraConnectorConf conf) {
        ObjectRef endpointsStr$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        this.logDebug((Function0<String>)new Serializable(conf, endpointsStr$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf conf$1;
            private final ObjectRef endpointsStr$lzy$1;
            private final VolatileByteRef bitmap$0$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to open native connection to Cassandra at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CassandraConnector$.MODULE$.com$datastax$spark$connector$cql$CassandraConnector$$endpointsStr$1(this.conf$1, this.endpointsStr$lzy$1, this.bitmap$0$2)}));
            }
            {
                this.conf$1 = conf$1;
                this.endpointsStr$lzy$1 = endpointsStr$lzy$1;
                this.bitmap$0$2 = bitmap$0$2;
            }
        });
        Cluster cluster = conf.connectionFactory().createCluster(conf);
        try {
            String clusterName = cluster.getMetadata().getClusterName();
            this.logInfo((Function0<String>)new Serializable(clusterName){
                public static final long serialVersionUID = 0L;
                private final String clusterName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to Cassandra cluster: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterName$1}));
                }
                {
                    this.clusterName$1 = clusterName$1;
                }
            });
            return cluster.connect();
        }
        catch (Throwable throwable) {
            cluster.close();
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to open native connection to Cassandra at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.com$datastax$spark$connector$cql$CassandraConnector$$endpointsStr$1(conf, endpointsStr$lzy, bitmap$0)})), throwable);
        }
    }

    public void com$datastax$spark$connector$cql$CassandraConnector$$destroySession(Session session) {
        Cluster cluster = session.getCluster();
        String clusterName = cluster.getMetadata().getClusterName();
        session.close();
        cluster.close();
        PreparedStatementCache$.MODULE$.remove(cluster);
        this.logInfo((Function0<String>)new Serializable(clusterName){
            public static final long serialVersionUID = 0L;
            private final String clusterName$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disconnected from Cassandra cluster: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterName$2}));
            }
            {
                this.clusterName$2 = clusterName$2;
            }
        });
    }

    public Set<CassandraConnectorConf> com$datastax$spark$connector$cql$CassandraConnector$$alternativeConnectionConfigs(CassandraConnectorConf conf, Session session) {
        Set allHosts = JavaConversions$.MODULE$.asScalaSet(session.getCluster().getMetadata().getAllHosts()).toSet();
        String dcToUse = (String)conf.localDC().getOrElse((Function0)new Serializable(conf, allHosts){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf conf$2;
            private final Set allHosts$2;

            public final String apply() {
                return LocalNodeFirstLoadBalancingPolicy$.MODULE$.determineDataCenter(this.conf$2.hosts(), (Set<Host>)this.allHosts$2);
            }
            {
                this.conf$2 = conf$2;
                this.allHosts$2 = allHosts$2;
            }
        });
        Set hosts2 = (Set)allHosts.filter((Function1)new Serializable(dcToUse){
            public static final long serialVersionUID = 0L;
            private final String dcToUse$2;

            public final boolean apply(Host x$8) {
                String string = x$8.getDatacenter();
                String string2 = this.dcToUse$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.dcToUse$2 = dcToUse$2;
            }
        });
        return (Set)((SetLike)hosts2.map((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf conf$2;

            public final CassandraConnectorConf apply(Host h) {
                return this.conf$2.copy((Set<InetAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{h.getAddress()}))), this.conf$2.copy$default$2(), this.conf$2.copy$default$3(), this.conf$2.copy$default$4(), this.conf$2.copy$default$5(), this.conf$2.copy$default$6(), this.conf$2.copy$default$7(), this.conf$2.copy$default$8(), this.conf$2.copy$default$9(), this.conf$2.copy$default$10(), this.conf$2.copy$default$11(), this.conf$2.copy$default$12(), this.conf$2.copy$default$13(), this.conf$2.copy$default$14());
            }
            {
                this.conf$2 = conf$2;
            }
        }, Set$.MODULE$.canBuildFrom())).$plus((Object)conf.copy((Set<InetAddress>)((Set)hosts2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InetAddress apply(Host x$9) {
                return x$9.getAddress();
            }
        }, Set$.MODULE$.canBuildFrom())), conf.copy$default$2(), conf.copy$default$3(), conf.copy$default$4(), conf.copy$default$5(), conf.copy$default$6(), conf.copy$default$7(), conf.copy$default$8(), conf.copy$default$9(), conf.copy$default$10(), conf.copy$default$11(), conf.copy$default$12(), conf.copy$default$13(), conf.copy$default$14()));
    }

    public CassandraConnector apply(SparkConf conf) {
        return new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
    }

    public CassandraConnector apply(Set<InetAddress> hosts2, int port, AuthConf authConf, Option<String> localDC, int keepAliveMillis, int minReconnectionDelayMillis, int maxReconnectionDelayMillis, int queryRetryCount, int connectTimeoutMillis, int readTimeoutMillis, CassandraConnectionFactory connectionFactory, CassandraConnectorConf.CassandraSSLConf cassandraSSLConf, CassandraConnectorConf.RetryDelayConf queryRetryDelay) {
        Set<InetAddress> x$10 = hosts2;
        int x$11 = port;
        AuthConf x$12 = authConf;
        Option<String> x$13 = localDC;
        int x$14 = keepAliveMillis;
        int x$15 = minReconnectionDelayMillis;
        int x$16 = maxReconnectionDelayMillis;
        int x$17 = queryRetryCount;
        int x$18 = connectTimeoutMillis;
        int x$19 = readTimeoutMillis;
        CassandraConnectionFactory x$20 = connectionFactory;
        CassandraConnectorConf.CassandraSSLConf x$21 = cassandraSSLConf;
        CassandraConnectorConf.RetryDelayConf x$22 = queryRetryDelay;
        ProtocolOptions.Compression x$23 = CassandraConnectorConf$.MODULE$.apply$default$8();
        CassandraConnectorConf config = new CassandraConnectorConf(x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$23, x$17, x$18, x$19, x$20, x$21, x$22);
        return new CassandraConnector(config);
    }

    public int apply$default$2() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ConnectionPortParam().default());
    }

    public AuthConf apply$default$3() {
        return NoAuthConf$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public int apply$default$5() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.KeepAliveMillisParam().default());
    }

    public int apply$default$6() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.MinReconnectionDelayParam().default());
    }

    public int apply$default$7() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.MaxReconnectionDelayParam().default());
    }

    public int apply$default$8() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.QueryRetryParam().default());
    }

    public int apply$default$9() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ConnectionTimeoutParam().default());
    }

    public int apply$default$10() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ReadTimeoutParam().default());
    }

    public CassandraConnectionFactory apply$default$11() {
        return DefaultConnectionFactory$.MODULE$;
    }

    public CassandraConnectorConf.CassandraSSLConf apply$default$12() {
        return CassandraConnectorConf$.MODULE$.DefaultCassandraSSLConf();
    }

    public CassandraConnectorConf.RetryDelayConf apply$default$13() {
        return CassandraConnectorConf$.MODULE$.QueryRetryDelayParam().default();
    }

    public void evictCache() {
        this.sessionCache().evict();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final String endpointsStr$lzycompute$1(CassandraConnectorConf conf$1, ObjectRef endpointsStr$lzy$1, VolatileByteRef bitmap$0$2) {
        CassandraConnector$ cassandraConnector$ = this;
        synchronized (cassandraConnector$) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                endpointsStr$lzy$1.elem = new StringBuilder().append((Object)((TraversableOnce)conf$1.hosts().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(InetAddress x$7) {
                        return x$7.getHostAddress();
                    }
                }, Set$.MODULE$.canBuildFrom())).mkString("{", ", ", "}")).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)conf$1.port())).toString();
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return (String)endpointsStr$lzy$1.elem;
        }
    }

    public final String com$datastax$spark$connector$cql$CassandraConnector$$endpointsStr$1(CassandraConnectorConf conf$1, ObjectRef endpointsStr$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? this.endpointsStr$lzycompute$1(conf$1, endpointsStr$lzy$1, bitmap$0$2) : (String)endpointsStr$lzy$1.elem;
    }

    private CassandraConnector$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.sessionCache = new RefCountedCache(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Session apply(CassandraConnectorConf conf) {
                return CassandraConnector$.MODULE$.com$datastax$spark$connector$cql$CassandraConnector$$createSession(conf);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Session session) {
                CassandraConnector$.MODULE$.com$datastax$spark$connector$cql$CassandraConnector$$destroySession(session);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<CassandraConnectorConf> apply(CassandraConnectorConf conf, Session session) {
                return CassandraConnector$.MODULE$.com$datastax$spark$connector$cql$CassandraConnector$$alternativeConnectionConfigs(conf, session);
            }
        });
        SerialShutdownHooks$.MODULE$.add("Clearing session cache for C* connector", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CassandraConnector$.MODULE$.sessionCache().shutdown();
            }
        });
    }
}

