/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.ProtocolOptions;
import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.AuthConf$;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CassandraConnectorConf$CassandraSSLConf$;
import com.datastax.spark.connector.cql.DefaultConnectionFactory$;
import com.datastax.spark.connector.cql.NoAuthConf$;
import com.datastax.spark.connector.util.ConfigCheck$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import java.net.InetAddress;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple14;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CassandraConnectorConf$
implements Logging,
Serializable {
    public static final CassandraConnectorConf$ MODULE$;
    private final String ReferenceSection;
    private final ConfigParameter<String> ConnectionHostParam;
    private final ConfigParameter<Object> ConnectionPortParam;
    private final ConfigParameter<Option<String>> LocalDCParam;
    private final ConfigParameter<Object> ConnectionTimeoutParam;
    private final ConfigParameter<Object> KeepAliveMillisParam;
    private final ConfigParameter<Object> MinReconnectionDelayParam;
    private final ConfigParameter<Object> MaxReconnectionDelayParam;
    private final ConfigParameter<ProtocolOptions.Compression> CompressionParam;
    private final ConfigParameter<Object> QueryRetryParam;
    private final ConfigParameter<CassandraConnectorConf.RetryDelayConf> QueryRetryDelayParam;
    private final ConfigParameter<Object> ReadTimeoutParam;
    private final String ReferenceSectionSSL;
    private final CassandraConnectorConf.CassandraSSLConf DefaultCassandraSSLConf;
    private final ConfigParameter<Object> SSLEnabledParam;
    private final ConfigParameter<Option<String>> SSLTrustStorePathParam;
    private final ConfigParameter<Option<String>> SSLTrustStorePasswordParam;
    private final ConfigParameter<String> SSLTrustStoreTypeParam;
    private final ConfigParameter<String> SSLProtocolParam;
    private final String CassandraConnectionSSLEnabledAlgorithmsProperty;
    private final Set<String> DefaultSSLEnabledAlgorithms;
    private final String CassandraConnectionSSLEnabledAlgorithmsDescription;
    private final ConfigParameter<Set<String>> SSLEnabledAlgorithmsParam;
    private final ConfigParameter<Object> SSLClientAuthEnabledParam;
    private final ConfigParameter<Option<String>> SSLKeyStorePathParam;
    private final ConfigParameter<Option<String>> SSLKeyStorePasswordParam;
    private final ConfigParameter<String> SSLKeyStoreTypeParam;
    private final Set<ConfigParameter<?>> Properties;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new CassandraConnectorConf$();
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public ConfigParameter<String> ConnectionHostParam() {
        return this.ConnectionHostParam;
    }

    public ConfigParameter<Object> ConnectionPortParam() {
        return this.ConnectionPortParam;
    }

    public ConfigParameter<Option<String>> LocalDCParam() {
        return this.LocalDCParam;
    }

    public ConfigParameter<Object> ConnectionTimeoutParam() {
        return this.ConnectionTimeoutParam;
    }

    public ConfigParameter<Object> KeepAliveMillisParam() {
        return this.KeepAliveMillisParam;
    }

    public ConfigParameter<Object> MinReconnectionDelayParam() {
        return this.MinReconnectionDelayParam;
    }

    public ConfigParameter<Object> MaxReconnectionDelayParam() {
        return this.MaxReconnectionDelayParam;
    }

    public ConfigParameter<ProtocolOptions.Compression> CompressionParam() {
        return this.CompressionParam;
    }

    public ConfigParameter<Object> QueryRetryParam() {
        return this.QueryRetryParam;
    }

    public ConfigParameter<CassandraConnectorConf.RetryDelayConf> QueryRetryDelayParam() {
        return this.QueryRetryDelayParam;
    }

    public ConfigParameter<Object> ReadTimeoutParam() {
        return this.ReadTimeoutParam;
    }

    public String ReferenceSectionSSL() {
        return this.ReferenceSectionSSL;
    }

    public CassandraConnectorConf.CassandraSSLConf DefaultCassandraSSLConf() {
        return this.DefaultCassandraSSLConf;
    }

    public ConfigParameter<Object> SSLEnabledParam() {
        return this.SSLEnabledParam;
    }

    public ConfigParameter<Option<String>> SSLTrustStorePathParam() {
        return this.SSLTrustStorePathParam;
    }

    public ConfigParameter<Option<String>> SSLTrustStorePasswordParam() {
        return this.SSLTrustStorePasswordParam;
    }

    public ConfigParameter<String> SSLTrustStoreTypeParam() {
        return this.SSLTrustStoreTypeParam;
    }

    public ConfigParameter<String> SSLProtocolParam() {
        return this.SSLProtocolParam;
    }

    public String CassandraConnectionSSLEnabledAlgorithmsProperty() {
        return this.CassandraConnectionSSLEnabledAlgorithmsProperty;
    }

    public Set<String> DefaultSSLEnabledAlgorithms() {
        return this.DefaultSSLEnabledAlgorithms;
    }

    public String CassandraConnectionSSLEnabledAlgorithmsDescription() {
        return this.CassandraConnectionSSLEnabledAlgorithmsDescription;
    }

    public ConfigParameter<Set<String>> SSLEnabledAlgorithmsParam() {
        return this.SSLEnabledAlgorithmsParam;
    }

    public ConfigParameter<Object> SSLClientAuthEnabledParam() {
        return this.SSLClientAuthEnabledParam;
    }

    public ConfigParameter<Option<String>> SSLKeyStorePathParam() {
        return this.SSLKeyStorePathParam;
    }

    public ConfigParameter<Option<String>> SSLKeyStorePasswordParam() {
        return this.SSLKeyStorePasswordParam;
    }

    public ConfigParameter<String> SSLKeyStoreTypeParam() {
        return this.SSLKeyStoreTypeParam;
    }

    public Set<ConfigParameter<?>> Properties() {
        return this.Properties;
    }

    public Option<InetAddress> com$datastax$spark$connector$cql$CassandraConnectorConf$$resolveHost(String hostName) {
        Some some;
        try {
            some = new Some((Object)InetAddress.getByName(hostName));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(hostName){
                public static final long serialVersionUID = 0L;
                private final String hostName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostName$1}));
                }
                {
                    this.hostName$1 = hostName$1;
                }
            }, e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public CassandraConnectorConf apply(SparkConf conf) {
        ConfigCheck$.MODULE$.checkConfig(conf);
        String hostsStr = conf.get(this.ConnectionHostParam().name(), InetAddress.getLocalHost().getHostAddress());
        Set hosts2 = (Set)Predef$.MODULE$.refArrayOps((Object[])hostsStr.split(",")).toSet().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<InetAddress> apply(String hostName) {
                return Option$.MODULE$.option2Iterable(CassandraConnectorConf$.MODULE$.com$datastax$spark$connector$cql$CassandraConnectorConf$$resolveHost(hostName.trim()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InetAddress apply(InetAddress hostAddress) {
                        return hostAddress;
                    }
                }));
            }
        }, Set$.MODULE$.canBuildFrom());
        int port = conf.getInt(this.ConnectionPortParam().name(), BoxesRunTime.unboxToInt((Object)this.ConnectionPortParam().default()));
        AuthConf authConf = AuthConf$.MODULE$.fromSparkConf(conf);
        int keepAlive = conf.getInt(this.KeepAliveMillisParam().name(), BoxesRunTime.unboxToInt((Object)this.KeepAliveMillisParam().default()));
        Option localDC = conf.getOption(this.LocalDCParam().name());
        int minReconnectionDelay = conf.getInt(this.MinReconnectionDelayParam().name(), BoxesRunTime.unboxToInt((Object)this.MinReconnectionDelayParam().default()));
        int maxReconnectionDelay = conf.getInt(this.MaxReconnectionDelayParam().name(), BoxesRunTime.unboxToInt((Object)this.MaxReconnectionDelayParam().default()));
        int queryRetryCount = conf.getInt(this.QueryRetryParam().name(), BoxesRunTime.unboxToInt((Object)this.QueryRetryParam().default()));
        int connectTimeout = conf.getInt(this.ConnectionTimeoutParam().name(), BoxesRunTime.unboxToInt((Object)this.ConnectionTimeoutParam().default()));
        int readTimeout = conf.getInt(this.ReadTimeoutParam().name(), BoxesRunTime.unboxToInt((Object)this.ReadTimeoutParam().default()));
        ProtocolOptions.Compression compression = (ProtocolOptions.Compression)((Object)conf.getOption(this.CompressionParam().name()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ProtocolOptions.Compression apply(String x$1) {
                return ProtocolOptions.Compression.valueOf(x$1);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ProtocolOptions.Compression apply() {
                return CassandraConnectorConf$.MODULE$.CompressionParam().default();
            }
        }));
        CassandraConnectionFactory connectionFactory = CassandraConnectionFactory$.MODULE$.fromSparkConf(conf);
        boolean sslEnabled = conf.getBoolean(this.SSLEnabledParam().name(), BoxesRunTime.unboxToBoolean((Object)this.SSLEnabledParam().default()));
        Option sslTrustStorePath = conf.getOption(this.SSLTrustStorePathParam().name()).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return CassandraConnectorConf$.MODULE$.SSLTrustStorePathParam().default();
            }
        });
        Option sslTrustStorePassword = conf.getOption(this.SSLTrustStorePasswordParam().name()).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return CassandraConnectorConf$.MODULE$.SSLTrustStorePasswordParam().default();
            }
        });
        String sslTrustStoreType = conf.get(this.SSLTrustStoreTypeParam().name(), this.SSLTrustStoreTypeParam().default());
        String sslProtocol = conf.get(this.SSLProtocolParam().name(), this.SSLProtocolParam().default());
        Set sslEnabledAlgorithms = (Set)conf.getOption(this.SSLEnabledAlgorithmsParam().name()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])x$1.split(",")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$2) {
                        return x$2.trim();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<String> apply() {
                return CassandraConnectorConf$.MODULE$.SSLEnabledAlgorithmsParam().default();
            }
        });
        boolean sslClientAuthEnabled = conf.getBoolean(this.SSLClientAuthEnabledParam().name(), BoxesRunTime.unboxToBoolean((Object)this.SSLClientAuthEnabledParam().default()));
        Option sslKeyStorePath = conf.getOption(this.SSLKeyStorePathParam().name()).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return CassandraConnectorConf$.MODULE$.SSLKeyStorePathParam().default();
            }
        });
        Option sslKeyStorePassword = conf.getOption(this.SSLKeyStorePasswordParam().name()).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return CassandraConnectorConf$.MODULE$.SSLKeyStorePasswordParam().default();
            }
        });
        String sslKeyStoreType = conf.get(this.SSLKeyStoreTypeParam().name(), this.SSLKeyStoreTypeParam().default());
        boolean x$3 = sslEnabled;
        Option x$4 = sslTrustStorePath;
        Option x$5 = sslTrustStorePassword;
        String x$6 = sslTrustStoreType;
        boolean x$7 = sslClientAuthEnabled;
        Option x$8 = sslKeyStorePath;
        Option x$9 = sslKeyStorePassword;
        String x$10 = sslKeyStoreType;
        String x$11 = sslProtocol;
        Set x$12 = sslEnabledAlgorithms;
        CassandraConnectorConf.CassandraSSLConf cassandraSSLConf = new CassandraConnectorConf.CassandraSSLConf(x$3, (Option<String>)x$4, (Option<String>)x$5, x$6, x$11, (Set<String>)x$12, x$7, (Option<String>)x$8, (Option<String>)x$9, x$10);
        return new CassandraConnectorConf((Set<InetAddress>)hosts2, port, authConf, (Option<String>)localDC, keepAlive, minReconnectionDelay, maxReconnectionDelay, compression, queryRetryCount, connectTimeout, readTimeout, connectionFactory, cassandraSSLConf, this.apply$default$14());
    }

    public int apply$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.ConnectionPortParam().default());
    }

    public AuthConf apply$default$3() {
        return NoAuthConf$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public int apply$default$5() {
        return BoxesRunTime.unboxToInt((Object)this.KeepAliveMillisParam().default());
    }

    public int apply$default$6() {
        return BoxesRunTime.unboxToInt((Object)this.MinReconnectionDelayParam().default());
    }

    public int apply$default$7() {
        return BoxesRunTime.unboxToInt((Object)this.MaxReconnectionDelayParam().default());
    }

    public ProtocolOptions.Compression apply$default$8() {
        return this.CompressionParam().default();
    }

    public int apply$default$9() {
        return BoxesRunTime.unboxToInt((Object)this.QueryRetryParam().default());
    }

    public int apply$default$10() {
        return BoxesRunTime.unboxToInt((Object)this.ConnectionTimeoutParam().default());
    }

    public int apply$default$11() {
        return BoxesRunTime.unboxToInt((Object)this.ReadTimeoutParam().default());
    }

    public CassandraConnectionFactory apply$default$12() {
        return DefaultConnectionFactory$.MODULE$;
    }

    public CassandraConnectorConf.CassandraSSLConf apply$default$13() {
        return this.DefaultCassandraSSLConf();
    }

    public CassandraConnectorConf.RetryDelayConf apply$default$14() {
        return this.QueryRetryDelayParam().default();
    }

    public CassandraConnectorConf apply(Set<InetAddress> hosts2, int port, AuthConf authConf, Option<String> localDC, int keepAliveMillis, int minReconnectionDelayMillis, int maxReconnectionDelayMillis, ProtocolOptions.Compression compression, int queryRetryCount, int connectTimeoutMillis, int readTimeoutMillis, CassandraConnectionFactory connectionFactory, CassandraConnectorConf.CassandraSSLConf cassandraSSLConf, CassandraConnectorConf.RetryDelayConf queryRetryDelay) {
        return new CassandraConnectorConf(hosts2, port, authConf, localDC, keepAliveMillis, minReconnectionDelayMillis, maxReconnectionDelayMillis, compression, queryRetryCount, connectTimeoutMillis, readTimeoutMillis, connectionFactory, cassandraSSLConf, queryRetryDelay);
    }

    public Option<Tuple14<Set<InetAddress>, Object, AuthConf, Option<String>, Object, Object, Object, ProtocolOptions.Compression, Object, Object, Object, CassandraConnectionFactory, CassandraConnectorConf.CassandraSSLConf, CassandraConnectorConf.RetryDelayConf>> unapply(CassandraConnectorConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14(x$0.hosts(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.authConf(), x$0.localDC(), (Object)BoxesRunTime.boxToInteger((int)x$0.keepAliveMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.minReconnectionDelayMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.maxReconnectionDelayMillis()), (Object)x$0.compression(), (Object)BoxesRunTime.boxToInteger((int)x$0.queryRetryCount()), (Object)BoxesRunTime.boxToInteger((int)x$0.connectTimeoutMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.readTimeoutMillis()), (Object)x$0.connectionFactory(), (Object)x$0.cassandraSSLConf(), (Object)x$0.queryRetryDelay()));
    }

    public int $lessinit$greater$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.ConnectionPortParam().default());
    }

    public AuthConf $lessinit$greater$default$3() {
        return NoAuthConf$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public int $lessinit$greater$default$5() {
        return BoxesRunTime.unboxToInt((Object)this.KeepAliveMillisParam().default());
    }

    public int $lessinit$greater$default$6() {
        return BoxesRunTime.unboxToInt((Object)this.MinReconnectionDelayParam().default());
    }

    public int $lessinit$greater$default$7() {
        return BoxesRunTime.unboxToInt((Object)this.MaxReconnectionDelayParam().default());
    }

    public ProtocolOptions.Compression $lessinit$greater$default$8() {
        return this.CompressionParam().default();
    }

    public int $lessinit$greater$default$9() {
        return BoxesRunTime.unboxToInt((Object)this.QueryRetryParam().default());
    }

    public int $lessinit$greater$default$10() {
        return BoxesRunTime.unboxToInt((Object)this.ConnectionTimeoutParam().default());
    }

    public int $lessinit$greater$default$11() {
        return BoxesRunTime.unboxToInt((Object)this.ReadTimeoutParam().default());
    }

    public CassandraConnectionFactory $lessinit$greater$default$12() {
        return DefaultConnectionFactory$.MODULE$;
    }

    public CassandraConnectorConf.CassandraSSLConf $lessinit$greater$default$13() {
        return this.DefaultCassandraSSLConf();
    }

    public CassandraConnectorConf.RetryDelayConf $lessinit$greater$default$14() {
        return this.QueryRetryDelayParam().default();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraConnectorConf$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ReferenceSection = "Cassandra Connection Parameters";
        this.ConnectionHostParam = new ConfigParameter<String>("spark.cassandra.connection.host", this.ReferenceSection(), "localhost", new StringOps(Predef$.MODULE$.augmentString("Contact point to connect to the Cassandra cluster. A comma seperated list\n        |may also be used. (\"127.0.0.1,192.168.0.1\")\n      ")).stripMargin());
        this.ConnectionPortParam = new ConfigParameter<Integer>("spark.cassandra.connection.port", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)9042), "Cassandra native connection port");
        this.LocalDCParam = new ConfigParameter<None$>("spark.cassandra.connection.local_dc", this.ReferenceSection(), None$.MODULE$, "The local DC to connect to (other nodes will be ignored)");
        this.ConnectionTimeoutParam = new ConfigParameter<Integer>("spark.cassandra.connection.timeout_ms", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)5000), "Maximum period of time to attempt connecting to a node");
        this.KeepAliveMillisParam = new ConfigParameter<Integer>("spark.cassandra.connection.keep_alive_ms", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)5000), "Period of time to keep unused connections open");
        this.MinReconnectionDelayParam = new ConfigParameter<Integer>("spark.cassandra.connection.reconnection_delay_ms.min", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)1000), "Minimum period of time to wait before reconnecting to a dead node");
        this.MaxReconnectionDelayParam = new ConfigParameter<Integer>("spark.cassandra.connection.reconnection_delay_ms.max", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)60000), "Maximum period of time to wait before reconnecting to a dead node");
        this.CompressionParam = new ConfigParameter<ProtocolOptions.Compression>("spark.cassandra.connection.compression", this.ReferenceSection(), ProtocolOptions.Compression.NONE, "Compression to use (LZ4, SNAPPY or NONE)");
        this.QueryRetryParam = new ConfigParameter<Integer>("spark.cassandra.query.retry.count", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)10), "Number of times to retry a timed-out query");
        this.QueryRetryDelayParam = new ConfigParameter<CassandraConnectorConf.RetryDelayConf.ExponentialDelay>("spark.cassandra.query.retry.delay", this.ReferenceSection(), new CassandraConnectorConf.RetryDelayConf.ExponentialDelay((Duration)new package.DurationInt(package$.MODULE$.DurationInt(4)).seconds(), 1.5), new StringOps(Predef$.MODULE$.augmentString("The delay between subsequent retries (can be constant,\n      | like 1000; linearly increasing, like 1000+100; or exponential, like 1000*2)")).stripMargin());
        this.ReadTimeoutParam = new ConfigParameter<Integer>("spark.cassandra.read.timeout_ms", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)120000), "Maximum period of time to wait for a read to return ");
        this.ReferenceSectionSSL = "Cassandra SSL Connection Options";
        this.DefaultCassandraSSLConf = new CassandraConnectorConf.CassandraSSLConf(CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$1(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$2(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$3(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$4(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$5(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$6(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$7(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$8(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$9(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$10());
        this.SSLEnabledParam = new ConfigParameter<Boolean>("spark.cassandra.connection.ssl.enabled", this.ReferenceSectionSSL(), BoxesRunTime.boxToBoolean((boolean)this.DefaultCassandraSSLConf().enabled()), "Enable secure connection to Cassandra cluster");
        this.SSLTrustStorePathParam = new ConfigParameter<Option<String>>("spark.cassandra.connection.ssl.trustStore.path", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().trustStorePath(), "Path for the trust store being used");
        this.SSLTrustStorePasswordParam = new ConfigParameter<Option<String>>("spark.cassandra.connection.ssl.trustStore.password", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().trustStorePassword(), "Trust store password");
        this.SSLTrustStoreTypeParam = new ConfigParameter<String>("spark.cassandra.connection.ssl.trustStore.type", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().trustStoreType(), "Trust store type");
        this.SSLProtocolParam = new ConfigParameter<String>("spark.cassandra.connection.ssl.protocol", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().protocol(), "SSL protocol");
        this.CassandraConnectionSSLEnabledAlgorithmsProperty = "spark.cassandra.connection.ssl.enabledAlgorithms";
        this.DefaultSSLEnabledAlgorithms = this.DefaultCassandraSSLConf().enabledAlgorithms();
        this.CassandraConnectionSSLEnabledAlgorithmsDescription = "SSL cipher suites";
        this.SSLEnabledAlgorithmsParam = new ConfigParameter<Set<String>>("spark.cassandra.connection.ssl.enabledAlgorithms", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().enabledAlgorithms(), "SSL cipher suites");
        this.SSLClientAuthEnabledParam = new ConfigParameter<Boolean>("spark.cassandra.connection.ssl.clientAuth.enabled", this.ReferenceSectionSSL(), BoxesRunTime.boxToBoolean((boolean)this.DefaultCassandraSSLConf().clientAuthEnabled()), "Enable 2-way secure connection to Cassandra cluster");
        this.SSLKeyStorePathParam = new ConfigParameter<Option<String>>("spark.cassandra.connection.ssl.keyStore.path", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().keyStorePath(), "Path for the key store being used");
        this.SSLKeyStorePasswordParam = new ConfigParameter<Option<String>>("spark.cassandra.connection.ssl.keyStore.password", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().keyStorePassword(), "Key store password");
        this.SSLKeyStoreTypeParam = new ConfigParameter<String>("spark.cassandra.connection.ssl.keyStore.type", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().keyStoreType(), "Key store type");
        this.Properties = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigParameter[]{this.ConnectionHostParam(), this.ConnectionPortParam(), this.LocalDCParam(), this.ConnectionTimeoutParam(), this.KeepAliveMillisParam(), this.MinReconnectionDelayParam(), this.MaxReconnectionDelayParam(), this.CompressionParam(), this.QueryRetryParam(), this.QueryRetryDelayParam(), this.ReadTimeoutParam(), this.SSLEnabledParam(), this.SSLTrustStoreTypeParam(), this.SSLTrustStorePathParam(), this.SSLTrustStorePasswordParam(), this.SSLProtocolParam(), this.SSLEnabledAlgorithmsParam(), this.SSLClientAuthEnabledParam(), this.SSLKeyStorePathParam(), this.SSLKeyStorePasswordParam(), this.SSLKeyStoreTypeParam()}));
    }
}

