/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;

public final class PreparedStatementCache$
implements Logging {
    public static final PreparedStatementCache$ MODULE$;
    private final TrieMap<Cluster, TrieMap<String, PreparedStatement>> clusterCache;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new PreparedStatementCache$();
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private TrieMap<Cluster, TrieMap<String, PreparedStatement>> clusterCache() {
        return this.clusterCache;
    }

    private Option<PreparedStatement> get(Cluster cluster, String query) {
        return this.clusterCache().get((Object)cluster).flatMap((Function1)new Serializable(query){
            public static final long serialVersionUID = 0L;
            private final String query$1;

            public final Option<PreparedStatement> apply(TrieMap<String, PreparedStatement> statementCache) {
                return statementCache.get((Object)this.query$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PreparedStatement apply(PreparedStatement statement) {
                        return statement;
                    }
                });
            }
            {
                this.query$1 = query$1;
            }
        });
    }

    private PreparedStatement put(Cluster cluster, String query, PreparedStatement statement) {
        Option option;
        block4: {
            block3: {
                Option option2;
                block2: {
                    option = this.clusterCache().get((Object)cluster);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    TrieMap statementCache = (TrieMap)some.x();
                    option2 = statementCache.put((Object)query, (Object)statement);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                option2 = this.clusterCache().put((Object)cluster, (Object)TrieMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)query), (Object)statement)})));
            }
            return statement;
        }
        throw new MatchError((Object)option);
    }

    public void remove(Cluster cluster) {
        PreparedStatementCache$ preparedStatementCache$ = this;
        synchronized (preparedStatementCache$) {
            this.clusterCache().remove((Object)cluster);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareStatement(Session session, RegularStatement query) {
        Cluster cluster = session.getCluster();
        Option<PreparedStatement> option = this.get(cluster, query.toString());
        if (option instanceof Some) {
            Some some = (Some)option;
            PreparedStatement stmt = (PreparedStatement)some.x();
            return stmt;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        PreparedStatementCache$ preparedStatementCache$ = this;
        synchronized (preparedStatementCache$) {
            Option<PreparedStatement> option2;
            block7: {
                PreparedStatement preparedStatement;
                option2 = this.get(cluster, query.toString());
                if (option2 instanceof Some) {
                    PreparedStatement stmt;
                    Some some = (Some)option2;
                    preparedStatement = stmt = (PreparedStatement)some.x();
                } else {
                    if (!None$.MODULE$.equals(option2)) break block7;
                    PreparedStatement stmt = session.prepare(query);
                    preparedStatement = this.put(cluster, query.toString(), stmt);
                }
                PreparedStatement preparedStatement2 = preparedStatement;
                return preparedStatement2;
            }
            throw new MatchError(option2);
        }
    }

    private PreparedStatementCache$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.clusterCache = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

