/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ClusteringColumn;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.ColumnDef$;
import com.datastax.spark.connector.cql.IndexDef;
import com.datastax.spark.connector.cql.KeyspaceDef;
import com.datastax.spark.connector.cql.PartitionKeyColumn$;
import com.datastax.spark.connector.cql.RegularColumn$;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.StaticColumn$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import com.datastax.spark.connector.util.NameTools;
import com.datastax.spark.connector.util.NameTools$;
import java.io.IOException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Schema$
implements Logging,
Serializable {
    public static final Schema$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new Schema$();
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public Seq<ColumnDef> com$datastax$spark$connector$cql$Schema$$fetchPartitionKey(AbstractTableMetadata table) {
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(table.getPartitionKey()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(ColumnMetadata column) {
                return ColumnDef$.MODULE$.apply(column, PartitionKeyColumn$.MODULE$);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public Seq<ColumnDef> com$datastax$spark$connector$cql$Schema$$fetchClusteringColumns(AbstractTableMetadata table) {
        return (Seq)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(table.getClusteringColumns()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<ColumnMetadata, Object> check$ifrefutable$1) {
                Tuple2<ColumnMetadata, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(Tuple2<ColumnMetadata, Object> x$13) {
                Tuple2<ColumnMetadata, Object> tuple2 = x$13;
                if (tuple2 != null) {
                    ColumnMetadata column = (ColumnMetadata)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    ColumnDef columnDef = ColumnDef$.MODULE$.apply(column, new ClusteringColumn(index));
                    return columnDef;
                }
                throw new MatchError(tuple2);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public Seq<ColumnDef> com$datastax$spark$connector$cql$Schema$$fetchRegularColumns(AbstractTableMetadata table) {
        Set primaryKey = JavaConversions$.MODULE$.asScalaBuffer(table.getPrimaryKey()).toSet();
        Buffer regularColumns = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(table.getColumns()).filterNot((Function1)new Serializable(primaryKey){
            public static final long serialVersionUID = 0L;
            private final Set primaryKey$1;

            public final boolean apply(ColumnMetadata elem) {
                return this.primaryKey$1.contains((Object)elem);
            }
            {
                this.primaryKey$1 = primaryKey$1;
            }
        });
        return (Seq)regularColumns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(ColumnMetadata column) {
                return column.isStatic() ? ColumnDef$.MODULE$.apply(column, StaticColumn$.MODULE$) : ColumnDef$.MODULE$.apply(column, RegularColumn$.MODULE$);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public Schema fromCassandra(CassandraConnector connector, Option<String> keyspaceName, Option<String> tableName) {
        return (Schema)connector.withClusterDo(new Serializable(keyspaceName, tableName){
            public static final long serialVersionUID = 0L;
            private final Option keyspaceName$1;
            private final Option tableName$1;

            public final Schema apply(Cluster cluster) {
                String clusterName = cluster.getMetadata().getClusterName();
                Schema$.MODULE$.logDebug((Function0<String>)new Serializable(this, clusterName){
                    public static final long serialVersionUID = 0L;
                    private final String clusterName$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieving database schema from cluster ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterName$1}));
                    }
                    {
                        this.clusterName$1 = clusterName$1;
                    }
                });
                Set keyspaces = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchKeyspaces$1(cluster.getMetadata(), this.keyspaceName$1, this.tableName$1);
                Schema$.MODULE$.logDebug((Function0<String>)new Serializable(this, clusterName, keyspaces){
                    public static final long serialVersionUID = 0L;
                    private final String clusterName$1;
                    private final Set keyspaces$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " keyspaces fetched from cluster ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.keyspaces$1.size()), this.clusterName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.keyspaces$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(KeyspaceDef x$15) {
                                return x$15.keyspaceName();
                            }
                        }, Set$.MODULE$.canBuildFrom())).mkString("{", ",", "}")}))).toString();
                    }
                    {
                        this.clusterName$1 = clusterName$1;
                        this.keyspaces$1 = keyspaces$1;
                    }
                });
                return new Schema(clusterName, (Set<KeyspaceDef>)keyspaces);
            }
            {
                this.keyspaceName$1 = keyspaceName$1;
                this.tableName$1 = tableName$1;
            }
        });
    }

    public Option<String> fromCassandra$default$2() {
        return None$.MODULE$;
    }

    public Option<String> fromCassandra$default$3() {
        return None$.MODULE$;
    }

    public TableDef tableFromCassandra(CassandraConnector connector, String keyspaceName, String tableName) {
        Option option = this.fromCassandra(connector, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName)).tables().headOption();
        if (option instanceof Some) {
            TableDef t;
            Some some = (Some)option;
            TableDef tableDef = t = (TableDef)some.x();
            return tableDef;
        }
        if (None$.MODULE$.equals(option)) {
            Metadata metadata2 = (Metadata)connector.withClusterDo(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Metadata apply(Cluster x$16) {
                    return x$16.getMetadata();
                }
            });
            Option<NameTools.Suggestions> suggestions = NameTools$.MODULE$.getSuggestions(metadata2, keyspaceName, tableName);
            String errorMessage = NameTools$.MODULE$.getErrorString(keyspaceName, tableName, suggestions);
            throw new IOException(errorMessage);
        }
        throw new MatchError((Object)option);
    }

    public Schema apply(String clusterName, Set<KeyspaceDef> keyspaces) {
        return new Schema(clusterName, keyspaces);
    }

    public Option<Tuple2<String, Set<KeyspaceDef>>> unapply(Schema x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.clusterName(), x$0.keyspaces()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final boolean com$datastax$spark$connector$cql$Schema$$isKeyspaceSelected$1(KeyspaceMetadata keyspace, Option keyspaceName$1) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = keyspaceName$1;
                    if (!None$.MODULE$.equals(option)) break block2;
                    bl = true;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                String name = (String)some.x();
                String string = keyspace.getName();
                String string2 = name;
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public final boolean com$datastax$spark$connector$cql$Schema$$isTableSelected$1(AbstractTableMetadata table, Option tableName$1) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = tableName$1;
                    if (!None$.MODULE$.equals(option)) break block2;
                    bl = true;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                String name = (String)some.x();
                String string = table.getName();
                String string2 = name;
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public final Set com$datastax$spark$connector$cql$Schema$$fetchTables$1(KeyspaceMetadata keyspace, Option tableName$1) {
        return (Set)JavaConversions$.MODULE$.collectionAsScalaIterable(keyspace.getTables()).toSet().$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.collectionAsScalaIterable(keyspace.getMaterializedViews()).toSet()).withFilter((Function1)new Serializable(tableName$1){
            public static final long serialVersionUID = 0L;
            private final Option tableName$1;

            public final boolean apply(AbstractTableMetadata table) {
                return Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$isTableSelected$1(table, this.tableName$1);
            }
            {
                this.tableName$1 = tableName$1;
            }
        }).map((Function1)new Serializable(keyspace){
            public static final long serialVersionUID = 0L;
            private final KeyspaceMetadata keyspace$1;

            public final TableDef apply(AbstractTableMetadata table) {
                Seq<ColumnDef> partitionKey = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchPartitionKey(table);
                Seq<ColumnDef> clusteringColumns = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchClusteringColumns(table);
                Seq<ColumnDef> regularColumns = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchRegularColumns(table);
                Seq indexDefs = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$getIndexDefs$1(table);
                AbstractTableMetadata abstractTableMetadata = table;
                boolean bl = abstractTableMetadata instanceof MaterializedViewMetadata;
                boolean isView = bl;
                return new TableDef(this.keyspace$1.getName(), table.getName(), partitionKey, clusteringColumns, regularColumns, (Seq<IndexDef>)indexDefs, isView);
            }
            {
                this.keyspace$1 = keyspace$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public final Set com$datastax$spark$connector$cql$Schema$$fetchKeyspaces$1(Metadata metadata2, Option keyspaceName$1, Option tableName$1) {
        return (Set)JavaConversions$.MODULE$.asScalaBuffer(metadata2.getKeyspaces()).toSet().withFilter((Function1)new Serializable(keyspaceName$1){
            public static final long serialVersionUID = 0L;
            private final Option keyspaceName$1;

            public final boolean apply(KeyspaceMetadata keyspace) {
                return Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$isKeyspaceSelected$1(keyspace, this.keyspaceName$1);
            }
            {
                this.keyspaceName$1 = keyspaceName$1;
            }
        }).map((Function1)new Serializable(tableName$1){
            public static final long serialVersionUID = 0L;
            private final Option tableName$1;

            public final KeyspaceDef apply(KeyspaceMetadata keyspace) {
                return new KeyspaceDef(keyspace.getName(), (Set<TableDef>)Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchTables$1(keyspace, this.tableName$1));
            }
            {
                this.tableName$1 = tableName$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public final String com$datastax$spark$connector$cql$Schema$$handleId$1(TableMetadata table, String columnName2) {
        return (String)Option$.MODULE$.apply((Object)table.getColumn(columnName2)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnMetadata x$14) {
                return x$14.getName();
            }
        }).getOrElse((Function0)new Serializable(columnName2){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;

            public final String apply() {
                return this.columnName$1;
            }
            {
                this.columnName$1 = columnName$1;
            }
        });
    }

    public final Seq com$datastax$spark$connector$cql$Schema$$getIndexDefs$1(AbstractTableMetadata tableOrView) {
        AbstractTableMetadata abstractTableMetadata;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    abstractTableMetadata = tableOrView;
                    if (!(abstractTableMetadata instanceof TableMetadata)) break block2;
                    TableMetadata tableMetadata = (TableMetadata)abstractTableMetadata;
                    seq = ((TraversableOnce)JavaConversions$.MODULE$.collectionAsScalaIterable(tableMetadata.getIndexes()).map((Function1)new Serializable(tableMetadata){
                        public static final long serialVersionUID = 0L;
                        private final TableMetadata x2$1;

                        public final IndexDef apply(IndexMetadata index) {
                            String target = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$handleId$1(this.x2$1, index.getTarget());
                            return new IndexDef(index.getIndexClassName(), target, index.getName(), (Map<String, String>)Predef$.MODULE$.Map().empty());
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq();
                    break block3;
                }
                if (!(abstractTableMetadata instanceof MaterializedViewMetadata)) break block4;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)abstractTableMetadata);
    }

    private Schema$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

