/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.cql.KeyspaceDef;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.CassandraSQLContext;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceOptions$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.catalyst.CatalystConf;
import org.apache.spark.sql.catalyst.SimpleCatalystConf;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Catalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Subquery;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.sources.BaseRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import shade.com.datastax.spark.connector.google.common.cache.CacheBuilder;
import shade.com.datastax.spark.connector.google.common.cache.CacheLoader;
import shade.com.datastax.spark.connector.google.common.cache.LoadingCache;

@ScalaSignature(bytes="\u0006\u0001\u0005me!B\u0001\u0003\u0001\ta!\u0001E\"bgN\fg\u000e\u001a:b\u0007\u0006$\u0018\r\\8h\u0015\t\u0019A!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\t\u0001i1c\u0007\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005QIR\"A\u000b\u000b\u0005Y9\u0012\u0001C1oC2L8/[:\u000b\u0005a!\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005i)\"aB\"bi\u0006dwn\u001a\t\u00039\u0019j\u0011!\b\u0006\u0003=}\tA!\u001e;jY*\u0011\u0001%I\u0001\nG>tg.Z2u_JT!a\u0002\u0012\u000b\u0005\r\"\u0013\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003\u0015\n1aY8n\u0013\t9SDA\u0004M_\u001e<\u0017N\\4\t\u0011%\u0002!\u0011!Q\u0001\n-\n1aY:d\u0007\u0001\u0001\"\u0001L\u0017\u000e\u0003\tI!A\f\u0002\u0003'\r\u000b7o]1oIJ\f7+\u0015'D_:$X\r\u001f;\t\u000bA\u0002A\u0011A\u0019\u0002\rqJg.\u001b;?)\t\u00114\u0007\u0005\u0002-\u0001!)\u0011f\fa\u0001W!9Q\u0007\u0001b\u0001\n\u00031\u0014!D2bg\u0016\u001cVM\\:ji&4X-F\u00018!\tq\u0001(\u0003\u0002:\u001f\t9!i\\8mK\u0006t\u0007BB\u001e\u0001A\u0003%q'\u0001\bdCN,7+\u001a8tSRLg/\u001a\u0011\t\u0011u\u0002!\u0019!C\u0001\u0005y\nacY1dQ\u0016$G)\u0019;b'>,(oY3UC\ndWm]\u000b\u0002\u007fA!\u0001iR%N\u001b\u0005\t%B\u0001\"D\u0003\u0015\u0019\u0017m\u00195f\u0015\t!U)\u0001\u0004d_6lwN\u001c\u0006\u0003\r\u0012\naaZ8pO2,\u0017B\u0001%B\u00051au.\u00193j]\u001e\u001c\u0015m\u00195f!\tQ5*D\u0001\u0018\u0013\tauCA\bUC\ndW-\u00133f]RLg-[3s!\tq5+D\u0001P\u0015\t\u0001\u0016+A\u0004m_\u001eL7-\u00197\u000b\u0005I;\u0012!\u00029mC:\u001c\u0018B\u0001+P\u0005-aunZ5dC2\u0004F.\u00198\t\rY\u0003\u0001\u0015!\u0003@\u0003]\u0019\u0017m\u00195fI\u0012\u000bG/Y*pkJ\u001cW\rV1cY\u0016\u001c\b\u0005C\u0003Y\u0001\u0011\u0005\u0013,\u0001\bm_>\\W\u000f\u001d*fY\u0006$\u0018n\u001c8\u0015\u00075SF\fC\u0003\\/\u0002\u0007\u0011*\u0001\u0006uC\ndW-\u00133f]RDq!X,\u0011\u0002\u0003\u0007a,A\u0003bY&\f7\u000fE\u0002\u000f?\u0006L!\u0001Y\b\u0003\r=\u0003H/[8o!\t\u0011WM\u0004\u0002\u000fG&\u0011AmD\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002e\u001f!)\u0011\u000e\u0001C\u0005U\u0006i!-^5mIJ+G.\u0019;j_:$\"!T6\t\u000b1D\u0007\u0019A%\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJDQA\u001c\u0001\u0005\n=\facZ3u\u00072,8\u000f^3s\t\n#\u0016M\u00197f\u001d\u0006lWm\u001d\u000b\u0003aN\u0004RAD9bC\u0006L!A]\b\u0003\rQ+\b\u000f\\34\u0011\u0015YV\u000e1\u0001J\u0011\u0015)\b\u0001\"\u0011w\u00035\u0011XmZ5ti\u0016\u0014H+\u00192mKR\u0019qO_>\u0011\u00059A\u0018BA=\u0010\u0005\u0011)f.\u001b;\t\u000bm#\b\u0019A%\t\u000bq$\b\u0019A'\u0002\tAd\u0017M\u001c\u0005\u0006}\u0002!\te`\u0001\u0010k:\u0014XmZ5ti\u0016\u0014H+\u00192mKR\u0019q/!\u0001\t\u000bmk\b\u0019A%\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b\u0005\u0019RO\u001c:fO&\u001cH/\u001a:BY2$\u0016M\u00197fgR\tq\u000fC\u0004\u0002\f\u0001!\t%!\u0004\u0002\u0017Q\f'\r\\3Fq&\u001cHo\u001d\u000b\u0004o\u0005=\u0001BB.\u0002\n\u0001\u0007\u0011\nC\u0004\u0002\u0014\u0001!\t%!\u0006\u0002\u0013\u001d,G\u000fV1cY\u0016\u001cH\u0003BA\f\u0003k\u0001b!!\u0007\u0002*\u0005=b\u0002BA\u000e\u0003KqA!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003CQ\u0013A\u0002\u001fs_>$h(C\u0001\u0011\u0013\r\t9cD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY#!\f\u0003\u0007M+\u0017OC\u0002\u0002(=\u0001RADA\u0019C^J1!a\r\u0010\u0005\u0019!V\u000f\u001d7fe!9\u0011qGA\t\u0001\u0004q\u0016\u0001\u00043bi\u0006\u0014\u0017m]3OC6,\u0007bBA\u001e\u0001\u0011\u0005\u0011QH\u0001\u0017O\u0016$H+\u00192mKN4%o\\7DCN\u001c\u0018M\u001c3sCR!\u0011qCA \u0011\u001d\t9$!\u000fA\u0002yCq!a\u0011\u0001\t\u0003\t)%\u0001\nhKR$\u0016M\u00197fg\u001a\u0013x.\\\"bG\",GCBA\f\u0003\u000f\nI\u0005C\u0004\u00028\u0005\u0005\u0003\u0019\u00010\t\u0013\u0005-\u0013\u0011\tI\u0001\u0002\u0004q\u0016aB2mkN$XM\u001d\u0005\b\u0003\u001f\u0002A\u0011BA)\u0003U9W\r^\"bgN\fg\u000e\u001a:b\u0007>tg.Z2u_J$B!a\u0015\u0002`A!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z}\t1aY9m\u0013\u0011\ti&a\u0016\u0003%\r\u000b7o]1oIJ\f7i\u001c8oK\u000e$xN\u001d\u0005\t\u0003C\ni\u00051\u0001\u0002d\u0005AA/\u00192mKJ+g\rE\u0002-\u0003KJ1!a\u001a\u0003\u0005!!\u0016M\u00197f%\u00164\u0007\"CA6\u0001\t\u0007I\u0011IA7\u0003\u0011\u0019wN\u001c4\u0016\u0005\u0005=\u0004c\u0001&\u0002r%\u0019\u00111O\f\u0003\u0019\r\u000bG/\u00197zgR\u001cuN\u001c4\t\u0011\u0005]\u0004\u0001)A\u0005\u0003_\nQaY8oM\u0002Bq!a\u001f\u0001\t\u0003\ni(\u0001\u0007sK\u001a\u0014Xm\u001d5UC\ndW\rF\u0002x\u0003\u007fBaaWA=\u0001\u0004I\u0005\"CAB\u0001E\u0005I\u0011AAC\u0003q9W\r\u001e+bE2,7O\u0012:p[\u000e\u000b7\r[3%I\u00164\u0017-\u001e7uII*\"!a\"+\u0007y\u000bIi\u000b\u0002\u0002\fB!\u0011QRAL\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!C;oG\",7m[3e\u0015\r\t)jD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAM\u0003\u001f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class CassandraCatalog
implements Catalog,
Logging {
    public final CassandraSQLContext org$apache$spark$sql$cassandra$CassandraCatalog$$csc;
    private final boolean caseSensitive;
    private final LoadingCache<TableIdentifier, LogicalPlan> cachedDataSourceTables;
    private final CatalystConf conf;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    @TraitSetter
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String getTableName(TableIdentifier tableIdent) {
        return Catalog.class.getTableName((Catalog)this, (TableIdentifier)tableIdent);
    }

    public Option<String> lookupRelation$default$2() {
        return Catalog.class.lookupRelation$default$2((Catalog)this);
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public LoadingCache<TableIdentifier, LogicalPlan> cachedDataSourceTables() {
        return this.cachedDataSourceTables;
    }

    public LogicalPlan lookupRelation(TableIdentifier tableIdent, Option<String> alias) {
        LogicalPlan tableLogicPlan = this.cachedDataSourceTables().get(tableIdent);
        return (LogicalPlan)alias.map((Function1)new Serializable(this, tableLogicPlan){
            public static final long serialVersionUID = 0L;
            private final LogicalPlan tableLogicPlan$1;

            public final Subquery apply(String a) {
                return new Subquery(a, this.tableLogicPlan$1);
            }
            {
                this.tableLogicPlan$1 = tableLogicPlan$1;
            }
        }).getOrElse((Function0)new Serializable(this, tableLogicPlan){
            public static final long serialVersionUID = 0L;
            private final LogicalPlan tableLogicPlan$1;

            public final LogicalPlan apply() {
                return this.tableLogicPlan$1;
            }
            {
                this.tableLogicPlan$1 = tableLogicPlan$1;
            }
        });
    }

    public LogicalPlan org$apache$spark$sql$cassandra$CassandraCatalog$$buildRelation(TableIdentifier tableIdentifier) {
        Tuple3<String, String, String> tuple3 = this.getClusterDBTableNames(tableIdentifier);
        if (tuple3 != null) {
            Tuple3 tuple32;
            String cluster = (String)tuple3._1();
            String database = (String)tuple3._2();
            String table = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)cluster, (Object)database, (Object)table);
            String cluster2 = (String)tuple33._1();
            String database2 = (String)tuple33._2();
            String table2 = (String)tuple33._3();
            TableRef tableRef = new TableRef(table2, database2, (Option<String>)Option$.MODULE$.apply((Object)cluster2));
            CassandraSourceRelation sourceRelation = CassandraSourceRelation$.MODULE$.apply(tableRef, this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc, new CassandraSourceOptions(CassandraSourceOptions$.MODULE$.apply$default$1(), CassandraSourceOptions$.MODULE$.apply$default$2(), CassandraSourceOptions$.MODULE$.apply$default$3()), CassandraSourceRelation$.MODULE$.apply$default$4());
            return new Subquery(table2, (LogicalPlan)new LogicalRelation((BaseRelation)sourceRelation, LogicalRelation$.MODULE$.apply$default$2()));
        }
        throw new MatchError(tuple3);
    }

    private Tuple3<String, String, String> getClusterDBTableNames(TableIdentifier tableIdent) {
        String database = (String)tableIdent.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;

            public final String apply() {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getKeyspace();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String table = tableIdent.table();
        return new Tuple3((Object)this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster(), (Object)database, (Object)table);
    }

    public void registerTable(TableIdentifier tableIdent, LogicalPlan plan) {
        this.cachedDataSourceTables().put(tableIdent, plan);
    }

    public void unregisterTable(TableIdentifier tableIdent) {
        this.cachedDataSourceTables().invalidate(tableIdent);
    }

    public void unregisterAllTables() {
        this.cachedDataSourceTables().invalidateAll();
    }

    public boolean tableExists(TableIdentifier tableIdent) {
        Tuple3<String, String, String> tuple3 = this.getClusterDBTableNames(tableIdent);
        if (tuple3 != null) {
            boolean bl;
            Tuple3 tuple32;
            String cluster = (String)tuple3._1();
            String database = (String)tuple3._2();
            String table = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)cluster, (Object)database, (Object)table);
            String cluster2 = (String)tuple33._1();
            String database2 = (String)tuple33._2();
            String table2 = (String)tuple33._3();
            boolean cached = this.cachedDataSourceTables().asMap().containsKey(tableIdent);
            if (cached) {
                bl = true;
            } else {
                TableRef tableRef = new TableRef(table2, database2, (Option<String>)Option$.MODULE$.apply((Object)cluster2));
                Schema schema2 = Schema$.MODULE$.fromCassandra(this.getCassandraConnector(tableRef), Schema$.MODULE$.fromCassandra$default$2(), Schema$.MODULE$.fromCassandra$default$3());
                Option tabDef = schema2.keyspaceByName().get((Object)database2).flatMap((Function1)new Serializable(this, table2){
                    public static final long serialVersionUID = 0L;
                    private final String table$1;

                    public final Option<TableDef> apply(KeyspaceDef ksDef) {
                        return ksDef.tableByName().get((Object)this.table$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TableDef apply(TableDef tabDef) {
                                return tabDef;
                            }
                        });
                    }
                    {
                        this.table$1 = table$1;
                    }
                });
                bl = tabDef.nonEmpty();
            }
            return bl;
        }
        throw new MatchError(tuple3);
    }

    public Seq<Tuple2<String, Object>> getTables(Option<String> databaseName) {
        String cluster = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
        Seq tableNamesFromCache = (Seq)this.getTablesFromCache(databaseName, (Option<String>)Option$.MODULE$.apply((Object)cluster)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$3) {
                return (String)x$3._1();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Tuple2<String, Object>> tablesFromCassandra = this.getTablesFromCassandra(databaseName);
        Seq tablesOnlyInCache = (Seq)((TraversableLike)tableNamesFromCache.diff((GenSeq)tablesFromCassandra.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$4) {
                return (String)x$4._1();
            }
        }, Seq$.MODULE$.canBuildFrom()))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String name) {
                return new Tuple2((Object)name, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)tablesFromCassandra.$plus$plus((GenTraversableOnce)tablesOnlyInCache, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, Object>> getTablesFromCassandra(Option<String> databaseName) {
        String cluster = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
        TableRef tableRef = new TableRef("", (String)databaseName.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), (Option<String>)Option$.MODULE$.apply((Object)cluster));
        Schema schema2 = Schema$.MODULE$.fromCassandra(this.getCassandraConnector(tableRef), databaseName, Schema$.MODULE$.fromCassandra$default$3());
        return (Seq)schema2.keyspaces().toSeq().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, Object>> apply(KeyspaceDef ksDef) {
                return (Set)ksDef.tables().map((Function1)new Serializable(this, ksDef){
                    public static final long serialVersionUID = 0L;
                    private final KeyspaceDef ksDef$1;

                    public final Tuple2<String, Object> apply(TableDef tableDef) {
                        return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ksDef$1.keyspaceName(), tableDef.tableName()})), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    {
                        this.ksDef$1 = ksDef$1;
                    }
                }, Set$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, Object>> getTablesFromCache(Option<String> databaseName, Option<String> cluster) {
        String clusterName = (String)cluster.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;

            public final String apply() {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getCluster();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (Seq)JavaConversions$.MODULE$.asScalaSet(this.cachedDataSourceTables().asMap().keySet()).toSeq().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TableIdentifier check$ifrefutable$1) {
                Seq seq;
                Some some;
                TableIdentifier tableIdentifier = check$ifrefutable$1;
                boolean bl = tableIdentifier instanceof Seq && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)tableIdentifier)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0;
                return bl;
            }
        }).withFilter((Function1)new Serializable(this, databaseName, clusterName){
            public static final long serialVersionUID = 0L;
            private final Option databaseName$1;
            private final String clusterName$1;

            public final boolean apply(TableIdentifier x$6) {
                Seq seq;
                Some some;
                TableIdentifier tableIdentifier = x$6;
                if (tableIdentifier instanceof Seq && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)tableIdentifier)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object c = ((SeqLike)some.get()).apply(0);
                    Object db = ((SeqLike)some.get()).apply(1);
                    Object object = c;
                    String string = this.clusterName$1;
                    boolean bl = !(object != null ? !object.equals(string) : string != null) && this.databaseName$1.forall((Function1)new Serializable(this, db){
                        public static final long serialVersionUID = 0L;
                        private final Object db$1;

                        public final boolean apply(String x$5) {
                            String string = x$5;
                            Object object = this.db$1;
                            return !(string != null ? !string.equals(object) : object != null);
                        }
                        {
                            this.db$1 = db$1;
                        }
                    });
                    return bl;
                }
                throw new MatchError((Object)tableIdentifier);
            }
            {
                this.databaseName$1 = databaseName$1;
                this.clusterName$1 = clusterName$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(TableIdentifier x$7) {
                Seq seq;
                Some some;
                TableIdentifier tableIdentifier = x$7;
                if (tableIdentifier instanceof Seq && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)tableIdentifier)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object db = ((SeqLike)some.get()).apply(1);
                    Object table = ((SeqLike)some.get()).apply(2);
                    Tuple2 tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db, table})), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return tuple2;
                }
                throw new MatchError((Object)tableIdentifier);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> getTablesFromCache$default$2() {
        return None$.MODULE$;
    }

    private CassandraConnector getCassandraConnector(TableRef tableRef) {
        SparkConf sparkConf = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.sparkContext().getConf().clone();
        Map sqlConf = this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc.getAllConfs();
        SparkConf conf = CassandraSourceRelation$.MODULE$.consolidateConfs(sparkConf, (Map<String, String>)sqlConf, tableRef, (Map<String, String>)Predef$.MODULE$.Map().empty());
        return new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
    }

    public CatalystConf conf() {
        return this.conf;
    }

    public void refreshTable(TableIdentifier tableIdent) {
        this.cachedDataSourceTables().refresh(tableIdent);
    }

    public CassandraCatalog(CassandraSQLContext csc) {
        this.org$apache$spark$sql$cassandra$CassandraCatalog$$csc = csc;
        Catalog.class.$init$((Catalog)this);
        Logging$class.$init$(this);
        this.caseSensitive = true;
        CacheLoader<TableIdentifier, LogicalPlan> cacheLoader = new CacheLoader<TableIdentifier, LogicalPlan>(this){
            private final /* synthetic */ CassandraCatalog $outer;

            public LogicalPlan load(TableIdentifier tableIdent) {
                this.$outer.logDebug((Function0<String>)new Serializable(this, tableIdent){
                    public static final long serialVersionUID = 0L;
                    private final TableIdentifier tableIdent$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating new cached data source for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdent$1}));
                    }
                    {
                        this.tableIdent$1 = tableIdent$1;
                    }
                });
                return this.$outer.org$apache$spark$sql$cassandra$CassandraCatalog$$buildRelation(tableIdent);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.cachedDataSourceTables = CacheBuilder.newBuilder().maximumSize(1000L).build(cacheLoader);
        this.conf = new SimpleCatalystConf(this.caseSensitive());
    }
}

