/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ValidRDDType$;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.InetType$;
import com.datastax.spark.connector.types.UUIDType$;
import com.datastax.spark.connector.types.VarIntType$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.util.ReflectionUtil$;
import com.datastax.spark.connector.writer.SqlRowWriter$Factory$;
import com.datastax.spark.connector.writer.WriteConf;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.BasicCassandraPredicatePushDown;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.CassandraSQLRow;
import org.apache.spark.sql.cassandra.CassandraSQLRow$;
import org.apache.spark.sql.cassandra.CassandraSQLRow$CassandraSQLRowReader$;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$$anonfun$additionalRules$1$;
import org.apache.spark.sql.cassandra.DataTypeConverter$;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\rma!B\u0001\u0003\u0001\ta!aF\"bgN\fg\u000e\u001a:b'>,(oY3SK2\fG/[8o\u0015\t\u0019A!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u000b\u0001i1CF\r\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011aB:pkJ\u001cWm]\u0005\u0003%=\u0011ABQ1tKJ+G.\u0019;j_:\u0004\"A\u0004\u000b\n\u0005Uy!AE%og\u0016\u0014H/\u00192mKJ+G.\u0019;j_:\u0004\"AD\f\n\u0005ay!A\u0005)sk:,GMR5mi\u0016\u0014X\rZ*dC:\u0004\"A\u0007\u0013\u000e\u0003mQ!\u0001H\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003=}\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005\u001d\u0001#BA\u0011#\u0003!!\u0017\r^1ti\u0006D(\"A\u0012\u0002\u0007\r|W.\u0003\u0002&7\t9Aj\\4hS:<\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u0011Q\f'\r\\3SK\u001a\u001c\u0001\u0001\u0005\u0002+W5\t!!\u0003\u0002-\u0005\tAA+\u00192mKJ+g\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003M)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b!\r\u00014'N\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1q\n\u001d;j_:\u0004\"AN\u001d\u000e\u0003]R!\u0001\u000f\u0003\u0002\u000bQL\b/Z:\n\u0005i:$AC*ueV\u001cG\u000fV=qK\"AA\b\u0001B\u0001B\u0003%Q(\u0001\bgS2$XM\u001d)vg\"$wn\u001e8\u0011\u0005Ar\u0014BA 2\u0005\u001d\u0011un\u001c7fC:D\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006I!P\u0001\u0010G>tg-\u001b:n)J,hnY1uK\"A1\t\u0001B\u0001B\u0003%A)\u0001\tuC\ndWmU5{K&s')\u001f;fgB\u0019\u0001gM#\u0011\u0005A2\u0015BA$2\u0005\u0011auN\\4\t\u0011y\u0001!\u0011!Q\u0001\n%\u0003\"AS'\u000e\u0003-S!\u0001T\u000f\u0002\u0007\r\fH.\u0003\u0002O\u0017\n\u00112)Y:tC:$'/Y\"p]:,7\r^8s\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0016\u0001\u0003:fC\u0012\u001cuN\u001c4\u0011\u0005I+V\"A*\u000b\u0005Qk\u0012a\u0001:eI&\u0011ak\u0015\u0002\t%\u0016\fGmQ8oM\"A\u0001\f\u0001B\u0001B\u0003%\u0011,A\u0005xe&$XmQ8oMB\u0011!,X\u0007\u00027*\u0011A,H\u0001\u0007oJLG/\u001a:\n\u0005y[&!C,sSR,7i\u001c8g\u0011!\u0001\u0007A!b\u0001\n\u0003\n\u0017AC:rY\u000e{g\u000e^3yiV\t!\r\u0005\u0002dI6\tA!\u0003\u0002f\t\tQ1+\u0015'D_:$X\r\u001f;\t\u0011\u001d\u0004!\u0011!Q\u0001\n\t\f1b]9m\u0007>tG/\u001a=uA!)\u0011\u000e\u0001C\u0001U\u00061A(\u001b8jiz\"\"b\u001b7n]>\u0004\u0018O]:u!\tQ\u0003\u0001C\u0003(Q\u0002\u0007\u0011\u0006C\u0003/Q\u0002\u0007q\u0006C\u0003=Q\u0002\u0007Q\bC\u0003BQ\u0002\u0007Q\bC\u0003DQ\u0002\u0007A\tC\u0003\u001fQ\u0002\u0007\u0011\nC\u0003QQ\u0002\u0007\u0011\u000bC\u0003YQ\u0002\u0007\u0011\fC\u0003aQ\u0002\u0007!\r\u0003\u0004w\u0001\u0001\u0006Ia^\u0001\ti\u0006\u0014G.\u001a#fMB\u0011!\n_\u0005\u0003s.\u0013\u0001\u0002V1cY\u0016$UM\u001a\u0005\u0006w\u0002!\t\u0005`\u0001\u0007g\u000eDW-\\1\u0016\u0003UBQA \u0001\u0005B}\fa!\u001b8tKJ$HCBA\u0001\u0003\u000f\t\t\u0002E\u00021\u0003\u0007I1!!\u00022\u0005\u0011)f.\u001b;\t\u000f\u0005%Q\u00101\u0001\u0002\f\u0005!A-\u0019;b!\r\u0019\u0017QB\u0005\u0004\u0003\u001f!!!\u0003#bi\u00064%/Y7f\u0011\u0019\t\u0019\" a\u0001{\u0005IqN^3soJLG/\u001a\u0005\b\u0003/\u0001A\u0011IA\r\u0003-\u0019\u0018N_3J]\nKH/Z:\u0016\u0003\u0015C\u0011\"!\b\u0001\u0005\u0004%\u0019!a\b\u0002%\r\f7o]1oIJ\f7i\u001c8oK\u000e$xN]\u000b\u0002\u0013\"9\u00111\u0005\u0001!\u0002\u0013I\u0015aE2bgN\fg\u000e\u001a:b\u0007>tg.Z2u_J\u0004\u0003\"CA\u0014\u0001\t\u0007I1AA\u0015\u0003!\u0011X-\u00193d_:4W#A)\t\u000f\u00055\u0002\u0001)A\u0005#\u0006I!/Z1eG>tg\r\t\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u00024\u00059!-Y:f%\u0012$\u0007#\u0002*\u00026\u0005e\u0012bAA\u001c'\n)2)Y:tC:$'/\u0019+bE2,7kY1o%\u0012#\u0005c\u0001\u0016\u0002<%\u0019\u0011Q\b\u0002\u0003\u001f\r\u000b7o]1oIJ\f7+\u0015'S_^Dq!!\u0011\u0001\t\u0003\t\u0019%A\u0005ck&dGmU2b]R\u0011\u0011Q\t\t\u0007\u0003\u000f\nY%a\u0014\u000e\u0005\u0005%#B\u0001+\u0007\u0013\u0011\ti%!\u0013\u0003\u0007I#E\tE\u0002d\u0003#J1!a\u0015\u0005\u0005\r\u0011vn\u001e\u0005\b\u0003/\u0002A\u0011IA-\u0003A)h\u000e[1oI2,GMR5mi\u0016\u00148\u000f\u0006\u0003\u0002\\\u0005\u001d\u0004#\u0002\u0019\u0002^\u0005\u0005\u0014bAA0c\t)\u0011I\u001d:bsB\u0019a\"a\u0019\n\u0007\u0005\u0015tB\u0001\u0004GS2$XM\u001d\u0005\t\u0003S\n)\u00061\u0001\u0002\\\u00059a-\u001b7uKJ\u001c\bBCA7\u0001!\u0015\r\u0011\"\u0001\u0002p\u0005y\u0011\r\u001a3ji&|g.\u00197Sk2,7/\u0006\u0002\u0002rA1\u00111OAB\u0003\u0013sA!!\u001e\u0002\u00009!\u0011qOA?\u001b\t\tIHC\u0002\u0002|!\na\u0001\u0010:p_Rt\u0014\"\u0001\u001a\n\u0007\u0005\u0005\u0015'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0015q\u0011\u0002\u0004'\u0016\f(bAAAcA\u0019!&a#\n\u0007\u00055%AA\fDCN\u001c\u0018M\u001c3sCB\u0013X\rZ5dCR,'+\u001e7fg\"Q\u0011\u0011\u0013\u0001\t\u0002\u0003\u0006K!!\u001d\u0002!\u0005$G-\u001b;j_:\fGNU;mKN\u0004\u0003bBAK\u0001\u0011%\u0011qS\u0001\u0012aJ,G-[2bi\u0016\u0004Vo\u001d5E_^tG\u0003BAM\u0003?\u00032AKAN\u0013\r\tiJ\u0001\u0002\u0013\u0003:\fG.\u001f>fIB\u0013X\rZ5dCR,7\u000f\u0003\u0005\u0002j\u0005M\u0005\u0019AA.\u0011\u001d\t\t\u0005\u0001C!\u0003G#b!!\u0012\u0002&\u0006e\u0006\u0002CAT\u0003C\u0003\r!!+\u0002\u001fI,\u0017/^5sK\u0012\u001cu\u000e\\;n]N\u0004R\u0001MA/\u0003W\u0003B!!,\u00024:\u0019\u0001'a,\n\u0007\u0005E\u0016'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\u000b9L\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c\u000b\u0004\u0002CA5\u0003C\u0003\r!a\u0017\u0006\r\u0005u\u0006\u0001BA`\u0005\u001d\u0011F\t\u0012+za\u0016\u0004RAUAa\u0003sI1!a1T\u00051\u0019\u0015m]:b]\u0012\u0014\u0018M\u0015#E\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013\f1\"\\1zE\u0016\u001cV\r\\3diR1\u0011QIAf\u0003#Dq\u0001VAc\u0001\u0004\ti\r\u0005\u0003\u0002P\u0006mV\"\u0001\u0001\t\u0011\u0005\u001d\u0016Q\u0019a\u0001\u0003SCq!!6\u0001\t\u0013\t9.\u0001\u000bnCf\u0014W\rU;tQ\u0012|wO\u001c$jYR,'o\u001d\u000b\u0007\u0003\u001b\fI.a7\t\u000fQ\u000b\u0019\u000e1\u0001\u0002N\"A\u0011\u0011NAj\u0001\u0004\ti\u000e\u0005\u0004\u0002t\u0005\r\u0015\u0011\r\u0005\b\u0003C\u0004A\u0011BAr\u0003M1\u0017\u000e\u001c;feR{7)\u001d7B]\u00124\u0016\r\\;f)\u0011\t)/a=\u0011\u000fA\n9/a+\u0002l&\u0019\u0011\u0011^\u0019\u0003\rQ+\b\u000f\\33!\u0019\t\u0019(a!\u0002nB\u0019\u0001'a<\n\u0007\u0005E\u0018GA\u0002B]fD\u0001\"!>\u0002`\u0002\u0007\u0011Q^\u0001\u0007M&dG/\u001a:\t\u000f\u0005e\b\u0001\"\u0003\u0002|\u0006YAo\\\"rYZ\u000bG.^3t)\u0019\tY/!@\u0003\u0002!A\u0011q`A|\u0001\u0004\tY+\u0001\u0006d_2,XN\u001c(b[\u0016D\u0001Ba\u0001\u0002x\u0002\u0007!QA\u0001\u0007m\u0006dW/Z:\u0011\u000bA\ni&!<\t\u000f\t%\u0001\u0001\"\u0003\u0003\f\u0005QAo\\\"rYZ\u000bG.^3\u0015\r\u00055(Q\u0002B\b\u0011!\tyPa\u0002A\u0002\u0005-\u0006\u0002\u0003B\t\u0005\u000f\u0001\r!!<\u0002\u000bY\fG.^3\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018\u0005Yq\u000f[3sK\u000ec\u0017-^:f)\u0011\t)O!\u0007\t\u0011\tm!1\u0003a\u0001\u0003W\fq\u0002];tQ\u0012|wO\u001c$jYR,'o]\u0004\b\u0005?\u0011\u0001\u0012\u0001B\u0011\u0003]\u0019\u0015m]:b]\u0012\u0014\u0018mU8ve\u000e,'+\u001a7bi&|g\u000eE\u0002+\u0005G1a!\u0001\u0002\t\u0002\t\u00152\u0003\u0002B\u0012\u0005O\u00012\u0001\rB\u0015\u0013\r\u0011Y#\r\u0002\u0007\u0003:L(+\u001a4\t\u000f%\u0014\u0019\u0003\"\u0001\u00030Q\u0011!\u0011\u0005\u0005\u000b\u0005g\u0011\u0019C1A\u0005\u0002\tU\u0012\u0001\u0005*fM\u0016\u0014XM\\2f'\u0016\u001cG/[8o+\t\u00119\u0004\u0005\u0003\u0003:\t\rSB\u0001B\u001e\u0015\u0011\u0011iDa\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0003\nAA[1wC&!\u0011Q\u0017B\u001e\u0011%\u00119Ea\t!\u0002\u0013\u00119$A\tSK\u001a,'/\u001a8dKN+7\r^5p]\u0002B!Ba\u0013\u0003$\t\u0007I\u0011\u0001B'\u0003U!\u0016M\u00197f'&TX-\u00138CsR,7\u000fU1sC6,\"Aa\u0014\u0011\ti\u0011\t\u0006R\u0005\u0004\u0005'Z\"aD\"p]\u001aLw\rU1sC6,G/\u001a:\t\u0013\t]#1\u0005Q\u0001\n\t=\u0013A\u0006+bE2,7+\u001b>f\u0013:\u0014\u0015\u0010^3t!\u0006\u0014\u0018-\u001c\u0011\t\u0015\tm#1\u0005b\u0001\n\u0003\u0011i&A\u0013BI\u0012LG/[8oC2\u001c\u0015m]:b]\u0012\u0014\u0018\rU;tQ\u0012{wO\u001c*vY\u0016\u001c\b+\u0019:b[V\u0011!q\f\t\u00065\tE#\u0011\r\t\u0007\u0003g\u0012\u0019'!#\n\t\t\u0015\u0014q\u0011\u0002\u0005\u0019&\u001cH\u000fC\u0005\u0003j\t\r\u0002\u0015!\u0003\u0003`\u00051\u0013\t\u001a3ji&|g.\u00197DCN\u001c\u0018M\u001c3sCB+8\u000f\u001b#po:\u0014V\u000f\\3t!\u0006\u0014\u0018-\u001c\u0011\t\u0015\t5$1\u0005b\u0001\n\u0003\u0011y'\u0001\u0006Qe>\u0004XM\u001d;jKN,\"A!\u001d\u0011\r\tM$\u0011\u0010B>\u001b\t\u0011)HC\u0002\u0003xE\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)I!\u001e1\t\tu$1\u0011\t\u00065\tE#q\u0010\t\u0005\u0005\u0003\u0013\u0019\t\u0004\u0001\u0005\u0017\t\u0015\u0005!!A\u0001\u0002\u000b\u0005!q\u0011\u0002\u0005?R\u0012D'\u0005\u0003\u0003\n\ne%#\u0002BF\t\n=eA\u0002BG\u0001\u0001\u0011II\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0004\u0003\u0012\n]\u0015\u0011R\u0007\u0003\u0005'SAA!&\u0003v\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0005K\u0012\u0019J\u0005\u0005\u0003\u001c\nu%1\u0015BU\r\u0019\u0011i\t\u0001\u0001\u0003\u001aB\u0019\u0001Ga(\n\u0007\t\u0005\u0016GA\u0004Qe>$Wo\u0019;\u0011\t\te\"QU\u0005\u0005\u0005O\u0013YD\u0001\u0004PE*,7\r\u001e\t\u0005\u0005W\u0013\t,\u0004\u0002\u0003.*!!q\u0016B \u0003\tIw.\u0003\u0003\u00034\n5&\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0003B\\\u0005G\u0001\u000b\u0011\u0002B9\u0003-\u0001&o\u001c9feRLWm\u001d\u0011\t\u0015\tm&1\u0005b\u0001\n\u0003\u0011)$\u0001\neK\u001a\fW\u000f\u001c;DYV\u001cH/\u001a:OC6,\u0007\"\u0003B`\u0005G\u0001\u000b\u0011\u0002B\u001c\u0003M!WMZ1vYR\u001cE.^:uKJt\u0015-\\3!\u0011!\u0011\u0019Ma\t\u0005\u0002\t\u0015\u0017!B1qa2LH#C6\u0003H\n%'1\u001aBk\u0011\u00199#\u0011\u0019a\u0001S!1\u0001M!1A\u0002\tD!B!4\u0003BB\u0005\t\u0019\u0001Bh\u0003\u001dy\u0007\u000f^5p]N\u00042A\u000bBi\u0013\r\u0011\u0019N\u0001\u0002\u0017\u0007\u0006\u001c8/\u00198ee\u0006\u001cv.\u001e:dK>\u0003H/[8og\"A1P!1\u0011\u0002\u0003\u0007q\u0006\u0003\u0005\u0003Z\n\rB\u0011\u0001Bn\u0003A\u0019wN\\:pY&$\u0017\r^3D_:47\u000f\u0006\u0006\u0003^\n\u0015(\u0011\u001eBz\u0005k\u0004BAa8\u0003b6\ta!C\u0002\u0003d\u001a\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\t\u001d(q\u001ba\u0001\u0005;\f\u0011b\u001d9be.\u001cuN\u001c4\t\u0011\t-(q\u001ba\u0001\u0005[\fqa]9m\u0007>tg\r\u0005\u0005\u0002.\n=\u00181VAV\u0013\u0011\u0011\t0a.\u0003\u00075\u000b\u0007\u000f\u0003\u0004(\u0005/\u0004\r!\u000b\u0005\t\u0005o\u00149\u000e1\u0001\u0003n\u0006IA/\u00192mK\u000e{gN\u001a\u0005\u000b\u0005w\u0014\u0019#%A\u0005\u0002\tu\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t}(\u0006\u0002Bh\u0007\u0003Y#aa\u0001\u0011\t\r\u00151qB\u0007\u0003\u0007\u000fQAa!\u0003\u0004\f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u001b\t\u0014AC1o]>$\u0018\r^5p]&!1\u0011CB\u0004\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0007+\u0011\u0019#%A\u0005\u0002\r]\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\re!fA\u0018\u0004\u0002\u0001")
public class CassandraSourceRelation
extends BaseRelation
implements InsertableRelation,
PrunedFilteredScan,
Logging {
    private final TableRef tableRef;
    private final Option<StructType> userSpecifiedSchema;
    private final boolean filterPushdown;
    private final boolean confirmTruncate;
    private final Option<Object> tableSizeInBytes;
    private final CassandraConnector connector;
    private final WriteConf writeConf;
    private final SQLContext sqlContext;
    public final TableDef org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef;
    private final CassandraConnector cassandraConnector;
    private final ReadConf readconf;
    private final CassandraTableScanRDD<CassandraSQLRow> baseRdd;
    private Seq<CassandraPredicateRules> additionalRules;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile boolean bitmap$0;

    public static Option<StructType> apply$default$4() {
        return CassandraSourceRelation$.MODULE$.apply$default$4();
    }

    public static CassandraSourceOptions apply$default$3() {
        return CassandraSourceRelation$.MODULE$.apply$default$3();
    }

    public static SparkConf consolidateConfs(SparkConf sparkConf, Map<String, String> map, TableRef tableRef, Map<String, String> map2) {
        return CassandraSourceRelation$.MODULE$.consolidateConfs(sparkConf, map, tableRef, map2);
    }

    public static CassandraSourceRelation apply(TableRef tableRef, SQLContext sQLContext, CassandraSourceOptions cassandraSourceOptions, Option<StructType> option) {
        return CassandraSourceRelation$.MODULE$.apply(tableRef, sQLContext, cassandraSourceOptions, option);
    }

    public static String defaultClusterName() {
        return CassandraSourceRelation$.MODULE$.defaultClusterName();
    }

    public static Seq<ConfigParameter<? extends Product>> Properties() {
        return CassandraSourceRelation$.MODULE$.Properties();
    }

    public static ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam() {
        return CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam();
    }

    public static ConfigParameter<Option<Object>> TableSizeInBytesParam() {
        return CassandraSourceRelation$.MODULE$.TableSizeInBytesParam();
    }

    public static String ReferenceSection() {
        return CassandraSourceRelation$.MODULE$.ReferenceSection();
    }

    private Seq additionalRules$lzycompute() {
        CassandraSourceRelation cassandraSourceRelation = this;
        synchronized (cassandraSourceRelation) {
            Option option;
            block7: {
                if (!this.bitmap$0) {
                    Seq seq;
                    SparkContext sc = this.sqlContext().sparkContext();
                    Option userClasses = sc.getConf().getOption(CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().name()).orElse((Function0)new scala.Serializable(this, sc){
                        public static final long serialVersionUID = 0L;
                        private final SparkContext sc$1;

                        public final Option<String> apply() {
                            return Option$.MODULE$.apply((Object)this.sc$1.getLocalProperty(CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().name()));
                        }
                        {
                            this.sc$1 = sc$1;
                        }
                    });
                    option = userClasses;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String classes = (String)some.x();
                        seq = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])classes.trim().split("\\s*,\\s*")).map((Function1)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final CassandraPredicateRules apply(String objectName) {
                                JavaUniverse $u = package$.MODULE$.universe();
                                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CassandraSourceRelation.class.getClassLoader());
                                public final class Org_apache_spark_sql_cassandra_CassandraSourceRelation$$anonfun$additionalRules$1$$typecreator1$1
                                extends TypeCreator {
                                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                        Universe $u = $m$untyped.universe();
                                        Mirror<U> $m = $m$untyped;
                                        return $m.staticClass("org.apache.spark.sql.cassandra.CassandraPredicateRules").asType().toTypeConstructor();
                                    }

                                    public Org_apache_spark_sql_cassandra_CassandraSourceRelation$$anonfun$additionalRules$1$$typecreator1$1($anonfun$additionalRules$1 $outer) {
                                    }
                                }
                                return (CassandraPredicateRules)ReflectionUtil$.MODULE$.findGlobalObject(objectName, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_cassandra_CassandraSourceRelation$$anonfun$additionalRules$1$$typecreator1$1(this)));
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CassandraPredicateRules.class)))).reverse());
                    } else {
                        if (!None$.MODULE$.equals(option)) break block7;
                        seq = (Seq)CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().default();
                    }
                    this.additionalRules = seq;
                    this.bitmap$0 = true;
                }
                return this.additionalRules;
            }
            throw new MatchError((Object)option);
        }
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    @TraitSetter
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        return (StructType)this.userSpecifiedSchema.getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final StructType apply() {
                return StructType$.MODULE$.apply((Seq)this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columns().map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(ColumnDef column) {
                        return DataTypeConverter$.MODULE$.toStructField(column);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(DataFrame data, boolean overwrite) {
        Object object;
        if (overwrite) {
            if (!this.confirmTruncate) throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString("You are attempting to use overwrite mode which will truncate\n          |this table prior to inserting data. If you would merely like\n          |to change data already in the table use the \"Append\" mode.\n          |To actually truncate please pass in true value to the option\n          |\"confirm.truncate\" when saving. ")).stripMargin());
            String keyspace = Quote$.MODULE$.quote(this.tableRef.keyspace());
            String table = Quote$.MODULE$.quote(this.tableRef.table());
            object = this.connector.withSessionDo(new scala.Serializable(this, keyspace, table){
                public static final long serialVersionUID = 0L;
                private final String keyspace$1;
                private final String table$1;

                public final ResultSet apply(Session session) {
                    return session.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyspace$1, this.table$1})));
                }
                {
                    this.keyspace$1 = keyspace$1;
                    this.table$1 = table$1;
                }
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        SqlRowWriter$Factory$ rwf = SqlRowWriter$Factory$.MODULE$;
        SomeColumns columns = new SomeColumns((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])data.columns()).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnRef apply(String x) {
                return com.datastax.spark.connector.package$.MODULE$.toNamedColumnRef(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class)))));
        com.datastax.spark.connector.package$.MODULE$.toRDDFunctions(data.rdd()).saveToCassandra(this.tableRef.keyspace(), this.tableRef.table(), columns, this.writeConf, this.cassandraConnector(), rwf);
    }

    public long sizeInBytes() {
        return BoxesRunTime.unboxToLong((Object)this.tableSizeInBytes.getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.sqlContext().conf().defaultSizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public CassandraConnector cassandraConnector() {
        return this.cassandraConnector;
    }

    public ReadConf readconf() {
        return this.readconf;
    }

    public RDD<Row> buildScan() {
        return this.baseRdd;
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        boolean bl;
        block4: {
            Filter[] filterArray;
            block3: {
                block2: {
                    bl = this.filterPushdown;
                    if (!bl) break block2;
                    filterArray = (Filter[])this.predicatePushDown(filters).handledBySpark().toArray(ClassTag$.MODULE$.apply(Filter.class));
                    break block3;
                }
                if (bl) break block4;
                filterArray = filters;
            }
            return filterArray;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public Seq<CassandraPredicateRules> additionalRules() {
        return this.bitmap$0 ? this.additionalRules : this.additionalRules$lzycompute();
    }

    private AnalyzedPredicates predicatePushDown(Filter[] filters) {
        this.logInfo((Function0<String>)new scala.Serializable(this, filters){
            public static final long serialVersionUID = 0L;
            private final Filter[] filters$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input Predicates: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.filters$1).mkString(", ")}));
            }
            {
                this.filters$1 = filters$1;
            }
        });
        ProtocolVersion pv = (ProtocolVersion)((Object)this.connector.withClusterDo(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ProtocolVersion apply(Cluster x$1) {
                return x$1.getConfiguration().getProtocolOptions().getProtocolVersion();
            }
        }));
        BasicCassandraPredicatePushDown<Filter> bcpp = new BasicCassandraPredicatePushDown<Filter>(Predef$.MODULE$.refArrayOps((Object[])filters).toSet(), this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef, pv, PredicateOps$FilterOps$.MODULE$);
        AnalyzedPredicates basicPushdown = new AnalyzedPredicates(bcpp.predicatesToPushDown(), bcpp.predicatesToPreserve());
        this.logDebug((Function0<String>)new scala.Serializable(this, basicPushdown){
            public static final long serialVersionUID = 0L;
            private final AnalyzedPredicates basicPushdown$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Basic Rules Applied:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.basicPushdown$1}));
            }
            {
                this.basicPushdown$1 = basicPushdown$1;
            }
        });
        AnalyzedPredicates finalPushdown = (AnalyzedPredicates)this.additionalRules().foldRight((Object)basicPushdown, (Function2)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            /*
             * WARNING - void declaration
             */
            public final AnalyzedPredicates apply(CassandraPredicateRules rules, AnalyzedPredicates pushdowns) {
                void var3_3;
                AnalyzedPredicates pd = rules.apply(pushdowns, this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef);
                this.$outer.logDebug((Function0<String>)new scala.Serializable(this, pd, rules){
                    public static final long serialVersionUID = 0L;
                    private final AnalyzedPredicates pd$1;
                    private final CassandraPredicateRules rules$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Applied ", " Pushdown Filters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rules$1.getClass().getSimpleName(), this.pd$1}));
                    }
                    {
                        this.pd$1 = pd$1;
                        this.rules$1 = rules$1;
                    }
                });
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new scala.Serializable(this, finalPushdown){
            public static final long serialVersionUID = 0L;
            private final AnalyzedPredicates finalPushdown$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final Pushdown filters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.finalPushdown$1}));
            }
            {
                this.finalPushdown$1 = finalPushdown$1;
            }
        });
        return finalPushdown;
    }

    public RDD<Row> buildScan(String[] requiredColumns2, Filter[] filters) {
        CassandraRDD cassandraRDD;
        if (this.filterPushdown) {
            Filter[] pushdownFilters = (Filter[])this.predicatePushDown(filters).handledByCassandra().toArray(ClassTag$.MODULE$.apply(Filter.class));
            cassandraRDD = this.maybePushdownFilters(this.baseRdd, (Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])pushdownFilters));
        } else {
            cassandraRDD = this.baseRdd;
        }
        CassandraTableScanRDD<CassandraSQLRow> filteredRdd = cassandraRDD;
        return this.maybeSelect(filteredRdd, requiredColumns2);
    }

    private RDD<Row> maybeSelect(CassandraRDD<CassandraSQLRow> rdd, String[] requiredColumns2) {
        CassandraRDD cassandraRDD;
        if (Predef$.MODULE$.refArrayOps((Object[])requiredColumns2).nonEmpty()) {
            cassandraRDD = rdd.select((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns2).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ColumnRef apply(String column) {
                    return com.datastax.spark.connector.package$.MODULE$.toNamedColumnRef(column);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class)))));
        } else {
            CassandraRDD cassandraRDD2;
            CassandraRDD cassandraRDD3 = rdd;
            if (cassandraRDD3 instanceof CassandraTableScanRDD) {
                CassandraTableScanRDD cassandraTableScanRDD = (CassandraTableScanRDD)cassandraRDD3;
                CassandraTableScanRDD<Object> qual$1 = CassandraTableScanRDD$.MODULE$.countRDD(cassandraTableScanRDD);
                scala.Serializable x$8 = new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<CassandraSQLRow> apply(Iterator<Object> x$2) {
                        return x$2.flatMap((Function1)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterator<CassandraSQLRow> apply(long count) {
                                return scala.package$.MODULE$.Iterator().fill((int)count, (Function0)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final CassandraSQLRow apply() {
                                        return CassandraSQLRow$.MODULE$.empty();
                                    }
                                });
                            }
                        });
                    }
                };
                boolean x$9 = qual$1.mapPartitions$default$2();
                cassandraRDD2 = qual$1.mapPartitions((Function1)x$8, x$9, ClassTag$.MODULE$.apply(CassandraSQLRow.class));
            } else {
                cassandraRDD2 = rdd;
            }
            cassandraRDD = cassandraRDD2;
        }
        CassandraRDD prunedRdd = cassandraRDD;
        return prunedRdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CassandraRDD<CassandraSQLRow> maybePushdownFilters(CassandraRDD<CassandraSQLRow> rdd, Seq<Filter> filters) {
        Tuple2<String, Seq<Object>> tuple2 = this.whereClause(filters);
        if (tuple2 == null) return rdd;
        String cql2 = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        if (!values.nonEmpty()) return rdd;
        return rdd.where(cql2, (Seq<Object>)values);
    }

    public Tuple2<String, Seq<Object>> org$apache$spark$sql$cassandra$CassandraSourceRelation$$filterToCqlAndValue(Object filter) {
        block8: {
            Tuple2 tuple2;
            block3: {
                Object object;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    object = filter;
                                    if (!(object instanceof EqualTo)) break block2;
                                    EqualTo equalTo = (EqualTo)object;
                                    String attribute = equalTo.attribute();
                                    Object value2 = equalTo.value();
                                    tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value2)})));
                                    break block3;
                                }
                                if (!(object instanceof LessThan)) break block4;
                                LessThan lessThan = (LessThan)object;
                                String attribute = lessThan.attribute();
                                Object value3 = lessThan.value();
                                tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value3)})));
                                break block3;
                            }
                            if (!(object instanceof LessThanOrEqual)) break block5;
                            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)object;
                            String attribute = lessThanOrEqual.attribute();
                            Object value4 = lessThanOrEqual.value();
                            tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <= ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value4)})));
                            break block3;
                        }
                        if (!(object instanceof GreaterThan)) break block6;
                        GreaterThan greaterThan = (GreaterThan)object;
                        String attribute = greaterThan.attribute();
                        Object value5 = greaterThan.value();
                        tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " > ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value5)})));
                        break block3;
                    }
                    if (!(object instanceof GreaterThanOrEqual)) break block7;
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)object;
                    String attribute = greaterThanOrEqual.attribute();
                    Object value6 = greaterThanOrEqual.value();
                    tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value6)})));
                    break block3;
                }
                if (!(object instanceof In)) break block8;
                In in = (In)object;
                String attribute = in.attribute();
                Object[] values = in.values();
                tuple2 = new Tuple2((Object)new StringBuilder().append((Object)Quote$.MODULE$.quote(attribute)).append((Object)" IN ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$3) {
                        return "?";
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("(", ", ", ")")).toString(), this.toCqlValues(attribute, values));
            }
            return tuple2;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It's not a valid filter ", " to be pushed down, only >, <, >=, <= and In are allowed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter})));
    }

    private Seq<Object> toCqlValues(String columnName2, Object[] values) {
        return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new scala.Serializable(this, columnName2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;
            private final String columnName$1;

            public final Object apply(Object x$4) {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(this.columnName$1, x$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnName$1 = columnName$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
    }

    public Object org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(String columnName2, Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof Decimal) {
            Decimal decimal = (Decimal)object2;
            ColumnType<?> columnType = ((ColumnDef)this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columnByName().apply((Object)columnName2)).columnType();
            VarIntType$ varIntType$ = VarIntType$.MODULE$;
            boolean isVarIntColumn = !(columnType != null ? !columnType.equals(varIntType$) : varIntType$ != null);
            object = isVarIntColumn ? decimal.toJavaBigDecimal().toBigInteger() : decimal;
        } else if (object2 instanceof UTF8String) {
            Serializable serializable;
            ColumnType<?> columnType;
            UTF8String uTF8String = (UTF8String)object2;
            ColumnType<?> columnType2 = columnType = ((ColumnDef)this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columnByName().apply((Object)columnName2)).columnType();
            InetType$ inetType$ = InetType$.MODULE$;
            if (!(columnType2 != null ? !columnType2.equals(inetType$) : inetType$ != null)) {
                serializable = InetAddress.getByName(uTF8String.toString());
            } else {
                ColumnType<?> columnType3 = columnType;
                UUIDType$ uUIDType$ = UUIDType$.MODULE$;
                serializable = !(columnType3 != null ? !columnType3.equals(uUIDType$) : uUIDType$ != null) ? UUID.fromString(uTF8String.toString()) : uTF8String;
            }
            object = serializable;
        } else {
            object = object2;
        }
        return object;
    }

    private Tuple2<String, Seq<Object>> whereClause(Seq<Object> pushdownFilters) {
        Seq cqlValue = (Seq)pushdownFilters.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final Tuple2<String, Seq<Object>> apply(Object filter) {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$filterToCqlAndValue(filter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        String cql2 = ((TraversableOnce)cqlValue.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Seq<Object>> x$5) {
                return (String)x$5._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        Seq args = (Seq)cqlValue.flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<String, Seq<Object>> x$6) {
                return (Seq)x$6._2();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)cql2, (Object)args);
    }

    public CassandraSourceRelation(TableRef tableRef, Option<StructType> userSpecifiedSchema, boolean filterPushdown, boolean confirmTruncate, Option<Object> tableSizeInBytes, CassandraConnector connector, ReadConf readConf, WriteConf writeConf, SQLContext sqlContext) {
        this.tableRef = tableRef;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.filterPushdown = filterPushdown;
        this.confirmTruncate = confirmTruncate;
        this.tableSizeInBytes = tableSizeInBytes;
        this.connector = connector;
        this.writeConf = writeConf;
        this.sqlContext = sqlContext;
        Logging$class.$init$(this);
        this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef = Schema$.MODULE$.tableFromCassandra(connector, tableRef.keyspace(), tableRef.table());
        this.cassandraConnector = connector;
        this.readconf = readConf;
        this.baseRdd = com.datastax.spark.connector.package$.MODULE$.toSparkContextFunctions(sqlContext.sparkContext()).cassandraTable(tableRef.keyspace(), tableRef.table(), this.cassandraConnector(), this.readconf(), ClassTag$.MODULE$.apply(CassandraSQLRow.class), CassandraSQLRow$CassandraSQLRowReader$.MODULE$, ValidRDDType$.MODULE$.javaSerializableAsValidRDDType());
    }
}

