/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.types.AsciiType$;
import com.datastax.spark.connector.types.BigIntType$;
import com.datastax.spark.connector.types.BlobType$;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.ColumnType$;
import com.datastax.spark.connector.types.CounterType$;
import com.datastax.spark.connector.types.CustomDriverConverter;
import com.datastax.spark.connector.types.DateType$;
import com.datastax.spark.connector.types.DecimalType$;
import com.datastax.spark.connector.types.DoubleType$;
import com.datastax.spark.connector.types.FloatType$;
import com.datastax.spark.connector.types.InetType$;
import com.datastax.spark.connector.types.IntType$;
import com.datastax.spark.connector.types.ListType;
import com.datastax.spark.connector.types.MapType;
import com.datastax.spark.connector.types.SetType;
import com.datastax.spark.connector.types.SmallIntType$;
import com.datastax.spark.connector.types.TextType$;
import com.datastax.spark.connector.types.TimeType$;
import com.datastax.spark.connector.types.TimeUUIDType$;
import com.datastax.spark.connector.types.TimestampType$;
import com.datastax.spark.connector.types.TinyIntType$;
import com.datastax.spark.connector.types.TupleFieldDef;
import com.datastax.spark.connector.types.TupleType;
import com.datastax.spark.connector.types.UDTFieldDef;
import com.datastax.spark.connector.types.UUIDType$;
import com.datastax.spark.connector.types.UserDefinedType;
import com.datastax.spark.connector.types.VarCharType$;
import com.datastax.spark.connector.types.VarIntType$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;

public final class DataTypeConverter$
implements Logging {
    public static final DataTypeConverter$ MODULE$;
    private final Map<ColumnType<?>, DataType> primitiveTypeMap;
    private PartialFunction<ColumnType<?>, DataType> customCatalystDataType;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile boolean bitmap$0;

    static {
        new DataTypeConverter$();
    }

    private PartialFunction customCatalystDataType$lzycompute() {
        DataTypeConverter$ dataTypeConverter$ = this;
        synchronized (dataTypeConverter$) {
            if (!this.bitmap$0) {
                this.customCatalystDataType = (PartialFunction)ColumnType$.MODULE$.customDriverConverter().flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Some<PartialFunction<ColumnType<?>, DataType>> apply(CustomDriverConverter clazz) {
                        return new Some(clazz.catalystDataType());
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final PartialFunction<Object, Nothing$> apply() {
                        return PartialFunction$.MODULE$.empty();
                    }
                });
                this.bitmap$0 = true;
            }
            return this.customCatalystDataType;
        }
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    @TraitSetter
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public Map<ColumnType<?>, DataType> primitiveTypeMap() {
        return this.primitiveTypeMap;
    }

    public DataType catalystDataType(ColumnType<?> cassandraType, boolean nullable) {
        ArrayType arrayType;
        ColumnType<?> columnType = cassandraType;
        if (columnType instanceof SetType) {
            SetType setType = (SetType)columnType;
            ColumnType et = setType.elemType();
            arrayType = new ArrayType(this.catalystDataType(et, nullable), nullable);
        } else if (columnType instanceof ListType) {
            ListType listType = (ListType)columnType;
            ColumnType et = listType.elemType();
            arrayType = new ArrayType(this.catalystDataType(et, nullable), nullable);
        } else if (columnType instanceof MapType) {
            MapType mapType = (MapType)columnType;
            ColumnType kt = mapType.keyType();
            ColumnType vt = mapType.valueType();
            arrayType = new org.apache.spark.sql.types.MapType(this.catalystDataType(kt, nullable), this.catalystDataType(vt, nullable), nullable);
        } else if (columnType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)columnType;
            IndexedSeq<UDTFieldDef> fields2 = userDefinedType.columns();
            arrayType = StructType$.MODULE$.apply((Seq)fields2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(UDTFieldDef field) {
                    return DataTypeConverter$.MODULE$.org$apache$spark$sql$cassandra$DataTypeConverter$$catalystStructField$1(field);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom()));
        } else if (columnType instanceof TupleType) {
            TupleType tupleType = (TupleType)columnType;
            Seq<TupleFieldDef> fields3 = tupleType.componentTypes();
            arrayType = StructType$.MODULE$.apply((Seq)fields3.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(TupleFieldDef field) {
                    return DataTypeConverter$.MODULE$.org$apache$spark$sql$cassandra$DataTypeConverter$$catalystStructFieldFromTuple$1(field);
                }
            }, Seq$.MODULE$.canBuildFrom()));
        } else if (VarIntType$.MODULE$.equals(columnType)) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "VarIntType is mapped to catalystTypes.DecimalType with unlimited values.";
                }
            });
            arrayType = this.primitiveCatalystDataType(cassandraType);
        } else {
            arrayType = this.primitiveCatalystDataType(cassandraType);
        }
        return arrayType;
    }

    public DataType primitiveCatalystDataType(ColumnType<?> cassandraType) {
        PartialFunction getColumnType = this.customCatalystDataType().orElse(this.primitiveTypeMap());
        return (DataType)getColumnType.apply(cassandraType);
    }

    private PartialFunction<ColumnType<?>, DataType> customCatalystDataType() {
        return this.bitmap$0 ? this.customCatalystDataType : this.customCatalystDataType$lzycompute();
    }

    public StructField toStructField(ColumnDef column) {
        return new StructField(column.columnName(), this.catalystDataType(column.columnType(), true), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public final StructField org$apache$spark$sql$cassandra$DataTypeConverter$$catalystStructField$1(UDTFieldDef field) {
        return new StructField(field.columnName(), this.catalystDataType(field.columnType(), true), true, StructField$.MODULE$.apply$default$4());
    }

    public final StructField org$apache$spark$sql$cassandra$DataTypeConverter$$catalystStructFieldFromTuple$1(TupleFieldDef field) {
        return new StructField(((Object)BoxesRunTime.boxToInteger((int)field.index())).toString(), this.catalystDataType(field.columnType(), true), true, StructField$.MODULE$.apply$default$4());
    }

    private DataTypeConverter$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.primitiveTypeMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TextType$.MODULE$), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AsciiType$.MODULE$), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VarCharType$.MODULE$), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)com.datastax.spark.connector.types.BooleanType$.MODULE$), (Object)BooleanType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IntType$.MODULE$), (Object)IntegerType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BigIntType$.MODULE$), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CounterType$.MODULE$), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FloatType$.MODULE$), (Object)org.apache.spark.sql.types.FloatType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DoubleType$.MODULE$), (Object)org.apache.spark.sql.types.DoubleType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SmallIntType$.MODULE$), (Object)ShortType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TinyIntType$.MODULE$), (Object)ByteType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VarIntType$.MODULE$), (Object)new DecimalType(38, 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DecimalType$.MODULE$), (Object)new DecimalType(38, 18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampType$.MODULE$), (Object)org.apache.spark.sql.types.TimestampType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)InetType$.MODULE$), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UUIDType$.MODULE$), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUUIDType$.MODULE$), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BlobType$.MODULE$), (Object)BinaryType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateType$.MODULE$), (Object)org.apache.spark.sql.types.DateType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeType$.MODULE$), (Object)LongType$.MODULE$)}));
    }
}

