/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.google.common.collect;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;
import shade.com.datastax.spark.connector.google.common.collect.ClassToInstanceMap;
import shade.com.datastax.spark.connector.google.common.collect.ForwardingMap;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableMap;
import shade.com.datastax.spark.connector.google.common.primitives.Primitives;

public final class ImmutableClassToInstanceMap<B>
extends ForwardingMap<Class<? extends B>, B>
implements ClassToInstanceMap<B>,
Serializable {
    private final ImmutableMap<Class<? extends B>, B> delegate;

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public static <B, S extends B> ImmutableClassToInstanceMap<B> copyOf(Map<? extends Class<? extends S>, ? extends S> map) {
        if (map instanceof ImmutableClassToInstanceMap) {
            ImmutableClassToInstanceMap cast = (ImmutableClassToInstanceMap)map;
            return cast;
        }
        return new Builder().putAll(map).build();
    }

    private ImmutableClassToInstanceMap(ImmutableMap<Class<? extends B>, B> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected Map<Class<? extends B>, B> delegate() {
        return this.delegate;
    }

    @Override
    @Nullable
    public <T extends B> T getInstance(Class<T> type) {
        return (T)this.delegate.get(Preconditions.checkNotNull(type));
    }

    @Override
    @Deprecated
    public <T extends B> T putInstance(Class<T> type, T value2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder<B> {
        private final ImmutableMap.Builder<Class<? extends B>, B> mapBuilder = ImmutableMap.builder();

        public <T extends B> Builder<B> put(Class<T> key, T value2) {
            this.mapBuilder.put(key, value2);
            return this;
        }

        public <T extends B> Builder<B> putAll(Map<? extends Class<? extends T>, ? extends T> map) {
            for (Map.Entry<Class<T>, T> entry : map.entrySet()) {
                Class<? extends T> type = entry.getKey();
                T value2 = entry.getValue();
                this.mapBuilder.put(type, Builder.cast(type, value2));
            }
            return this;
        }

        private static <B, T extends B> T cast(Class<T> type, B value2) {
            return Primitives.wrap(type).cast(value2);
        }

        public ImmutableClassToInstanceMap<B> build() {
            return new ImmutableClassToInstanceMap(this.mapBuilder.build());
        }
    }
}

