/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.google.common.collect;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import shade.com.datastax.spark.connector.google.common.annotations.GwtCompatible;
import shade.com.datastax.spark.connector.google.common.base.Function;
import shade.com.datastax.spark.connector.google.common.base.Predicate;
import shade.com.datastax.spark.connector.google.common.collect.MapMaker;
import shade.com.datastax.spark.connector.google.common.collect.Maps;
import shade.com.datastax.spark.connector.google.common.collect.Sets;

@GwtCompatible(emulated=true)
final class Platform {
    static <T> T[] newArray(T[] reference, int length) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, length);
        return result;
    }

    static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return Collections.newSetFromMap(map);
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    static <K, V1, V2> SortedMap<K, V2> mapsTransformEntriesSortedMap(SortedMap<K, V1> fromMap2, Maps.EntryTransformer<? super K, ? super V1, V2> transformer) {
        return fromMap2 instanceof NavigableMap ? Maps.transformEntries((NavigableMap)fromMap2, transformer) : Maps.transformEntriesIgnoreNavigable(fromMap2, transformer);
    }

    static <K, V> SortedMap<K, V> mapsAsMapSortedSet(SortedSet<K> set, Function<? super K, V> function) {
        return set instanceof NavigableSet ? Maps.asMap((NavigableSet)set, function) : Maps.asMapSortedIgnoreNavigable(set, function);
    }

    static <E> SortedSet<E> setsFilterSortedSet(SortedSet<E> set, Predicate<? super E> predicate2) {
        return set instanceof NavigableSet ? Sets.filter((NavigableSet)set, predicate2) : Sets.filterSortedIgnoreNavigable(set, predicate2);
    }

    static <K, V> SortedMap<K, V> mapsFilterSortedMap(SortedMap<K, V> map, Predicate<? super Map.Entry<K, V>> predicate2) {
        return map instanceof NavigableMap ? Maps.filterEntries((NavigableMap)map, predicate2) : Maps.filterSortedIgnoreNavigable(map, predicate2);
    }

    private Platform() {
    }
}

