/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.hadoop.hive.metastore;

import com.datastax.bdp.hadoop.hive.metastore.CassandraClientConfiguration;
import com.datastax.bdp.hadoop.hive.metastore.CassandraHiveMetaStoreException;
import com.datastax.bdp.hadoop.hive.metastore.HiveMetaStoreNotFoundException;
import com.datastax.bdp.hadoop.hive.metastore.HiveMetaStoreVersionUtil;
import com.datastax.bdp.util.ScalaJavaUtil;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.spark.connector.cql.CassandraConnector;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TSerializer;
import org.apache.thrift.meta_data.FieldMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStorePersister {
    private static final String COL_NAME_SEP = "::";
    private static final Logger log = LoggerFactory.getLogger(MetaStorePersister.class);
    private CassandraClientConfiguration configuration;
    private TSerializer serializer;
    private TDeserializer deserializer;
    private CassandraConnector cc;
    private String dseVersion;
    private Integer hiveMetaStoreVersion;
    private static final String insertQuery_template = "INSERT INTO \"%s\".\"%s\" (key, entity, value) VALUES(?, ?, ?)";
    private static final String selectAllQuery_template = "SELECT key, entity, value FROM \"%s\".\"%s\"";
    private static final String selectPerKeyQuery_template = "SELECT key, entity, value FROM \"%s\".\"%s\" WHERE key=?";
    private static final String selectQuery_template = "SELECT key, entity, value FROM \"%s\".\"%s\" WHERE key=? AND entity=?";
    private static final String deleteQuery_template = "DELETE FROM \"%s\".\"%s\" WHERE key=? AND entity=?";
    private static WeakHashMap<CassandraClientConfiguration, MetaStorePersister> metaStorePersisterInstanceCache = new WeakHashMap();

    public static synchronized MetaStorePersister getInstance(CassandraClientConfiguration cassandraClientConfiguration, CassandraConnector cassandraConnector) {
        MetaStorePersister metaStorePersister = metaStorePersisterInstanceCache.get(cassandraClientConfiguration);
        if (metaStorePersister == null) {
            metaStorePersister = new MetaStorePersister(cassandraClientConfiguration, cassandraConnector);
            metaStorePersisterInstanceCache.put(cassandraClientConfiguration, metaStorePersister);
        } else {
            metaStorePersister.configuration = cassandraClientConfiguration;
        }
        return metaStorePersister;
    }

    private MetaStorePersister(CassandraClientConfiguration cassandraClientConfiguration, CassandraConnector cassandraConnector) {
        this.configuration = cassandraClientConfiguration;
        this.cc = cassandraConnector;
        this.dseVersion = this.cc.withSessionDo(ScalaJavaUtil.asScalaFunction(HiveMetaStoreVersionUtil::getDSEVersion)).toString();
        this.hiveMetaStoreVersion = HiveMetaStoreVersionUtil.getHiveMetastoreVersion(this.dseVersion);
    }

    public void save(Map<? extends TFieldIdEnum, FieldMetaData> map, TBase tBase, String string) throws CassandraHiveMetaStoreException {
        if (log.isDebugEnabled()) {
            log.debug("in save with class: {} dbname: {}", (Object)tBase, (Object)string);
        }
        this.serializer = new TSerializer();
        this.cc.jWithSessionDo(cqlSession -> {
            try {
                String string2 = String.format(insertQuery_template, this.configuration.getKeyspaceName(), this.configuration.getColumnFamily());
                SimpleStatementBuilder simpleStatementBuilder = new SimpleStatementBuilder(string2).addPositionalValue((Object)this.versionedName(string.toLowerCase())).addPositionalValue((Object)this.buildEntityColumnName(tBase)).addPositionalValue((Object)ByteBuffer.wrap(this.serializer.serialize(tBase)));
                return cqlSession.execute((Statement)simpleStatementBuilder.build());
            }
            catch (Exception exception) {
                throw new CassandraHiveMetaStoreException(exception.getMessage(), exception);
            }
        });
    }

    public TBase load(TBase tBase, String string) throws CassandraHiveMetaStoreException, HiveMetaStoreNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("in load with class: {} dbname: {}", (Object)tBase.getClass().getName(), (Object)string);
        }
        this.deserializer = new TDeserializer();
        String string2 = this.buildEntityColumnName(tBase);
        ResultSet resultSet = this.cc.jWithSessionDo(cqlSession -> {
            String string3 = String.format(selectQuery_template, this.configuration.getKeyspaceName(), this.configuration.getColumnFamily());
            SimpleStatementBuilder simpleStatementBuilder = new SimpleStatementBuilder(string3).addPositionalValue((Object)this.versionedName(string.toLowerCase())).addPositionalValue((Object)string2);
            return cqlSession.execute((Statement)simpleStatementBuilder.build());
        });
        Row row = (Row)resultSet.one();
        if (row == null) {
            throw new HiveMetaStoreNotFoundException();
        }
        try {
            this.deserializer.deserialize(tBase, row.getByteBuffer("value").array());
        }
        catch (Exception exception) {
            throw new CassandraHiveMetaStoreException(exception.getMessage(), exception);
        }
        return tBase;
    }

    public List<TBase> find(TBase tBase, String string) throws CassandraHiveMetaStoreException {
        return this.find(tBase, string, null, Integer.MAX_VALUE);
    }

    public List<TBase> find(TBase tBase, String string, String string2, int n) throws CassandraHiveMetaStoreException {
        if (log.isDebugEnabled()) {
            log.debug("in find with class: {} dbname: {} prefix: {} and count: {}", new Object[]{tBase.getClass().getName(), string, string2, n});
        }
        this.deserializer = new TDeserializer();
        ArrayList<TBase> arrayList = new ArrayList<TBase>();
        int n2 = n < 0 ? Integer.MAX_VALUE : n;
        this.cc.jWithSessionDo(cqlSession -> {
            try {
                String string3 = String.format(selectPerKeyQuery_template, this.configuration.getKeyspaceName(), this.configuration.getColumnFamily());
                SimpleStatementBuilder simpleStatementBuilder = new SimpleStatementBuilder(string3).addPositionalValue((Object)this.versionedName(string.toLowerCase()));
                ResultSet resultSet = cqlSession.execute((Statement)simpleStatementBuilder.build());
                Iterator iterator = resultSet.iterator();
                int n2 = 0;
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    String string4 = this.entityPrefix(tBase, string2);
                    if (n2 >= n2 || !row.getString("entity").startsWith(string4)) continue;
                    TBase tBase2 = (TBase)tBase.getClass().newInstance();
                    this.deserializer.deserialize(tBase2, row.getByteBuffer("value").array());
                    arrayList.add(tBase2);
                    ++n2;
                }
                return null;
            }
            catch (Exception exception) {
                throw new CassandraHiveMetaStoreException(exception.getMessage(), exception);
            }
        });
        return arrayList;
    }

    private String entityPrefix(TBase tBase, String string) {
        StringBuilder stringBuilder = new StringBuilder(96);
        stringBuilder.append(tBase.getClass().getName()).append(COL_NAME_SEP);
        if (string != null && !string.isEmpty()) {
            if (tBase instanceof Table || tBase instanceof Partition) {
                string = string.toLowerCase();
            }
            stringBuilder.append(string);
            if (tBase instanceof Index || tBase instanceof Partition) {
                stringBuilder.append(COL_NAME_SEP);
            }
        }
        return stringBuilder.toString();
    }

    public void remove(TBase tBase, String string) {
        this.removeAll(Arrays.asList(tBase), string);
    }

    public void removeAll(List<TBase> list, String string) {
        this.serializer = new TSerializer();
        this.cc.jWithSessionDo(cqlSession -> {
            PreparedStatement preparedStatement = cqlSession.prepare(String.format(deleteQuery_template, this.configuration.getKeyspaceName(), this.configuration.getColumnFamily()));
            try {
                for (TBase tBase : list) {
                    if (log.isDebugEnabled()) {
                        log.debug("in remove with class: {} dbname: {}", (Object)tBase, (Object)string);
                    }
                    this.delete((CqlSession)cqlSession, preparedStatement, this.versionedName(string.toLowerCase()), this.buildEntityColumnName(tBase));
                }
            }
            catch (Exception exception) {
                throw new CassandraHiveMetaStoreException(exception.getMessage(), exception);
            }
            return null;
        });
    }

    private void delete(CqlSession cqlSession, PreparedStatement preparedStatement, String string, String string2) {
        if (log.isDebugEnabled()) {
            log.debug("delete key: {}, entity: {}", (Object)string, (Object)string2);
        }
        cqlSession.execute((Statement)preparedStatement.bind(new Object[]{string, string2}));
    }

    private String buildEntityColumnName(TBase tBase) {
        StringBuilder stringBuilder = new StringBuilder(96);
        stringBuilder.append(tBase.getClass().getName()).append(COL_NAME_SEP);
        if (tBase instanceof Database) {
            stringBuilder.append(((Database)tBase).getName().toLowerCase());
        } else if (tBase instanceof Table) {
            stringBuilder.append(((Table)tBase).getTableName().toLowerCase());
        } else if (tBase instanceof Index) {
            stringBuilder.append(((Index)tBase).getOrigTableName().toLowerCase()).append(COL_NAME_SEP).append(((Index)tBase).getIndexName());
        } else if (tBase instanceof Partition) {
            stringBuilder.append(((Partition)tBase).getTableName().toLowerCase());
            for (String string : ((Partition)tBase).getValues()) {
                stringBuilder.append(COL_NAME_SEP).append(string);
            }
        } else if (tBase instanceof Type) {
            stringBuilder.append(((Type)tBase).getName());
        } else if (tBase instanceof Role) {
            stringBuilder.append(((Role)tBase).getRoleName());
        } else if (tBase instanceof Function) {
            stringBuilder.append(((Function)tBase).getFunctionName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Constructed columnName: {}", (Object)stringBuilder);
        }
        return stringBuilder.toString();
    }

    private String versionedName(String string) {
        if (Objects.equals(this.hiveMetaStoreVersion, HiveMetaStoreVersionUtil.nonHiveMetastoreVersion)) {
            return String.format("_%s_%s", this.dseVersion, string);
        }
        return String.format("_%s_%s", this.hiveMetaStoreVersion, string);
    }
}

