/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.cql.ContactInfo;
import com.datastax.spark.connector.cql.DefaultConnectionFactory$;
import com.datastax.spark.connector.cql.IpBasedContactInfo;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy$;
import com.datastax.spark.connector.cql.RefCountedCache;
import com.datastax.spark.connector.types.TypeConverter;
import com.datastax.spark.connector.types.TypeConverter$;
import com.datastax.spark.connector.util.ConfigCheck;
import com.datastax.spark.connector.util.DriverUtil$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.SerialShutdownHooks$;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class CassandraConnector$
implements Logging,
Serializable {
    public static final CassandraConnector$ MODULE$;
    private final RefCountedCache<CassandraConnectorConf, CqlSession> sessionCache;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new CassandraConnector$();
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RefCountedCache<CassandraConnectorConf, CqlSession> sessionCache() {
        return this.sessionCache;
    }

    public CqlSession com$datastax$spark$connector$cql$CassandraConnector$$createSession(CassandraConnectorConf conf) {
        ObjectRef endpointsStr$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        this.logDebug((Function0<String>)new Serializable(conf, endpointsStr$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf conf$1;
            private final ObjectRef endpointsStr$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to open native connection to Cassandra with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CassandraConnector$.MODULE$.com$datastax$spark$connector$cql$CassandraConnector$$endpointsStr$1(this.conf$1, this.endpointsStr$lzy$1, this.bitmap$0$1)}));
            }
            {
                this.conf$1 = conf$1;
                this.endpointsStr$lzy$1 = endpointsStr$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
        try {
            CqlSession session = conf.connectionFactory().createSession(conf);
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to Cassandra cluster."})).s((Seq)Nil$.MODULE$);
                }
            });
            return session;
        }
        catch (Throwable throwable) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to open native connection to Cassandra at ", " :: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.com$datastax$spark$connector$cql$CassandraConnector$$endpointsStr$1(conf, endpointsStr$lzy, bitmap$0), throwable.getLocalizedMessage()})), throwable);
        }
    }

    public void com$datastax$spark$connector$cql$CassandraConnector$$destroySession(CqlSession session) {
        session.close();
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disconnected from Cassandra cluster."})).s((Seq)Nil$.MODULE$);
            }
        });
    }

    private Set<InetSocketAddress> dataCenterNodes(CassandraConnectorConf conf, IpBasedContactInfo ipConf, CqlSession session) {
        String dcToUse;
        Set allNodes = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(session.getMetadata().getNodes()).asScala()).values().toSet();
        Set nodes = (Set)((GenericTraversableTemplate)allNodes.collect((PartialFunction)new Serializable(dcToUse = (String)conf.localDC().getOrElse((Function0)new Serializable(ipConf, allNodes){
            public static final long serialVersionUID = 0L;
            private final IpBasedContactInfo ipConf$1;
            private final Set allNodes$1;

            public final String apply() {
                return LocalNodeFirstLoadBalancingPolicy$.MODULE$.determineDataCenter(this.ipConf$1.hosts(), this.allNodes$1);
            }
            {
                this.ipConf$1 = ipConf$1;
                this.allNodes$1 = allNodes$1;
            }
        })){
            public static final long serialVersionUID = 0L;
            private final String dcToUse$1;

            public final <A1 extends Node, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                String string = A1.getDatacenter();
                String string2 = this.dcToUse$1;
                Object object = !(string != null ? !string.equals(string2) : string2 != null) ? DriverUtil$.MODULE$.toAddress(A1) : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(Node x3) {
                Node node = x3;
                String string = node.getDatacenter();
                String string2 = this.dcToUse$1;
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                return bl;
            }
            {
                this.dcToUse$1 = dcToUse$1;
            }
        }, Set$.MODULE$.canBuildFrom())).flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<InetSocketAddress> apply(Option<InetSocketAddress> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        });
        if (nodes.isEmpty()) {
            throw new ConfigCheck.ConnectorConfigurationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not determine suitable nodes for DC: ", " and known nodes: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dcToUse}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)allNodes.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<UUID, Option<InetSocketAddress>> apply(Node n) {
                    return new Tuple2((Object)n.getHostId(), (Object)DriverUtil$.MODULE$.toAddress(n));
                }
            }, Set$.MODULE$.canBuildFrom())).mkString(", ")}))).toString());
        }
        return nodes;
    }

    public Set<CassandraConnectorConf> com$datastax$spark$connector$cql$CassandraConnector$$alternativeConnectionConfigs(CassandraConnectorConf conf, CqlSession session) {
        Set set;
        ContactInfo contactInfo = conf.contactInfo();
        if (contactInfo instanceof IpBasedContactInfo) {
            IpBasedContactInfo ipBasedContactInfo = (IpBasedContactInfo)contactInfo;
            Set<InetSocketAddress> nodes = this.dataCenterNodes(conf, ipBasedContactInfo, session);
            set = (Set)((SetLike)nodes.map((Function1)new Serializable(conf, ipBasedContactInfo){
                public static final long serialVersionUID = 0L;
                private final CassandraConnectorConf conf$2;
                private final IpBasedContactInfo x2$1;

                public final CassandraConnectorConf apply(InetSocketAddress n) {
                    return this.conf$2.copy(this.x2$1.copy((Set<InetSocketAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetSocketAddress[]{n}))), this.x2$1.copy$default$2(), this.x2$1.copy$default$3()), this.conf$2.copy$default$2(), this.conf$2.copy$default$3(), this.conf$2.copy$default$4(), this.conf$2.copy$default$5(), this.conf$2.copy$default$6(), this.conf$2.copy$default$7(), this.conf$2.copy$default$8(), this.conf$2.copy$default$9(), this.conf$2.copy$default$10(), this.conf$2.copy$default$11(), this.conf$2.copy$default$12(), this.conf$2.copy$default$13(), this.conf$2.copy$default$14(), this.conf$2.copy$default$15());
                }
                {
                    this.conf$2 = conf$2;
                    this.x2$1 = x2$1;
                }
            }, Set$.MODULE$.canBuildFrom())).$plus((Object)conf.copy(ipBasedContactInfo.copy(nodes, ipBasedContactInfo.copy$default$2(), ipBasedContactInfo.copy$default$3()), conf.copy$default$2(), conf.copy$default$3(), conf.copy$default$4(), conf.copy$default$5(), conf.copy$default$6(), conf.copy$default$7(), conf.copy$default$8(), conf.copy$default$9(), conf.copy$default$10(), conf.copy$default$11(), conf.copy$default$12(), conf.copy$default$13(), conf.copy$default$14(), conf.copy$default$15()));
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public CassandraConnector apply(CassandraConnectorConf conf) {
        return new CassandraConnector(conf);
    }

    public CassandraConnector apply(SparkConf conf) {
        return this.apply(CassandraConnectorConf$.MODULE$.fromSparkConf(conf));
    }

    public CassandraConnector apply(SparkContext sc) {
        return this.apply(sc.getConf());
    }

    public CassandraConnector apply(ContactInfo contactInfo, Option<String> localDC, int keepAliveMillis, int minReconnectionDelayMillis, int maxReconnectionDelayMillis, int queryRetryCount, int connectTimeoutMillis, int readTimeoutMillis, CassandraConnectionFactory connectionFactory) {
        ContactInfo x$5 = contactInfo;
        Option<String> x$6 = localDC;
        int x$7 = keepAliveMillis;
        int x$8 = minReconnectionDelayMillis;
        int x$9 = maxReconnectionDelayMillis;
        int x$10 = queryRetryCount;
        int x$11 = connectTimeoutMillis;
        int x$12 = readTimeoutMillis;
        CassandraConnectionFactory x$13 = connectionFactory;
        Option<Object> x$14 = CassandraConnectorConf$.MODULE$.apply$default$6();
        Option<Object> x$15 = CassandraConnectorConf$.MODULE$.apply$default$7();
        String x$16 = CassandraConnectorConf$.MODULE$.apply$default$8();
        int x$17 = CassandraConnectorConf$.MODULE$.apply$default$13();
        int x$18 = CassandraConnectorConf$.MODULE$.apply$default$14();
        boolean x$19 = CassandraConnectorConf$.MODULE$.apply$default$15();
        CassandraConnectorConf config = new CassandraConnectorConf(x$5, x$6, x$7, x$8, x$9, x$14, x$15, x$16, x$10, x$11, x$12, x$13, x$17, x$18, x$19);
        return new CassandraConnector(config);
    }

    public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    public int apply$default$3() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.KeepAliveMillisParam().default());
    }

    public int apply$default$4() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.MinReconnectionDelayParam().default());
    }

    public int apply$default$5() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.MaxReconnectionDelayParam().default());
    }

    public int apply$default$6() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.QueryRetryParam().default());
    }

    public int apply$default$7() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ConnectionTimeoutParam().default());
    }

    public int apply$default$8() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ReadTimeoutParam().default());
    }

    public CassandraConnectionFactory apply$default$9() {
        return DefaultConnectionFactory$.MODULE$;
    }

    public void evictCache() {
        this.sessionCache().evict();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final String endpointsStr$lzycompute$1(CassandraConnectorConf conf$1, ObjectRef endpointsStr$lzy$1, VolatileByteRef bitmap$0$1) {
        CassandraConnector$ cassandraConnector$ = this;
        synchronized (cassandraConnector$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                endpointsStr$lzy$1.elem = conf$1.contactInfo().endPointStr();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)endpointsStr$lzy$1.elem;
        }
    }

    public final String com$datastax$spark$connector$cql$CassandraConnector$$endpointsStr$1(CassandraConnectorConf conf$1, ObjectRef endpointsStr$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.endpointsStr$lzycompute$1(conf$1, endpointsStr$lzy$1, bitmap$0$1) : (String)endpointsStr$lzy$1.elem;
    }

    private CassandraConnector$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        TypeConverter$.MODULE$.registerConverter((TypeConverter)new CassandraConnector.GenericRowWithSchemeToValuesByNameConverter());
        TypeConverter$.MODULE$.registerConverter((TypeConverter)new CassandraConnector.GenericRowWithSchemeToValuesSeqConverter());
        this.sessionCache = new RefCountedCache(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CqlSession apply(CassandraConnectorConf conf) {
                return CassandraConnector$.MODULE$.com$datastax$spark$connector$cql$CassandraConnector$$createSession(conf);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CqlSession session) {
                CassandraConnector$.MODULE$.com$datastax$spark$connector$cql$CassandraConnector$$destroySession(session);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<CassandraConnectorConf> apply(CassandraConnectorConf conf, CqlSession session) {
                return CassandraConnector$.MODULE$.com$datastax$spark$connector$cql$CassandraConnector$$alternativeConnectionConfigs(conf, session);
            }
        });
        SerialShutdownHooks$.MODULE$.add("Clearing session cache for C* connector", 200, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CassandraConnector$.MODULE$.sessionCache().shutdown();
            }
        });
    }
}

