/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.bdp.spark.ContinuousPagingScanner;
import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.OngoingConfigOptions;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.SessionBuilder;
import com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy;
import com.datastax.oss.driver.internal.core.ssl.DefaultSslEngineFactory;
import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$class;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CloudBasedContactInfo;
import com.datastax.spark.connector.cql.ContactInfo;
import com.datastax.spark.connector.cql.DefaultScanner;
import com.datastax.spark.connector.cql.IpBasedContactInfo;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy;
import com.datastax.spark.connector.cql.MultipleRetryPolicy;
import com.datastax.spark.connector.cql.MultipleRetryPolicy$;
import com.datastax.spark.connector.cql.MultiplexingSchemaListener;
import com.datastax.spark.connector.cql.ProfileFileBasedContactInfo;
import com.datastax.spark.connector.cql.Scanner;
import com.datastax.spark.connector.rdd.ReadConf;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFiles$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class DefaultConnectionFactory$
implements CassandraConnectionFactory {
    public static final DefaultConnectionFactory$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DefaultConnectionFactory$();
    }

    private Logger logger$lzycompute() {
        DefaultConnectionFactory$ defaultConnectionFactory$ = this;
        synchronized (defaultConnectionFactory$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger((String)"com.datastax.spark.connector.cql.CassandraConnectionFactory");
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Set<String> properties() {
        return CassandraConnectionFactory$class.properties(this);
    }

    private Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public ProgrammaticDriverConfigLoaderBuilder connectorConfigBuilder(CassandraConnectorConf conf, ProgrammaticDriverConfigLoaderBuilder initBuilder) {
        Seq seq;
        Seq universalProperties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf conf$1;

            public final ProgrammaticDriverConfigLoaderBuilder apply(ProgrammaticDriverConfigLoaderBuilder builder) {
                return DefaultConnectionFactory$.MODULE$.com$datastax$spark$connector$cql$DefaultConnectionFactory$$basicProperties$1(builder, this.conf$1);
            }
            {
                this.conf$1 = conf$1;
            }
        }, new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf conf$1;

            public final ProgrammaticDriverConfigLoaderBuilder apply(ProgrammaticDriverConfigLoaderBuilder b) {
                return DefaultConnectionFactory$.MODULE$.com$datastax$spark$connector$cql$DefaultConnectionFactory$$compressionProperties$1(b, this.conf$1);
            }
            {
                this.conf$1 = conf$1;
            }
        }, new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf conf$1;

            public final ProgrammaticDriverConfigLoaderBuilder apply(ProgrammaticDriverConfigLoaderBuilder b) {
                return DefaultConnectionFactory$.MODULE$.com$datastax$spark$connector$cql$DefaultConnectionFactory$$localDCProperty$1(b, this.conf$1);
            }
            {
                this.conf$1 = conf$1;
            }
        }}));
        ContactInfo contactInfo = conf.contactInfo();
        if (contactInfo instanceof IpBasedContactInfo) {
            IpBasedContactInfo ipBasedContactInfo = (IpBasedContactInfo)contactInfo;
            seq = (Seq)universalProperties.$colon$plus((Object)this.ipBasedConnectionProperties$1(ipBasedContactInfo), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = universalProperties;
        }
        Seq appliedProperties = seq;
        return (ProgrammaticDriverConfigLoaderBuilder)appliedProperties.foldLeft((Object)initBuilder, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ProgrammaticDriverConfigLoaderBuilder apply(ProgrammaticDriverConfigLoaderBuilder x0$2, Function1<ProgrammaticDriverConfigLoaderBuilder, ProgrammaticDriverConfigLoaderBuilder> x1$2) {
                Tuple2 tuple2 = new Tuple2((Object)x0$2, x1$2);
                if (tuple2 != null) {
                    ProgrammaticDriverConfigLoaderBuilder builder = (ProgrammaticDriverConfigLoaderBuilder)tuple2._1();
                    Function1 properties = (Function1)tuple2._2();
                    ProgrammaticDriverConfigLoaderBuilder programmaticDriverConfigLoaderBuilder = (ProgrammaticDriverConfigLoaderBuilder)properties.apply((Object)builder);
                    return programmaticDriverConfigLoaderBuilder;
                }
                throw new MatchError((Object)tuple2);
            }
        });
    }

    @Override
    public CqlSession createSession(CassandraConnectorConf conf) {
        ContactInfo contactInfo;
        block5: {
            CqlSessionBuilder cqlSessionBuilder;
            block3: {
                CqlSessionBuilder initialBuilder;
                block4: {
                    DriverConfigLoader configLoader;
                    block2: {
                        ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder = DriverConfigLoader.programmaticBuilder();
                        configLoader = this.connectorConfigBuilder(conf, configLoaderBuilder).build();
                        initialBuilder = CqlSession.builder();
                        contactInfo = conf.contactInfo();
                        if (!(contactInfo instanceof IpBasedContactInfo)) break block2;
                        IpBasedContactInfo ipBasedContactInfo = (IpBasedContactInfo)contactInfo;
                        cqlSessionBuilder = (CqlSessionBuilder)((SessionBuilder)ipBasedContactInfo.authConf().authProvider().fold((Function0)new Serializable(initialBuilder){
                            public static final long serialVersionUID = 0L;
                            private final CqlSessionBuilder initialBuilder$1;

                            public final CqlSessionBuilder apply() {
                                return this.initialBuilder$1;
                            }
                            {
                                this.initialBuilder$1 = initialBuilder$1;
                            }
                        }, (Function1)new Serializable(initialBuilder){
                            public static final long serialVersionUID = 0L;
                            private final CqlSessionBuilder initialBuilder$1;

                            public final CqlSessionBuilder apply(AuthProvider x$1) {
                                return (CqlSessionBuilder)this.initialBuilder$1.withAuthProvider(x$1);
                            }
                            {
                                this.initialBuilder$1 = initialBuilder$1;
                            }
                        })).withConfigLoader(configLoader);
                        break block3;
                    }
                    if (!(contactInfo instanceof CloudBasedContactInfo)) break block4;
                    CloudBasedContactInfo cloudBasedContactInfo = (CloudBasedContactInfo)contactInfo;
                    String path = cloudBasedContactInfo.path();
                    AuthConf authConf = cloudBasedContactInfo.authConf();
                    cqlSessionBuilder = (CqlSessionBuilder)((SessionBuilder)authConf.authProvider().fold((Function0)new Serializable(initialBuilder){
                        public static final long serialVersionUID = 0L;
                        private final CqlSessionBuilder initialBuilder$1;

                        public final CqlSessionBuilder apply() {
                            return this.initialBuilder$1;
                        }
                        {
                            this.initialBuilder$1 = initialBuilder$1;
                        }
                    }, (Function1)new Serializable(initialBuilder){
                        public static final long serialVersionUID = 0L;
                        private final CqlSessionBuilder initialBuilder$1;

                        public final CqlSessionBuilder apply(AuthProvider x$1) {
                            return (CqlSessionBuilder)this.initialBuilder$1.withAuthProvider(x$1);
                        }
                        {
                            this.initialBuilder$1 = initialBuilder$1;
                        }
                    })).withCloudSecureConnectBundle(this.maybeGetLocalFile(path)).withConfigLoader(configLoader);
                    break block3;
                }
                if (!(contactInfo instanceof ProfileFileBasedContactInfo)) break block5;
                ProfileFileBasedContactInfo profileFileBasedContactInfo = (ProfileFileBasedContactInfo)contactInfo;
                String path = profileFileBasedContactInfo.path();
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring all programmatic configuration, only using configuration from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
                cqlSessionBuilder = (CqlSessionBuilder)initialBuilder.withConfigLoader(DriverConfigLoader.fromUrl((URL)this.maybeGetLocalFile(path)));
            }
            CqlSessionBuilder builderWithContactInfo = cqlSessionBuilder;
            String appName = (String)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(SparkEnv env) {
                    return env.conf().getAppId();
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "NoAppID";
                }
            });
            return (CqlSession)builderWithContactInfo.withApplicationName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark-Cassandra-Connector-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appName}))).withSchemaChangeListener((SchemaChangeListener)new MultiplexingSchemaListener()).build();
        }
        throw new MatchError((Object)contactInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL maybeGetLocalFile(String path) {
        URL uRL;
        Path localPath = Paths.get(SparkFiles$.MODULE$.get(path), new String[0]);
        if (Files.exists(localPath, new LinkOption[0])) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found the ", " locally at ", ", using this local file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, localPath})));
            uRL = localPath.toUri().toURL();
            return uRL;
        }
        try {
            uRL = new URL(path);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The provided path ", " is not a valid URL nor an existing locally path. Provide an "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"URL accessible to all executors or a path existing on all executors (you may use `spark.files` to "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"distribute a file to each executor)."})).s((Seq)Nil$.MODULE$)).toString(), malformedURLException);
        }
    }

    public boolean continuousPagingEnabled(CqlSession session) {
        boolean bl;
        boolean confEnabled = SparkEnv$.MODULE$.get().conf().getBoolean(CassandraConnectionFactory$.MODULE$.continuousPagingParam().name(), BoxesRunTime.unboxToBoolean((Object)CassandraConnectionFactory$.MODULE$.continuousPagingParam().default()));
        ProtocolVersion pv = session.getContext().getProtocolVersion();
        if (pv.getCode() > DseProtocolVersion.DSE_V1.getCode() && confEnabled) {
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scan Method Being Set to Continuous Paging"})).s((Seq)Nil$.MODULE$));
            bl = true;
        } else {
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scan Mode Disabled or Connecting to Non-DSE Cassandra Cluster"})).s((Seq)Nil$.MODULE$));
            bl = false;
        }
        return bl;
    }

    @Override
    public Scanner getScanner(ReadConf readConf, CassandraConnectorConf connConf, IndexedSeq<String> columnNames) {
        Scanner scanner;
        boolean isContinuousPagingEnabled = BoxesRunTime.unboxToBoolean(new CassandraConnector(connConf).withSessionDo(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CqlSession session) {
                return DefaultConnectionFactory$.MODULE$.continuousPagingEnabled(session);
            }
        }));
        if (isContinuousPagingEnabled) {
            this.logger().debug("Using ContinousPagingScanner");
            scanner = new ContinuousPagingScanner(readConf, connConf, columnNames);
        } else {
            this.logger().debug("Not Connected to DSE 5.1 or Greater Falling back to Non-Continuous Paging");
            scanner = new DefaultScanner(readConf, connConf, columnNames);
        }
        return scanner;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final ProgrammaticDriverConfigLoaderBuilder com$datastax$spark$connector$cql$DefaultConnectionFactory$$basicProperties$1(ProgrammaticDriverConfigLoaderBuilder builder, CassandraConnectorConf conf$1) {
        int localCoreThreadCount = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        return (ProgrammaticDriverConfigLoaderBuilder)builder.withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE, BoxesRunTime.unboxToInt((Object)conf$1.localConnectionsPerExecutor().getOrElse((Function0)new Serializable(localCoreThreadCount){
            public static final long serialVersionUID = 0L;
            private final int localCoreThreadCount$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.localCoreThreadCount$1;
            }
            {
                this.localCoreThreadCount$1 = localCoreThreadCount$1;
            }
        }))).withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE, BoxesRunTime.unboxToInt((Object)conf$1.remoteConnectionsPerExecutor().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }))).withInt((DriverOption)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, conf$1.connectTimeoutMillis()).withDuration((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT, Duration.ofMillis(conf$1.connectTimeoutMillis())).withDuration((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REQUEST_TIMEOUT, Duration.ofMillis(conf$1.connectTimeoutMillis())).withInt((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, conf$1.readTimeoutMillis()).withClass((DriverOption)DefaultDriverOption.RETRY_POLICY_CLASS, MultipleRetryPolicy.class).withClass((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, ExponentialReconnectionPolicy.class).withDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, Duration.ofMillis(conf$1.minReconnectionDelayMillis())).withDuration((DriverOption)DefaultDriverOption.RECONNECTION_MAX_DELAY, Duration.ofMillis(conf$1.maxReconnectionDelayMillis())).withInt((DriverOption)DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_QUIET_PERIOD, conf$1.quietPeriodBeforeCloseMillis() / 1000).withInt((DriverOption)DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_TIMEOUT, conf$1.timeoutBeforeCloseMillis() / 1000).withInt((DriverOption)DefaultDriverOption.NETTY_IO_SHUTDOWN_QUIET_PERIOD, conf$1.quietPeriodBeforeCloseMillis() / 1000).withInt((DriverOption)DefaultDriverOption.NETTY_IO_SHUTDOWN_TIMEOUT, conf$1.timeoutBeforeCloseMillis() / 1000).withBoolean((DriverOption)DefaultDriverOption.NETTY_DAEMON, true).withBoolean((DriverOption)DefaultDriverOption.RESOLVE_CONTACT_POINTS, conf$1.resolveContactPoints()).withInt(MultipleRetryPolicy$.MODULE$.MaxRetryCount(), conf$1.queryRetryCount()).withDuration((DriverOption)DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE, Duration.ofMillis(conf$1.readTimeoutMillis())).withDuration((DriverOption)DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES, Duration.ofMillis(conf$1.readTimeoutMillis()));
    }

    public final ProgrammaticDriverConfigLoaderBuilder com$datastax$spark$connector$cql$DefaultConnectionFactory$$compressionProperties$1(ProgrammaticDriverConfigLoaderBuilder b, CassandraConnectorConf conf$1) {
        return (ProgrammaticDriverConfigLoaderBuilder)Option$.MODULE$.apply((Object)conf$1.compression()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                String string = x$1.toLowerCase();
                String string2 = "none";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        }).fold((Function0)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final ProgrammaticDriverConfigLoaderBuilder b$1;

            public final ProgrammaticDriverConfigLoaderBuilder apply() {
                return this.b$1;
            }
            {
                this.b$1 = b$1;
            }
        }, (Function1)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final ProgrammaticDriverConfigLoaderBuilder b$1;

            public final ProgrammaticDriverConfigLoaderBuilder apply(String c) {
                return (ProgrammaticDriverConfigLoaderBuilder)this.b$1.withString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, c.toLowerCase());
            }
            {
                this.b$1 = b$1;
            }
        });
    }

    public final ProgrammaticDriverConfigLoaderBuilder com$datastax$spark$connector$cql$DefaultConnectionFactory$$localDCProperty$1(ProgrammaticDriverConfigLoaderBuilder b, CassandraConnectorConf conf$1) {
        return (ProgrammaticDriverConfigLoaderBuilder)conf$1.localDC().map((Function1)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final ProgrammaticDriverConfigLoaderBuilder b$2;

            public final ProgrammaticDriverConfigLoaderBuilder apply(String x$2) {
                return (ProgrammaticDriverConfigLoaderBuilder)this.b$2.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, x$2);
            }
            {
                this.b$2 = b$2;
            }
        }).getOrElse((Function0)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final ProgrammaticDriverConfigLoaderBuilder b$2;

            public final ProgrammaticDriverConfigLoaderBuilder apply() {
                return this.b$2;
            }
            {
                this.b$2 = b$2;
            }
        });
    }

    private final Function1 ipBasedConnectionProperties$1(IpBasedContactInfo ipConf) {
        return new Serializable(ipConf){
            public static final long serialVersionUID = 0L;
            private final IpBasedContactInfo ipConf$1;

            public final ProgrammaticDriverConfigLoaderBuilder apply(ProgrammaticDriverConfigLoaderBuilder builder) {
                builder.withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)this.ipConf$1.hosts().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(InetSocketAddress h) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{h.getHostString(), BoxesRunTime.boxToInteger((int)h.getPort())}));
                    }
                }, Set$.MODULE$.canBuildFrom())).toList()).asJava()).withClass((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, LocalNodeFirstLoadBalancingPolicy.class);
                return this.ipConf$1.cassandraSSLConf().enabled() ? (ProgrammaticDriverConfigLoaderBuilder)((OngoingConfigOptions)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultDriverOption.SSL_TRUSTSTORE_PATH), this.ipConf$1.cassandraSSLConf().trustStorePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultDriverOption.SSL_TRUSTSTORE_PASSWORD), this.ipConf$1.cassandraSSLConf().trustStorePassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultDriverOption.SSL_KEYSTORE_PATH), (Object)this.clientAuthEnabled$1(this.ipConf$1.cassandraSSLConf().keyStorePath())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultDriverOption.SSL_KEYSTORE_PASSWORD), (Object)this.clientAuthEnabled$1(this.ipConf$1.cassandraSSLConf().keyStorePassword()))}))).foldLeft((Object)builder, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ProgrammaticDriverConfigLoaderBuilder apply(ProgrammaticDriverConfigLoaderBuilder x0$1, Tuple2<DefaultDriverOption, Option<String>> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                        if (tuple2 != null) {
                            ProgrammaticDriverConfigLoaderBuilder b = (ProgrammaticDriverConfigLoaderBuilder)tuple2._1();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                DefaultDriverOption name = (DefaultDriverOption)tuple22._1();
                                Option value2 = (Option)tuple22._2();
                                ProgrammaticDriverConfigLoaderBuilder programmaticDriverConfigLoaderBuilder = (ProgrammaticDriverConfigLoaderBuilder)value2.map((Function1)new Serializable(this, b, name){
                                    public static final long serialVersionUID = 0L;
                                    private final ProgrammaticDriverConfigLoaderBuilder b$3;
                                    private final DefaultDriverOption name$1;

                                    public final ProgrammaticDriverConfigLoaderBuilder apply(String x$3) {
                                        return (ProgrammaticDriverConfigLoaderBuilder)this.b$3.withString((DriverOption)this.name$1, x$3);
                                    }
                                    {
                                        this.b$3 = b$3;
                                        this.name$1 = name$1;
                                    }
                                }).getOrElse((Function0)new Serializable(this, b){
                                    public static final long serialVersionUID = 0L;
                                    private final ProgrammaticDriverConfigLoaderBuilder b$3;

                                    public final ProgrammaticDriverConfigLoaderBuilder apply() {
                                        return this.b$3;
                                    }
                                    {
                                        this.b$3 = b$3;
                                    }
                                });
                                return programmaticDriverConfigLoaderBuilder;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                })).withClass((DriverOption)DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS, DefaultSslEngineFactory.class).withStringList((DriverOption)DefaultDriverOption.SSL_CIPHER_SUITES, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.ipConf$1.cassandraSSLConf().enabledAlgorithms().toList()).asJava()).withBoolean((DriverOption)DefaultDriverOption.SSL_HOSTNAME_VALIDATION, false) : builder;
            }

            private final Option clientAuthEnabled$1(Option value2) {
                return this.ipConf$1.cassandraSSLConf().clientAuthEnabled() ? value2 : None$.MODULE$;
            }
            {
                this.ipConf$1 = ipConf$1;
            }
        };
    }

    private DefaultConnectionFactory$() {
        MODULE$ = this;
        CassandraConnectionFactory$class.$init$(this);
    }
}

