/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.spark.connector.CassandraRowMetadata;
import com.datastax.spark.connector.CassandraRowMetadata$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.CassandraLimit;
import com.datastax.spark.connector.rdd.CassandraMergeJoinRDD$;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.rdd.ClusteringOrder;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartition;
import com.datastax.spark.connector.rdd.partitioner.CqlTokenRange;
import com.datastax.spark.connector.rdd.partitioner.NodeAddresses;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator$;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.ColumnType$;
import com.datastax.spark.connector.types.TypeConverter;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.MergeJoinIterator;
import com.datastax.spark.connector.util.NameTools$;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.util.package$;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.metrics.InputMetricsUpdater;
import org.apache.spark.metrics.InputMetricsUpdater$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u0001\u0003\u00015\u0011QcQ1tg\u0006tGM]1NKJ<WMS8j]J#EI\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001a3\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001+\rqQ\u0006O\n\u0003\u0001=\u00012\u0001E\f\u001a\u001b\u0005\t\"BA\u0002\u0013\u0015\t91C\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<\u0017B\u0001\r\u0012\u0005\r\u0011F\t\u0012\t\u00055uyb'D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019!V\u000f\u001d7feA\u0019\u0001\u0005K\u0016\u000f\u0005\u00052cB\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\r\u0003\u0019a$o\\8u}%\tA$\u0003\u0002(7\u00059\u0001/Y2lC\u001e,\u0017BA\u0015+\u0005\r\u0019V-\u001d\u0006\u0003Om\u0001\"\u0001L\u0017\r\u0001\u0011)a\u0006\u0001b\u0001_\t\tA*\u0005\u00021gA\u0011!$M\u0005\u0003em\u0011qAT8uQ&tw\r\u0005\u0002\u001bi%\u0011Qg\u0007\u0002\u0004\u0003:L\bc\u0001\u0011)oA\u0011A\u0006\u000f\u0003\u0006s\u0001\u0011\ra\f\u0002\u0002%\"A1\b\u0001B\u0001B\u0003%A(\u0001\u0002tGB\u0011QHP\u0007\u0002%%\u0011qH\u0005\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006YA.\u001a4u'\u000e\fgN\u0015#E!\r\u0019EiK\u0007\u0002\u0005%\u0011QI\u0001\u0002\u0016\u0007\u0006\u001c8/\u00198ee\u0006$\u0016M\u00197f'\u000e\fgN\u0015#E\u0011!9\u0005A!A!\u0002\u0013A\u0015\u0001\u0004:jO\"$8kY1o%\u0012#\u0005cA\"Eo!A!\n\u0001B\u0001B\u0003-1*\u0001\u0007mK\u001a$8\t\\1tgR\u000bw\rE\u0002M\u001f.j\u0011!\u0014\u0006\u0003\u001dn\tqA]3gY\u0016\u001cG/\u0003\u0002Q\u001b\nA1\t\\1tgR\u000bw\r\u0003\u0005S\u0001\t\u0005\t\u0015a\u0003T\u00035\u0011\u0018n\u001a5u\u00072\f7o\u001d+bOB\u0019AjT\u001c\t\u000bU\u0003A\u0011\u0001,\u0002\rqJg.\u001b;?)\u001196\fX/\u0015\u0007aK&\f\u0005\u0003D\u0001-:\u0004\"\u0002&U\u0001\bY\u0005\"\u0002*U\u0001\b\u0019\u0006\"B\u001eU\u0001\u0004a\u0004\"B!U\u0001\u0004\u0011\u0005\"B$U\u0001\u0004A\u0005bB\u0003\u0001\u0005\u0004%\taX\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111\rB\u0001\u0004GFd\u0017BA3c\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\t\r\u001d\u0004\u0001\u0015!\u0003a\u0003)\u0019wN\u001c8fGR|'\u000f\t\u0005\u0006S\u0002!\tA[\u0001\u0010O\u0016$\b+\u0019:uSRLwN\\&fsR!1n\u001c9z!\r\u0001\u0003\u0006\u001c\t\u0003C6L!A\u001c2\u0003\u0013\r{G.^7o\t\u00164\u0007\"B\u0003i\u0001\u0004\u0001\u0007\"B9i\u0001\u0004\u0011\u0018\u0001D6fsN\u0004\u0018mY3OC6,\u0007CA:w\u001d\tQB/\u0003\u0002v7\u00051\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)8\u0004C\u0003{Q\u0002\u0007!/A\u0005uC\ndWMT1nK\")A\u0010\u0001C\u0001{\u0006\u00192\r[3dWZ\u000bG.\u001b3NKJ<WMS8j]R\ta\u0010\u0005\u0002\u001b\u007f&\u0019\u0011\u0011A\u000e\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u000b\u0001!\u0019!C\u0001\u0003\u000f\t1\u0002V8lK:\u001cu\u000e\\;n]V\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0011\u0001\u00026bm\u0006L1a^A\u0007\u0011!\tI\u0002\u0001Q\u0001\n\u0005%\u0011\u0001\u0004+pW\u0016t7i\u001c7v[:\u0004\u0003bBA\u000f\u0001\u0011\u0005\u0011qD\u0001\u000fi>\\WM\\#yiJ\f7\r^8s)\u0011\t\t#!\u0011\u0011\t\u0005\r\u0012QH\u0007\u0003\u0003KQA!a\n\u0002*\u0005)Ao\\6f]*!\u00111FA\u0017\u0003!iW\r^1eCR\f'\u0002BA\u0018\u0003c\tAaY8sK*!\u00111GA\u001b\u0003\r\t\u0007/\u001b\u0006\u0005\u0003o\tI$\u0001\u0004ee&4XM\u001d\u0006\u0004\u0003wA\u0011aA8tg&!\u0011qHA\u0013\u0005\u0015!vn[3o\u0011!\t\u0019%a\u0007A\u0002\u0005\u0015\u0013a\u0001:poB!\u0011qIA&\u001b\t\tIEC\u0002d\u0003[IA!!\u0014\u0002J\t\u0019!k\\<\t\u0015\u0005E\u0003\u0001#b\u0001\n\u0013\t\u0019&A\nmK\u001a$\b+\u0019:uSRLwN\\&fsN#(/F\u0001s\u0011%\t9\u0006\u0001E\u0001B\u0003&!/\u0001\u000bmK\u001a$\b+\u0019:uSRLwN\\&fsN#(\u000f\t\u0005\b\u00037\u0002A\u0011BA/\u0003Q!xn[3o%\u0006tw-\u001a+p\u0007Fd\u0017+^3ssV!\u0011qLA7)\u0019\t\t'!\u001a\u0002rA)!$\b:\u0002dA\u0019\u0001\u0005K\u001a\t\u0011\u0005\u001d\u0014\u0011\fa\u0001\u0003S\nqA\u001a:p[J#E\t\u0005\u0003D\t\u0006-\u0004c\u0001\u0017\u0002n\u00119\u0011qNA-\u0005\u0004y#!\u0001+\t\u0011\u0005M\u0014\u0011\fa\u0001\u0003k\nQA]1oO\u0016\u0004d!a\u001e\u0002\u0006\u0006-\u0005\u0003CA=\u0003\u007f\n\u0019)!#\u000e\u0005\u0005m$bAA?\u0005\u0005Y\u0001/\u0019:uSRLwN\\3s\u0013\u0011\t\t)a\u001f\u0003\u001b\r\u000bH\u000eV8lK:\u0014\u0016M\\4f!\ra\u0013Q\u0011\u0003\f\u0003\u000f\u000b\t(!A\u0001\u0002\u000b\u0005qFA\u0002`IE\u00022\u0001LAF\t-\ti)!\u001d\u0002\u0002\u0003\u0005)\u0011A\u0018\u0003\u0007}##\u0007C\u0004\u0002\u0012\u0002!I!a%\u0002\u001f\r\u0014X-\u0019;f'R\fG/Z7f]R$\"\"!&\u0002\u001c\u0006\u001d\u0016\u0011WAZ!\u0011\t9%a&\n\t\u0005e\u0015\u0011\n\u0002\u000f\u0005>,h\u000eZ*uCR,W.\u001a8u\u0011!\ti*a$A\u0002\u0005}\u0015aB:fgNLwN\u001c\t\u0005\u0003C\u000b\u0019+\u0004\u0002\u0002.%!\u0011QUA\u0017\u0005)\u0019\u0015\u000f\\*fgNLwN\u001c\u0005\t\u0003S\u000by\t1\u0001\u0002,\u0006A!/Z1e\u0007>tg\rE\u0002D\u0003[K1!a,\u0003\u0005!\u0011V-\u00193D_:4\u0007BB2\u0002\u0010\u0002\u0007!\u000f\u0003\u0005\u00026\u0006=\u0005\u0019AA\\\u0003\u00191\u0018\r\\;fgB!!$!/4\u0013\r\tYl\u0007\u0002\u000byI,\u0007/Z1uK\u0012t\u0004bBA`\u0001\u0011%\u0011\u0011Y\u0001\u0013G>tg/\u001a:u%><\u0018\n^3sCR|'/\u0006\u0003\u0002D\u00065G\u0003CAc\u0003\u001f\f).!:\u0011\u000b\u0001\n9-a3\n\u0007\u0005%'F\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\ra\u0013Q\u001a\u0003\b\u0003_\niL1\u00010\u0011!\t\t.!0A\u0002\u0005M\u0017\u0001C5uKJ\fGo\u001c:\u0011\u000b\u0001\n9-!\u0012\t\u0011\u0005]\u0017Q\u0018a\u0001\u00033\f\u0011B]8x%\u0016\fG-\u001a:\u0011\r\u0005m\u0017\u0011]Af\u001b\t\tiNC\u0002\u0002`\n\taA]3bI\u0016\u0014\u0018\u0002BAr\u0003;\u0014\u0011BU8x%\u0016\fG-\u001a:\t\u0011\u0005\u001d\u0018Q\u0018a\u0001\u0003S\fabY8mk6tW*\u001a;b\t\u0006$\u0018\r\u0005\u0003\u0002l\u00065X\"\u0001\u0003\n\u0007\u0005=HA\u0001\u000bDCN\u001c\u0018M\u001c3sCJ{w/T3uC\u0012\fG/\u0019\u0005\b\u0003g\u0004A\u0011BA{\u0003=1W\r^2i)>\\WM\u001c*b]\u001e,W\u0003BA|\u0005\u0007!\"\"!?\u0002|\u0006u(Q\u0001B\f!\u0019QR$!;\u0002T\"A\u0011QTAy\u0001\u0004\ty\n\u0003\u0005\u0002h\u0005E\b\u0019AA\u0000!\u0011\u0019EI!\u0001\u0011\u00071\u0012\u0019\u0001B\u0004\u0002p\u0005E(\u0019A\u0018\t\u0011\u0005M\u0014\u0011\u001fa\u0001\u0005\u000f\u0001dA!\u0003\u0003\u000e\tM\u0001\u0003CA=\u0003\u007f\u0012YA!\u0005\u0011\u00071\u0012i\u0001B\u0006\u0003\u0010\t\u0015\u0011\u0011!A\u0001\u0006\u0003y#aA0%gA\u0019AFa\u0005\u0005\u0017\tU!QAA\u0001\u0002\u0003\u0015\ta\f\u0002\u0004?\u0012\"\u0004\u0002\u0003B\r\u0003c\u0004\rAa\u0007\u0002'%t\u0007/\u001e;NKR\u0014\u0018nY:Va\u0012\fG/\u001a:\u0011\t\tu!1E\u0007\u0003\u0005?Q1A!\t\u0013\u0003\u001diW\r\u001e:jGNLAA!\n\u0003 \t\u0019\u0012J\u001c9vi6+GO]5dgV\u0003H-\u0019;fe\"9!\u0011\u0006\u0001\u0005B\t-\u0012aB2p[B,H/\u001a\u000b\u0007\u0005[\u0011yC!\u000f\u0011\t\u0001\n9-\u0007\u0005\t\u0005c\u00119\u00031\u0001\u00034\u0005)1\u000f\u001d7jiB\u0019QH!\u000e\n\u0007\t]\"CA\u0005QCJ$\u0018\u000e^5p]\"A!1\bB\u0014\u0001\u0004\u0011i$A\u0004d_:$X\r\u001f;\u0011\u0007u\u0012y$C\u0002\u0003BI\u00111\u0002V1tW\u000e{g\u000e^3yi\"\"!q\u0005B#!\u0011\u00119E!\u0014\u000e\u0005\t%#b\u0001B&%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=#\u0011\n\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0005\b\u0005'\u0002A\u0011\u000bB+\u000359W\r\u001e)beRLG/[8ogV\u0011!q\u000b\t\u00065\te#1G\u0005\u0004\u00057Z\"!B!se\u0006L\bB\u0003B0\u0001!\u0015\r\u0011\"\u0003\u0003b\u0005ian\u001c3f\u0003\u0012$'/Z:tKN,\"Aa\u0019\u0011\t\u0005e$QM\u0005\u0005\u0005O\nYHA\u0007O_\u0012,\u0017\t\u001a3sKN\u001cXm\u001d\u0005\u000b\u0005W\u0002\u0001\u0012!Q!\n\t\r\u0014A\u00048pI\u0016\fE\r\u001a:fgN,7\u000f\t\u0005\b\u0005_\u0002A\u0011\tB9\u0003U9W\r\u001e)sK\u001a,'O]3e\u0019>\u001c\u0017\r^5p]N$BAa\u001d\u0003vA\u0019\u0001\u0005\u000b:\t\u0011\tE\"Q\u000ea\u0001\u0005g\u0001")
public class CassandraMergeJoinRDD<L, R>
extends RDD<Tuple2<Seq<L>, Seq<R>>> {
    public final CassandraTableScanRDD<L> com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD;
    public final CassandraTableScanRDD<R> com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD;
    private final CassandraConnector connector;
    private final String TokenColumn;
    private String leftPartitionKeyStr;
    private NodeAddresses com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses;
    private volatile byte bitmap$0;

    private String leftPartitionKeyStr$lzycompute() {
        CassandraMergeJoinRDD cassandraMergeJoinRDD = this;
        synchronized (cassandraMergeJoinRDD) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.leftPartitionKeyStr = ((TraversableOnce)((TraversableLike)this.getPartitionKey(this.connector(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.keyspaceName(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.tableName()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ColumnDef x$4) {
                        return x$4.columnName();
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String name) {
                        return Quote$.MODULE$.quote(name);
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.leftPartitionKeyStr;
        }
    }

    private NodeAddresses com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses$lzycompute() {
        CassandraMergeJoinRDD cassandraMergeJoinRDD = this;
        synchronized (cassandraMergeJoinRDD) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses = new NodeAddresses(this.connector());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses;
        }
    }

    public CassandraConnector connector() {
        return this.connector;
    }

    public Seq<ColumnDef> getPartitionKey(CassandraConnector connector, String keyspaceName, String tableName) {
        Option option = package$.MODULE$.schemaFromCassandra(connector, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName)).tables().headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            TableDef table = (TableDef)some.x();
            Seq seq = table.partitionKey();
            return seq;
        }
        if (None$.MODULE$.equals(option)) {
            Metadata metadata = (Metadata)connector.withSessionDo(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Metadata apply(CqlSession x$1) {
                    return x$1.getMetadata();
                }
            });
            Option suggestions = NameTools$.MODULE$.getSuggestions(metadata, keyspaceName, tableName);
            String errorMessage = NameTools$.MODULE$.getErrorString(keyspaceName, tableName, suggestions);
            throw new IOException(errorMessage);
        }
        throw new MatchError((Object)option);
    }

    public void checkValidMergeJoin() {
        Seq leftPartitionKeyTypes = (Seq)this.getPartitionKey(this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.connector(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.keyspaceName(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.tableName()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnType<?> apply(ColumnDef x$2) {
                return x$2.columnType();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq rightPartitionKeyTypes = (Seq)this.getPartitionKey(this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.connector(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.keyspaceName(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.tableName()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnType<?> apply(ColumnDef x$3) {
                return x$3.columnType();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq seq = leftPartitionKeyTypes;
        Seq seq2 = rightPartitionKeyTypes;
        Predef$.MODULE$.assert(!(seq != null ? !seq.equals(seq2) : seq2 != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition key types do not match between Right and Left RDDs in MergeJoin";
            }
        });
    }

    public String TokenColumn() {
        return this.TokenColumn;
    }

    public com.datastax.oss.driver.api.core.metadata.token.Token tokenExtractor(Row row) {
        return row.getToken(this.TokenColumn());
    }

    private String leftPartitionKeyStr() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.leftPartitionKeyStr$lzycompute() : this.leftPartitionKeyStr;
    }

    private <T> Tuple2<String, Seq<Object>> tokenRangeToCqlQuery(CassandraTableScanRDD<T> fromRDD, CqlTokenRange<?, ?> range) {
        String columns = ((TraversableOnce)fromRDD.selectedColumnRefs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$5) {
                return x$5.cql();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
        String pk = ((TraversableOnce)fromRDD.tableDef().partitionKey().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef colDef) {
                return Quote$.MODULE$.quote(colDef.columnName());
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        Tuple2<String, Seq<Object>> tuple2 = range.cql(this.leftPartitionKeyStr());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String cql = (String)tuple2._1();
            Seq values = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)cql, (Object)values);
            String cql2 = (String)tuple23._1();
            Seq values2 = (Seq)tuple23._2();
            String string = cql2;
            String filter = ((TraversableOnce)((TraversableLike)fromRDD.where().predicates().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$8) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
                }
            })).mkString(" AND ");
            String limitClause = (String)fromRDD.limit().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(CassandraLimit limit) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIMIT ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{limit}));
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            String orderBy = (String)fromRDD.clusteringOrder().map((Function1)new Serializable(this, fromRDD){
                public static final long serialVersionUID = 0L;
                private final CassandraTableScanRDD fromRDD$1;

                public final String apply(ClusteringOrder x$9) {
                    return x$9.toCql(this.fromRDD$1.tableDef());
                }
                {
                    this.fromRDD$1 = fromRDD$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            String quotedKeyspaceName = Quote$.MODULE$.quote(fromRDD.keyspaceName());
            String quotedTableName = Quote$.MODULE$.quote(fromRDD.tableName());
            String queryTemplate = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT ", ", TOKEN(", ") as ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columns, pk, this.TokenColumn()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FROM ", ".", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedKeyspaceName, quotedTableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHERE ", " ", " ", " ALLOW FILTERING"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter, orderBy, limitClause}))).toString();
            Seq queryParamValues = (Seq)values2.$plus$plus(fromRDD.where().values(), Seq$.MODULE$.canBuildFrom());
            return new Tuple2((Object)queryTemplate, (Object)queryParamValues);
        }
        throw new MatchError(tuple2);
    }

    private BoundStatement createStatement(CqlSession session, ReadConf readConf, String cql, Seq<Object> values) {
        try {
            PreparedStatement stmt = session.prepare(cql);
            TypeConverter[] converters = (TypeConverter[])((TraversableOnce)JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)stmt.getVariableDefinitions()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TypeConverter<?> apply(ColumnDefinition v) {
                    return ColumnType$.MODULE$.converterToCassandra(v.getType());
                }
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeConverter.class));
            Seq convertedValues = (Seq)((TraversableLike)values.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])converters), Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, TypeConverter<?>> check$ifrefutable$1) {
                    Tuple2<Object, TypeConverter<?>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Tuple2<Object, TypeConverter<?>> x$10) {
                    Tuple2<Object, TypeConverter<?>> tuple2 = x$10;
                    if (tuple2 != null) {
                        Object value2 = tuple2._1();
                        TypeConverter converter = (TypeConverter)tuple2._2();
                        Object object = converter.convert(value2);
                        return object;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            return (BoundStatement)stmt.bind((Object[])convertedValues.toArray(ClassTag$.MODULE$.AnyRef())).setIdempotent(Predef$.MODULE$.boolean2Boolean(true)).setPageSize(readConf.fetchSizeInRows()).setConsistencyLevel(readConf.consistencyLevel());
        }
        catch (Throwable throwable) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception during preparation of ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cql, throwable.getMessage()})), throwable);
        }
    }

    public <T> Iterator<T> com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$convertRowIterator(Iterator<Row> iterator, RowReader<T> rowReader2, CassandraRowMetadata columnMetaData) {
        return iterator.map((Function1)new Serializable(this, rowReader2, columnMetaData){
            public static final long serialVersionUID = 0L;
            private final RowReader rowReader$1;
            private final CassandraRowMetadata columnMetaData$1;

            public final T apply(Row row) {
                return this.rowReader$1.read(row, this.columnMetaData$1);
            }
            {
                void var3_3;
                this.rowReader$1 = rowReader$1;
                this.columnMetaData$1 = var3_3;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Tuple2<CassandraRowMetadata, Iterator<Row>> com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$fetchTokenRange(CqlSession session, CassandraTableScanRDD<T> fromRDD, CqlTokenRange<?, ?> range, InputMetricsUpdater inputMetricsUpdater) {
        Tuple2 tuple22;
        Tuple2<String, Seq<Object>> tuple2 = this.tokenRangeToCqlQuery(fromRDD, range);
        if (tuple2 == null) throw new MatchError(tuple2);
        String cql2 = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)cql2, (Object)values);
        String cql = (String)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        this.logDebug((Function0)new Serializable(this, range, cql, values2){
            public static final long serialVersionUID = 0L;
            private final CqlTokenRange range$1;
            private final String cql$1;
            private final Seq values$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching data for range ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cql$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with params ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.values$1.mkString("[", ",", "]")}))).toString();
            }
            {
                void var4_4;
                void var3_3;
                this.range$1 = range$1;
                this.cql$1 = var3_3;
                this.values$1 = var4_4;
            }
        });
        BoundStatement stmt = this.createStatement(session, fromRDD.readConf(), cql, (Seq<Object>)values2);
        try {
            ResultSet rs = session.execute((Statement)stmt);
            scala.collection.immutable.IndexedSeq columnNames = (scala.collection.immutable.IndexedSeq)((TraversableOnce)fromRDD.selectedColumnRefs().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ColumnRef x$12) {
                    return x$12.selectedAs();
                }
            }, Seq$.MODULE$.canBuildFrom())).toIndexedSeq().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.TokenColumn()})), IndexedSeq$.MODULE$.canBuildFrom());
            CassandraRowMetadata columnMetaData = CassandraRowMetadata$.MODULE$.fromResultSet((IndexedSeq)columnNames, rs, session);
            PrefetchingResultSetIterator iterator = new PrefetchingResultSetIterator(rs, fromRDD.readConf().fetchSizeInRows(), PrefetchingResultSetIterator$.MODULE$.$lessinit$greater$default$3());
            Iterator iteratorWithMetrics = iterator.map(new Serializable(this, inputMetricsUpdater){
                public static final long serialVersionUID = 0L;
                private final InputMetricsUpdater inputMetricsUpdater$1;

                public final Row apply(Row row) {
                    return this.inputMetricsUpdater$1.updateMetrics(row);
                }
                {
                    this.inputMetricsUpdater$1 = inputMetricsUpdater$1;
                }
            });
            this.logDebug((Function0)new Serializable(this, range){
                public static final long serialVersionUID = 0L;
                private final CqlTokenRange range$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Row iterator for range ", " obtained successfully."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1}));
                }
                {
                    this.range$1 = range$1;
                }
            });
            return new Tuple2((Object)columnMetaData, iteratorWithMetrics);
        }
        catch (Throwable throwable) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception during execution of ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cql, throwable.getMessage()})), throwable);
        }
    }

    @DeveloperApi
    public Iterator<Tuple2<Seq<L>, Seq<R>>> compute(Partition split2, TaskContext context) {
        Tuple2 tuple2 = this.openSessions$1();
        if (tuple2 != null) {
            Tuple2 tuple22;
            CqlSession leftSession = (CqlSession)tuple2._1();
            CqlSession rightSession = (CqlSession)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftSession, (Object)rightSession);
            CqlSession leftSession2 = (CqlSession)tuple23._1();
            CqlSession rightSession2 = (CqlSession)tuple23._2();
            CassandraPartition partition = (CassandraPartition)split2;
            Iterable tokenRanges2 = partition.tokenRanges();
            boolean x$16 = this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.readConf().taskMetricsEnabled() || this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.readConf().taskMetricsEnabled();
            Option<Object> x$17 = ReadConf$.MODULE$.$lessinit$greater$default$1();
            int x$18 = ReadConf$.MODULE$.$lessinit$greater$default$2();
            int x$19 = ReadConf$.MODULE$.$lessinit$greater$default$3();
            ConsistencyLevel x$20 = ReadConf$.MODULE$.$lessinit$greater$default$4();
            Option<Object> x$21 = ReadConf$.MODULE$.$lessinit$greater$default$6();
            Option<Object> x$22 = ReadConf$.MODULE$.$lessinit$greater$default$7();
            int x$23 = ReadConf$.MODULE$.$lessinit$greater$default$8();
            Option<String> x$24 = ReadConf$.MODULE$.$lessinit$greater$default$9();
            ReadConf metricsReadConf = new ReadConf(x$17, x$18, x$19, x$20, x$16, x$21, x$22, x$23, x$24);
            InputMetricsUpdater metricsUpdater = InputMetricsUpdater$.MODULE$.apply(context, metricsReadConf, InputMetricsUpdater$.MODULE$.apply$default$3());
            Iterator mergingIterator = tokenRanges2.iterator().flatMap((Function1)new Serializable(this, leftSession2, rightSession2, metricsUpdater){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraMergeJoinRDD $outer;
                private final CqlSession leftSession$1;
                private final CqlSession rightSession$1;
                private final InputMetricsUpdater metricsUpdater$1;

                public final Iterator<Tuple3<com.datastax.oss.driver.api.core.metadata.token.Token, List<L>, List<R>>> apply(CqlTokenRange<Object, Token> tokenRange) {
                    Tuple2<CassandraRowMetadata, Iterator<Row>> tuple2 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$fetchTokenRange(this.leftSession$1, this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD, tokenRange, this.metricsUpdater$1);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        CassandraRowMetadata leftMetadata = (CassandraRowMetadata)tuple2._1();
                        Iterator leftRowIterator = (Iterator)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftMetadata, (Object)leftRowIterator);
                        CassandraRowMetadata leftMetadata2 = (CassandraRowMetadata)tuple23._1();
                        Iterator leftRowIterator2 = (Iterator)tuple23._2();
                        Tuple2<CassandraRowMetadata, Iterator<Row>> tuple24 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$fetchTokenRange(this.rightSession$1, this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD, tokenRange, this.metricsUpdater$1);
                        if (tuple24 != null) {
                            Tuple2 tuple25;
                            CassandraRowMetadata rightMetadata = (CassandraRowMetadata)tuple24._1();
                            Iterator rightRowIterator = (Iterator)tuple24._2();
                            Tuple2 tuple26 = tuple25 = new Tuple2((Object)rightMetadata, (Object)rightRowIterator);
                            CassandraRowMetadata rightMetadata2 = (CassandraRowMetadata)tuple26._1();
                            Iterator rightRowIterator2 = (Iterator)tuple26._2();
                            MergeJoinIterator<L, R, K> rowMerger = new MergeJoinIterator<L, R, K>(leftRowIterator2, rightRowIterator2, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$16 $outer;

                                public final com.datastax.oss.driver.api.core.metadata.token.Token apply(Row row) {
                                    return this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().tokenExtractor(row);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$16 $outer;

                                public final com.datastax.oss.driver.api.core.metadata.token.Token apply(Row row) {
                                    return this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().tokenExtractor(row);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                            return rowMerger.map(new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$16 $outer;
                                private final CassandraRowMetadata leftMetadata$1;
                                private final CassandraRowMetadata rightMetadata$1;

                                public final Tuple3<com.datastax.oss.driver.api.core.metadata.token.Token, List<L>, List<R>> apply(Tuple3<com.datastax.oss.driver.api.core.metadata.token.Token, Seq<Row>, Seq<Row>> x0$1) {
                                    Tuple3<com.datastax.oss.driver.api.core.metadata.token.Token, Seq<Row>, Seq<Row>> tuple3 = x0$1;
                                    if (tuple3 != null) {
                                        com.datastax.oss.driver.api.core.metadata.token.Token t = (com.datastax.oss.driver.api.core.metadata.token.Token)tuple3._1();
                                        Seq lRows = (Seq)tuple3._2();
                                        Seq rRows = (Seq)tuple3._3();
                                        if (t != null) {
                                            com.datastax.oss.driver.api.core.metadata.token.Token token = t;
                                            if (lRows != null) {
                                                Seq seq = lRows;
                                                if (rRows != null) {
                                                    Seq seq2 = rRows;
                                                    Tuple3 tuple32 = new Tuple3((Object)token, (Object)this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$convertRowIterator((Iterator<Row>)seq.iterator(), this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.rowReader(), this.leftMetadata$1).toList(), (Object)this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$convertRowIterator((Iterator<Row>)seq2.iterator(), this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.rowReader(), this.rightMetadata$1).toList());
                                                    return tuple32;
                                                }
                                            }
                                        }
                                    }
                                    throw new MatchError(tuple3);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.leftMetadata$1 = leftMetadata$1;
                                    this.rightMetadata$1 = rightMetadata$1;
                                }
                            });
                        }
                        throw new MatchError(tuple24);
                    }
                    throw new MatchError(tuple2);
                }

                public /* synthetic */ CassandraMergeJoinRDD com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    void var4_4;
                    void var3_3;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.leftSession$1 = leftSession$1;
                    this.rightSession$1 = var3_3;
                    this.metricsUpdater$1 = var4_4;
                }
            });
            CountingIterator countingIterator = new CountingIterator(mergingIterator, CountingIterator$.MODULE$.$lessinit$greater$default$2());
            context.addTaskCompletionListener((Function1)new Serializable(this, leftSession2, rightSession2, partition, metricsUpdater, countingIterator){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraMergeJoinRDD $outer;
                private final CqlSession leftSession$1;
                private final CqlSession rightSession$1;
                public final CassandraPartition partition$1;
                private final InputMetricsUpdater metricsUpdater$1;
                public final CountingIterator countingIterator$1;

                public final TaskContext apply(TaskContext context) {
                    double duration = (double)this.metricsUpdater$1.finish() / 1.0E9;
                    this.$outer.logDebug((Function0)new Serializable(this, duration){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$compute$1 $outer;
                        private final double duration$1;

                        public final String apply() {
                            Integer arg$macro$10 = BoxesRunTime.boxToInteger((int)this.$outer.countingIterator$1.count());
                            String arg$macro$11 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.keyspaceName();
                            String arg$macro$12 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.tableName();
                            String arg$macro$13 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.tableName();
                            Integer arg$macro$14 = BoxesRunTime.boxToInteger((int)this.$outer.partition$1.index());
                            double arg$macro$15 = this.duration$1;
                            return new StringOps(Predef$.MODULE$.augmentString(new StringOps("Fetched %s rows from\n            |%s %s and %s\n            |for partition %s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$10, arg$macro$11, arg$macro$12, arg$macro$13, arg$macro$14, BoxesRunTime.boxToDouble((double)arg$macro$15)})))).stripMargin();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.duration$1 = duration$1;
                        }
                    });
                    this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$closeSessions$1(this.leftSession$1, this.rightSession$1);
                    return context;
                }

                public /* synthetic */ CassandraMergeJoinRDD com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    void var6_6;
                    void var5_5;
                    void var4_4;
                    void var3_3;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.leftSession$1 = leftSession$1;
                    this.rightSession$1 = var3_3;
                    this.partition$1 = var4_4;
                    this.metricsUpdater$1 = var5_5;
                    this.countingIterator$1 = var6_6;
                }
            });
            Iterator iteratorWithoutToken = countingIterator.map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<List<L>, List<R>> apply(Tuple3<com.datastax.oss.driver.api.core.metadata.token.Token, List<L>, List<R>> tuple) {
                    return new Tuple2(tuple._2(), tuple._3());
                }
            });
            return iteratorWithoutToken;
        }
        throw new MatchError((Object)tuple2);
    }

    public Partition[] getPartitions() {
        this.checkValidMergeJoin();
        return this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.partitions().length >= this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.partitions().length ? this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.partitions() : this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.partitions();
    }

    public NodeAddresses com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses$lzycompute() : this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses;
    }

    public Seq<String> getPreferredLocations(Partition split2) {
        return ((TraversableOnce)((CassandraPartition)split2).endpoints().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMergeJoinRDD $outer;

            public final Set<String> apply(InetAddress nativeTransportAddress) {
                return this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses().hostNames(nativeTransportAddress);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private final Tuple2 openSessions$1() {
        Tuple2 tuple2;
        CassandraConnector cassandraConnector = this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.connector();
        CassandraConnector cassandraConnector2 = this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.connector();
        if (!(cassandraConnector != null ? !cassandraConnector.equals(cassandraConnector2) : cassandraConnector2 != null)) {
            CqlSession session = this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.connector().openSession();
            tuple2 = new Tuple2((Object)session, (Object)session);
        } else {
            tuple2 = new Tuple2((Object)this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.connector().openSession(), (Object)this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.connector().openSession());
        }
        return tuple2;
    }

    public final void com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$closeSessions$1(CqlSession leftSession, CqlSession rightSession) {
        CqlSession cqlSession = leftSession;
        CqlSession cqlSession2 = rightSession;
        if (cqlSession == null ? cqlSession2 != null : !cqlSession.equals(cqlSession2)) {
            rightSession.close();
        }
        leftSession.close();
    }

    public CassandraMergeJoinRDD(SparkContext sc, CassandraTableScanRDD<L> leftScanRDD, CassandraTableScanRDD<R> rightScanRDD, ClassTag<L> leftClassTag, ClassTag<R> rightClassTag) {
        this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD = leftScanRDD;
        this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD = rightScanRDD;
        super(sc, (Seq)Seq$.MODULE$.empty(), ClassTag$.MODULE$.apply(Tuple2.class));
        this.connector = leftScanRDD.connector();
        this.TokenColumn = "mj_tok_col";
    }
}

