/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartition;
import com.datastax.spark.connector.rdd.partitioner.TokenGenerator;
import com.datastax.spark.connector.util.DriverUtil$;
import com.datastax.spark.connector.util.package$;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0001\u0003\u0001=\u0011!CU3qY&\u001c\u0017\rU1si&$\u0018n\u001c8fe*\u00111\u0001B\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u0002\u0006\r\u0005\u0019!\u000f\u001a3\u000b\u0005\u001dA\u0011!C2p]:,7\r^8s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u0005AA-\u0019;bgR\f\u0007PC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001+\t\u0001ri\u0005\u0002\u0001#A\u0011!\u0003G\u0007\u0002')\u0011\u0011\u0002\u0006\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014x-\u0003\u0002\u001a'\tY\u0001+\u0019:uSRLwN\\3s\u0011!Y\u0002A!A!\u0002\u0013a\u0012!\u0002;bE2,\u0007CA\u000f$\u001d\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tz\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0011-,\u0017p\u001d9bG\u0016D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0018a\u0006\u0014H/\u001b;j_:\u001c\b+\u001a:SKBd\u0017nY1TKR\u0004\"AH\u0016\n\u00051z\"aA%oi\"Aa\u0006\u0001B\u0001B\u0003%q&\u0001\nqCJ$\u0018\u000e^5p].+\u00170T1qa\u0016\u0014\bC\u0001\u00192\u001b\u00051\u0011B\u0001\u001a\u0007\u00059\u0019u\u000e\\;n]N+G.Z2u_JD\u0001b\u0002\u0001\u0003\u0006\u0004%\t\u0001N\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001HB\u0001\u0004GFd\u0017B\u0001\u001e8\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\t\u0011q\u0002!\u0011!Q\u0001\nU\n!bY8o]\u0016\u001cGo\u001c:!\u0011!q\u0004A!A!\u0002\u0017y\u0014aC2veJ,g\u000e\u001e+za\u0016\u00042\u0001Q\"F\u001b\u0005\t%B\u0001\" \u0003\u001d\u0011XM\u001a7fGRL!\u0001R!\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"AR$\r\u0001\u0011)\u0001\n\u0001b\u0001\u0013\n\tA+\u0005\u0002K\u001bB\u0011adS\u0005\u0003\u0019~\u0011qAT8uQ&tw\r\u0005\u0002\u001f\u001d&\u0011qj\b\u0002\u0004\u0003:L\b\u0002C)\u0001\u0005\u000b\u0007I1\u0002*\u0002\u0007I<h-F\u0001T!\r!v+R\u0007\u0002+*\u0011aKB\u0001\u0007oJLG/\u001a:\n\u0005a+&\u0001\u0005*po^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011!Q\u0006A!A!\u0002\u0013\u0019\u0016\u0001\u0002:xM\u0002B#!\u0017/\u0011\u0005yi\u0016B\u00010 \u0005%!(/\u00198tS\u0016tG\u000fC\u0003a\u0001\u0011\u0005\u0011-\u0001\u0004=S:LGO\u0010\u000b\u0007E\u001eD\u0017N[6\u0015\u0007\r,g\rE\u0002e\u0001\u0015k\u0011A\u0001\u0005\u0006}}\u0003\u001da\u0010\u0005\u0006#~\u0003\u001da\u0015\u0005\u00067}\u0003\r\u0001\b\u0005\u0006O}\u0003\r\u0001\b\u0005\u0006S}\u0003\rA\u000b\u0005\u0006]}\u0003\ra\f\u0005\u0006\u000f}\u0003\r!\u000e\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0003%y6.Z=ta\u0006\u001cW-F\u0001p!\t\u0001\u00180D\u0001r\u0015\t\u00118/\u0001\u0003d_J,'B\u0001;v\u0003\r\t\u0007/\u001b\u0006\u0003m^\fa\u0001\u001a:jm\u0016\u0014(B\u0001=\u000b\u0003\ry7o]\u0005\u0003uF\u0014QbQ9m\u0013\u0012,g\u000e^5gS\u0016\u0014\bB\u0002?\u0001A\u0003%q.\u0001\u0006`W\u0016L8\u000f]1dK\u0002BqA \u0001C\u0002\u0013\u0005q0\u0001\u0005uC\ndW\rR3g+\t\t\t\u0001E\u00027\u0003\u0007I1!!\u00028\u0005!!\u0016M\u00197f\t\u00164\u0007\u0002CA\u0005\u0001\u0001\u0006I!!\u0001\u0002\u0013Q\f'\r\\3EK\u001a\u0004\u0003\"CA\u0007\u0001\t\u0007I\u0011AA\b\u0003%\u0011xn^,sSR,'/\u0006\u0002\u0002\u0012A!A+a\u0005F\u0013\r\t)\"\u0016\u0002\n%><xK]5uKJD\u0001\"!\u0007\u0001A\u0003%\u0011\u0011C\u0001\u000be><xK]5uKJ\u0004\u0003BCA\u000f\u0001!\u0015\r\u0011\"\u0003\u0002 \u0005qAo\\6f]\u001e+g.\u001a:bi>\u0014XCAA\u0011!\u0011!\u00171E#\n\u0007\u0005\u0015\"A\u0001\bU_.,gnR3oKJ\fGo\u001c:\t\u0015\u0005%\u0002\u0001#A!B\u0013\t\t#A\bu_.,gnR3oKJ\fGo\u001c:!Q\r\t9\u0003\u0018\u0005\u000b\u0003_\u0001\u0001R1A\u0005\n\u0005E\u0012\u0001\u0003;pW\u0016tW*\u00199\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005e\u0012/\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\ti$a\u000e\u0003\u0011Q{7.\u001a8NCBD!\"!\u0011\u0001\u0011\u0003\u0005\u000b\u0015BA\u001a\u0003%!xn[3o\u001b\u0006\u0004\b\u0005K\u0002\u0002@qC!\"a\u0012\u0001\u0011\u000b\u0007I\u0011BA%\u0003=\u0001(o\u001c;pG>dg+\u001a:tS>tWCAA&!\r\u0001\u0018QJ\u0005\u0004\u0003\u001f\n(a\u0004)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\t\u0015\u0005M\u0003\u0001#A!B\u0013\tY%\u0001\tqe>$xnY8m-\u0016\u00148/[8oA!\u001a\u0011\u0011\u000b/\t\u0015\u0005e\u0003\u0001#b\u0001\n\u0013\tY&A\u0003dY\u0006T(0\u0006\u0002\u0002^A\"\u0011qLA9!\u0019\t\t'a\u001b\u0002p5\u0011\u00111\r\u0006\u0005\u0003K\n9'\u0001\u0003mC:<'BAA5\u0003\u0011Q\u0017M^1\n\t\u00055\u00141\r\u0002\u0006\u00072\f7o\u001d\t\u0004\r\u0006EDaCA:\u0003k\n\t\u0011!A\u0003\u0002%\u00131a\u0018\u00132\u0011)\t9\b\u0001E\u0001B\u0003&\u0011QL\u0001\u0007G2\f'P\u001f\u0011)\u0007\u0005UD\fC\u0005\u0002~\u0001\u0011\r\u0011\"\u0003\u0002\u0000\u0005)\u0001n\\:ugV\u0011\u0011\u0011\u0011\t\u0007\u0003\u0007\u000bI)a$\u000f\u0007y\t))C\u0002\u0002\b~\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\f\u00065%A\u0002,fGR|'OC\u0002\u0002\b~\u0001B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9'A\u0002oKRLA!!'\u0002\u0014\nY\u0011J\\3u\u0003\u0012$'/Z:t\u0011!\ti\n\u0001Q\u0001\n\u0005\u0005\u0015A\u00025pgR\u001c\b\u0005C\u0005\u0002\"\u0002\u0011\r\u0011\"\u0003\u0002$\u00069\u0001n\\:u'\u0016$XCAAS!\u0019\t9+!-\u0002\u00106\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+A\u0005j[6,H/\u00192mK*\u0019\u0011qV\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00024\u0006%&aA*fi\"A\u0011q\u0017\u0001!\u0002\u0013\t)+\u0001\u0005i_N$8+\u001a;!\u0011%\tY\f\u0001b\u0001\n\u0013\ti,\u0001\u0005ok6Dun\u001d;t+\u0005Q\u0003bBAa\u0001\u0001\u0006IAK\u0001\n]Vl\u0007j\\:ug\u0002B\u0011\"!2\u0001\u0005\u0004%I!a2\u0002!A\f'\u000f^5uS>t\u0017J\u001c3fq\u0016\u001cXCAAe!\u0019\t\u0019)a3\u0002P&!\u0011QZAG\u0005\u0011a\u0015n\u001d;\u0011\u000b\u0005\u001d\u0016\u0011\u001b\u0016\n\t\u0005M\u0017\u0011\u0016\u0002\u000b\u0013:$W\r_3e'\u0016\f\b\u0002CAl\u0001\u0001\u0006I!!3\u0002#A\f'\u000f^5uS>t\u0017J\u001c3fq\u0016\u001c\b\u0005C\u0005\u0002\\\u0002\u0011\r\u0011\"\u0003\u0002^\u00069\u0001n\\:u\u001b\u0006\u0004XCAAp!!\t9+!9\u0002\u0010\u0006=\u0017\u0002BAr\u0003S\u00131!T1q\u0011!\t9\u000f\u0001Q\u0001\n\u0005}\u0017\u0001\u00035pgRl\u0015\r\u001d\u0011\t\u0013\u0005-\bA1A\u0005\n\u00055\u0018\u0001C5oI\u0016DX*\u00199\u0016\u0005\u0005=\bcBAT\u0003CT\u0013q\u0012\u0005\t\u0003g\u0004\u0001\u0015!\u0003\u0002p\u0006I\u0011N\u001c3fq6\u000b\u0007\u000f\t\u0005\b\u0003o\u0004A\u0011BA}\u0003%\t'm]'pIVdw\u000eF\u0003+\u0003w\fy\u0010C\u0004\u0002~\u0006U\b\u0019\u0001\u0016\u0002\u0011\u0011Lg/\u001b3f]\u0012DqA!\u0001\u0002v\u0002\u0007!&A\u0004eSZL7o\u001c:\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b\u0005Q!/\u00198e_6Dun\u001d;\u0015\t\u0005=%\u0011\u0002\u0005\b\u0005\u0017\u0011\u0019\u00011\u0001+\u0003\u0015Ig\u000eZ3y\u0011\u001d\u0011y\u0001\u0001C!\u0005#\tAbZ3u!\u0006\u0014H/\u001b;j_:$2A\u000bB\n\u0011\u001d\u0011)B!\u0004A\u00025\u000b1a[3z\u0011\u001d\u0011I\u0002\u0001C!\u0003{\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bb\u0002B\u000f\u0001\u0011\u0005!qD\u0001\u0015O\u0016$XI\u001c3q_&tG\u000fU1si&$\u0018n\u001c8\u0015\t\t\u0005\"q\u0005\t\u0004I\n\r\u0012b\u0001B\u0013\u0005\t\u0001\"+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c\u0005\t\u0005S\u0011Y\u00021\u0001\u0003,\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0004%\t5\u0012b\u0001B\u0018'\tI\u0001+\u0019:uSRLwN\u001c")
public class ReplicaPartitioner<T>
extends Partitioner {
    private final int partitionsPerReplicaSet;
    private final CassandraConnector connector;
    private final ClassTag<T> currentType;
    private final transient RowWriterFactory<T> rwf;
    private final CqlIdentifier _keyspace;
    private final TableDef tableDef;
    private final RowWriter<T> rowWriter;
    private transient TokenGenerator<T> tokenGenerator;
    private transient TokenMap tokenMap;
    private transient ProtocolVersion protocolVersion;
    private transient Class<?> clazz;
    private final Vector<InetAddress> hosts;
    private final scala.collection.immutable.Set<InetAddress> hostSet;
    private final int numHosts;
    private final List<IndexedSeq<Object>> partitionIndexes;
    private final Map<InetAddress, IndexedSeq<Object>> hostMap;
    private final Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    private volatile transient byte bitmap$trans$0;

    private TokenGenerator tokenGenerator$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.tokenGenerator = new TokenGenerator<T>(this.connector(), this.tableDef(), this.rowWriter());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.tokenGenerator;
        }
    }

    private TokenMap tokenMap$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.tokenMap = (TokenMap)this.connector().withSessionDo(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TokenMap apply(CqlSession x$1) {
                        return (TokenMap)x$1.getMetadata().getTokenMap().get();
                    }
                });
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.tokenMap;
        }
    }

    private ProtocolVersion protocolVersion$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.protocolVersion = (ProtocolVersion)this.connector().withSessionDo(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ProtocolVersion apply(CqlSession x$2) {
                        return x$2.getContext().getProtocolVersion();
                    }
                });
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.protocolVersion;
        }
    }

    private Class clazz$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.currentType)).runtimeClass();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.clazz;
        }
    }

    public CassandraConnector connector() {
        return this.connector;
    }

    private RowWriterFactory<T> rwf() {
        return this.rwf;
    }

    public CqlIdentifier _keyspace() {
        return this._keyspace;
    }

    public TableDef tableDef() {
        return this.tableDef;
    }

    public RowWriter<T> rowWriter() {
        return this.rowWriter;
    }

    private TokenGenerator<T> tokenGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tokenGenerator$lzycompute() : this.tokenGenerator;
    }

    private TokenMap tokenMap() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.tokenMap$lzycompute() : this.tokenMap;
    }

    private ProtocolVersion protocolVersion() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.protocolVersion$lzycompute() : this.protocolVersion;
    }

    private Class<?> clazz() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.clazz$lzycompute() : this.clazz;
    }

    private Vector<InetAddress> hosts() {
        return this.hosts;
    }

    private scala.collection.immutable.Set<InetAddress> hostSet() {
        return this.hostSet;
    }

    private int numHosts() {
        return this.numHosts;
    }

    private List<IndexedSeq<Object>> partitionIndexes() {
        return this.partitionIndexes;
    }

    private Map<InetAddress, IndexedSeq<Object>> hostMap() {
        return this.hostMap;
    }

    public Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap() {
        return this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    }

    private int absModulo(int dividend, int divisor) {
        return Math.abs(dividend % divisor);
    }

    private InetAddress randomHost(int index) {
        return (InetAddress)this.hosts().apply(this.absModulo(index, this.hosts().length()));
    }

    public int getPartition(Object key) {
        Object object = key;
        Option option = this.currentType.unapply(object);
        if (!option.isEmpty() && option.get() instanceof Object && this.clazz().isInstance(object)) {
            int n;
            Token token = this.tokenGenerator().getTokenFor(object);
            int tokenHash = Math.abs(token.hashCode());
            Set replicas = (Set)JavaConversions$.MODULE$.asScalaSet(this.tokenMap().getReplicas(this._keyspace(), token)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final InetAddress apply(Node n) {
                    return ((InetSocketAddress)DriverUtil$.MODULE$.toAddress(n).get()).getAddress();
                }
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom());
            Vector replicaSetInDC = ((TraversableOnce)this.hostSet().$amp((GenSet)replicas)).toVector();
            if (replicaSetInDC.nonEmpty()) {
                InetAddress endpoint = (InetAddress)replicaSetInDC.apply(this.absModulo(tokenHash, replicaSetInDC.size()));
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)endpoint)).apply(this.absModulo(tokenHash, this.partitionsPerReplicaSet)));
            } else {
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)this.randomHost(tokenHash))).apply(this.absModulo(tokenHash, this.partitionsPerReplicaSet)));
            }
            int n2 = n;
            return n2;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"ReplicaPartitioner can only determine the partition of a tuple whose key is a non-empty Set[InetAddress]. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).toString());
    }

    public int numPartitions() {
        return this.partitionsPerReplicaSet * this.numHosts();
    }

    public ReplicaPartition getEndpointPartition(Partition partition) {
        InetAddress endpoints = (InetAddress)this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)partition.index()), (Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaPartitioner $outer;
            private final Partition partition$1;

            public final Nothing$ apply() {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : Can't get an endpoint for Partition ", ".index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap(), this.partition$1})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        });
        return new ReplicaPartition(partition.index(), (scala.collection.immutable.Set<InetAddress>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{endpoints}))));
    }

    public ReplicaPartitioner(String table, String keyspace, int partitionsPerReplicaSet, ColumnSelector partitionKeyMapper, CassandraConnector connector, ClassTag<T> currentType, RowWriterFactory<T> rwf) {
        this.partitionsPerReplicaSet = partitionsPerReplicaSet;
        this.connector = connector;
        this.currentType = currentType;
        this.rwf = rwf;
        this._keyspace = CqlIdentifier.fromInternal((String)keyspace);
        this.tableDef = package$.MODULE$.tableFromCassandra(connector, keyspace, table);
        this.rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(rwf)).rowWriter(this.tableDef(), partitionKeyMapper.selectFrom(this.tableDef()));
        this.hosts = ((TraversableOnce)connector.hosts().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InetAddress apply(InetSocketAddress x$3) {
                return x$3.getAddress();
            }
        }, Set$.MODULE$.canBuildFrom())).toVector();
        this.hostSet = this.hosts().toSet();
        this.numHosts = this.hosts().size();
        this.partitionIndexes = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionsPerReplicaSet * this.numHosts()).grouped(partitionsPerReplicaSet).toList();
        this.hostMap = ((TraversableOnce)this.hosts().zip(this.partitionIndexes(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap = (Map)this.hostMap().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<InetAddress, IndexedSeq<Object>> check$ifrefutable$1) {
                Tuple2<InetAddress, IndexedSeq<Object>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Tuple2<Object, InetAddress>> apply(Tuple2<InetAddress, IndexedSeq<Object>> x$4) {
                Tuple2<InetAddress, IndexedSeq<Object>> tuple2 = x$4;
                if (tuple2 != null) {
                    InetAddress ip = (InetAddress)tuple2._1();
                    IndexedSeq partitions = (IndexedSeq)tuple2._2();
                    IndexedSeq indexedSeq = (IndexedSeq)partitions.map((Function1)new Serializable(this, ip){
                        public static final long serialVersionUID = 0L;
                        private final InetAddress ip$1;

                        public final Tuple2<Object, InetAddress> apply(int partition) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)this.ip$1);
                        }
                        {
                            this.ip$1 = ip$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return indexedSeq;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }
}

