/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates;
import com.datastax.spark.connector.rdd.partitioner.SplitSizeEstimator;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public abstract class SplitSizeEstimator$class {
    public static TokenFactory tokenFactory(CassandraRDD $this) {
        return TokenFactory$.MODULE$.forSystemLocalPartitioner($this.connector());
    }

    private static long estimateDataSize(CassandraRDD $this) {
        return new DataSizeEstimates<Object, Token>($this.connector(), $this.keyspaceName(), $this.tableName(), ((SplitSizeEstimator)((Object)$this)).tokenFactory()).dataSizeInBytes();
    }

    public static int minimalSplitCount(CassandraRDD $this) {
        int coreCount = $this.context().defaultParallelism();
        return 1 + coreCount * 2;
    }

    public static int estimateSplitCount(CassandraRDD $this, long splitSize) {
        int n;
        Predef$.MODULE$.require(splitSize > 0L, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Split size must be greater than zero.";
            }
        });
        if (SplitSizeEstimator$class.estimateDataSize((CassandraRDD)((Object)((SplitSizeEstimator)((Object)$this)))) == Long.MAX_VALUE || SplitSizeEstimator$class.estimateDataSize((CassandraRDD)((Object)((SplitSizeEstimator)((Object)$this)))) < 0L) {
            $this.logWarning((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraRDD $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Size Estimates has overflowed and calculated that the data size is Infinite.\n        |Falling back to ", " (2 * SparkCores + 1) Split Count.\n        |This is most likely occurring because you are reading size_estimates\n        |from a DataCenter which has very small primary ranges. Explicitly set\n        |the splitCount when reading to manually adjust this."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((SplitSizeEstimator)((Object)this.$outer)).minimalSplitCount())})))).stripMargin();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            n = ((SplitSizeEstimator)((Object)$this)).minimalSplitCount();
        } else {
            long splitCountEstimate = SplitSizeEstimator$class.estimateDataSize((CassandraRDD)((Object)((SplitSizeEstimator)((Object)$this)))) / splitSize;
            n = Math.max((int)splitCountEstimate, ((SplitSizeEstimator)((Object)$this)).minimalSplitCount());
        }
        return n;
    }

    public static void $init$(CassandraRDD $this) {
    }
}

