/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.NoNodeAvailableException;
import com.datastax.oss.driver.api.core.connection.BusyConnectionException;
import com.datastax.oss.driver.api.core.servererrors.OverloadedException;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.AsyncExecutor$;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.concurrent.TrieMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u00015\u0011Q\"Q:z]\u000e,\u00050Z2vi>\u0014(BA\u0002\u0005\u0003\u00199(/\u001b;fe*\u0011QAB\u0001\nG>tg.Z2u_JT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003-\t1aY8n\u0007\u0001)2A\u0004\u00126'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YIR\"A\f\u000b\u0005a!\u0011\u0001B;uS2L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001B\u0001B\u0003%Q$A\u0006bgft7-Q2uS>t\u0007\u0003\u0002\t\u001fA-J!aH\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u0011#\u0019\u0001!Qa\t\u0001C\u0002\u0011\u0012\u0011\u0001V\t\u0003K!\u0002\"\u0001\u0005\u0014\n\u0005\u001d\n\"a\u0002(pi\"Lgn\u001a\t\u0003!%J!AK\t\u0003\u0007\u0005s\u0017\u0010E\u0002-eQj\u0011!\f\u0006\u0003]=\n!bY8oGV\u0014(/\u001a8u\u0015\tA\u0002GC\u00012\u0003\u0011Q\u0017M^1\n\u0005Mj#aD\"p[BdW\r^5p]N#\u0018mZ3\u0011\u0005\u0005*D!\u0002\u001c\u0001\u0005\u0004!#!\u0001*\t\u0011a\u0002!\u0011!Q\u0001\ne\n!#\\1y\u0007>t7-\u001e:sK:$H+Y:lgB\u0011\u0001CO\u0005\u0003wE\u00111!\u00138u\u0011!i\u0004A!A!\u0002\u0013q\u0014AD:vG\u000e,7o\u001d%b]\u0012dWM\u001d\t\u0004!}\n\u0015B\u0001!\u0012\u0005\u0019y\u0005\u000f^5p]B\u0019!\t\u0014\u0011\u000f\u0005\r#U\"\u0001\u0002\b\u000b\u0015\u0013\u0001\u0012\u0001$\u0002\u001b\u0005\u001b\u0018P\\2Fq\u0016\u001cW\u000f^8s!\t\u0019uIB\u0003\u0002\u0005!\u0005\u0001j\u0005\u0002H\u001f!)!j\u0012C\u0001\u0017\u00061A(\u001b8jiz\"\u0012AR\u0003\u0005\u001b\u001e\u0003aJA\u0004IC:$G.\u001a:\u0016\u0005=\u001b\u0006C\u0002\tQ%R#v+\u0003\u0002R#\tIa)\u001e8di&|gn\r\t\u0003CM#Qa\t'C\u0002\u0011\u0002\"\u0001E+\n\u0005Y\u000b\"\u0001\u0002'p]\u001e\u0004\"\u0001\u0005-\n\u0005e\u000b\"\u0001B+oSRDqaW$\u0012\u0002\u0013\u0005A,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0004;.dW#\u00010+\u0005}\u0013gB\u0001\ta\u0013\t\t\u0017#\u0001\u0003O_:,7&A2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017!C;oG\",7m[3e\u0015\tA\u0017#\u0001\u0006b]:|G/\u0019;j_:L!A[3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003$5\n\u0007A\u0005B\u000375\n\u0007A\u0005\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003?\u000391\u0017-\u001b7ve\u0016D\u0015M\u001c3mKJDQA\u0013\u0001\u0005\u0002A$R!\u001d:tiV\u0004Ba\u0011\u0001!i!)Ad\u001ca\u0001;!)\u0001h\u001ca\u0001s!9Qh\u001cI\u0001\u0002\u0004q\u0004\"\u00028p\u0001\u0004q\u0004bB<\u0001\u0005\u0004%I\u0001_\u0001\ng\u0016l\u0017\r\u001d5pe\u0016,\u0012!\u001f\t\u0003YiL!a_\u0017\u0003\u0013M+W.\u00199i_J,\u0007BB?\u0001A\u0003%\u00110\u0001\u0006tK6\f\u0007\u000f[8sK\u0002B\u0001b \u0001C\u0002\u0013%\u0011\u0011A\u0001\u000fa\u0016tG-\u001b8h\rV$XO]3t+\t\t\u0019\u0001\u0005\u0005\u0002\u0006\u00055\u0011\u0011CA\u000e\u001b\t\t9AC\u0002/\u0003\u0013Q1!a\u0003\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\t9AA\u0004Ue&,W*\u00199\u0011\u000b\u0005M\u0011q\u0003\u001b\u000e\u0005\u0005U!B\u0001\u0018\u0012\u0013\u0011\tI\"!\u0006\u0003\r\u0019+H/\u001e:f!\r\u0001\u0012QD\u0005\u0004\u0003?\t\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0004\u0005y\u0001/\u001a8eS:<g)\u001e;ve\u0016\u001c\b\u0005C\u0005\u0002(\u0001\u0001\r\u0011\"\u0003\u0002*\u0005yA.\u0019;fgR,\u0005pY3qi&|g.\u0006\u0002\u0002,A!\u0001cPA\u0017!\u0011\ty#a\u0010\u000f\t\u0005E\u00121\b\b\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011q\u0007\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012bAA\u001f#\u00059\u0001/Y2lC\u001e,\u0017\u0002BA!\u0003\u0007\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005u\u0012\u0003C\u0005\u0002H\u0001\u0001\r\u0011\"\u0003\u0002J\u0005\u0019B.\u0019;fgR,\u0005pY3qi&|gn\u0018\u0013fcR\u0019q+a\u0013\t\u0015\u00055\u0013QIA\u0001\u0002\u0004\tY#A\u0002yIEB\u0001\"!\u0015\u0001A\u0003&\u00111F\u0001\u0011Y\u0006$Xm\u001d;Fq\u000e,\u0007\u000f^5p]\u0002BC!a\u0014\u0002VA\u0019\u0001#a\u0016\n\u0007\u0005e\u0013C\u0001\u0005w_2\fG/\u001b7f\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\n!cZ3u\u0019\u0006$Xm\u001d;Fq\u000e,\u0007\u000f^5p]R\u0011\u00111\u0006\u0005\b\u0003G\u0002A\u0011AA3\u00031)\u00070Z2vi\u0016\f5/\u001f8d)\u0011\t\t\"a\u001a\t\u000f\u0005%\u0014\u0011\ra\u0001A\u0005!A/Y:l\u0011\u001d\ti\u0007\u0001C\u0001\u0003_\nq!\u001a=fGV$X\rF\u00025\u0003cBq!!\u001b\u0002l\u0001\u0007\u0001\u0005C\u0004\u0002v\u0001!\t!a\u001e\u0002=]\f\u0017\u000e\u001e$pe\u000e+(O]3oi2LX\t_3dkRLgn\u001a+bg.\u001cH#A,")
public class AsyncExecutor<T, R>
implements Logging {
    private final Function1<T, CompletionStage<R>> asyncAction;
    public final Option<Function3<T, Object, Object, BoxedUnit>> com$datastax$spark$connector$writer$AsyncExecutor$$successHandler;
    public final Option<Function3<T, Object, Object, BoxedUnit>> com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler;
    private final Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    private final TrieMap<Future<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;
    private volatile Option<Throwable> com$datastax$spark$connector$writer$AsyncExecutor$$latestException;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public static <T, R> None$ $lessinit$greater$default$3() {
        return AsyncExecutor$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    }

    public TrieMap<Future<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;
    }

    private Option<Throwable> com$datastax$spark$connector$writer$AsyncExecutor$$latestException() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException;
    }

    public void com$datastax$spark$connector$writer$AsyncExecutor$$latestException_$eq(Option<Throwable> x$1) {
        this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException = x$1;
    }

    public Option<Throwable> getLatestException() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException();
    }

    public Future<R> executeAsync(T task) {
        long submissionTimestamp = System.nanoTime();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().acquire();
        Promise promise = Promise$.MODULE$.apply();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().put((Object)promise.future(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        long executionTimestamp = System.nanoTime();
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(task, submissionTimestamp, promise, executionTimestamp);
    }

    public R execute(T task) {
        return (R)Await$.MODULE$.result(this.executeAsync(task), (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS));
    }

    public void waitForCurrentlyExecutingTasks() {
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().snapshot().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Future<R>, Object> check$ifrefutable$1) {
                Tuple2<Future<R>, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Try<R> apply(Tuple2<Future<R>, Object> x$4) {
                Tuple2<Future<R>, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    Future future = (Future)tuple2._1();
                    Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, future){
                        public static final long serialVersionUID = 0L;
                        private final Future future$1;

                        public final R apply() {
                            return (R)Await$.MODULE$.result((Awaitable)this.future$1, (Duration)Duration$.MODULE$.Inf());
                        }
                        {
                            this.future$1 = future$1;
                        }
                    });
                    return try_;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public final Future com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(Object task$1, long submissionTimestamp$1, Promise promise$1, long executionTimestamp$1) {
        CompletionStage value2 = (CompletionStage)this.asyncAction.apply(task$1);
        value2.whenComplete(new BiConsumer<R, Throwable>(this, task$1, submissionTimestamp$1, promise$1, executionTimestamp$1){
            private final /* synthetic */ AsyncExecutor $outer;
            public final Object task$1;
            public final long submissionTimestamp$1;
            private final Promise promise$1;
            public final long executionTimestamp$1;

            private void release() {
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().release();
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().remove((Object)this.promise$1.future());
            }

            public void com$datastax$spark$connector$writer$AsyncExecutor$$anon$$onSuccess(R result) {
                this.release();
                this.promise$1.success(result);
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$successHandler.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply(Function3<T, Object, Object, BoxedUnit> x$1) {
                        x$1.apply(this.$outer.task$1, (Object)BoxesRunTime.boxToLong((long)this.$outer.submissionTimestamp$1), (Object)BoxesRunTime.boxToLong((long)this.$outer.executionTimestamp$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public void com$datastax$spark$connector$writer$AsyncExecutor$$anon$$onFailure(Throwable throwable) {
                AllNodesFailedException allNodesFailedException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AllNodesFailedException && ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((allNodesFailedException = (AllNodesFailedException)throwable2).getAllErrors()).asScala()).values().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(List<Throwable> x$2) {
                        return x$2 instanceof BusyConnectionException;
                    }
                })) {
                    this.$outer.logTrace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "BusyConnectionException ... Retrying";
                        }
                    });
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(this.task$1, this.submissionTimestamp$1, this.promise$1, this.executionTimestamp$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable2 instanceof NoNodeAvailableException) {
                    this.$outer.logTrace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "No Nodes Available ... Retrying";
                        }
                    });
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(this.task$1, this.submissionTimestamp$1, this.promise$1, this.executionTimestamp$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable2 instanceof OverloadedException) {
                    this.$outer.logTrace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Backpressure rejection ... Retrying";
                        }
                    });
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(this.task$1, this.submissionTimestamp$1, this.promise$1, this.executionTimestamp$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Failed to execute: ").append(this.$outer.task$1).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, throwable2);
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$latestException_$eq((Option<Throwable>)new Some((Object)throwable));
                    this.release();
                    this.promise$1.failure(throwable);
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;

                        public final void apply(Function3<T, Object, Object, BoxedUnit> x$3) {
                            x$3.apply(this.$outer.task$1, (Object)BoxesRunTime.boxToLong((long)this.$outer.submissionTimestamp$1), (Object)BoxesRunTime.boxToLong((long)this.$outer.executionTimestamp$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public void accept(R r, Throwable t) {
                Option$.MODULE$.apply((Object)t).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply(Throwable throwable) {
                        this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$anon$$onFailure(throwable);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Option$.MODULE$.apply(r).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply(R result) {
                        this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$anon$$onSuccess(result);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                void var5_4;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$1 = task$1;
                this.submissionTimestamp$1 = submissionTimestamp$1;
                this.promise$1 = var5_4;
                this.executionTimestamp$1 = executionTimestamp$1;
            }
        });
        return promise$1.future();
    }

    public AsyncExecutor(Function1<T, CompletionStage<R>> asyncAction, int maxConcurrentTasks, Option<Function3<T, Object, Object, BoxedUnit>> successHandler, Option<Function3<T, Object, Object, BoxedUnit>> failureHandler) {
        this.asyncAction = asyncAction;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$successHandler = successHandler;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler = failureHandler;
        Logging.class.$init$((Logging)this);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore = new Semaphore(maxConcurrentTasks);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures = new TrieMap();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException = None$.MODULE$;
    }
}

