/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.spark.connector.CollectionAppend$;
import com.datastax.spark.connector.CollectionBehavior;
import com.datastax.spark.connector.CollectionColumnName;
import com.datastax.spark.connector.CollectionOverwrite$;
import com.datastax.spark.connector.CollectionPrepend$;
import com.datastax.spark.connector.CollectionRemove$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.QueryUtils$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ListType;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$None$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.BatchGroupingKey$ReplicaSet$;
import com.datastax.spark.connector.writer.BatchStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.GroupingBatchBuilder;
import com.datastax.spark.connector.writer.PerRowWriteOptionValue;
import com.datastax.spark.connector.writer.QueryExecutor;
import com.datastax.spark.connector.writer.RateLimiter;
import com.datastax.spark.connector.writer.RateLimiter$;
import com.datastax.spark.connector.writer.RichBoundStatementWrapper;
import com.datastax.spark.connector.writer.RichStatement;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.StaticWriteOptionValue;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TableWriter$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteOptionValue;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.OutputMetricsUpdater;
import org.apache.spark.metrics.OutputMetricsUpdater$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t-e\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016<&/\u001b;fe*\u00111\u0001B\u0001\u0007oJLG/\u001a:\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001+\tqah\u0005\u0003\u0001\u001fUA\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0011-%\u0011q#\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00033qi\u0011A\u0007\u0006\u00037\u0011\tA!\u001e;jY&\u0011QD\u0007\u0002\b\u0019><w-\u001b8h\u0011!)\u0001A!A!\u0002\u0013y\u0002C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\r\u0019\u0017\u000f\\\u0005\u0003I\u0005\u0012!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\"Aa\u0005\u0001B\u0001B\u0003%q%\u0001\u0005uC\ndW\rR3g!\t\u0001\u0003&\u0003\u0002*C\tAA+\u00192mK\u0012+g\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u00039\u0019w\u000e\\;n]N+G.Z2u_J\u00042!\f\u00193\u001b\u0005q#BA\u0018\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003c9\u0012!\"\u00138eKb,GmU3r!\t\u0019D'D\u0001\u0005\u0013\t)DAA\u0005D_2,XN\u001c*fM\"Aq\u0007\u0001B\u0001B\u0003%\u0001(A\u0005s_^<&/\u001b;feB\u0019\u0011H\u000f\u001f\u000e\u0003\tI!a\u000f\u0002\u0003\u0013I{wo\u0016:ji\u0016\u0014\bCA\u001f?\u0019\u0001!Qa\u0010\u0001C\u0002\u0001\u0013\u0011\u0001V\t\u0003\u0003\u0012\u0003\"\u0001\u0005\"\n\u0005\r\u000b\"a\u0002(pi\"Lgn\u001a\t\u0003!\u0015K!AR\t\u0003\u0007\u0005s\u0017\u0010\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0003%9(/\u001b;f\u0007>tg\r\u0005\u0002:\u0015&\u00111J\u0001\u0002\n/JLG/Z\"p]\u001aDQ!\u0014\u0001\u0005\n9\u000ba\u0001P5oSRtDCB(Q#J\u001bF\u000bE\u0002:\u0001qBQ!\u0002'A\u0002}AQA\n'A\u0002\u001dBQa\u000b'A\u00021BQa\u000e'A\u0002aBQ\u0001\u0013'A\u0002%CqA\u0016\u0001C\u0002\u0013\u0005q+\u0001\u0007lKf\u001c\b/Y2f\u001d\u0006lW-F\u0001Y!\tIFL\u0004\u0002\u00115&\u00111,E\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\#!1\u0001\r\u0001Q\u0001\na\u000bQb[3zgB\f7-\u001a(b[\u0016\u0004\u0003b\u00022\u0001\u0005\u0004%\taV\u0001\ni\u0006\u0014G.\u001a(b[\u0016Da\u0001\u001a\u0001!\u0002\u0013A\u0016A\u0003;bE2,g*Y7fA!9a\r\u0001b\u0001\n\u00039\u0017aC2pYVlgNT1nKN,\u0012\u0001\u001b\t\u0004[%D\u0016B\u00016/\u0005\r\u0019V-\u001d\u0005\u0007Y\u0002\u0001\u000b\u0011\u00025\u0002\u0019\r|G.^7o\u001d\u0006lWm\u001d\u0011\t\u000f9\u0004!\u0019!C\u0001_\u000691m\u001c7v[:\u001cX#\u00019\u0011\u00075J\u0017\u000f\u0005\u0002!e&\u00111/\t\u0002\n\u0007>dW/\u001c8EK\u001aDa!\u001e\u0001!\u0002\u0013\u0001\u0018\u0001C2pYVlgn\u001d\u0011\t\u0013]\u0004\u0001R1A\u0005\u0002\u00119\u0016\u0001G9vKJLH+Z7qY\u0006$X-V:j]\u001eLen]3si\"A\u0011\u0010\u0001E\u0001B\u0003&\u0001,A\rrk\u0016\u0014\u0018\u0010V3na2\fG/Z+tS:<\u0017J\\:feR\u0004\u0003\"B>\u0001\t\u0013a\u0018a\u00053fY\u0016$X-U;fef$V-\u001c9mCR,GC\u0001-~\u0011\u0015q(\u00101\u0001\u0000\u00035!W\r\\3uK\u000e{G.^7ogB\u00191'!\u0001\n\u0007\u0005\rAA\u0001\bD_2,XN\\*fY\u0016\u001cGo\u001c:\t\u0013\u0005\u001d\u0001\u0001#b\u0001\n\u00139\u0016\u0001G9vKJLH+Z7qY\u0006$X-V:j]\u001e,\u0006\u000fZ1uK\"I\u00111\u0002\u0001\t\u0002\u0003\u0006K\u0001W\u0001\u001acV,'/\u001f+f[Bd\u0017\r^3Vg&tw-\u00169eCR,\u0007\u0005C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012\u0005y\u0011n]\"pk:$XM]+qI\u0006$X-\u0006\u0002\u0002\u0014A\u0019\u0001#!\u0006\n\u0007\u0005]\u0011CA\u0004C_>dW-\u00198\t\u0011\u0005m\u0001\u0001)A\u0005\u0003'\t\u0001#[:D_VtG/\u001a:Va\u0012\fG/\u001a\u0011\t\u0013\u0005}\u0001A1A\u0005\n\u0005E\u0011aG2p]R\f\u0017N\\:D_2dWm\u0019;j_:\u0014U\r[1wS>\u00148\u000f\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\n\u0003q\u0019wN\u001c;bS:\u001c8i\u001c7mK\u000e$\u0018n\u001c8CK\"\fg/[8sg\u0002B!\"a\n\u0001\u0005\u0004%\t\u0001BA\t\u00031I7/\u00133f[B|G/\u001a8u\u0011!\tY\u0003\u0001Q\u0001\n\u0005M\u0011!D5t\u0013\u0012,W\u000e]8uK:$\b\u0005C\u0004\u00020\u0001!I!!\r\u0002!A\u0014X\r]1sKN#\u0018\r^3nK:$HCBA\u001a\u0003\u001b\n\t\u0006\u0005\u0003\u00026\u0005%SBAA\u001c\u0015\r\u0011\u0013\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0003d_J,'\u0002BA \u0003\u0003\n1!\u00199j\u0015\u0011\t\u0019%!\u0012\u0002\r\u0011\u0014\u0018N^3s\u0015\r\t9\u0005C\u0001\u0004_N\u001c\u0018\u0002BA&\u0003o\u0011\u0011\u0003\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u0011\u001d\ty%!\fA\u0002a\u000bQ\"];fef$V-\u001c9mCR,\u0007\u0002CA*\u0003[\u0001\r!!\u0016\u0002\u000fM,7o]5p]B!\u0011qKA-\u001b\t\tI$\u0003\u0003\u0002\\\u0005e\"AC\"rYN+7o]5p]\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014a\u00042bi\u000eD'k\\;uS:<7*Z=\u0015\t\u0005\r\u0014q\u000e\u000b\u0004\t\u0006\u0015\u0004\u0002CA4\u0003;\u0002\r!!\u001b\u0002\u0005\t\u001c\bcA\u001d\u0002l%\u0019\u0011Q\u000e\u0002\u00033IK7\r\u001b\"pk:$7\u000b^1uK6,g\u000e^,sCB\u0004XM\u001d\u0005\t\u0003'\ni\u00061\u0001\u0002V!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0014!B<sSR,GCBA<\u0003{\n\u0019\nE\u0002\u0011\u0003sJ1!a\u001f\u0012\u0005\u0011)f.\u001b;\t\u0011\u0005}\u0014\u0011\u000fa\u0001\u0003\u0003\u000b1\u0002^1tW\u000e{g\u000e^3yiB!\u00111QAH\u001b\t\t)IC\u0002\b\u0003\u000fSA!!#\u0002\f\u00061\u0011\r]1dQ\u0016T!!!$\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0012\u0006\u0015%a\u0003+bg.\u001cuN\u001c;fqRD\u0001\"!&\u0002r\u0001\u0007\u0011qS\u0001\u0005I\u0006$\u0018\r\u0005\u0003.\u00033c\u0014bAAN]\tA\u0011\n^3sCR|'\u000fC\u0004\u0002 \u0002!\t!!)\u0002\rU\u0004H-\u0019;f)\u0019\t9(a)\u0002&\"A\u0011qPAO\u0001\u0004\t\t\t\u0003\u0005\u0002\u0016\u0006u\u0005\u0019AAL\u0011\u001d\tI\u000b\u0001C\u0001\u0003W\u000ba!\u001b8tKJ$HCBA<\u0003[\u000by\u000b\u0003\u0005\u0002\u0000\u0005\u001d\u0006\u0019AAA\u0011!\t)*a*A\u0002\u0005]\u0005bBAZ\u0001\u0011\u0005\u0011QW\u0001\u0007I\u0016dW\r^3\u0015\t\u0005]\u0016Q\u0018\u000b\u0007\u0003o\nI,a/\t\u0011\u0005}\u0014\u0011\u0017a\u0001\u0003\u0003C\u0001\"!&\u00022\u0002\u0007\u0011q\u0013\u0005\u0007]\u0006E\u0006\u0019A@\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\u0006iqO]5uK&sG/\u001a:oC2$\u0002\"a\u001e\u0002F\u0006\u001d\u0017\u0011\u001a\u0005\b\u0003\u001f\ny\f1\u0001Y\u0011!\ty(a0A\u0002\u0005\u0005\u0005\u0002CAK\u0003\u007f\u0003\r!a&\b\u000f\u00055'\u0001#\u0001\u0002P\u0006YA+\u00192mK^\u0013\u0018\u000e^3s!\rI\u0014\u0011\u001b\u0004\u0007\u0003\tA\t!a5\u0014\t\u0005Ew\"\u0006\u0005\b\u001b\u0006EG\u0011AAl)\t\ty\r\u0003\u0005\u0002\\\u0006EG\u0011BAo\u0003M\u0019\u0007.Z2l\u001b&\u001c8/\u001b8h\u0007>dW/\u001c8t)\u0019\t9(a8\u0002d\"9\u0011\u0011]Am\u0001\u00049\u0013!\u0002;bE2,\u0007B\u00024\u0002Z\u0002\u0007\u0001\u000e\u0003\u0005\u0002h\u0006EG\u0011BAu\u0003u\u0019\u0007.Z2l\u001b&\u001c8/\u001b8h!JLW.\u0019:z\u0017\u0016L8i\u001c7v[:\u001cHCBA<\u0003W\fi\u000fC\u0004\u0002b\u0006\u0015\b\u0019A\u0014\t\r\u0019\f)\u000f1\u0001i\u0011!\t\t0!5\u0005\n\u0005M\u0018aH2iK\u000e\\W*[:tS:<\u0007+\u0019:uSRLwN\\&fs\u000e{G.^7ogR1\u0011qOA{\u0003oDq!!9\u0002p\u0002\u0007q\u0005\u0003\u0004g\u0003_\u0004\r\u0001\u001b\u0005\t\u0003w\f\t\u000e\"\u0003\u0002~\u0006IrN\u001c7z!\u0006\u0014H/\u001b;j_:\\U-_!oIN#\u0018\r^5d)\u0019\t\u0019\"a@\u0003\u0002!9\u0011\u0011]A}\u0001\u00049\u0003B\u00024\u0002z\u0002\u0007\u0001\u000e\u0003\u0005\u0003\u0006\u0005EG\u0011\u0002B\u0004\u0003a\u0019\u0007.Z2l\u0007>dG.Z2uS>t')\u001a5bm&|'o\u001d\u000b\u0007\u0003o\u0012IAa\u0003\t\u000f\u0005\u0005(1\u0001a\u0001O!9!Q\u0002B\u0002\u0001\u0004a\u0013AC2pYVlgNU3gg\"A!\u0011CAi\t\u0013\u0011\u0019\"\u0001\u0007dQ\u0016\u001c7nQ8mk6t7\u000f\u0006\u0005\u0002x\tU!q\u0003B\r\u0011\u001d\t\tOa\u0004A\u0002\u001dBqA!\u0004\u0003\u0010\u0001\u0007A\u0006\u0003\u0005\u0003\u001c\t=\u0001\u0019AA\n\u0003E\u0019\u0007.Z2l!\u0006\u0014H/\u001b;j_:\\U-\u001f\u0005\u000b\u0005?\t\tN1A\u0005\n\t\u0005\u0012aD%oi\u0016\u0014h.\u00197D_2,XN\\:\u0016\u0005\t\r\u0002#B\u0017\u0003&\t%\u0012b\u0001B\u0014]\t\u00191+\u001a;\u0011\t\t-\"QG\u0007\u0003\u0005[QAAa\f\u00032\u0005!A.\u00198h\u0015\t\u0011\u0019$\u0001\u0003kCZ\f\u0017bA/\u0003.!I!\u0011HAiA\u0003%!1E\u0001\u0011\u0013:$XM\u001d8bY\u000e{G.^7og\u0002B\u0001B!\u0010\u0002R\u0012\u0005!qH\u0001\u0006CB\u0004H._\u000b\u0005\u0005\u0003\u0012I\u0005\u0006\b\u0003D\tU#q\u000bB-\u00057\u0012iFa\u0018\u0015\t\t\u0015#1\n\t\u0005s\u0001\u00119\u0005E\u0002>\u0005\u0013\"aa\u0010B\u001e\u0005\u0004\u0001\u0005B\u0003B'\u0005w\t\t\u0011q\u0001\u0003P\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u000be\u0012\tFa\u0012\n\u0007\tM#A\u0001\tS_^<&/\u001b;fe\u001a\u000b7\r^8ss\"1QAa\u000fA\u0002}AaA\u0016B\u001e\u0001\u0004A\u0006B\u00022\u0003<\u0001\u0007\u0001\f\u0003\u0004g\u0005w\u0001\ra \u0005\u0007\u0011\nm\u0002\u0019A%\t\u0015\tm!1\bI\u0001\u0002\u0004\t\u0019\u0002\u0003\u0006\u0003d\u0005E\u0017\u0013!C\u0001\u0005K\nq\"\u00199qYf$C-\u001a4bk2$HEN\u000b\u0005\u0005O\u0012i(\u0006\u0002\u0003j)\"\u00111\u0003B6W\t\u0011i\u0007\u0005\u0003\u0003p\teTB\u0001B9\u0015\u0011\u0011\u0019H!\u001e\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B<#\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm$\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GAB \u0003b\t\u0007\u0001\t\u0003\u0006\u0003\u0002\u0006E\u0017\u0011!C\u0005\u0005\u0007\u000b1B]3bIJ+7o\u001c7wKR\u0011!Q\u0011\t\u0005\u0005W\u00119)\u0003\u0003\u0003\n\n5\"AB(cU\u0016\u001cG\u000f")
public class TableWriter<T>
implements Serializable,
Logging {
    private final CassandraConnector connector;
    public final TableDef com$datastax$spark$connector$writer$TableWriter$$tableDef;
    private final IndexedSeq<ColumnRef> columnSelector;
    public final RowWriter<T> com$datastax$spark$connector$writer$TableWriter$$rowWriter;
    public final WriteConf com$datastax$spark$connector$writer$TableWriter$$writeConf;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private final Seq<ColumnDef> columns;
    private String queryTemplateUsingInsert;
    private String queryTemplateUsingUpdate;
    private final boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    private final boolean containsCollectionBehaviors;
    private final boolean isIdempotent;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile byte bitmap$0;

    public static <T> boolean apply$default$6() {
        return TableWriter$.MODULE$.apply$default$6();
    }

    public static <T> TableWriter<T> apply(CassandraConnector cassandraConnector, String string, String string2, ColumnSelector columnSelector, WriteConf writeConf, boolean bl, RowWriterFactory<T> rowWriterFactory) {
        return TableWriter$.MODULE$.apply(cassandraConnector, string, string2, columnSelector, writeConf, bl, rowWriterFactory);
    }

    private String queryTemplateUsingInsert$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                WriteOptionValue<Object> writeOptionValue;
                None$ none$;
                WriteOptionValue<Object> writeOptionValue2;
                WriteOptionValue<Object> writeOptionValue3;
                None$ none$2;
                WriteOptionValue<Object> writeOptionValue4;
                Seq quotedColumnNames2 = (Seq)this.columnNames().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String name) {
                        return Quote$.MODULE$.quote(name);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String columnSpec = quotedColumnNames2.mkString(", ");
                String valueSpec = ((TraversableOnce)quotedColumnNames2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$1) {
                        return new StringBuilder().append((Object)":").append((Object)x$1).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String ifNotExistsSpec = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ifNotExists() ? "IF NOT EXISTS " : "";
                TTLOption tTLOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ttl();
                if (tTLOption != null && (writeOptionValue4 = tTLOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue4;
                    String placeholder2 = perRowWriteOptionValue.placeholder();
                    none$2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder2})));
                } else if (tTLOption != null && (writeOptionValue3 = tTLOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue3;
                    int value2 = BoxesRunTime.unboxToInt(staticWriteOptionValue.value());
                    none$2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)value2)})));
                } else {
                    none$2 = None$.MODULE$;
                }
                None$ ttlSpec = none$2;
                TimestampOption timestampOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.timestamp();
                if (timestampOption != null && (writeOptionValue2 = timestampOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue2;
                    String placeholder3 = perRowWriteOptionValue.placeholder();
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder3})));
                } else if (timestampOption != null && (writeOptionValue = timestampOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
                    long value3 = BoxesRunTime.unboxToLong(staticWriteOptionValue.value());
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)value3)})));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ timestampSpec = none$;
                List options = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{ttlSpec, timestampSpec})).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<String> apply(Option<String> xo) {
                        return Option$.MODULE$.option2Iterable(xo);
                    }
                });
                String optionsSpec = options.nonEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USING ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.mkString(" AND ")})) : "";
                this.queryTemplateUsingInsert = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", ".", " (", ") VALUES (", ") ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), columnSpec, valueSpec, ifNotExistsSpec, optionsSpec})).trim();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.queryTemplateUsingInsert;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String queryTemplateUsingUpdate$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Tuple2 tuple23 = this.columns().partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ColumnDef x$6) {
                        return x$6.isPrimaryKeyColumn();
                    }
                });
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Seq primaryKey = (Seq)tuple23._1();
                Seq regularColumns = (Seq)tuple23._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
                Seq primaryKey2 = (Seq)tuple24._1();
                Seq regularColumns2 = (Seq)tuple24._2();
                Tuple2 tuple25 = regularColumns2.partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ColumnDef x$8) {
                        return x$8.isCounterColumn();
                    }
                });
                if (tuple25 == null) throw new MatchError((Object)tuple25);
                Seq counterColumns = (Seq)tuple25._1();
                Seq nonCounterColumns = (Seq)tuple25._2();
                Tuple2 tuple26 = tuple2 = new Tuple2((Object)counterColumns, (Object)nonCounterColumns);
                Seq counterColumns2 = (Seq)tuple26._1();
                Seq nonCounterColumns2 = (Seq)tuple26._2();
                Map nameToBehavior = ((TraversableOnce)this.columnSelector.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof CollectionColumnName) {
                            CollectionColumnName collectionColumnName = (CollectionColumnName)A1;
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)collectionColumnName.columnName()), (Object)collectionColumnName.collectionBehavior());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(ColumnRef x1) {
                        ColumnRef columnRef = x1;
                        boolean bl = columnRef instanceof CollectionColumnName;
                        return bl;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Seq setNonCounterColumnsClause = (Seq)((TraversableLike)nonCounterColumns2.map((Function1)new Serializable(this, nameToBehavior){
                    public static final long serialVersionUID = 0L;
                    private final Map nameToBehavior$1;

                    public final Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> apply(ColumnDef colDef) {
                        String name = colDef.columnName();
                        Option collectionBehavior = this.nameToBehavior$1.get((Object)name);
                        String quotedName = Quote$.MODULE$.quote(name);
                        return new Tuple4((Object)colDef, (Object)name, (Object)collectionBehavior, (Object)quotedName);
                    }
                    {
                        this.nameToBehavior$1 = nameToBehavior$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> x$10) {
                        Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> tuple4;
                        block2: {
                            Option option;
                            block7: {
                                String string;
                                block4: {
                                    Some some;
                                    CollectionBehavior collectionBehavior;
                                    String quotedName;
                                    block6: {
                                        CollectionBehavior collectionBehavior2;
                                        Some some2;
                                        boolean bl;
                                        block5: {
                                            CollectionBehavior collectionBehavior3;
                                            block3: {
                                                tuple4 = x$10;
                                                if (tuple4 == null) break block2;
                                                Option collectionBehavior4 = (Option)tuple4._3();
                                                quotedName = (String)tuple4._4();
                                                bl = false;
                                                some2 = null;
                                                option = collectionBehavior4;
                                                if (!(option instanceof Some)) break block3;
                                                bl = true;
                                                some2 = (Some)option;
                                                CollectionBehavior collectionBehavior5 = (CollectionBehavior)some2.x();
                                                if (!CollectionAppend$.MODULE$.equals(collectionBehavior5)) break block3;
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                                break block4;
                                            }
                                            if (!bl || !CollectionPrepend$.MODULE$.equals(collectionBehavior3 = (CollectionBehavior)some2.x())) break block5;
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", " + ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                            break block4;
                                        }
                                        if (!bl || !CollectionRemove$.MODULE$.equals(collectionBehavior2 = (CollectionBehavior)some2.x())) break block6;
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " - :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                        break block4;
                                    }
                                    boolean bl = option instanceof Some && CollectionOverwrite$.MODULE$.equals(collectionBehavior = (CollectionBehavior)(some = (Some)option).x()) ? true : None$.MODULE$.equals(option);
                                    if (!bl) break block7;
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName}));
                                }
                                String string2 = string;
                                return string2;
                            }
                            throw new MatchError((Object)option);
                        }
                        throw new MatchError(tuple4);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq setCounterColumnsClause = (Seq)this.quotedColumnNames$2(counterColumns2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String setClause = ((TraversableOnce)setNonCounterColumnsClause.$plus$plus((GenTraversableOnce)setCounterColumnsClause, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String whereClause2 = ((TraversableOnce)this.quotedColumnNames$2(primaryKey2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
                this.queryTemplateUsingUpdate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", ".", " SET ", " WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), setClause, whereClause2}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.queryTemplateUsingUpdate;
        }
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public Seq<ColumnDef> columns() {
        return this.columns;
    }

    public String queryTemplateUsingInsert() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.queryTemplateUsingInsert$lzycompute() : this.queryTemplateUsingInsert;
    }

    private String deleteQueryTemplate(ColumnSelector deleteColumns) {
        Seq deleteColumnNames = (Seq)deleteColumns.selectFrom(this.com$datastax$spark$connector$writer$TableWriter$$tableDef).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$2) {
                return x$2.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = this.columns().partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnDef x$3) {
                return x$3.isPrimaryKeyColumn();
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq primaryKey = (Seq)tuple2._1();
            Seq regularColumns = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
            Seq primaryKey2 = (Seq)tuple23._1();
            Seq regularColumns2 = (Seq)tuple23._2();
            if (regularColumns2.nonEmpty()) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only primary key columns can be used in delete. Regular columns found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{regularColumns2.mkString(", ")})));
            }
            TableWriter$.MODULE$.com$datastax$spark$connector$writer$TableWriter$$checkMissingColumns(this.com$datastax$spark$connector$writer$TableWriter$$tableDef, (Seq<String>)deleteColumnNames);
            String deleteColumnsClause = ((TraversableOnce)deleteColumnNames.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String name) {
                    return Quote$.MODULE$.quote(name);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
            String whereClause2 = ((TraversableOnce)this.quotedColumnNames$1(primaryKey2).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String c) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE ", " FROM ", ".", " WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deleteColumnsClause, Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), whereClause2}));
        }
        throw new MatchError((Object)tuple2);
    }

    private String queryTemplateUsingUpdate() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.queryTemplateUsingUpdate$lzycompute() : this.queryTemplateUsingUpdate;
    }

    public boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() {
        return this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    }

    private boolean containsCollectionBehaviors() {
        return this.containsCollectionBehaviors;
    }

    public boolean isIdempotent() {
        return this.isIdempotent;
    }

    public PreparedStatement com$datastax$spark$connector$writer$TableWriter$$prepareStatement(String queryTemplate, CqlSession session) {
        try {
            SimpleStatement stmt = (SimpleStatement)SimpleStatement.newInstance((String)queryTemplate).setIdempotent(Predef$.MODULE$.boolean2Boolean(this.isIdempotent())).setConsistencyLevel(this.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
            return session.prepare(stmt);
        }
        catch (Throwable throwable) {
            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to prepare statement ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryTemplate}))).append((Object)throwable.getMessage()).toString(), throwable);
        }
    }

    public Object batchRoutingKey(CqlSession session, RichBoundStatementWrapper bs) {
        BatchGroupingKey batchGroupingKey;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        batchGroupingKey = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingKey();
                        if (!BatchGroupingKey$None$.MODULE$.equals(batchGroupingKey)) break block2;
                        object = BoxesRunTime.boxToInteger((int)0);
                        break block3;
                    }
                    if (!BatchGroupingKey$ReplicaSet$.MODULE$.equals(batchGroupingKey)) break block4;
                    object = ((TokenMap)session.getMetadata().getTokenMap().orElseThrow(this.missingMetadataException$1())).getReplicas(this.keyspaceName(), QueryUtils$.MODULE$.getRoutingKeyOrError(bs.stmt()));
                    break block3;
                }
                if (!BatchGroupingKey$Partition$.MODULE$.equals(batchGroupingKey)) break block5;
                object = QueryUtils$.MODULE$.getRoutingKeyOrError(bs.stmt());
            }
            return object;
        }
        throw new MatchError((Object)batchGroupingKey);
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        if (this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() || this.containsCollectionBehaviors()) {
            this.update(taskContext, data);
        } else {
            this.insert(taskContext, data);
        }
    }

    public void update(TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.queryTemplateUsingUpdate(), taskContext, data);
    }

    public void insert(TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.queryTemplateUsingInsert(), taskContext, data);
    }

    public void delete(ColumnSelector columns, TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.deleteQueryTemplate(columns), taskContext, data);
    }

    private void writeInternal(String queryTemplate, TaskContext taskContext, Iterator<T> data) {
        OutputMetricsUpdater updater = OutputMetricsUpdater$.MODULE$.apply(taskContext, this.com$datastax$spark$connector$writer$TableWriter$$writeConf);
        this.connector.withSessionDo(new Serializable(this, queryTemplate, data, updater){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final String queryTemplate$1;
            private final Iterator data$1;
            public final OutputMetricsUpdater updater$1;

            public final void apply(CqlSession session) {
                Option<Object> option;
                block6: {
                    Object object;
                    GroupingBatchBuilder<T> batchBuilder;
                    BoundStatementBuilder<T> boundStmtBuilder;
                    QueryExecutor queryExecutor;
                    CountingIterator<T> rowIterator;
                    block5: {
                        block4: {
                            ProtocolVersion protocolVersion2 = session.getContext().getProtocolVersion();
                            rowIterator = new CountingIterator<T>(this.data$1, CountingIterator$.MODULE$.$lessinit$greater$default$2());
                            PreparedStatement stmt = this.$outer.com$datastax$spark$connector$writer$TableWriter$$prepareStatement(this.queryTemplate$1, session);
                            queryExecutor = new QueryExecutor(session, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.parallelismLevel(), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                                public final void apply(RichStatement x$15, long x$16, long x$17) {
                                    this.$outer.updater$1.batchFinished(true, x$15, x$16, x$17);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                                public final void apply(RichStatement x$18, long x$19, long x$20) {
                                    this.$outer.updater$1.batchFinished(false, x$18, x$19, x$20);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            DefaultBatchType batchType = this.$outer.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() ? DefaultBatchType.COUNTER : DefaultBatchType.UNLOGGED;
                            RowWriter<T> x$32 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$rowWriter;
                            PreparedStatement x$33 = stmt;
                            ProtocolVersion x$34 = protocolVersion2;
                            boolean x$35 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.ignoreNulls();
                            Seq<Object> x$36 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$3();
                            boundStmtBuilder = new BoundStatementBuilder<T>(x$32, x$33, x$36, x$35, x$34);
                            BatchStatementBuilder batchStmtBuilder = new BatchStatementBuilder((BatchType)batchType, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
                            Serializable batchKeyGenerator = new Serializable(this, session){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$writeInternal$1 $outer;
                                private final CqlSession session$1;

                                public final Object apply(RichBoundStatementWrapper bs) {
                                    return this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().batchRoutingKey(this.session$1, bs);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.session$1 = session$1;
                                }
                            };
                            batchBuilder = new GroupingBatchBuilder<T>(boundStmtBuilder, batchStmtBuilder, (Function1<RichBoundStatementWrapper, Object>)batchKeyGenerator, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingBufferSize(), rowIterator);
                            option = this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.throughputMiBPS();
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            double throughput = BoxesRunTime.unboxToDouble((Object)some.x());
                            RateLimiter rateLimiter = new RateLimiter((long)(throughput * (double)1024 * (double)1024), 0x100000L, RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
                            object = new Serializable(this, rateLimiter){
                                public static final long serialVersionUID = 0L;
                                private final RateLimiter rateLimiter$1;

                                public final void apply(RichStatement stmt) {
                                    this.rateLimiter$1.maybeSleep(stmt.bytesCount());
                                }
                                {
                                    this.rateLimiter$1 = rateLimiter$1;
                                }
                            };
                            break block5;
                        }
                        if (!None$.MODULE$.equals(option)) break block6;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(RichStatement stmt) {
                            }
                        };
                    }
                    Serializable maybeRateLimit = object;
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing data partition to ", ".", " in batches of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    batchBuilder.foreach(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$writeInternal$1 $outer;
                        private final QueryExecutor queryExecutor$1;
                        private final Function1 maybeRateLimit$1;

                        public final void apply(RichStatement stmtToWrite) {
                            this.queryExecutor$1.executeAsync(stmtToWrite.executeAs(this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().com$datastax$spark$connector$writer$TableWriter$$writeConf.executeAs()));
                            this.maybeRateLimit$1.apply((Object)stmtToWrite);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.queryExecutor$1 = queryExecutor$1;
                            this.maybeRateLimit$1 = maybeRateLimit$1;
                        }
                    });
                    queryExecutor.waitForCurrentlyExecutingTasks();
                    queryExecutor.getLatestException().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                        public final Nothing$ apply(Throwable x0$2) {
                            Throwable throwable = x0$2;
                            throw new IOException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write statements to ", ".", ". The\n               |latest exception was\n               |  ", "\n               |\n               |Please check the executor logs for more exceptions and information\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName(), throwable.getMessage()})))).stripMargin());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    double duration = (double)this.updater$1.finish() / 1.0E9;
                    this.$outer.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$writeInternal$1 $outer;
                        private final CountingIterator rowIterator$1;
                        private final double duration$1;

                        public final String apply() {
                            Integer arg$macro$21 = BoxesRunTime.boxToInteger((int)this.rowIterator$1.count());
                            String arg$macro$22 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName();
                            String arg$macro$23 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName();
                            double arg$macro$24 = this.duration$1;
                            return new StringOps("Wrote %s rows to %s.%s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$21, arg$macro$22, arg$macro$23, BoxesRunTime.boxToDouble((double)arg$macro$24)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rowIterator$1 = rowIterator$1;
                            this.duration$1 = duration$1;
                        }
                    });
                    if (boundStmtBuilder.logUnsetToNullWarning()) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this, boundStmtBuilder){
                            public static final long serialVersionUID = 0L;
                            private final BoundStatementBuilder boundStmtBuilder$1;

                            public final String apply() {
                                return this.boundStmtBuilder$1.UnsetToNullWarning();
                            }
                            {
                                this.boundStmtBuilder$1 = boundStmtBuilder$1;
                            }
                        });
                    }
                    return;
                }
                throw new MatchError(option);
            }

            public /* synthetic */ TableWriter com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queryTemplate$1 = queryTemplate$1;
                this.data$1 = var3_3;
                this.updater$1 = var4_4;
            }
        });
    }

    private final Seq quotedColumnNames$1(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$5) {
                return x$5.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return Quote$.MODULE$.quote(name);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq quotedColumnNames$2(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$11) {
                return x$11.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return Quote$.MODULE$.quote(name);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Supplier missingMetadataException$1() {
        return new Supplier<IllegalArgumentException>(this){

            public IllegalArgumentException get() {
                return new IllegalArgumentException("TokenMap Metadata Missing");
            }
        };
    }

    public TableWriter(CassandraConnector connector, TableDef tableDef, IndexedSeq<ColumnRef> columnSelector, RowWriter<T> rowWriter, WriteConf writeConf) {
        this.connector = connector;
        this.com$datastax$spark$connector$writer$TableWriter$$tableDef = tableDef;
        this.columnSelector = columnSelector;
        this.com$datastax$spark$connector$writer$TableWriter$$rowWriter = rowWriter;
        this.com$datastax$spark$connector$writer$TableWriter$$writeConf = writeConf;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(!tableDef.isView(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is a Materialized View and Views are not writable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef.name()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = (Seq)rowWriter.columnNames().diff(writeConf.optionPlaceholders());
        this.columns = (Seq)this.columnNames().map((Function1)tableDef.columnByName(), Seq$.MODULE$.canBuildFrom());
        this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate = tableDef.columns().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnDef x$12) {
                return x$12.isCounterColumn();
            }
        });
        this.containsCollectionBehaviors = columnSelector.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnRef x$13) {
                return x$13 instanceof CollectionColumnName;
            }
        });
        this.isIdempotent = this.columns().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnDef x$14) {
                return x$14.isCounterColumn();
            }
        }) ? false : columnSelector.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;

            public final boolean apply(ColumnRef x0$1) {
                ColumnRef columnRef;
                block4: {
                    boolean bl;
                    block3: {
                        block2: {
                            columnRef = x0$1;
                            if (!(columnRef instanceof CollectionColumnName)) break block2;
                            CollectionColumnName collectionColumnName = (CollectionColumnName)columnRef;
                            String name = collectionColumnName.columnName();
                            CollectionBehavior behavior = collectionColumnName.collectionBehavior();
                            boolean isNotList = !(((ColumnDef)this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef.columnByName().apply((Object)name)).columnType() instanceof ListType);
                            CollectionBehavior collectionBehavior = behavior;
                            boolean bl2 = CollectionPrepend$.MODULE$.equals(collectionBehavior) ? isNotList : (CollectionAppend$.MODULE$.equals(collectionBehavior) ? isNotList : true);
                            bl = bl2;
                            break block3;
                        }
                        if (columnRef == null) break block4;
                        bl = true;
                    }
                    return bl;
                }
                throw new MatchError((Object)columnRef);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

