/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.spark.connector.BatchSize;
import com.datastax.spark.connector.TableRef;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.ConfigParameter$;
import com.datastax.spark.connector.util.DeprecatedConfigParameter;
import com.datastax.spark.connector.util.DeprecatedConfigParameter$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteConf$;
import java.util.Locale;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.cassandra.AlwaysOff$;
import org.apache.spark.sql.cassandra.AlwaysOn$;
import org.apache.spark.sql.cassandra.Automatic$;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceRelation;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.DirectJoinSetting;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple11;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.sys.package$;

public final class CassandraSourceRelation$
implements Logging,
Serializable {
    public static final CassandraSourceRelation$ MODULE$;
    private HiveConf hiveConf;
    private final String ReferenceSection;
    private final String TableOptions;
    private final ConfigParameter<Option<Object>> TableSizeInBytesParam;
    private final ConfigParameter<Option<String>> WriteTimeParam;
    private final ConfigParameter<Option<String>> TTLParam;
    private final ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam;
    private final ConfigParameter<Object> SearchPredicateOptimizationRatioParam;
    private final ConfigParameter<String> SearchPredicateOptimizationParam;
    private final DeprecatedConfigParameter<String> SolrPredciateOptimizationParam;
    private final ConfigParameter<Object> DirectJoinSizeRatioParam;
    private final ConfigParameter<String> DirectJoinSettingParam;
    private final ConfigParameter<Object> InClauseToJoinWithTableConversionThreshold;
    private final DeprecatedConfigParameter<Object> DseInClauseToJoinWithTableConversionThreshold;
    private final ConfigParameter<Object> InClauseToFullTableScanConversionThreshold;
    private final DeprecatedConfigParameter<Object> DseInClauseToFullTableScanConversionThreshold;
    private final ConfigParameter<Object> IgnoreMissingMetaColumns;
    private final String defaultClusterName;
    private final boolean proxyPerSourceRelationEnabled;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile boolean bitmap$0;

    static {
        new CassandraSourceRelation$();
    }

    private HiveConf hiveConf$lzycompute() {
        CassandraSourceRelation$ cassandraSourceRelation$ = this;
        synchronized (cassandraSourceRelation$) {
            if (!this.bitmap$0) {
                this.hiveConf = new HiveConf();
                this.bitmap$0 = true;
            }
            return this.hiveConf;
        }
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private HiveConf hiveConf() {
        return this.bitmap$0 ? this.hiveConf : this.hiveConf$lzycompute();
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public String TableOptions() {
        return this.TableOptions;
    }

    public ConfigParameter<Option<Object>> TableSizeInBytesParam() {
        return this.TableSizeInBytesParam;
    }

    public ConfigParameter<Option<String>> WriteTimeParam() {
        return this.WriteTimeParam;
    }

    public ConfigParameter<Option<String>> TTLParam() {
        return this.TTLParam;
    }

    public ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam() {
        return this.AdditionalCassandraPushDownRulesParam;
    }

    public ConfigParameter<Object> SearchPredicateOptimizationRatioParam() {
        return this.SearchPredicateOptimizationRatioParam;
    }

    public ConfigParameter<String> SearchPredicateOptimizationParam() {
        return this.SearchPredicateOptimizationParam;
    }

    public DeprecatedConfigParameter<String> SolrPredciateOptimizationParam() {
        return this.SolrPredciateOptimizationParam;
    }

    public ConfigParameter<Object> DirectJoinSizeRatioParam() {
        return this.DirectJoinSizeRatioParam;
    }

    public ConfigParameter<String> DirectJoinSettingParam() {
        return this.DirectJoinSettingParam;
    }

    public ConfigParameter<Object> InClauseToJoinWithTableConversionThreshold() {
        return this.InClauseToJoinWithTableConversionThreshold;
    }

    public DeprecatedConfigParameter<Object> DseInClauseToJoinWithTableConversionThreshold() {
        return this.DseInClauseToJoinWithTableConversionThreshold;
    }

    public ConfigParameter<Object> InClauseToFullTableScanConversionThreshold() {
        return this.InClauseToFullTableScanConversionThreshold;
    }

    public DeprecatedConfigParameter<Object> DseInClauseToFullTableScanConversionThreshold() {
        return this.DseInClauseToFullTableScanConversionThreshold;
    }

    public ConfigParameter<Object> IgnoreMissingMetaColumns() {
        return this.IgnoreMissingMetaColumns;
    }

    public String defaultClusterName() {
        return this.defaultClusterName;
    }

    private boolean proxyPerSourceRelationEnabled() {
        return this.proxyPerSourceRelationEnabled;
    }

    public CassandraSourceRelation apply(TableRef tableRef, SQLContext sqlContext, CassandraSourceOptions options, Option<StructType> schema2) {
        Option option;
        block4: {
            String string;
            block8: {
                Product product;
                WriteConf writeConf;
                ReadConf readConf;
                Option tableSizeInBytes;
                CassandraConnector cassandraConnector;
                SparkConf conf;
                block6: {
                    block7: {
                        block5: {
                            Option option2;
                            VolatileByteRef bitmap$0;
                            ObjectRef proxyUser$lzy;
                            block3: {
                                block2: {
                                    proxyUser$lzy = ObjectRef.zero();
                                    bitmap$0 = VolatileByteRef.create((byte)0);
                                    SparkConf sparkConf = sqlContext.sparkContext().getConf();
                                    Map sqlConf = sqlContext.getAllConfs();
                                    conf = this.consolidateConfs(sparkConf, (Map<String, String>)sqlConf, tableRef, options.cassandraConfs());
                                    Option tableSizeInBytesString = conf.getOption(this.TableSizeInBytesParam().name());
                                    cassandraConnector = new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
                                    option = tableSizeInBytesString;
                                    if (!(option instanceof Some)) break block2;
                                    Some some = (Some)option;
                                    String size = (String)some.x();
                                    option2 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(size)).toLong()));
                                    break block3;
                                }
                                if (!None$.MODULE$.equals(option)) break block4;
                                TokenFactory<Object, Token> tokenFactory = TokenFactory$.MODULE$.forSystemLocalPartitioner(cassandraConnector);
                                long dataSizeInBytes2 = new DataSizeEstimates<Object, Token>(cassandraConnector, tableRef.keyspace(), tableRef.table(), tokenFactory).totalDataSizeInBytes();
                                option2 = dataSizeInBytes2 <= 0L ? None$.MODULE$ : Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)dataSizeInBytes2));
                            }
                            tableSizeInBytes = option2;
                            ReadConf rc = ReadConf$.MODULE$.fromSparkConf(conf);
                            Option x$88 = rc.executeAs().orElse((Function0)new Serializable(sqlContext, proxyUser$lzy, bitmap$0){
                                public static final long serialVersionUID = 0L;
                                private final SQLContext sqlContext$1;
                                private final ObjectRef proxyUser$lzy$1;
                                private final VolatileByteRef bitmap$0$1;

                                public final Option<String> apply() {
                                    return CassandraSourceRelation$.MODULE$.org$apache$spark$sql$cassandra$CassandraSourceRelation$$proxyUser$1(this.sqlContext$1, this.proxyUser$lzy$1, this.bitmap$0$1);
                                }
                                {
                                    this.sqlContext$1 = sqlContext$1;
                                    this.proxyUser$lzy$1 = proxyUser$lzy$1;
                                    this.bitmap$0$1 = bitmap$0$1;
                                }
                            });
                            Option<Object> x$89 = rc.copy$default$1();
                            int x$90 = rc.copy$default$2();
                            int x$91 = rc.copy$default$3();
                            ConsistencyLevel x$92 = rc.copy$default$4();
                            boolean x$93 = rc.copy$default$5();
                            Option<Object> x$94 = rc.copy$default$6();
                            Option<Object> x$95 = rc.copy$default$7();
                            int x$96 = rc.copy$default$8();
                            readConf = rc.copy(x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, (Option<String>)x$88);
                            WriteConf wc = WriteConf$.MODULE$.fromSparkConf(conf);
                            Option x$97 = wc.executeAs().orElse((Function0)new Serializable(sqlContext, proxyUser$lzy, bitmap$0){
                                public static final long serialVersionUID = 0L;
                                private final SQLContext sqlContext$1;
                                private final ObjectRef proxyUser$lzy$1;
                                private final VolatileByteRef bitmap$0$1;

                                public final Option<String> apply() {
                                    return CassandraSourceRelation$.MODULE$.org$apache$spark$sql$cassandra$CassandraSourceRelation$$proxyUser$1(this.sqlContext$1, this.proxyUser$lzy$1, this.bitmap$0$1);
                                }
                                {
                                    this.sqlContext$1 = sqlContext$1;
                                    this.proxyUser$lzy$1 = proxyUser$lzy$1;
                                    this.bitmap$0$1 = bitmap$0$1;
                                }
                            });
                            BatchSize x$98 = wc.copy$default$1();
                            int x$99 = wc.copy$default$2();
                            BatchGroupingKey x$100 = wc.copy$default$3();
                            ConsistencyLevel x$101 = wc.copy$default$4();
                            boolean x$102 = wc.copy$default$5();
                            boolean x$103 = wc.copy$default$6();
                            int x$104 = wc.copy$default$7();
                            Option<Object> x$105 = wc.copy$default$8();
                            TTLOption x$106 = wc.copy$default$9();
                            TimestampOption x$107 = wc.copy$default$10();
                            boolean x$108 = wc.copy$default$11();
                            writeConf = wc.copy(x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, (Option<String>)x$97);
                            string = conf.get(this.DirectJoinSettingParam().name(), this.DirectJoinSettingParam().default()).toLowerCase();
                            if (!"auto".equals(string)) break block5;
                            product = Automatic$.MODULE$;
                            break block6;
                        }
                        if (!"on".equals(string)) break block7;
                        product = AlwaysOn$.MODULE$;
                        break block6;
                    }
                    if (!"off".equals(string)) break block8;
                    product = AlwaysOff$.MODULE$;
                }
                Automatic$ directJoinSetting = product;
                return new CassandraSourceRelation(tableRef, schema2, options.pushdown(), options.confirmTruncate(), (Option<Object>)tableSizeInBytes, cassandraConnector, readConf, writeConf, conf, sqlContext, directJoinSetting);
            }
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", " is not a valid ", " value.\n               |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, this.DirectJoinSettingParam().name(), this.DirectJoinSettingParam().description()})))).stripMargin());
        }
        throw new MatchError((Object)option);
    }

    public DirectJoinSetting apply$default$11() {
        return Automatic$.MODULE$;
    }

    public SparkConf consolidateConfs(SparkConf sparkConf, Map<String, String> sqlConf, TableRef tableRef, Map<String, String> tableConf) {
        SparkConf conf = sparkConf.clone();
        String cluster = (String)tableRef.cluster().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return CassandraSourceRelation$.MODULE$.defaultClusterName();
            }
        });
        String ks = tableRef.keyspace();
        Seq AllSCCConfNames = (Seq)ConfigParameter$.MODULE$.names().$plus$plus(DeprecatedConfigParameter$.MODULE$.names(), Seq$.MODULE$.canBuildFrom());
        AllSCCConfNames.foreach((Function1)new Serializable(sqlConf, tableConf, conf, cluster, ks){
            public static final long serialVersionUID = 0L;
            private final Map sqlConf$1;
            private final Map tableConf$1;
            public final SparkConf conf$1;
            private final String cluster$1;
            private final String ks$1;

            public final void apply(String prop) {
                Option value2 = ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{this.tableConf$1.get((Object)prop.toLowerCase(Locale.ROOT)), this.sqlConf$1.get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cluster$1, this.ks$1, prop}))), this.sqlConf$1.get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cluster$1, prop}))), this.sqlConf$1.get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop}))), this.sqlConf$1.get((Object)prop)})).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<String> apply(Option<String> xo) {
                        return Option$.MODULE$.option2Iterable(xo);
                    }
                })).headOption();
                value2.foreach((Function1)new Serializable(this, prop){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.consolidateConfs.1 $outer;
                    private final String prop$1;

                    public final SparkConf apply(String x$19) {
                        return this.$outer.conf$1.set(this.prop$1, x$19);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.prop$1 = prop$1;
                    }
                });
            }
            {
                this.sqlConf$1 = sqlConf$1;
                this.tableConf$1 = tableConf$1;
                this.conf$1 = conf$1;
                this.cluster$1 = cluster$1;
                this.ks$1 = ks$1;
            }
        });
        conf.setAll((Traversable)tableConf.$minus$minus((GenTraversableOnce)AllSCCConfNames));
        return conf;
    }

    private Option<String> getProxyUser(SQLContext sqlContext) {
        ObjectRef user$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        boolean doAsEnabled = this.hiveConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        String string = this.hiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION).toUpperCase();
        boolean bl = !"NONE".equals(string);
        boolean authenticationEnabled = bl;
        return doAsEnabled && authenticationEnabled ? new Some((Object)this.user$1(user$lzy, bitmap$0).getUserName()) : None$.MODULE$;
    }

    public <K> Dataset<K> setDirectJoin(Dataset<K> ds, DirectJoinSetting directJoinSetting, Encoder<K> evidence$1) {
        LogicalPlan oldPlan = ds.queryExecution().logical();
        return Dataset$.MODULE$.apply(ds.sparkSession(), (LogicalPlan)oldPlan.transform((PartialFunction)new Serializable(directJoinSetting){
            public static final long serialVersionUID = 0L;
            private final DirectJoinSetting directJoinSetting$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                LogicalRelation logicalRelation;
                BaseRelation cassandraSourceRelation;
                A1 A1 = x3;
                if (A1 instanceof LogicalRelation && (cassandraSourceRelation = (logicalRelation = (LogicalRelation)A1).relation()) instanceof CassandraSourceRelation) {
                    CassandraSourceRelation cassandraSourceRelation2 = (CassandraSourceRelation)cassandraSourceRelation;
                    object = logicalRelation.copy((BaseRelation)cassandraSourceRelation2.withDirectJoin(this.directJoinSetting$1), logicalRelation.copy$default$2(), logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x3) {
                LogicalRelation logicalRelation;
                BaseRelation cassandraSourceRelation;
                LogicalPlan logicalPlan = x3;
                boolean bl = logicalPlan instanceof LogicalRelation && (cassandraSourceRelation = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof CassandraSourceRelation;
                return bl;
            }
            {
                this.directJoinSetting$1 = directJoinSetting$1;
            }
        }), evidence$1);
    }

    public <K> DirectJoinSetting setDirectJoin$default$2() {
        return AlwaysOn$.MODULE$;
    }

    public CassandraSourceRelation apply(TableRef tableRef, Option<StructType> userSpecifiedSchema, boolean filterPushdown, boolean confirmTruncate, Option<Object> tableSizeInBytes, CassandraConnector connector, ReadConf readConf, WriteConf writeConf, SparkConf sparkConf, SQLContext sqlContext, DirectJoinSetting directJoinSetting) {
        return new CassandraSourceRelation(tableRef, userSpecifiedSchema, filterPushdown, confirmTruncate, tableSizeInBytes, connector, readConf, writeConf, sparkConf, sqlContext, directJoinSetting);
    }

    public Option<Tuple11<TableRef, Option<StructType>, Object, Object, Option<Object>, CassandraConnector, ReadConf, WriteConf, SparkConf, SQLContext, DirectJoinSetting>> unapply(CassandraSourceRelation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)x$0.tableRef(), x$0.userSpecifiedSchema(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.filterPushdown()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.confirmTruncate()), x$0.tableSizeInBytes(), (Object)x$0.connector(), (Object)x$0.readConf(), (Object)x$0.writeConf(), (Object)x$0.sparkConf(), (Object)x$0.sqlContext(), (Object)x$0.directJoinSetting()));
    }

    public DirectJoinSetting $lessinit$greater$default$11() {
        return Automatic$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Option proxyUser$lzycompute$1(SQLContext sqlContext$1, ObjectRef proxyUser$lzy$1, VolatileByteRef bitmap$0$1) {
        CassandraSourceRelation$ cassandraSourceRelation$ = this;
        synchronized (cassandraSourceRelation$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                proxyUser$lzy$1.elem = this.proxyPerSourceRelationEnabled() ? this.getProxyUser(sqlContext$1) : None$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Option)proxyUser$lzy$1.elem;
        }
    }

    public final Option org$apache$spark$sql$cassandra$CassandraSourceRelation$$proxyUser$1(SQLContext sqlContext$1, ObjectRef proxyUser$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.proxyUser$lzycompute$1(sqlContext$1, proxyUser$lzy$1, bitmap$0$1) : (Option)proxyUser$lzy$1.elem;
    }

    private final UserGroupInformation user$lzycompute$1(ObjectRef user$lzy$1, VolatileByteRef bitmap$0$2) {
        CassandraSourceRelation$ cassandraSourceRelation$ = this;
        synchronized (cassandraSourceRelation$) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                user$lzy$1.elem = UserGroupInformation.getCurrentUser();
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return (UserGroupInformation)user$lzy$1.elem;
        }
    }

    private final UserGroupInformation user$1(ObjectRef user$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? this.user$lzycompute$1(user$lzy$1, bitmap$0$2) : (UserGroupInformation)user$lzy$1.elem;
    }

    private CassandraSourceRelation$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.ReferenceSection = "Cassandra Datasource Parameters";
        this.TableOptions = "Cassandra Datasource Table Options";
        this.TableSizeInBytesParam = ConfigParameter$.MODULE$.apply("spark.cassandra.table.size.in.bytes", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Used by DataFrames Internally, will be updated in a future release to\n        |retrieve size from Cassandra. Can be set manually now")).stripMargin());
        this.WriteTimeParam = ConfigParameter$.MODULE$.apply("writetime", this.TableOptions(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Surfaces the Cassandra Row Writetime as a Column\n        |with the named specified. When reading use writetime.columnName=aliasForWritetime. This\n        |can be done for every column with a writetime. When Writing use writetime=columnName and the\n        |columname will be used to set the writetime for that row.")).stripMargin());
        this.TTLParam = ConfigParameter$.MODULE$.apply("ttl", this.TableOptions(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Surfaces the Cassandra Row TTL as a Column\n        |with the named specified. When reading use ttl.columnName=aliasForTTL. This\n        |can be done for every column with a TTL. When writing use writetime=columnName and the\n        |columname will be used to set the TTL for that row.")).stripMargin());
        this.AdditionalCassandraPushDownRulesParam = ConfigParameter$.MODULE$.apply("spark.cassandra.sql.pushdown.additionalClasses", this.ReferenceSection(), List$.MODULE$.empty(), new StringOps(Predef$.MODULE$.augmentString("A comma separated list of classes to be used (in order) to apply additional\n        | pushdown rules for Cassandra Dataframes. Classes must implement CassandraPredicateRules\n      ")).stripMargin());
        this.SearchPredicateOptimizationRatioParam = ConfigParameter$.MODULE$.apply("spark.sql.dse.search.autoRatio", this.ReferenceSection(), BoxesRunTime.boxToDouble((double)0.03), "When Search Predicate Optimization is set to auto, Search optimizations will be preformed if this parameter * the total number of rows is greater than the number of rows to be returned by the solr query");
        this.SearchPredicateOptimizationParam = ConfigParameter$.MODULE$.apply("spark.sql.dse.search.enableOptimization", this.ReferenceSection(), "auto", new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Enables SparkSQL to automatically replace Cassandra Pushdowns with DSE Search\n        |Pushdowns utilizing lucene indexes. Valid options are On, Off, and Auto. Auto enables\n        |optimizations when the solr query will pull less than ", " * the\n        |total table record count"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SearchPredicateOptimizationRatioParam().name()})))).stripMargin());
        String x$73 = "spark.sql.dse.solr.enable_optimization";
        Some x$74 = new Some(this.SearchPredicateOptimizationParam());
        String x$75 = "DSE 6.0.0";
        Function1<String, String> x$76 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        String x$77 = DeprecatedConfigParameter$.MODULE$.apply$default$5();
        this.SolrPredciateOptimizationParam = DeprecatedConfigParameter$.MODULE$.apply(x$73, x$74, x$76, x$75, x$77);
        this.DirectJoinSizeRatioParam = ConfigParameter$.MODULE$.apply("directJoinSizeRatio", this.TableOptions(), BoxesRunTime.boxToDouble((double)0.9), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | Sets the threshold on when to perform a DirectJoin in place of a full table scan. When\n         | the size of the (CassandraSource * thisParameter) > The other side of the join, A direct\n         | join will be performed if possible.\n      "})).s((Seq)Nil$.MODULE$))).stripMargin());
        this.DirectJoinSettingParam = ConfigParameter$.MODULE$.apply("directJoinSetting", this.TableOptions(), "auto", new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Acceptable values, \"on\", \"off\", \"auto\"\n        |\"on\" causes a direct join to happen if possible regardless of size ratio.\n        |\"off\" disables direct join even when possible\n        |\"auto\" only does a direct join when the size ratio is satisfied see ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DirectJoinSizeRatioParam().name()})))).stripMargin());
        this.InClauseToJoinWithTableConversionThreshold = ConfigParameter$.MODULE$.apply("spark.cassandra.sql.inClauseToJoinConversionThreshold", this.ReferenceSection(), BoxesRunTime.boxToLong((long)2500L), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Queries with `IN` clause(s) are converted to JoinWithCassandraTable operation if the size of cross\n           |product of all `IN` value sets exceeds this value. To disable `IN` clause conversion, set this setting to 0.\n           |Query `select * from t where k1 in (1,2,3) and k2 in (1,2) and k3 in (1,2,3,4)` has 3 sets of `IN` values.\n           |Cross product of these values has size of 24.\n         "})).s((Seq)Nil$.MODULE$))).stripMargin());
        String x$78 = "spark.sql.dse.inClauseToJoinConversionThreshold";
        Some x$79 = new Some(this.InClauseToJoinWithTableConversionThreshold());
        String x$80 = "3.0.0";
        String x$81 = "Renamed since this is no longer DSE Specific";
        Function1<String, String> x$82 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        this.DseInClauseToJoinWithTableConversionThreshold = DeprecatedConfigParameter$.MODULE$.apply(x$78, x$79, x$82, x$80, x$81);
        this.InClauseToFullTableScanConversionThreshold = ConfigParameter$.MODULE$.apply("spark.cassandra.sql.inClauseToFullScanConversionThreshold", this.ReferenceSection(), BoxesRunTime.boxToLong((long)20000000L), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Queries with `IN` clause(s) are not converted to JoinWithCassandraTable operation if the size of cross\n           |product of all `IN` value sets exceeds this value. It is meant to stop conversion for huge `IN` values sets\n           |that may cause memory problems. If this limit is exceeded full table scan is performed.\n           |This setting takes precedence over ", ".\n           |Query `select * from t where k1 in (1,2,3) and k2 in (1,2) and k3 in (1,2,3,4)` has 3 sets of `IN` values.\n           |Cross product of these values has size of 24.\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.InClauseToJoinWithTableConversionThreshold().name()})))).stripMargin());
        String x$83 = "spark.sql.dse.inClauseToFullScanConversionThreshold";
        Some x$84 = new Some(this.InClauseToFullTableScanConversionThreshold());
        String x$85 = "3.0.0";
        String x$86 = "Renamed because this is no longer DSE Specific";
        Function1<String, String> x$87 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        this.DseInClauseToFullTableScanConversionThreshold = DeprecatedConfigParameter$.MODULE$.apply(x$83, x$84, x$87, x$85, x$86);
        this.IgnoreMissingMetaColumns = ConfigParameter$.MODULE$.apply("ignoreMissingMetaColumns", this.TableOptions(), BoxesRunTime.boxToBoolean((boolean)false), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Acceptable values, \"true\", \"false\"\n         |\"true\" ignore missing meta properties\n         |\"false\" throw error if missing property is requested\n      "})).s((Seq)Nil$.MODULE$))).stripMargin());
        this.defaultClusterName = "default";
        this.proxyPerSourceRelationEnabled = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"DSE_ENABLE_PROXY_PER_SRC_RELATION", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "false";
            }
        }))).toBoolean();
    }
}

