/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class InClausePredicateRules$
implements CassandraPredicateRules,
Logging {
    public static final InClausePredicateRules$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new InClausePredicateRules$();
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public long inCrossProductSize(Set<Filter> filters) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)filters.toSeq().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof In) {
                    In in = (In)A1;
                    object = BoxesRunTime.boxToInteger((int)in.values().length);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x1) {
                Filter filter = x1;
                boolean bl = filter instanceof In;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private AnalyzedPredicates pushFiltersToSpark(AnalyzedPredicates predicates, Set<Filter> filters) {
        Set x$2 = (Set)predicates.handledBySpark().$plus$plus(filters);
        Set x$3 = (Set)predicates.handledByCassandra().$minus$minus(filters);
        return predicates.copy((Set<Filter>)x$3, (Set<Filter>)x$2);
    }

    private Set<Filter> columnsFilters(Set<Filter> filters, Seq<ColumnDef> columns) {
        return (Set)filters.filter((Function1)new Serializable(columns){
            public static final long serialVersionUID = 0L;
            private final Seq columns$1;

            public final boolean apply(Filter f) {
                return this.columns$1.exists((Function1)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final Filter f$1;

                    public final boolean apply(ColumnDef x$1) {
                        String string = x$1.columnName();
                        String string2 = PredicateOps$FilterOps$.MODULE$.columnName(this.f$1);
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
            }
            {
                this.columns$1 = columns$1;
            }
        });
    }

    private AnalyzedPredicates filterOutHugeInClausePredicates(AnalyzedPredicates predicates, TableDef tableDef, SparkConf sparkConf) {
        AnalyzedPredicates analyzedPredicates;
        long clusteringCartesianSize;
        long fullTableScanConversionThreshold = sparkConf.getLong(CassandraSourceRelation$.MODULE$.InClauseToFullTableScanConversionThreshold().name(), BoxesRunTime.unboxToLong((Object)CassandraSourceRelation$.MODULE$.InClauseToFullTableScanConversionThreshold().default()));
        Set inFilters = (Set)predicates.handledByCassandra().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Filter p) {
                return PredicateOps$FilterOps$.MODULE$.isInPredicate(p);
            }
        });
        Set<Filter> partitionColumnsFilters = this.columnsFilters((Set<Filter>)inFilters, (Seq<ColumnDef>)tableDef.partitionKey());
        Set<Filter> clusteringColumnsFilters = this.columnsFilters((Set<Filter>)inFilters, (Seq<ColumnDef>)tableDef.clusteringColumns());
        long partitionCartesianSize = this.inCrossProductSize(partitionColumnsFilters);
        if (partitionCartesianSize * (clusteringCartesianSize = this.inCrossProductSize(clusteringColumnsFilters)) < fullTableScanConversionThreshold) {
            analyzedPredicates = predicates;
        } else if (partitionCartesianSize < fullTableScanConversionThreshold) {
            this.logInfo((Function0<String>)new Serializable(fullTableScanConversionThreshold){
                public static final long serialVersionUID = 0L;
                private final long fullTableScanConversionThreshold$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of key combinations in 'IN' clauses exceeds ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CassandraSourceRelation$.MODULE$.InClauseToFullTableScanConversionThreshold().name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", "), clustering columns filters are not pushed down."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.fullTableScanConversionThreshold$1)}))).toString();
                }
                {
                    this.fullTableScanConversionThreshold$1 = fullTableScanConversionThreshold$1;
                }
            });
            analyzedPredicates = this.pushFiltersToSpark(predicates, clusteringColumnsFilters);
        } else {
            this.logInfo((Function0<String>)new Serializable(fullTableScanConversionThreshold){
                public static final long serialVersionUID = 0L;
                private final long fullTableScanConversionThreshold$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of key combinations in 'IN' clauses exceeds ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CassandraSourceRelation$.MODULE$.InClauseToFullTableScanConversionThreshold().name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", "), partition key filters are not pushed down. This results in full table "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.fullTableScanConversionThreshold$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scan with Spark side filtering."})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    this.fullTableScanConversionThreshold$1 = fullTableScanConversionThreshold$1;
                }
            });
            analyzedPredicates = this.pushFiltersToSpark(predicates, (Set<Filter>)((Set)partitionColumnsFilters.$plus$plus(clusteringColumnsFilters)));
        }
        return analyzedPredicates;
    }

    @Override
    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef, SparkConf conf) {
        return this.filterOutHugeInClausePredicates(predicates, tableDef, conf);
    }

    private InClausePredicateRules$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

