/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractGettableByIndexData;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.TypeTokens;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.utils.MoreObjects;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import shade.com.datastax.spark.connector.google.common.reflect.TypeToken;

abstract class AbstractAddressableByIndexData<T extends SettableByIndexData<T>>
extends AbstractGettableByIndexData
implements SettableByIndexData<T> {
    final ByteBuffer[] values;

    protected AbstractAddressableByIndexData(ProtocolVersion protocolVersion, int size) {
        super(protocolVersion);
        this.values = new ByteBuffer[size];
    }

    protected T setValue(int i, ByteBuffer value) {
        this.values[i] = value;
        return (T)this;
    }

    @Override
    protected ByteBuffer getValue(int i) {
        return this.values[i];
    }

    @Override
    public T setBool(int i, boolean v) {
        TypeCodec<Class<Boolean>> codec = this.codecFor(i, Boolean.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveBooleanCodec ? ((TypeCodec.PrimitiveBooleanCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Boolean>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setByte(int i, byte v) {
        TypeCodec<Class<Byte>> codec = this.codecFor(i, Byte.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveByteCodec ? ((TypeCodec.PrimitiveByteCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Byte>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setShort(int i, short v) {
        TypeCodec<Class<Short>> codec = this.codecFor(i, Short.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveShortCodec ? ((TypeCodec.PrimitiveShortCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Short>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setInt(int i, int v) {
        TypeCodec<Class<Integer>> codec = this.codecFor(i, Integer.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveIntCodec ? ((TypeCodec.PrimitiveIntCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Integer>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setLong(int i, long v) {
        TypeCodec<Class<Long>> codec = this.codecFor(i, Long.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveLongCodec ? ((TypeCodec.PrimitiveLongCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Long>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setTimestamp(int i, Date v) {
        return this.setValue(i, this.codecFor(i, Date.class).serialize((Class<Date>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setDate(int i, LocalDate v) {
        return this.setValue(i, this.codecFor(i, LocalDate.class).serialize((Class<LocalDate>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setTime(int i, long v) {
        TypeCodec<Class<Long>> codec = this.codecFor(i, Long.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveLongCodec ? ((TypeCodec.PrimitiveLongCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Long>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setFloat(int i, float v) {
        TypeCodec<Class<Float>> codec = this.codecFor(i, Float.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveFloatCodec ? ((TypeCodec.PrimitiveFloatCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Float>)((Object)Float.valueOf(v)), this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setDouble(int i, double v) {
        TypeCodec<Class<Double>> codec = this.codecFor(i, Double.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveDoubleCodec ? ((TypeCodec.PrimitiveDoubleCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Double>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setString(int i, String v) {
        return this.setValue(i, this.codecFor(i, String.class).serialize((Class<String>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setBytes(int i, ByteBuffer v) {
        return this.setValue(i, this.codecFor(i, ByteBuffer.class).serialize((Class<ByteBuffer>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setBytesUnsafe(int i, ByteBuffer v) {
        return this.setValue(i, v == null ? null : v.duplicate());
    }

    @Override
    public T setVarint(int i, BigInteger v) {
        return this.setValue(i, this.codecFor(i, BigInteger.class).serialize((Class<BigInteger>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setDecimal(int i, BigDecimal v) {
        return this.setValue(i, this.codecFor(i, BigDecimal.class).serialize((Class<BigDecimal>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setUUID(int i, UUID v) {
        return this.setValue(i, this.codecFor(i, UUID.class).serialize((Class<UUID>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setInet(int i, InetAddress v) {
        return this.setValue(i, this.codecFor(i, InetAddress.class).serialize((Class<InetAddress>)((Object)v), this.protocolVersion));
    }

    @Override
    public <E> T setList(int i, List<E> v) {
        return this.setValue(i, this.codecFor(i).serialize(v, this.protocolVersion));
    }

    @Override
    public <E> T setList(int i, List<E> v, Class<E> elementsClass) {
        return this.setValue(i, this.codecFor(i, TypeTokens.listOf(elementsClass)).serialize((TypeToken<List<E>>)((Object)v), this.protocolVersion));
    }

    @Override
    public <E> T setList(int i, List<E> v, TypeToken<E> elementsType) {
        return this.setValue(i, this.codecFor(i, TypeTokens.listOf(elementsType)).serialize((TypeToken<List<E>>)((Object)v), this.protocolVersion));
    }

    @Override
    public <K, V> T setMap(int i, Map<K, V> v) {
        return this.setValue(i, this.codecFor(i).serialize(v, this.protocolVersion));
    }

    @Override
    public <K, V> T setMap(int i, Map<K, V> v, Class<K> keysClass, Class<V> valuesClass) {
        return this.setValue(i, this.codecFor(i, TypeTokens.mapOf(keysClass, valuesClass)).serialize((TypeToken<Map<K, V>>)((Object)v), this.protocolVersion));
    }

    @Override
    public <K, V> T setMap(int i, Map<K, V> v, TypeToken<K> keysType, TypeToken<V> valuesType) {
        return this.setValue(i, this.codecFor(i, TypeTokens.mapOf(keysType, valuesType)).serialize((TypeToken<Map<K, V>>)((Object)v), this.protocolVersion));
    }

    @Override
    public <E> T setSet(int i, Set<E> v) {
        return this.setValue(i, this.codecFor(i).serialize(v, this.protocolVersion));
    }

    @Override
    public <E> T setSet(int i, Set<E> v, Class<E> elementsClass) {
        return this.setValue(i, this.codecFor(i, TypeTokens.setOf(elementsClass)).serialize((TypeToken<Set<E>>)((Object)v), this.protocolVersion));
    }

    @Override
    public <E> T setSet(int i, Set<E> v, TypeToken<E> elementsType) {
        return this.setValue(i, this.codecFor(i, TypeTokens.setOf(elementsType)).serialize((TypeToken<Set<E>>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setUDTValue(int i, UDTValue v) {
        return this.setValue(i, this.codecFor(i, UDTValue.class).serialize((Class<UDTValue>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setTupleValue(int i, TupleValue v) {
        return this.setValue(i, this.codecFor(i, TupleValue.class).serialize((Class<TupleValue>)((Object)v), this.protocolVersion));
    }

    @Override
    public <V> T set(int i, V v, Class<V> targetClass) {
        return this.set(i, v, this.codecFor(i, targetClass));
    }

    @Override
    public <V> T set(int i, V v, TypeToken<V> targetType) {
        return this.set(i, v, this.codecFor(i, targetType));
    }

    @Override
    public <V> T set(int i, V v, TypeCodec<V> codec) {
        this.checkType(i, codec.getCqlType().getName());
        return this.setValue(i, codec.serialize(v, this.protocolVersion));
    }

    @Override
    public T setToNull(int i) {
        return this.setValue(i, null);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractAddressableByIndexData)) {
            return false;
        }
        AbstractAddressableByIndexData that = (AbstractAddressableByIndexData)o;
        if (this.values.length != that.values.length) {
            return false;
        }
        if (this.protocolVersion != that.protocolVersion) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            Object thatValue;
            DataType thatType;
            DataType thisType = this.getType(i);
            if (!thisType.equals(thatType = that.getType(i))) {
                return false;
            }
            Object thisValue = this.codecFor(i).deserialize(this.values[i], this.protocolVersion);
            if (MoreObjects.equal(thisValue, thatValue = that.codecFor(i).deserialize(that.values[i], that.protocolVersion))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 31;
        for (int i = 0; i < this.values.length; ++i) {
            hash += this.values[i] == null ? 1 : this.codecFor(i).deserialize(this.values[i], this.protocolVersion).hashCode();
        }
        return hash;
    }
}

