/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.UnresolvedUserTypeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableMap;

class DataTypeCqlNameParser {
    private static final String FROZEN = "frozen";
    private static final String LIST = "list";
    private static final String SET = "set";
    private static final String MAP = "map";
    private static final String TUPLE = "tuple";
    private static final String EMPTY = "empty";
    private static final ImmutableMap<String, DataType> NATIVE_TYPES_MAP = new ImmutableMap.Builder<String, DataType>().put("ascii", DataType.ascii()).put("bigint", DataType.bigint()).put("blob", DataType.blob()).put("boolean", DataType.cboolean()).put("counter", DataType.counter()).put("decimal", DataType.decimal()).put("double", DataType.cdouble()).put("float", DataType.cfloat()).put("inet", DataType.inet()).put("int", DataType.cint()).put("text", DataType.text()).put("varchar", DataType.varchar()).put("timestamp", DataType.timestamp()).put("date", DataType.date()).put("time", DataType.time()).put("uuid", DataType.uuid()).put("varint", DataType.varint()).put("timeuuid", DataType.timeuuid()).put("tinyint", DataType.tinyint()).put("smallint", DataType.smallint()).put("duration", DataType.duration()).build();

    DataTypeCqlNameParser() {
    }

    static DataType parse(String toParse, Cluster cluster, String currentKeyspaceName, Map<String, UserType> currentUserTypes, Map<String, UserType> oldUserTypes, boolean frozen, boolean shallowUserTypes) {
        if (toParse.startsWith("'")) {
            return DataType.custom(toParse.substring(1, toParse.length() - 1));
        }
        Parser parser = new Parser(toParse, 0);
        String type = parser.parseTypeName();
        DataType nativeType = NATIVE_TYPES_MAP.get(type.toLowerCase());
        if (nativeType != null) {
            return nativeType;
        }
        if (parser.isEOS()) {
            if (type.equalsIgnoreCase(EMPTY)) {
                return DataType.custom(type);
            }
            if (shallowUserTypes) {
                return new UserType.Shallow(currentKeyspaceName, Metadata.handleId(type), frozen);
            }
            UserType userType = null;
            if (currentUserTypes != null) {
                userType = currentUserTypes.get(Metadata.handleId(type));
            }
            if (userType == null && oldUserTypes != null) {
                userType = oldUserTypes.get(Metadata.handleId(type));
            }
            if (userType == null) {
                throw new UnresolvedUserTypeException(currentKeyspaceName, type);
            }
            return userType.copy(frozen);
        }
        List<String> parameters = parser.parseTypeParameters();
        if (type.equalsIgnoreCase(LIST)) {
            if (parameters.size() != 1) {
                throw new DriverInternalError(String.format("Excepting single parameter for list, got %s", parameters));
            }
            DataType elementType = DataTypeCqlNameParser.parse(parameters.get(0), cluster, currentKeyspaceName, currentUserTypes, oldUserTypes, false, shallowUserTypes);
            return DataType.list(elementType, frozen);
        }
        if (type.equalsIgnoreCase(SET)) {
            if (parameters.size() != 1) {
                throw new DriverInternalError(String.format("Excepting single parameter for set, got %s", parameters));
            }
            DataType elementType = DataTypeCqlNameParser.parse(parameters.get(0), cluster, currentKeyspaceName, currentUserTypes, oldUserTypes, false, shallowUserTypes);
            return DataType.set(elementType, frozen);
        }
        if (type.equalsIgnoreCase(MAP)) {
            if (parameters.size() != 2) {
                throw new DriverInternalError(String.format("Excepting two parameters for map, got %s", parameters));
            }
            DataType keyType = DataTypeCqlNameParser.parse(parameters.get(0), cluster, currentKeyspaceName, currentUserTypes, oldUserTypes, false, shallowUserTypes);
            DataType valueType = DataTypeCqlNameParser.parse(parameters.get(1), cluster, currentKeyspaceName, currentUserTypes, oldUserTypes, false, shallowUserTypes);
            return DataType.map(keyType, valueType, frozen);
        }
        if (type.equalsIgnoreCase(FROZEN)) {
            if (parameters.size() != 1) {
                throw new DriverInternalError(String.format("Excepting single parameter for frozen keyword, got %s", parameters));
            }
            return DataTypeCqlNameParser.parse(parameters.get(0), cluster, currentKeyspaceName, currentUserTypes, oldUserTypes, true, shallowUserTypes);
        }
        if (type.equalsIgnoreCase(TUPLE)) {
            if (parameters.isEmpty()) {
                throw new IllegalArgumentException("Expecting at list one parameter for tuple, got none");
            }
            ArrayList<DataType> types = new ArrayList<DataType>(parameters.size());
            for (String rawType : parameters) {
                types.add(DataTypeCqlNameParser.parse(rawType, cluster, currentKeyspaceName, currentUserTypes, oldUserTypes, false, shallowUserTypes));
            }
            return cluster.getMetadata().newTupleType(types);
        }
        throw new IllegalArgumentException("Could not parse type name " + toParse);
    }

    private static class Parser {
        private final String str;
        private int idx;

        Parser(String str, int idx) {
            this.str = str;
            this.idx = idx;
        }

        String parseTypeName() {
            this.idx = ParseUtils.skipSpaces(this.str, this.idx);
            return this.readNextIdentifier();
        }

        List<String> parseTypeParameters() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.isEOS()) {
                return list;
            }
            this.skipBlankAndComma();
            if (this.str.charAt(this.idx) != '<') {
                throw new IllegalStateException();
            }
            ++this.idx;
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == '>') {
                    ++this.idx;
                    return list;
                }
                try {
                    String name = this.parseTypeName();
                    String args = this.readRawTypeParameters();
                    list.add(name + args);
                }
                catch (DriverInternalError e) {
                    DriverInternalError ex = new DriverInternalError(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                    ex.initCause(e);
                    throw ex;
                }
            }
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        private String readNextIdentifier() {
            int startIdx;
            if (this.str.charAt(startIdx = this.idx++) == '\"') {
                while (!this.isEOS()) {
                    boolean atQuote = this.str.charAt(this.idx) == '\"';
                    ++this.idx;
                    if (!atQuote) continue;
                    if (!this.isEOS() && this.str.charAt(this.idx) == '\"') {
                        ++this.idx;
                        continue;
                    }
                    break;
                }
            } else if (this.str.charAt(startIdx) == '\'') {
                ++this.idx;
                while (!this.isEOS() && this.str.charAt(this.idx++) != '\'') {
                }
            } else {
                while (!this.isEOS() && (ParseUtils.isIdentifierChar(this.str.charAt(this.idx)) || this.str.charAt(this.idx) == '\"')) {
                    ++this.idx;
                }
            }
            return this.str.substring(startIdx, this.idx);
        }

        private String readRawTypeParameters() {
            this.idx = ParseUtils.skipSpaces(this.str, this.idx);
            if (this.isEOS() || this.str.charAt(this.idx) == '>' || this.str.charAt(this.idx) == ',') {
                return "";
            }
            if (this.str.charAt(this.idx) != '<') {
                throw new IllegalStateException(String.format("Expecting char %d of %s to be '<' but '%c' found", this.idx, this.str, Character.valueOf(this.str.charAt(this.idx))));
            }
            int i = this.idx;
            int open = 1;
            boolean inQuotes = false;
            while (open > 0) {
                ++this.idx;
                if (this.isEOS()) {
                    throw new IllegalStateException("Non closed angle brackets");
                }
                if (!inQuotes) {
                    if (this.str.charAt(this.idx) == '\"') {
                        inQuotes = true;
                        continue;
                    }
                    if (this.str.charAt(this.idx) == '<') {
                        ++open;
                        continue;
                    }
                    if (this.str.charAt(this.idx) != '>') continue;
                    --open;
                    continue;
                }
                if (this.str.charAt(this.idx) != '\"') continue;
                inQuotes = false;
            }
            ++this.idx;
            return this.str.substring(i, this.idx);
        }

        private boolean skipBlankAndComma() {
            boolean commaFound = false;
            while (!this.isEOS()) {
                char c = this.str.charAt(this.idx);
                if (c == ',') {
                    if (commaFound) {
                        return true;
                    }
                    commaFound = true;
                } else if (!ParseUtils.isBlank(c)) {
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        private boolean isEOS() {
            return this.idx >= this.str.length();
        }

        public String toString() {
            return this.str.substring(0, this.idx) + "[" + (this.idx == this.str.length() ? "" : Character.valueOf(this.str.charAt(this.idx))) + "]" + this.str.substring(this.idx + 1);
        }
    }
}

