/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class ConnectionException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    public final InetSocketAddress address;

    public ConnectionException(InetSocketAddress address, String msg, Throwable cause) {
        super(msg, cause);
        this.address = address;
    }

    public ConnectionException(InetSocketAddress address, String msg) {
        super(msg);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address == null ? null : this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public String getMessage() {
        return this.address == null ? this.getRawMessage() : String.format("[%s] %s", this.address, this.getRawMessage());
    }

    @Override
    public ConnectionException copy() {
        return new ConnectionException(this.address, this.getRawMessage(), this);
    }

    String getRawMessage() {
        return super.getMessage();
    }
}

