/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.utils;

import com.datastax.driver.core.GuavaCompatibility;
import shade.com.datastax.spark.connector.google.common.util.concurrent.FutureCallback;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Futures;
import shade.com.datastax.spark.connector.google.common.util.concurrent.ListenableFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.SettableFuture;

public class MoreFutures {
    public static final ListenableFuture<Void> VOID_SUCCESS = Futures.immediateFuture(null);

    public static <T> void propagateFuture(final SettableFuture<T> settable, ListenableFuture<T> future) {
        GuavaCompatibility.INSTANCE.addCallback(future, new FutureCallback<T>(){

            @Override
            public void onSuccess(T result) {
                settable.set(result);
            }

            @Override
            public void onFailure(Throwable t) {
                settable.setException(t);
            }
        });
    }

    public static abstract class FailureCallback<V>
    implements FutureCallback<V> {
        @Override
        public void onSuccess(V result) {
        }
    }

    public static abstract class SuccessCallback<V>
    implements FutureCallback<V> {
        @Override
        public void onFailure(Throwable t) {
        }
    }
}

