/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.mapping.HierarchyScanStrategy;
import java.util.ArrayList;
import java.util.List;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;

public class DefaultHierarchyScanStrategy
implements HierarchyScanStrategy {
    private final Class<?> highestAncestor;
    private final boolean included;

    public DefaultHierarchyScanStrategy() {
        this(Object.class, false);
    }

    public DefaultHierarchyScanStrategy(Class<?> highestAncestor, boolean included) {
        Preconditions.checkNotNull(highestAncestor);
        this.highestAncestor = highestAncestor;
        this.included = included;
    }

    @Override
    public List<Class<?>> filterClassHierarchy(Class<?> mappedClass) {
        ArrayList classesToScan = new ArrayList();
        Class<?> highestAncestor = this.highestAncestor;
        for (Class<?> clazz = mappedClass; clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.equals(highestAncestor) || this.included) {
                classesToScan.add(clazz);
            }
            if (clazz.equals(highestAncestor)) break;
        }
        return classesToScan;
    }
}

