/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.mapping.AnnotationChecks;
import com.datastax.driver.mapping.DefaultHierarchyScanStrategy;
import com.datastax.driver.mapping.DefaultMappedProperty;
import com.datastax.driver.mapping.DefaultNamingStrategy;
import com.datastax.driver.mapping.HierarchyScanStrategy;
import com.datastax.driver.mapping.MappedProperty;
import com.datastax.driver.mapping.NamingStrategy;
import com.datastax.driver.mapping.PropertyAccessStrategy;
import com.datastax.driver.mapping.PropertyMapper;
import com.datastax.driver.mapping.PropertyTransienceStrategy;
import com.datastax.driver.mapping.annotations.ClusteringColumn;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.Computed;
import com.datastax.driver.mapping.annotations.Field;
import com.datastax.driver.mapping.annotations.Frozen;
import com.datastax.driver.mapping.annotations.FrozenKey;
import com.datastax.driver.mapping.annotations.FrozenValue;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Transient;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;
import shade.com.datastax.spark.connector.google.common.base.Throwables;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableSet;
import shade.com.datastax.spark.connector.google.common.collect.Sets;

public class DefaultPropertyMapper
implements PropertyMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPropertyMapper.class);
    private static final HashSet<String> DEFAULT_TRANSIENT_PROPERTY_NAMES = Sets.newHashSet("class", "metaClass");
    private static final Set<Class<?>> NON_TRANSIENT_ANNOTATIONS = ImmutableSet.of(Column.class, PartitionKey.class, ClusteringColumn.class, Field.class, Computed.class, Frozen.class, new Class[]{FrozenKey.class, FrozenValue.class});
    private static final Set<Class<? extends Annotation>> VALID_COLUMN_ANNOTATIONS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Column.class)).add(Computed.class)).add(ClusteringColumn.class)).add(Frozen.class)).add(FrozenKey.class)).add(FrozenValue.class)).add(PartitionKey.class)).add(Transient.class)).build();
    private static final Set<Class<? extends Annotation>> VALID_FIELD_ANNOTATIONS = ImmutableSet.of(Field.class, Frozen.class, FrozenKey.class, FrozenValue.class, Transient.class);
    private PropertyAccessStrategy propertyAccessStrategy = PropertyAccessStrategy.BOTH;
    private PropertyTransienceStrategy propertyTransienceStrategy = PropertyTransienceStrategy.OPT_OUT;
    private HierarchyScanStrategy hierarchyScanStrategy = new DefaultHierarchyScanStrategy();
    private NamingStrategy namingStrategy = new DefaultNamingStrategy();
    private Set<String> transientPropertyNames = new HashSet<String>(DEFAULT_TRANSIENT_PROPERTY_NAMES);

    public DefaultPropertyMapper setPropertyAccessStrategy(PropertyAccessStrategy propertyAccessStrategy) {
        this.propertyAccessStrategy = Preconditions.checkNotNull(propertyAccessStrategy);
        return this;
    }

    public DefaultPropertyMapper setPropertyTransienceStrategy(PropertyTransienceStrategy propertyTransienceStrategy) {
        this.propertyTransienceStrategy = Preconditions.checkNotNull(propertyTransienceStrategy);
        return this;
    }

    public DefaultPropertyMapper setHierarchyScanStrategy(HierarchyScanStrategy hierarchyScanStrategy) {
        this.hierarchyScanStrategy = Preconditions.checkNotNull(hierarchyScanStrategy);
        return this;
    }

    public DefaultPropertyMapper setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = Preconditions.checkNotNull(namingStrategy);
        return this;
    }

    public DefaultPropertyMapper setTransientPropertyNames(Set<String> transientPropertyNames) {
        this.transientPropertyNames = Preconditions.checkNotNull(transientPropertyNames);
        return this;
    }

    public DefaultPropertyMapper addTransientPropertyNames(String ... transientPropertyNames) {
        return this.addTransientPropertyNames(Arrays.asList((Object[])Preconditions.checkNotNull(transientPropertyNames)));
    }

    public DefaultPropertyMapper addTransientPropertyNames(Collection<String> transientPropertyNames) {
        this.transientPropertyNames.addAll(Preconditions.checkNotNull(transientPropertyNames));
        return this;
    }

    @Override
    public Set<? extends MappedProperty<?>> mapTable(Class<?> tableClass) {
        return this.mapTableOrUdt(tableClass, VALID_COLUMN_ANNOTATIONS);
    }

    @Override
    public Set<? extends MappedProperty<?>> mapUdt(Class<?> udtClass) {
        return this.mapTableOrUdt(udtClass, VALID_FIELD_ANNOTATIONS);
    }

    private Set<? extends MappedProperty<?>> mapTableOrUdt(Class<?> entityClass, Collection<? extends Class<? extends Annotation>> allowed) {
        java.lang.reflect.Field field;
        String propertyName;
        HashMap<String, Object[]> fieldsGettersAndSetters = new HashMap<String, Object[]>();
        List<Class<?>> classHierarchy = this.hierarchyScanStrategy.filterClassHierarchy(entityClass);
        if (this.propertyAccessStrategy.isFieldScanAllowed()) {
            Map<String, java.lang.reflect.Field> fields = DefaultPropertyMapper.scanFields(classHierarchy);
            for (Map.Entry<String, java.lang.reflect.Field> entry : fields.entrySet()) {
                propertyName = entry.getKey();
                field = (java.lang.reflect.Field)DefaultPropertyMapper.tryMakeAccessible((AccessibleObject)entry.getValue());
                fieldsGettersAndSetters.put(propertyName, new Object[]{field, null, null});
            }
        }
        if (this.propertyAccessStrategy.isGetterSetterScanAllowed()) {
            Map<String, PropertyDescriptor> properties = DefaultPropertyMapper.scanProperties(classHierarchy);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                PropertyDescriptor property = (PropertyDescriptor)entry.getValue();
                Method getter = DefaultPropertyMapper.tryMakeAccessible(this.locateGetter(entityClass, property));
                Method setter = DefaultPropertyMapper.tryMakeAccessible(this.locateSetter(entityClass, property));
                Object[] value = (Object[])fieldsGettersAndSetters.get(entry.getKey());
                if (value != null) {
                    value[1] = getter;
                    value[2] = setter;
                    continue;
                }
                if (getter == null && setter == null) continue;
                fieldsGettersAndSetters.put(entry.getKey(), new Object[]{null, getter, setter});
            }
        }
        HashSet mappedProperties = new HashSet(fieldsGettersAndSetters.size());
        for (Map.Entry<String, Object> entry : fieldsGettersAndSetters.entrySet()) {
            propertyName = entry.getKey();
            field = (java.lang.reflect.Field)((Object[])entry.getValue())[0];
            Method getter = (Method)((Object[])entry.getValue())[1];
            Method setter = (Method)((Object[])entry.getValue())[2];
            Map<Class<? extends Annotation>, Annotation> annotations = DefaultPropertyMapper.scanPropertyAnnotations(field, getter);
            AnnotationChecks.validateAnnotations(propertyName, annotations, allowed);
            if (this.isTransient(propertyName, field, getter, setter, annotations)) {
                LOGGER.debug(String.format("Property '%s' is transient and will not be mapped", propertyName));
                continue;
            }
            if (!annotations.containsKey(Computed.class) && field == null && getter == null) {
                throw new IllegalArgumentException(String.format("Property '%s' is not readable", propertyName));
            }
            if (field == null && setter == null) {
                throw new IllegalArgumentException(String.format("Property '%s' is not writable", propertyName));
            }
            String mappedName = this.inferMappedName(entityClass, propertyName, annotations);
            MappedProperty<?> property = this.createMappedProperty(entityClass, propertyName, mappedName, field, getter, setter, annotations);
            mappedProperties.add(property);
        }
        return mappedProperties;
    }

    protected boolean isTransient(String propertyName, java.lang.reflect.Field field, Method getter, Method setter, Map<Class<? extends Annotation>, Annotation> annotations) {
        if (this.propertyTransienceStrategy == PropertyTransienceStrategy.OPT_OUT) {
            return annotations.containsKey(Transient.class) || this.transientPropertyNames.contains(propertyName) && Collections.disjoint(annotations.keySet(), NON_TRANSIENT_ANNOTATIONS);
        }
        return Collections.disjoint(annotations.keySet(), NON_TRANSIENT_ANNOTATIONS);
    }

    protected Method locateGetter(Class<?> mappedClass, PropertyDescriptor property) {
        return property.getReadMethod();
    }

    protected Method locateSetter(Class<?> mappedClass, PropertyDescriptor property) {
        Method setter = property.getWriteMethod();
        if (setter == null) {
            String propertyName = property.getName();
            String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            try {
                Method m = mappedClass.getMethod(setterName, property.getPropertyType());
                if (!Modifier.isStatic(m.getModifiers())) {
                    setter = m;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return setter;
    }

    protected String inferMappedName(Class<?> mappedClass, String propertyName, Map<Class<? extends Annotation>, Annotation> annotations) {
        if (annotations.containsKey(Computed.class)) {
            String expression = ((Computed)annotations.get(Computed.class)).value();
            if (expression.isEmpty()) {
                throw new IllegalArgumentException(String.format("Property '%s': attribute 'value' of annotation @Computed is mandatory for computed properties", propertyName));
            }
            return expression;
        }
        boolean caseSensitive = false;
        String mappedName = null;
        if (annotations.containsKey(Column.class)) {
            Column column = (Column)annotations.get(Column.class);
            caseSensitive = column.caseSensitive();
            if (!column.name().isEmpty()) {
                mappedName = column.name();
            }
        } else if (annotations.containsKey(Field.class)) {
            Field udtMappedField = (Field)annotations.get(Field.class);
            caseSensitive = udtMappedField.caseSensitive();
            if (!udtMappedField.name().isEmpty()) {
                mappedName = udtMappedField.name();
            }
        }
        if (mappedName != null) {
            return caseSensitive ? Metadata.quote(mappedName) : mappedName.toLowerCase();
        }
        mappedName = this.namingStrategy.toCassandraName(propertyName);
        if (mappedName == null || mappedName.isEmpty()) {
            throw new IllegalArgumentException(String.format("Property '%s': could not infer mapped name", propertyName));
        }
        return Metadata.quoteIfNecessary(mappedName);
    }

    protected MappedProperty<?> createMappedProperty(Class<?> mappedClass, String propertyName, String mappedName, java.lang.reflect.Field field, Method getter, Method setter, Map<Class<? extends Annotation>, Annotation> annotations) {
        return DefaultMappedProperty.create(mappedClass, propertyName, mappedName, field, getter, setter, annotations);
    }

    private static Map<String, java.lang.reflect.Field> scanFields(List<Class<?>> classHierarchy) {
        HashMap<String, java.lang.reflect.Field> fields = new HashMap<String, java.lang.reflect.Field>();
        for (Class<?> clazz : classHierarchy) {
            for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        }
        return fields;
    }

    private static Map<String, PropertyDescriptor> scanProperties(List<Class<?>> classHierarchy) {
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        for (Class<?> clazz : classHierarchy) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(clazz, clazz.getSuperclass());
            }
            catch (IntrospectionException e) {
                throw Throwables.propagate(e);
            }
            for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
                if (properties.containsKey(property.getName())) continue;
                properties.put(property.getName(), property);
            }
        }
        return properties;
    }

    private static Map<Class<? extends Annotation>, Annotation> scanPropertyAnnotations(java.lang.reflect.Field field, Method getter) {
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        if (field != null) {
            DefaultPropertyMapper.scanFieldAnnotations(field, annotations);
        }
        if (getter != null) {
            DefaultPropertyMapper.scanMethodAnnotations(getter, annotations);
        }
        return annotations;
    }

    private static Map<Class<? extends Annotation>, Annotation> scanFieldAnnotations(java.lang.reflect.Field field, Map<Class<? extends Annotation>, Annotation> annotations) {
        for (Annotation annotation : field.getAnnotations()) {
            annotations.put(annotation.annotationType(), annotation);
        }
        return annotations;
    }

    private static Map<Class<? extends Annotation>, Annotation> scanMethodAnnotations(Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        Class<?> clazz;
        for (Annotation annotation : method.getAnnotations()) {
            annotations.put(annotation.annotationType(), annotation);
        }
        Class<?> getterClass = method.getDeclaringClass();
        for (clazz = getterClass.getSuperclass(); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            DefaultPropertyMapper.maybeAddOverriddenMethodAnnotations(annotations, method, clazz);
        }
        clazz = getterClass;
        while (!clazz.equals(Object.class)) {
            for (Class<?> itf : clazz.getInterfaces()) {
                DefaultPropertyMapper.maybeAddOverriddenMethodAnnotations(annotations, method, itf);
            }
            clazz = clazz.getSuperclass();
        }
        return annotations;
    }

    private static void maybeAddOverriddenMethodAnnotations(Map<Class<? extends Annotation>, Annotation> annotations, Method getter, Class<?> clazz) {
        try {
            Method overriddenGetter = clazz.getDeclaredMethod(getter.getName(), getter.getParameterTypes());
            for (Annotation annotation : overriddenGetter.getAnnotations()) {
                if (annotations.containsKey(annotation.annotationType())) continue;
                annotations.put(annotation.annotationType(), annotation);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static <T extends AccessibleObject> T tryMakeAccessible(T object) {
        if (object != null && !object.isAccessible()) {
            try {
                object.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return object;
    }
}

