/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.cql.ClusteringColumn;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.IndexDef;
import com.datastax.spark.connector.cql.PartitionKeyColumn$;
import com.datastax.spark.connector.cql.RegularColumn$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.cql.TableDef$;
import com.datastax.spark.connector.types.ColumnType;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0003\u0006\u0001'!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u00038\u0001\u0011\u0005\u0001\bC\u0004=\u0001\t\u0007I\u0011A\u001f\t\r\t\u0003\u0001\u0015!\u0003?\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u001dY\u0007!%A\u0005\u00021Dqa\u001e\u0001\u0012\u0002\u0013\u0005A\u000eC\u0004y\u0001E\u0005I\u0011A=\u0003%\u0011\u000bG/\u0019$sC6,g)\u001e8di&|gn\u001d\u0006\u0003\u00171\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u00055q\u0011!B:qCJ\\'BA\b\u0011\u0003!!\u0017\r^1ti\u0006D(\"A\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u0003+mI!\u0001\b\f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0013\u0011\fG/\u0019$sC6,\u0007CA\u00105\u001d\t\u0001\u0013G\u0004\u0002\"]9\u0011!\u0005\f\b\u0003G%r!\u0001J\u0014\u000e\u0003\u0015R!A\n\n\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0013aA8sO&\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u0003!J!!D\u0017\u000b\u0005)Z\u0013BA\u00181\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b5J!AM\u001a\u0002\u000fA\f7m[1hK*\u0011q\u0006M\u0005\u0003kY\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005I\u001a\u0014A\u0002\u001fj]&$h\b\u0006\u0002:wA\u0011!\bA\u0007\u0002\u0015!)QD\u0001a\u0001=\u0005a1\u000f]1sW\u000e{g\u000e^3yiV\ta\b\u0005\u0002@\u00016\t\u0001'\u0003\u0002Ba\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006i1\u000f]1sW\u000e{g\u000e^3yi\u0002\nAc\u0019:fCR,7)Y:tC:$'/\u0019+bE2,G#B#Q5rKGC\u0001$J!\t)r)\u0003\u0002I-\t!QK\\5u\u0011\u001dYQ\u0001%AA\u0004)\u0003\"a\u0013(\u000e\u00031S!!\u0014\u0006\u0002\u0007\r\fH.\u0003\u0002P\u0019\n\u00112)Y:tC:$'/Y\"p]:,7\r^8s\u0011\u0015\tV\u00011\u0001S\u00031YW-_:qC\u000e,g*Y7f!\t\u0019vK\u0004\u0002U+B\u0011AEF\u0005\u0003-Z\ta\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011aK\u0006\u0005\u00067\u0016\u0001\rAU\u0001\ni\u0006\u0014G.\u001a(b[\u0016Dq!X\u0003\u0011\u0002\u0003\u0007a,A\nqCJ$\u0018\u000e^5p].+\u0017pQ8mk6t7\u000fE\u0002\u0016?\u0006L!\u0001\u0019\f\u0003\r=\u0003H/[8o!\r\u0011gM\u0015\b\u0003G\u0016t!\u0001\n3\n\u0003]I!A\r\f\n\u0005\u001dD'aA*fc*\u0011!G\u0006\u0005\bU\u0016\u0001\n\u00111\u0001_\u0003Q\u0019G.^:uKJLgnZ&fs\u000e{G.^7og\u0006q2M]3bi\u0016\u001c\u0015m]:b]\u0012\u0014\u0018\rV1cY\u0016$C-\u001a4bk2$HeM\u000b\u0002[*\u0012aL\\\u0016\u0002_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u001e\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002wc\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002=\r\u0014X-\u0019;f\u0007\u0006\u001c8/\u00198ee\u0006$\u0016M\u00197fI\u0011,g-Y;mi\u0012\"\u0014AH2sK\u0006$XmQ1tg\u0006tGM]1UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00136)\u0015Q8\u0010`?\u007fU\tQe\u000eC\u0003R\u0011\u0001\u0007!\u000bC\u0003\\\u0011\u0001\u0007!\u000bC\u0003^\u0011\u0001\u0007a\fC\u0003k\u0011\u0001\u0007a\f")
public class DataFrameFunctions
implements scala.Serializable {
    private final Dataset<Row> dataFrame;
    private final SparkContext sparkContext;

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public void createCassandraTable(String keyspaceName, String tableName, Option<Seq<String>> partitionKeyColumns, Option<Seq<String>> clusteringKeyColumns, CassandraConnector connector) {
        ProtocolVersion protocolVersion = (ProtocolVersion)((Object)connector.withClusterDo((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getConfiguration().getProtocolOptions().getProtocolVersion()));
        TableDef rawTable = TableDef$.MODULE$.fromDataFrame(this.dataFrame, keyspaceName, tableName, protocolVersion);
        Map<String, ColumnDef> columnMapping = rawTable.columnByName();
        Set columnNames = columnMapping.keys().toSet();
        Seq partitionKeyNames = (Seq)partitionKeyColumns.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)rawTable.partitionKey().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.columnName(), Seq$.MODULE$.canBuildFrom()));
        Seq clusteringKeyNames = (Seq)clusteringKeyColumns.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq regularColumnNames = ((SetLike)columnNames.$minus$minus((GenTraversableOnce)partitionKeyNames.$plus$plus((GenTraversableOnce)clusteringKeyNames, Seq$.MODULE$.canBuildFrom()))).toSeq();
        Seq x$10 = (Seq)((TraversableLike)partitionKeyNames.map((Function1 & Serializable & scala.Serializable)partitionKeyName -> (ColumnDef)columnMapping.getOrElse(partitionKeyName, (Function0 & Serializable & scala.Serializable)() -> {
            throw DataFrameFunctions.missingColumnException$1(partitionKeyName, "Partition Key Column", columnNames);
        }), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            PartitionKeyColumn$ x$1 = PartitionKeyColumn$.MODULE$;
            String x$2 = x$3.copy$default$1();
            ColumnType<?> x$32 = x$3.copy$default$3();
            return x$3.copy(x$2, x$1, x$32);
        }, Seq$.MODULE$.canBuildFrom());
        Seq x$11 = (Seq)((TraversableLike)((IterableLike)clusteringKeyNames.map((Function1 & Serializable & scala.Serializable)clusteringKeyName -> (ColumnDef)columnMapping.getOrElse(clusteringKeyName, (Function0 & Serializable & scala.Serializable)() -> {
            throw DataFrameFunctions.missingColumnException$1(clusteringKeyName, "Clustering Column", columnNames);
        }), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ColumnDef col = (ColumnDef)tuple2._1();
            int index = tuple2._2$mcI$sp();
            ClusteringColumn x$4 = new ClusteringColumn(index);
            String x$5 = col.copy$default$1();
            ColumnType<?> x$6 = col.copy$default$3();
            ColumnDef columnDef = col.copy(x$5, x$4, x$6);
            return columnDef;
        }, Seq$.MODULE$.canBuildFrom());
        Seq x$12 = (Seq)((TraversableLike)regularColumnNames.map((Function1 & Serializable & scala.Serializable)regularColumnName -> (ColumnDef)columnMapping.getOrElse(regularColumnName, (Function0 & Serializable & scala.Serializable)() -> {
            throw DataFrameFunctions.missingColumnException$1(regularColumnName, "Regular Column", columnNames);
        }), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            RegularColumn$ x$7 = RegularColumn$.MODULE$;
            String x$8 = x$4.copy$default$1();
            ColumnType<?> x$9 = x$4.copy$default$3();
            return x$4.copy(x$8, x$7, x$9);
        }, Seq$.MODULE$.canBuildFrom());
        String x$13 = rawTable.copy$default$1();
        String x$14 = rawTable.copy$default$2();
        Seq<IndexDef> x$15 = rawTable.copy$default$6();
        boolean x$16 = rawTable.copy$default$7();
        TableDef table = rawTable.copy(x$13, x$14, (Seq<ColumnDef>)x$10, (Seq<ColumnDef>)x$11, (Seq<ColumnDef>)x$12, x$15, x$16);
        connector.withSessionDo((Function1 & Serializable & scala.Serializable)session -> session.execute(table.cql()));
    }

    public Option<Seq<String>> createCassandraTable$default$3() {
        return None$.MODULE$;
    }

    public Option<Seq<String>> createCassandraTable$default$4() {
        return None$.MODULE$;
    }

    public CassandraConnector createCassandraTable$default$5(String keyspaceName, String tableName, Option<Seq<String>> partitionKeyColumns, Option<Seq<String>> clusteringKeyColumns) {
        return CassandraConnector$.MODULE$.apply(this.sparkContext());
    }

    private static final IllegalArgumentException missingColumnException$1(String columnName, String columnType, Set columnNames$1) {
        return new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\"").append(columnName).append("\" not Found. Unable to make specified column ").append(columnName).append(" a ").append(columnType).append(".\n          |Available Columns: ").append(columnNames$1).toString())).stripMargin());
    }

    public DataFrameFunctions(Dataset<Row> dataFrame) {
        this.dataFrame = dataFrame;
        this.sparkContext = dataFrame.sqlContext().sparkContext();
    }
}

