/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.cql.DefaultConnectionFactory$;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy$;
import com.datastax.spark.connector.cql.NoAuthConf$;
import com.datastax.spark.connector.cql.PreparedStatementCache$;
import com.datastax.spark.connector.cql.RefCountedCache;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.SerialShutdownHooks$;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkExecutorInfo;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

public final class CassandraConnector$
implements Logging,
scala.Serializable {
    public static CassandraConnector$ MODULE$;
    private final RefCountedCache<CassandraConnectorConf, Session> sessionCache;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new CassandraConnector$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public RefCountedCache<CassandraConnectorConf, Session> sessionCache() {
        return this.sessionCache;
    }

    private Session createSession(CassandraConnectorConf conf) {
        Session session;
        LazyRef endpointsStr$lzy = new LazyRef();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Attempting to open native connection to Cassandra at ").append(CassandraConnector$.endpointsStr$1(endpointsStr$lzy, conf)).toString());
        Cluster cluster = conf.connectionFactory().createCluster(conf);
        try {
            String clusterName = cluster.getMetadata().getClusterName();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Connected to Cassandra cluster: ").append(clusterName).toString());
            session = cluster.connect();
        }
        catch (Throwable e) {
            cluster.close();
            throw new IOException(new StringBuilder(49).append("Failed to open native connection to Cassandra at ").append(CassandraConnector$.endpointsStr$1(endpointsStr$lzy, conf)).toString(), e);
        }
        return session;
    }

    private void destroySession(Session session) {
        Cluster cluster = session.getCluster();
        String clusterName = cluster.getMetadata().getClusterName();
        session.close();
        cluster.close();
        PreparedStatementCache$.MODULE$.remove(cluster);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Disconnected from Cassandra cluster: ").append(clusterName).toString());
    }

    private Set<CassandraConnectorConf> alternativeConnectionConfigs(CassandraConnectorConf conf, Session session) {
        Set allHosts = JavaConversions$.MODULE$.deprecated$u0020asScalaSet(session.getCluster().getMetadata().getAllHosts()).toSet();
        String dcToUse = (String)conf.localDC().getOrElse((Function0 & Serializable & scala.Serializable)() -> LocalNodeFirstLoadBalancingPolicy$.MODULE$.determineDataCenter(conf.hosts(), (Set<Host>)allHosts));
        Set hosts = (Set)allHosts.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CassandraConnector$.$anonfun$alternativeConnectionConfigs$2(dcToUse, x$8)));
        return (Set)((SetLike)hosts.map((Function1 & Serializable & scala.Serializable)h -> conf.copy((Set<InetAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{h.getAddress()}))), conf.copy$default$2(), conf.copy$default$3(), conf.copy$default$4(), conf.copy$default$5(), conf.copy$default$6(), conf.copy$default$7(), conf.copy$default$8(), conf.copy$default$9(), conf.copy$default$10(), conf.copy$default$11(), conf.copy$default$12(), conf.copy$default$13(), conf.copy$default$14()), Set$.MODULE$.canBuildFrom())).$plus((Object)conf.copy((Set<InetAddress>)((Set)hosts.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getAddress(), Set$.MODULE$.canBuildFrom())), conf.copy$default$2(), conf.copy$default$3(), conf.copy$default$4(), conf.copy$default$5(), conf.copy$default$6(), conf.copy$default$7(), conf.copy$default$8(), conf.copy$default$9(), conf.copy$default$10(), conf.copy$default$11(), conf.copy$default$12(), conf.copy$default$13(), conf.copy$default$14()));
    }

    public CassandraConnector apply(SparkConf conf) {
        return new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
    }

    public CassandraConnector apply(SparkContext sc) {
        CassandraConnectorConf conf = CassandraConnectorConf$.MODULE$.apply(sc.getConf());
        int numExecutors = package$.MODULE$.max(((SparkExecutorInfo[])Option$.MODULE$.apply((Object)sc.statusTracker().getExecutorInfos()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (SparkExecutorInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SparkExecutorInfo.class)))).length, 1);
        int numCores = sc.defaultParallelism();
        int coresPerExecutor = package$.MODULE$.max(numCores / numExecutors, 1);
        Option x$1 = conf.maxConnectionsPerExecutor().orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)coresPerExecutor)));
        Set<InetAddress> x$2 = conf.copy$default$1();
        int x$3 = conf.copy$default$2();
        AuthConf x$4 = conf.copy$default$3();
        Option<String> x$5 = conf.copy$default$4();
        int x$6 = conf.copy$default$5();
        int x$7 = conf.copy$default$6();
        int x$8 = conf.copy$default$7();
        ProtocolOptions.Compression x$9 = conf.copy$default$9();
        int x$10 = conf.copy$default$10();
        int x$11 = conf.copy$default$11();
        int x$12 = conf.copy$default$12();
        CassandraConnectionFactory x$13 = conf.copy$default$13();
        CassandraConnectorConf.CassandraSSLConf x$14 = conf.copy$default$14();
        CassandraConnectorConf runtimeConf = conf.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<Object>)x$1, x$9, x$10, x$11, x$12, x$13, x$14);
        return new CassandraConnector(runtimeConf);
    }

    public CassandraConnector apply(Set<InetAddress> hosts, int port, AuthConf authConf, Option<String> localDC, int keepAliveMillis, int minReconnectionDelayMillis, int maxReconnectionDelayMillis, int queryRetryCount, int connectTimeoutMillis, int readTimeoutMillis, CassandraConnectionFactory connectionFactory, CassandraConnectorConf.CassandraSSLConf cassandraSSLConf) {
        Set<InetAddress> x$1 = hosts;
        int x$2 = port;
        AuthConf x$3 = authConf;
        Option<String> x$4 = localDC;
        int x$5 = keepAliveMillis;
        int x$6 = minReconnectionDelayMillis;
        int x$7 = maxReconnectionDelayMillis;
        int x$8 = queryRetryCount;
        int x$9 = connectTimeoutMillis;
        int x$10 = readTimeoutMillis;
        CassandraConnectionFactory x$11 = connectionFactory;
        CassandraConnectorConf.CassandraSSLConf x$12 = cassandraSSLConf;
        Option<Object> x$13 = CassandraConnectorConf$.MODULE$.apply$default$8();
        ProtocolOptions.Compression x$14 = CassandraConnectorConf$.MODULE$.apply$default$9();
        CassandraConnectorConf config = new CassandraConnectorConf(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$13, x$14, x$8, x$9, x$10, x$11, x$12);
        return new CassandraConnector(config);
    }

    public int apply$default$2() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ConnectionPortParam().default());
    }

    public AuthConf apply$default$3() {
        return NoAuthConf$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public int apply$default$5() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.KeepAliveMillisParam().default());
    }

    public int apply$default$6() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.MinReconnectionDelayParam().default());
    }

    public int apply$default$7() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.MaxReconnectionDelayParam().default());
    }

    public int apply$default$8() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.QueryRetryParam().default());
    }

    public int apply$default$9() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ConnectionTimeoutParam().default());
    }

    public int apply$default$10() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ReadTimeoutParam().default());
    }

    public CassandraConnectionFactory apply$default$11() {
        return DefaultConnectionFactory$.MODULE$;
    }

    public CassandraConnectorConf.CassandraSSLConf apply$default$12() {
        return CassandraConnectorConf$.MODULE$.DefaultCassandraSSLConf();
    }

    public void evictCache() {
        this.sessionCache().evict();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final /* synthetic */ String endpointsStr$lzycompute$1(LazyRef endpointsStr$lzy$1, CassandraConnectorConf conf$1) {
        String string;
        LazyRef lazyRef = endpointsStr$lzy$1;
        synchronized (lazyRef) {
            string = endpointsStr$lzy$1.initialized() ? (String)endpointsStr$lzy$1.value() : (String)endpointsStr$lzy$1.initialize((Object)new StringBuilder(1).append(((TraversableOnce)conf$1.hosts().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getHostAddress(), Set$.MODULE$.canBuildFrom())).mkString("{", ", ", "}")).append(":").append(conf$1.port()).toString());
        }
        return string;
    }

    private static final String endpointsStr$1(LazyRef endpointsStr$lzy$1, CassandraConnectorConf conf$1) {
        return endpointsStr$lzy$1.initialized() ? (String)endpointsStr$lzy$1.value() : CassandraConnector$.endpointsStr$lzycompute$1(endpointsStr$lzy$1, conf$1);
    }

    public static final /* synthetic */ boolean $anonfun$alternativeConnectionConfigs$2(String dcToUse$2, Host x$8) {
        String string = x$8.getDatacenter();
        String string2 = dcToUse$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private CassandraConnector$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.sessionCache = new RefCountedCache((Function1 & Serializable & scala.Serializable)conf -> MODULE$.createSession((CassandraConnectorConf)conf), (Function1 & Serializable & scala.Serializable)session -> {
            CassandraConnector$.MODULE$.destroySession(session);
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable & scala.Serializable)(conf, session) -> MODULE$.alternativeConnectionConfigs((CassandraConnectorConf)conf, (Session)session));
        SerialShutdownHooks$.MODULE$.add("Clearing session cache for C* connector", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.sessionCache().shutdown());
    }
}

