/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy$;
import com.datastax.spark.connector.cql.MultipleRetryPolicy;
import com.datastax.spark.connector.cql.Scanner;
import com.datastax.spark.connector.rdd.ReadConf;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.LazyRef;

public final class DefaultConnectionFactory$
implements CassandraConnectionFactory {
    public static DefaultConnectionFactory$ MODULE$;

    static {
        new DefaultConnectionFactory$();
    }

    @Override
    public Set<String> properties() {
        return CassandraConnectionFactory.properties$(this);
    }

    @Override
    public Scanner getScanner(ReadConf readConf, CassandraConnectorConf connConf, IndexedSeq<String> columnNames) {
        return CassandraConnectionFactory.getScanner$(this, readConf, connConf, columnNames);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster.Builder clusterBuilder(CassandraConnectorConf conf) {
        Cluster.Builder builder;
        SocketOptions options = new SocketOptions().setConnectTimeoutMillis(conf.connectTimeoutMillis()).setReadTimeoutMillis(conf.readTimeoutMillis());
        Cluster.Builder builder2 = Cluster.builder().addContactPoints((InetAddress[])conf.hosts().toSeq().toArray(ClassTag$.MODULE$.apply(InetAddress.class))).withPort(conf.port()).withRetryPolicy(new MultipleRetryPolicy(conf.queryRetryCount())).withReconnectionPolicy(new ExponentialReconnectionPolicy(conf.minReconnectionDelayMillis(), conf.maxReconnectionDelayMillis())).withLoadBalancingPolicy(new LocalNodeFirstLoadBalancingPolicy(conf.hosts(), conf.localDC(), LocalNodeFirstLoadBalancingPolicy$.MODULE$.$lessinit$greater$default$3())).withAuthProvider(conf.authConf().authProvider()).withSocketOptions(options).withCompression(conf.compression()).withQueryOptions(new QueryOptions().setRefreshNodeIntervalMillis(0).setRefreshNodeListIntervalMillis(0).setRefreshSchemaIntervalMillis(0));
        if (conf.cassandraSSLConf().enabled()) {
            Cluster.Builder builder3;
            Option<SSLOptions> option = this.maybeCreateSSLOptions(conf.cassandraSSLConf());
            if (option instanceof Some) {
                Some some = (Some)option;
                SSLOptions sslOptions = (SSLOptions)some.value();
                builder3 = builder2.withSSL(sslOptions);
            } else if (None$.MODULE$.equals(option)) {
                builder3 = builder2.withSSL();
            } else {
                throw new MatchError(option);
            }
            builder = builder3;
        } else {
            void var3_3;
            builder = var3_3;
        }
        return builder;
    }

    private Option<KeyStore> getKeyStore(String ksType, Option<String> ksPassword, Option<Path> ksPath) {
        None$ none$;
        Option<Path> option = ksPath;
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            Path path = (Path)some2.value();
            InputStream ksIn = Files.newInputStream(path, new OpenOption[0]);
            try {
                KeyStore keyStore = KeyStore.getInstance(ksType);
                keyStore.load(ksIn, (char[])ksPassword.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toCharArray()).orNull(Predef$.MODULE$.$conforms()));
                some = new Some((Object)keyStore);
            }
            finally {
                IOUtils.closeQuietly((InputStream)ksIn);
            }
            none$ = some;
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    private Option<SSLOptions> maybeCreateSSLOptions(CassandraConnectorConf.CassandraSSLConf conf) {
        None$ none$;
        LazyRef trustStore$lzy = new LazyRef();
        LazyRef keyStore$lzy = new LazyRef();
        if (conf.enabled()) {
            Option trustManagerFactory = this.trustStore$1(trustStore$lzy, conf).map((Function1 & Serializable & scala.Serializable)ts -> {
                void var1_1;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)ts);
                return var1_1;
            });
            None$ keyManagerFactory = conf.clientAuthEnabled() ? this.keyStore$1(keyStore$lzy, conf).map((Function1 & Serializable & scala.Serializable)ks -> {
                void var2_2;
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init((KeyStore)ks, (char[])conf.keyStorePassword().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toCharArray()).orNull(Predef$.MODULE$.$conforms()));
                return var2_2;
            }) : None$.MODULE$;
            SSLContext context = SSLContext.getInstance(conf.protocol());
            context.init((KeyManager[])keyManagerFactory.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getKeyManagers()).orNull(Predef$.MODULE$.$conforms()), (TrustManager[])trustManagerFactory.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTrustManagers()).orNull(Predef$.MODULE$.$conforms()), new SecureRandom());
            none$ = new Some((Object)JdkSSLOptions.builder().withSSLContext(context).withCipherSuites((String[])conf.enabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class))).build());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Cluster createCluster(CassandraConnectorConf conf) {
        return this.clusterBuilder(conf).build();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final /* synthetic */ Option trustStore$lzycompute$1(LazyRef trustStore$lzy$1, CassandraConnectorConf.CassandraSSLConf conf$1) {
        Option option;
        LazyRef lazyRef = trustStore$lzy$1;
        synchronized (lazyRef) {
            option = trustStore$lzy$1.initialized() ? (Option)trustStore$lzy$1.value() : (Option)trustStore$lzy$1.initialize(this.getKeyStore(conf$1.trustStoreType(), conf$1.trustStorePassword(), (Option<Path>)conf$1.trustStorePath().map((Function1 & Serializable & scala.Serializable)x$2 -> Paths.get(x$2, new String[0]))));
        }
        return option;
    }

    private final Option trustStore$1(LazyRef trustStore$lzy$1, CassandraConnectorConf.CassandraSSLConf conf$1) {
        return trustStore$lzy$1.initialized() ? (Option)trustStore$lzy$1.value() : this.trustStore$lzycompute$1(trustStore$lzy$1, conf$1);
    }

    private final /* synthetic */ Option keyStore$lzycompute$1(LazyRef keyStore$lzy$1, CassandraConnectorConf.CassandraSSLConf conf$1) {
        Option option;
        LazyRef lazyRef = keyStore$lzy$1;
        synchronized (lazyRef) {
            option = keyStore$lzy$1.initialized() ? (Option)keyStore$lzy$1.value() : (Option)keyStore$lzy$1.initialize(this.getKeyStore(conf$1.keyStoreType(), conf$1.keyStorePassword(), (Option<Path>)conf$1.keyStorePath().map((Function1 & Serializable & scala.Serializable)x$3 -> Paths.get(x$3, new String[0]))));
        }
        return option;
    }

    private final Option keyStore$1(LazyRef keyStore$lzy$1, CassandraConnectorConf.CassandraSSLConf conf$1) {
        return keyStore$lzy$1.initialized() ? (Option)keyStore$lzy$1.value() : this.keyStore$lzycompute$1(keyStore$lzy$1, conf$1);
    }

    private DefaultConnectionFactory$() {
        MODULE$ = this;
        CassandraConnectionFactory.$init$(this);
    }
}

