/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.RetryPolicy;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0006\r\u0001]A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006c\u0001!\tA\r\u0005\u0006m\u0001!Ia\u000e\u0005\u0006\u001d\u0002!Ia\u0014\u0005\u0006#\u0002!\tE\u0015\u0005\u00069\u0002!\t%\u0018\u0005\u0006=\u0002!\te\u0018\u0005\u0006i\u0002!\t%\u001e\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\ty\u0002\u0001C!\u0003C\u00111#T;mi&\u0004H.\u001a*fiJL\bk\u001c7jGfT!!\u0004\b\u0002\u0007\r\fHN\u0003\u0002\u0010!\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\u0011\u0011\fG/Y:uCbT\u0011!F\u0001\u0004G>l7\u0001A\n\u0004\u0001a\u0001\u0003CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u0011a\u0017M\\4\u000b\u0003u\tAA[1wC&\u0011qD\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0005BS\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00039pY&\u001c\u0017.Z:\u000b\u0005\u00152\u0013\u0001B2pe\u0016T!a\n\n\u0002\r\u0011\u0014\u0018N^3s\u0013\tI#EA\u0006SKR\u0014\u0018\u0010U8mS\u000eL\u0018!D7bqJ+GO]=D_VtG\u000f\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0002J]R\fa\u0001P5oSRtDCA\u001a6!\t!\u0004!D\u0001\r\u0011\u0015Q#\u00011\u0001,\u0003U\u0011X\r\u001e:z\u001b\u0006t\u0017\u0010V5nKN|%\u000f\u00165s_^$\"\u0001\u000f'\u0011\u0005eJeB\u0001\u001eH\u001d\tYdI\u0004\u0002=\u000b:\u0011Q\b\u0012\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!\u0011\f\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012BA\n\u0015\u0013\t9##\u0003\u0002&M%\u00111\u0005J\u0005\u0003\u0011\n\n1BU3uef\u0004v\u000e\\5ds&\u0011!j\u0013\u0002\u000e%\u0016$(/\u001f#fG&\u001c\u0018n\u001c8\u000b\u0005!\u0013\u0003\"B'\u0004\u0001\u0004Y\u0013a\u00028c%\u0016$(/_\u0001\u0011e\u0016$(/_(oG\u0016|%\u000f\u00165s_^$\"\u0001\u000f)\t\u000b5#\u0001\u0019A\u0016\u0002\t%t\u0017\u000e\u001e\u000b\u0003'Z\u0003\"\u0001\f+\n\u0005Uk#\u0001B+oSRDQaV\u0003A\u0002a\u000bqa\u00197vgR,'\u000f\u0005\u0002Z56\tA%\u0003\u0002\\I\t91\t\\;ti\u0016\u0014\u0018!B2m_N,G#A*\u0002\u001b=t'+Z1e)&lWm\\;u)\u001dA\u0004-\u001a6m]NDQ!Y\u0004A\u0002\t\fAa\u001d;niB\u0011\u0011lY\u0005\u0003I\u0012\u0012\u0011b\u0015;bi\u0016lWM\u001c;\t\u000b\u0019<\u0001\u0019A4\u0002\u0005\rd\u0007CA-i\u0013\tIGE\u0001\tD_:\u001c\u0018n\u001d;f]\u000eLH*\u001a<fY\")1n\u0002a\u0001W\u0005\t\"/Z9vSJ,GMU3ta>t7/Z:\t\u000b5<\u0001\u0019A\u0016\u0002#I,7-Z5wK\u0012\u0014Vm\u001d9p]N,7\u000fC\u0003p\u000f\u0001\u0007\u0001/A\u0007eCR\f'+\u001a;sS\u00164X\r\u001a\t\u0003YEL!A]\u0017\u0003\u000f\t{w\u000e\\3b]\")Qj\u0002a\u0001W\u0005qqN\u001c*fcV,7\u000f^#se>\u0014HC\u0002\u001dwob\f\t\u0001C\u0003b\u0011\u0001\u0007!\rC\u0003g\u0011\u0001\u0007q\rC\u0003z\u0011\u0001\u0007!0\u0001\u0002fqB\u00111P`\u0007\u0002y*\u0011Q\u0010J\u0001\u000bKb\u001cW\r\u001d;j_:\u001c\u0018BA@}\u0005=!%/\u001b<fe\u0016C8-\u001a9uS>t\u0007\"B'\t\u0001\u0004Y\u0013AD8o/JLG/\u001a+j[\u0016|W\u000f\u001e\u000b\u000eq\u0005\u001d\u0011\u0011BA\u0006\u0003+\tI\"!\b\t\u000b\u0005L\u0001\u0019\u00012\t\u000b\u0019L\u0001\u0019A4\t\u000f\u00055\u0011\u00021\u0001\u0002\u0010\u0005IqO]5uKRK\b/\u001a\t\u00043\u0006E\u0011bAA\nI\tIqK]5uKRK\b/\u001a\u0005\u0007\u0003/I\u0001\u0019A\u0016\u0002\u0019I,\u0017/^5sK\u0012\f5m[:\t\r\u0005m\u0011\u00021\u0001,\u00031\u0011XmY3jm\u0016$\u0017iY6t\u0011\u0015i\u0015\u00021\u0001,\u00035yg.\u00168bm\u0006LG.\u00192mKRY\u0001(a\t\u0002&\u0005\u001d\u00121FA\u0018\u0011\u0015\t'\u00021\u0001c\u0011\u00151'\u00021\u0001h\u0011\u0019\tIC\u0003a\u0001W\u0005y!/Z9vSJ,GMU3qY&\u001c\u0017\r\u0003\u0004\u0002.)\u0001\raK\u0001\rC2Lg/\u001a*fa2L7-\u0019\u0005\u0006\u001b*\u0001\ra\u000b")
public class MultipleRetryPolicy
implements RetryPolicy {
    private final int maxRetryCount;

    private RetryPolicy.RetryDecision retryManyTimesOrThrow(int nbRetry) {
        RetryPolicy.RetryDecision retryDecision;
        int n = this.maxRetryCount;
        switch (n) {
            case -1: {
                retryDecision = RetryPolicy.RetryDecision.retry(null);
                break;
            }
            default: {
                if (nbRetry < n) {
                    retryDecision = RetryPolicy.RetryDecision.retry(null);
                    break;
                }
                retryDecision = RetryPolicy.RetryDecision.rethrow();
                break;
            }
        }
        return retryDecision;
    }

    private RetryPolicy.RetryDecision retryOnceOrThrow(int nbRetry) {
        return nbRetry == 0 ? RetryPolicy.RetryDecision.retry(null) : RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Statement stmt, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        return this.retryManyTimesOrThrow(nbRetry);
    }

    @Override
    public RetryPolicy.RetryDecision onRequestError(Statement stmt, ConsistencyLevel cl, DriverException ex, int nbRetry) {
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Statement stmt, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        return this.retryManyTimesOrThrow(nbRetry);
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Statement stmt, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        return this.retryManyTimesOrThrow(nbRetry);
    }

    public MultipleRetryPolicy(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }
}

