/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;

public final class PreparedStatementCache$
implements Logging {
    public static PreparedStatementCache$ MODULE$;
    private final TrieMap<Cluster, TrieMap<String, PreparedStatement>> clusterCache;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new PreparedStatementCache$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private TrieMap<Cluster, TrieMap<String, PreparedStatement>> clusterCache() {
        return this.clusterCache;
    }

    private Option<PreparedStatement> get(Cluster cluster, String query) {
        return this.clusterCache().get((Object)cluster).flatMap((Function1 & Serializable & scala.Serializable)statementCache -> statementCache.get((Object)query).map((Function1 & Serializable & scala.Serializable)statement -> statement));
    }

    private PreparedStatement put(Cluster cluster, String query, PreparedStatement statement) {
        Option option;
        Option option2 = this.clusterCache().get((Object)cluster);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            TrieMap statementCache = (TrieMap)some.value();
            option = statementCache.put((Object)query, (Object)statement);
        } else if (None$.MODULE$.equals(option2)) {
            option = this.clusterCache().put((Object)cluster, (Object)TrieMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)query), (Object)statement)})));
        } else {
            throw new MatchError((Object)option2);
        }
        return statement;
    }

    public int getSize(Cluster cluster) {
        return Option$.MODULE$.option2Iterable(this.clusterCache().get((Object)cluster)).size();
    }

    public void remove(Cluster cluster) {
        PreparedStatementCache$ preparedStatementCache$ = this;
        synchronized (preparedStatementCache$) {
            this.clusterCache().remove((Object)cluster);
        }
    }

    public PreparedStatement prepareStatement(Session session, RegularStatement query) {
        PreparedStatement preparedStatement;
        Cluster cluster = session.getCluster();
        Option<PreparedStatement> option = this.get(cluster, query.toString());
        if (option instanceof Some) {
            PreparedStatement stmt;
            Some some = (Some)option;
            preparedStatement = stmt = (PreparedStatement)some.value();
        } else if (None$.MODULE$.equals(option)) {
            PreparedStatement preparedStatement2;
            PreparedStatementCache$ preparedStatementCache$ = this;
            synchronized (preparedStatementCache$) {
                PreparedStatement preparedStatement3;
                Option<PreparedStatement> option2 = this.get(cluster, query.toString());
                if (option2 instanceof Some) {
                    PreparedStatement stmt;
                    Some some = (Some)option2;
                    preparedStatement3 = stmt = (PreparedStatement)some.value();
                } else if (None$.MODULE$.equals(option2)) {
                    PreparedStatement stmt = session.prepare(query);
                    preparedStatement3 = this.put(cluster, query.toString(), stmt);
                } else {
                    throw new MatchError(option2);
                }
                preparedStatement2 = preparedStatement3;
            }
            preparedStatement = preparedStatement2;
        } else {
            throw new MatchError(option);
        }
        return preparedStatement;
    }

    private PreparedStatementCache$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.clusterCache = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

