/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ClusteringColumn;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.ColumnDef$;
import com.datastax.spark.connector.cql.IndexDef;
import com.datastax.spark.connector.cql.KeyspaceDef;
import com.datastax.spark.connector.cql.PartitionKeyColumn$;
import com.datastax.spark.connector.cql.RegularColumn$;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.StaticColumn$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.NameTools;
import com.datastax.spark.connector.util.NameTools$;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;

public final class Schema$
implements Logging,
scala.Serializable {
    public static Schema$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new Schema$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private Seq<ColumnDef> fetchPartitionKey(AbstractTableMetadata table) {
        return (Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(table.getPartitionKey()).map((Function1 & Serializable & scala.Serializable)column -> ColumnDef$.MODULE$.apply((ColumnMetadata)column, PartitionKeyColumn$.MODULE$), Buffer$.MODULE$.canBuildFrom());
    }

    private Seq<ColumnDef> fetchClusteringColumns(AbstractTableMetadata table) {
        return (Seq)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(table.getClusteringColumns()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Schema$.$anonfun$fetchClusteringColumns$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ColumnMetadata column = (ColumnMetadata)tuple2._1();
            int index = tuple2._2$mcI$sp();
            ColumnDef columnDef = ColumnDef$.MODULE$.apply(column, new ClusteringColumn(index));
            return columnDef;
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private Seq<ColumnDef> fetchRegularColumns(AbstractTableMetadata table) {
        Set primaryKey = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(table.getPrimaryKey()).toSet();
        Buffer regularColumns = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(table.getColumns()).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)primaryKey.contains((Object)elem)));
        return (Seq)regularColumns.map((Function1 & Serializable & scala.Serializable)column -> column.isStatic() ? ColumnDef$.MODULE$.apply((ColumnMetadata)column, StaticColumn$.MODULE$) : ColumnDef$.MODULE$.apply((ColumnMetadata)column, RegularColumn$.MODULE$), Buffer$.MODULE$.canBuildFrom());
    }

    public Schema fromCassandra(CassandraConnector connector, Option<String> keyspaceName, Option<String> tableName) {
        return (Schema)connector.withClusterDo((Function1 & Serializable & scala.Serializable)cluster -> {
            String clusterName = cluster.getMetadata().getClusterName();
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Retrieving database schema from cluster ").append(clusterName).append("...").toString());
            Set keyspaces = Schema$.fetchKeyspaces$1(cluster.getMetadata(), keyspaceName, tableName);
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append(keyspaces.size()).append(" keyspaces fetched from cluster ").append(clusterName).append(": ").append(((TraversableOnce)keyspaces.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.keyspaceName(), Set$.MODULE$.canBuildFrom())).mkString("{", ",", "}")).toString());
            return new Schema(clusterName, (Set<KeyspaceDef>)keyspaces);
        });
    }

    public Option<String> fromCassandra$default$2() {
        return None$.MODULE$;
    }

    public Option<String> fromCassandra$default$3() {
        return None$.MODULE$;
    }

    public TableDef tableFromCassandra(CassandraConnector connector, String keyspaceName, String tableName) {
        TableDef t;
        Option option = this.fromCassandra(connector, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName)).tables().headOption();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                Metadata metadata = (Metadata)connector.withClusterDo((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getMetadata());
                Option<NameTools.Suggestions> suggestions = NameTools$.MODULE$.getSuggestions(metadata, keyspaceName, tableName);
                String errorMessage = NameTools$.MODULE$.getErrorString(keyspaceName, tableName, suggestions);
                throw new IOException(errorMessage);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        TableDef tableDef = t = (TableDef)some.value();
        return tableDef;
    }

    public Schema apply(String clusterName, Set<KeyspaceDef> keyspaces) {
        return new Schema(clusterName, keyspaces);
    }

    public Option<Tuple2<String, Set<KeyspaceDef>>> unapply(Schema x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.clusterName(), x$0.keyspaces()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$fetchClusteringColumns$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private static final boolean isKeyspaceSelected$1(KeyspaceMetadata keyspace, Option keyspaceName$1) {
        boolean bl;
        Option option = keyspaceName$1;
        if (None$.MODULE$.equals(option)) {
            bl = true;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            String string = keyspace.getName();
            String string2 = name;
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private static final boolean isTableSelected$1(AbstractTableMetadata table, Option tableName$1) {
        boolean bl;
        Option option = tableName$1;
        if (None$.MODULE$.equals(option)) {
            bl = true;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            String string = table.getName();
            String string2 = name;
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private static final Set fetchTables$1(KeyspaceMetadata keyspace, Option tableName$1) {
        return (Set)JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(keyspace.getTables()).toSet().$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(keyspace.getMaterializedViews()).toSet()).withFilter((Function1 & Serializable & scala.Serializable)table -> BoxesRunTime.boxToBoolean((boolean)Schema$.isTableSelected$1(table, tableName$1))).map((Function1 & Serializable & scala.Serializable)table -> {
            Seq<ColumnDef> partitionKey = MODULE$.fetchPartitionKey((AbstractTableMetadata)table);
            Seq<ColumnDef> clusteringColumns = MODULE$.fetchClusteringColumns((AbstractTableMetadata)table);
            Seq<ColumnDef> regularColumns = MODULE$.fetchRegularColumns((AbstractTableMetadata)table);
            Seq indexDefs = Schema$.getIndexDefs$1(table);
            AbstractTableMetadata abstractTableMetadata = table;
            boolean bl = abstractTableMetadata instanceof MaterializedViewMetadata;
            boolean isView = bl;
            return new TableDef(keyspace.getName(), table.getName(), partitionKey, clusteringColumns, regularColumns, (Seq<IndexDef>)indexDefs, isView);
        }, Set$.MODULE$.canBuildFrom());
    }

    private static final Set fetchKeyspaces$1(Metadata metadata, Option keyspaceName$1, Option tableName$1) {
        return (Set)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(metadata.getKeyspaces()).toSet().withFilter((Function1 & Serializable & scala.Serializable)keyspace -> BoxesRunTime.boxToBoolean((boolean)Schema$.isKeyspaceSelected$1(keyspace, keyspaceName$1))).map((Function1 & Serializable & scala.Serializable)keyspace -> new KeyspaceDef(keyspace.getName(), (Set<TableDef>)Schema$.fetchTables$1(keyspace, tableName$1)), Set$.MODULE$.canBuildFrom());
    }

    private static final String handleId$1(TableMetadata table, String columnName) {
        return (String)Option$.MODULE$.apply((Object)table.getColumn(columnName)).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> columnName);
    }

    private static final Seq getIndexDefs$1(AbstractTableMetadata tableOrView) {
        Seq seq;
        AbstractTableMetadata abstractTableMetadata = tableOrView;
        if (abstractTableMetadata instanceof TableMetadata) {
            TableMetadata tableMetadata = (TableMetadata)abstractTableMetadata;
            seq = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(tableMetadata.getIndexes()).map((Function1 & Serializable & scala.Serializable)index -> {
                String target = Schema$.handleId$1(tableMetadata, index.getTarget());
                return new IndexDef(index.getIndexClassName(), target, index.getName(), (Map<String, String>)Predef$.MODULE$.Map().empty());
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        } else if (abstractTableMetadata instanceof MaterializedViewMetadata) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError((Object)abstractTableMetadata);
        }
        return seq;
    }

    private Schema$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

