/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.spark.connector.AllColumns$;
import com.datastax.spark.connector.ColumnName;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.PartitionKeyColumns$;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.TTL;
import com.datastax.spark.connector.WriteTime;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.package$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import java.io.IOException;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015daB\u000b\u0017!\u0003\r\t!\t\u0005\u0006S\u0001!\tA\u000b\u0005\u00063\u00011\tB\f\u0005\u0006k\u00011\tB\u000e\u0005\u0006\u0005\u00021\tB\u000e\u0005\u0006\u0007\u00021\t\u0002\u0012\u0005\u0006\u0013\u00021\tB\u0013\u0005\u0006\u001f\u0002!\t\u0002\u0015\u0005\u0007/\u0002!\t\u0002\u0007-\t\u000bq\u0003A\u0011C/\t\u000by\u0003A\u0011C0\t\u000f!\u0004!\u0019!D\tS\"91\u0010\u0001b\u0001\u000e#a\bBCA\u0004\u0001!\u0015\r\u0011\"\u0001\u0002\n!Q\u0011\u0011\u0003\u0001\t\u0006\u0004%\t!a\u0005\t\u000f\u0005m\u0001\u0001\"\u0005\u0002\u001e!Q\u00111\b\u0001\t\u0006\u0004%\t!!\u0010\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003BCA(\u0001!\u0015\r\u0011\"\u0005\u0002R!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r$aH\"bgN\fg\u000e\u001a:b)\u0006\u0014G.\u001a*poJ+\u0017\rZ3s!J|g/\u001b3fe*\u0011q\u0003G\u0001\u0004e\u0012$'BA\r\u001b\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\u001c9\u0005)1\u000f]1sW*\u0011QDH\u0001\tI\u0006$\u0018m\u001d;bq*\tq$A\u0002d_6\u001c\u0001!\u0006\u0002#eN\u0011\u0001a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005Y\u0003C\u0001\u0013-\u0013\tiSE\u0001\u0003V]&$X#A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0005IB\u0012aA2rY&\u0011A'\r\u0002\u0013\u0007\u0006\u001c8/\u00198ee\u0006\u001cuN\u001c8fGR|'/\u0001\u0007lKf\u001c\b/Y2f\u001d\u0006lW-F\u00018!\tAtH\u0004\u0002:{A\u0011!(J\u0007\u0002w)\u0011A\bI\u0001\u0007yI|w\u000e\u001e \n\u0005y*\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!AP\u0013\u0002\u0013Q\f'\r\\3OC6,\u0017aC2pYVlgNT1nKN,\u0012!\u0012\t\u0003\r\u001ek\u0011\u0001G\u0005\u0003\u0011b\u0011abQ8mk6t7+\u001a7fGR|'/\u0001\u0005sK\u0006$7i\u001c8g+\u0005Y\u0005C\u0001'N\u001b\u00051\u0012B\u0001(\u0017\u0005!\u0011V-\u00193D_:4\u0017AC:qY&$8i\\;oiV\t\u0011\u000bE\u0002%%RK!aU\u0013\u0003\r=\u0003H/[8o!\t!S+\u0003\u0002WK\t\u0019\u0011J\u001c;\u0002\u0013M\u0004H.\u001b;TSj,W#A-\u0011\u0005\u0011R\u0016BA.&\u0005\u0011auN\\4\u0002\u0013\u0019,Go\u00195TSj,W#\u0001+\u0002!\r|gn]5ti\u0016t7-\u001f'fm\u0016dW#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001B2pe\u0016T!!\u001a\u000f\u0002\r\u0011\u0014\u0018N^3s\u0013\t9'M\u0001\tD_:\u001c\u0018n\u001d;f]\u000eLH*\u001a<fY\u0006\u0001\"o\\<SK\u0006$WM\u001d$bGR|'/_\u000b\u0002UB\u00191N\u001c9\u000e\u00031T!!\u001c\f\u0002\rI,\u0017\rZ3s\u0013\tyGN\u0001\tS_^\u0014V-\u00193fe\u001a\u000b7\r^8ssB\u0011\u0011O\u001d\u0007\u0001\t\u0015\u0019\bA1\u0001u\u0005\u0005\u0011\u0016CA;y!\t!c/\u0003\u0002xK\t9aj\u001c;iS:<\u0007C\u0001\u0013z\u0013\tQXEA\u0002B]f\f\u0001b\u00197bgN$\u0016mZ\u000b\u0002{B!a0a\u0001q\u001b\u0005y(bAA\u0001K\u00059!/\u001a4mK\u000e$\u0018bAA\u0003\u007f\nA1\t\\1tgR\u000bw-A\u0005s_^\u0014V-\u00193feV\u0011\u00111\u0002\t\u0005W\u00065\u0001/C\u0002\u0002\u00101\u0014\u0011BU8x%\u0016\fG-\u001a:\u0002\u0011Q\f'\r\\3EK\u001a,\"!!\u0006\u0011\u0007A\n9\"C\u0002\u0002\u001aE\u0012\u0001\u0002V1cY\u0016$UMZ\u0001\u0016G\",7m[\"pYVlgn]#ySN$XM\\2f)\u0011\ty\"a\u000e\u0011\r\u0005\u0005\u00121FA\u0019\u001d\u0011\t\u0019#a\n\u000f\u0007i\n)#C\u0001'\u0013\r\tI#J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti#a\f\u0003\u0007M+\u0017OC\u0002\u0002*\u0015\u00022ARA\u001a\u0013\r\t)\u0004\u0007\u0002\n\u0007>dW/\u001c8SK\u001aDq!!\u000f\u0010\u0001\u0004\ty\"A\u0004d_2,XN\\:\u0002%M,G.Z2uK\u0012\u001cu\u000e\\;n]J+gm]\u000b\u0003\u0003?\tQC\\1se><8i\u001c7v[:\u001cV\r\\3di&|g\u000e\u0006\u0003\u0002 \u0005\r\u0003bBA\u001d#\u0001\u0007\u0011qD\u0001\u0016G\",7m[\"pYVlgn]!wC&d\u0017M\u00197f)\u0015Y\u0013\u0011JA&\u0011\u001d\tID\u0005a\u0001\u0003?Aq!!\u0014\u0013\u0001\u0004\ty\"\u0001\tbm\u0006LG.\u00192mK\u000e{G.^7og\u0006i2-Y:tC:$'/\u0019)beRLG/[8oKJ\u001cE.Y:t\u001d\u0006lW-\u0006\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013\u0001\u00027b]\u001eT!!!\u0018\u0002\t)\fg/Y\u0005\u0004\u0001\u0006]\u0013A\u0002<fe&4\u0017\u0010\u0006\u0002\u0002\f\u0001")
public interface CassandraTableRowReaderProvider<R> {
    public CassandraConnector connector();

    public String keyspaceName();

    public String tableName();

    public ColumnSelector columnNames();

    public ReadConf readConf();

    public static /* synthetic */ Option splitCount$(CassandraTableRowReaderProvider $this) {
        return $this.splitCount();
    }

    default public Option<Object> splitCount() {
        return this.readConf().splitCount();
    }

    public static /* synthetic */ long splitSize$(CassandraTableRowReaderProvider $this) {
        return $this.splitSize();
    }

    default public long splitSize() {
        return (long)this.readConf().splitSizeInMB() * 1024L * 1024L;
    }

    public static /* synthetic */ int fetchSize$(CassandraTableRowReaderProvider $this) {
        return $this.fetchSize();
    }

    default public int fetchSize() {
        return this.readConf().fetchSizeInRows();
    }

    public static /* synthetic */ ConsistencyLevel consistencyLevel$(CassandraTableRowReaderProvider $this) {
        return $this.consistencyLevel();
    }

    default public ConsistencyLevel consistencyLevel() {
        return this.readConf().consistencyLevel();
    }

    public RowReaderFactory<R> rowReaderFactory();

    public ClassTag<R> classTag();

    public static /* synthetic */ RowReader rowReader$(CassandraTableRowReaderProvider $this) {
        return $this.rowReader();
    }

    default public RowReader<R> rowReader() {
        return this.rowReaderFactory().rowReader(this.tableDef(), this.columnNames().selectFrom(this.tableDef()));
    }

    public static /* synthetic */ TableDef tableDef$(CassandraTableRowReaderProvider $this) {
        return $this.tableDef();
    }

    default public TableDef tableDef() {
        return Schema$.MODULE$.tableFromCassandra(this.connector(), this.keyspaceName(), this.tableName());
    }

    public static /* synthetic */ Seq checkColumnsExistence$(CassandraTableRowReaderProvider $this, Seq columns) {
        return $this.checkColumnsExistence((Seq<ColumnRef>)columns);
    }

    default public Seq<ColumnRef> checkColumnsExistence(Seq<ColumnRef> columns) {
        Set allColumnNames = ((TraversableOnce)this.tableDef().columns().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.columnName(), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        Set regularColumnNames = ((TraversableOnce)this.tableDef().regularColumns().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.columnName(), Seq$.MODULE$.canBuildFrom())).toSet();
        return (Seq)columns.map((Function1 & Serializable & scala.Serializable)column -> this.checkSingleColumn$1((ColumnRef)column, allColumnNames, regularColumnNames), Seq$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ Seq selectedColumnRefs$(CassandraTableRowReaderProvider $this) {
        return $this.selectedColumnRefs();
    }

    default public Seq<ColumnRef> selectedColumnRefs() {
        Seq seq;
        Seq seq2;
        ColumnSelector columnSelector = this.columnNames();
        if (AllColumns$.MODULE$.equals(columnSelector)) {
            seq2 = (Seq)this.tableDef().columns().map((Function1 & Serializable & scala.Serializable)col -> package$.MODULE$.toNamedColumnRef(col.columnName()), IndexedSeq$.MODULE$.canBuildFrom());
        } else if (PartitionKeyColumns$.MODULE$.equals(columnSelector)) {
            seq2 = (Seq)this.tableDef().partitionKey().map((Function1 & Serializable & scala.Serializable)col -> package$.MODULE$.toNamedColumnRef(col.columnName()), Seq$.MODULE$.canBuildFrom());
        } else if (columnSelector instanceof SomeColumns) {
            SomeColumns someColumns = (SomeColumns)columnSelector;
            Seq<ColumnRef> cs = someColumns.columns();
            seq2 = this.checkColumnsExistence(cs);
        } else {
            throw new MatchError((Object)columnSelector);
        }
        Seq providedColumns = seq2;
        Option<Seq<ColumnRef>> option = this.rowReader().neededColumns();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq neededColumns = (Seq)some.value();
            seq = (Seq)providedColumns.filter((Function1)neededColumns.toSet());
        } else if (None$.MODULE$.equals(option)) {
            seq = providedColumns;
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    public static /* synthetic */ Seq narrowColumnSelection$(CassandraTableRowReaderProvider $this, Seq columns) {
        return $this.narrowColumnSelection((Seq<ColumnRef>)columns);
    }

    default public Seq<ColumnRef> narrowColumnSelection(Seq<ColumnRef> columns) {
        ColumnSelector columnSelector = this.columnNames();
        if (columnSelector instanceof SomeColumns) {
            SomeColumns someColumns = (SomeColumns)columnSelector;
            Seq<ColumnRef> cs = someColumns.columns();
            this.checkColumnsAvailable(columns, cs);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (AllColumns$.MODULE$.equals(columnSelector)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PartitionKeyColumns$.MODULE$.equals(columnSelector)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)columnSelector);
        }
        return columns;
    }

    private void checkColumnsAvailable(Seq<ColumnRef> columns, Seq<ColumnRef> availableColumns) {
        Set availableColumnsSet = ((TraversableOnce)availableColumns.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ColumnName) {
                    ColumnName columnName = (ColumnName)A1;
                    String columnName2 = columnName.columnName();
                    object = columnName2;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ColumnRef x1) {
                ColumnRef columnRef = x1;
                boolean bl = columnRef instanceof ColumnName;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Option notFound = columns.collectFirst((PartialFunction)new scala.Serializable(null, availableColumnsSet){
            public static final long serialVersionUID = 0L;
            private final Set availableColumnsSet$1;

            public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                ColumnName columnName;
                String columnName2;
                A1 A1 = x2;
                Object object = A1 instanceof ColumnName && !this.availableColumnsSet$1.contains((Object)(columnName2 = (columnName = (ColumnName)A1).columnName())) ? columnName2 : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(ColumnRef x2) {
                ColumnName columnName;
                String columnName2;
                ColumnRef columnRef = x2;
                boolean bl = columnRef instanceof ColumnName && !this.availableColumnsSet$1.contains((Object)(columnName2 = (columnName = (ColumnName)columnRef).columnName()));
                return bl;
            }
            {
                this.availableColumnsSet$1 = availableColumnsSet$1;
            }
        });
        if (notFound.isDefined()) {
            throw new IllegalArgumentException(new StringBuilder(55).append("Column not found in selection: ").append(notFound.get()).append(". ").append("Available columns: [").append(availableColumns.mkString(",")).append("].").toString());
        }
    }

    public static /* synthetic */ String cassandraPartitionerClassName$(CassandraTableRowReaderProvider $this) {
        return $this.cassandraPartitionerClassName();
    }

    default public String cassandraPartitionerClassName() {
        return (String)this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)session -> session.execute("SELECT partitioner FROM system.local").one().getString(0));
    }

    public static /* synthetic */ RowReader verify$(CassandraTableRowReaderProvider $this) {
        return $this.verify();
    }

    default public RowReader<R> verify() {
        this.tableDef().columns();
        return this.rowReader();
    }

    private ColumnRef checkSingleColumn$1(ColumnRef column, Set allColumnNames$1, Set regularColumnNames$1) {
        ColumnRef columnRef = column;
        if (columnRef instanceof ColumnName) {
            if (!allColumnNames$1.contains((Object)column.columnName())) {
                throw new IOException(new StringBuilder(28).append("Column ").append(column).append(" not found in table ").append(this.keyspaceName()).append(".").append(this.tableName()).toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (columnRef instanceof TTL) {
            TTL tTL = (TTL)columnRef;
            String columnName = tTL.columnName();
            if (!regularColumnNames$1.contains((Object)columnName)) {
                throw new IOException(new StringBuilder(93).append("TTL can be obtained only for regular columns, ").append("but column ").append(columnName).append(" is not a regular column in table ").append(this.keyspaceName()).append(".").append(this.tableName()).append(".").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (columnRef instanceof WriteTime) {
            WriteTime writeTime = (WriteTime)columnRef;
            String columnName = writeTime.columnName();
            if (!regularColumnNames$1.contains((Object)columnName)) {
                throw new IOException(new StringBuilder(100).append("Write time can be obtained only for regular columns, ").append("but column ").append(columnName).append(" is not a regular column in table ").append(this.keyspaceName()).append(".").append(this.tableName()).append(".").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return column;
    }

    public static void $init$(CassandraTableRowReaderProvider $this) {
    }
}

