/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.driver.core.Metadata;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartition;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitionGenerator$;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitioner;
import com.datastax.spark.connector.rdd.partitioner.CqlTokenRange;
import com.datastax.spark.connector.rdd.partitioner.Murmur3PartitionerTokenRangeSplitter;
import com.datastax.spark.connector.rdd.partitioner.RandomPartitionerTokenRangeSplitter;
import com.datastax.spark.connector.rdd.partitioner.TokenRangeClusterer;
import com.datastax.spark.connector.rdd.partitioner.TokenRangeSplitter;
import com.datastax.spark.connector.rdd.partitioner.dht.BigIntToken;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$Murmur3TokenFactory$;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$RandomPartitionerTokenFactory$;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenRange;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.Serializable;
import java.net.InetAddress;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg!\u0002\r\u001a\u0001u)\u0003\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011i\u0002!\u0011!Q\u0001\nmB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0006\u0007\")1\f\u0001C\u00019\u0016!!\f\u0001\u0001e\u000b\u0011)\u0007\u0001\u00014\t\u000f!\u0004!\u0019!C\u0005S\"1Q\u000f\u0001Q\u0001\n)DqA\u001e\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004x\u0001\u0001\u0006IA\u001b\u0005\u0006q\u0002!I!\u001f\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\ri\u0001A\u0011AA(\u000f\u001d\t\u0019*\u0007E\u0001\u0003+3a\u0001G\r\t\u0002\u0005]\u0005BB.\u0014\t\u0003\tI*B\u0003M'\u0001\tY*B\u0003W'\u0001\t\u0019\u000bC\u0004\u00022N!\t!a-\u00037\r\u000b7o]1oIJ\f\u0007+\u0019:uSRLwN\\$f]\u0016\u0014\u0018\r^8s\u0015\tQ2$A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014(B\u0001\u000f\u001e\u0003\r\u0011H\r\u001a\u0006\u0003=}\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003!!\u0017\r^1ti\u0006D(\"\u0001\u0013\u0002\u0007\r|W.F\u0002'\u0017V\u001b2\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011a&M\u0007\u0002_)\u0011\u0001'H\u0001\u0005kRLG.\u0003\u00023_\t9Aj\\4hS:<7\u0001\u0001\t\u0003kaj\u0011A\u000e\u0006\u0003ou\t1aY9m\u0013\tIdG\u0001\nDCN\u001c\u0018M\u001c3sC\u000e{gN\\3di>\u0014\u0018\u0001\u0003;bE2,G)\u001a4\u0011\u0005Ub\u0014BA\u001f7\u0005!!\u0016M\u00197f\t\u00164\u0017AC:qY&$8i\\;oiB\u0011\u0001\u0006Q\u0005\u0003\u0003&\u00121!\u00138u\u00031!xn[3o\r\u0006\u001cGo\u001c:z!\u0011!u)\u0013+\u000e\u0003\u0015S!AR\r\u0002\u0007\u0011DG/\u0003\u0002I\u000b\naAk\\6f]\u001a\u000b7\r^8ssB\u0011!j\u0013\u0007\u0001\t\u0015a\u0005A1\u0001N\u0005\u00051\u0016C\u0001(R!\tAs*\u0003\u0002QS\t9aj\u001c;iS:<\u0007C\u0001\u0015S\u0013\t\u0019\u0016FA\u0002B]f\u0004\"AS+\u0005\u000bY\u0003!\u0019A,\u0003\u0003Q\u000b\"A\u0014-\u0011\u0007\u0011K\u0016*\u0003\u0002[\u000b\n)Ak\\6f]\u00061A(\u001b8jiz\"B!X1cGR\u0011a\f\u0019\t\u0005?\u0002IE+D\u0001\u001a\u0011\u0015\u0011U\u0001q\u0001D\u0011\u0015qR\u00011\u00015\u0011\u0015QT\u00011\u0001<\u0011\u0015qT\u00011\u0001@!\r!\u0015\f\u0016\u0002\u000b)>\\WM\u001c*b]\u001e,\u0007\u0003\u0002#h\u0013RK!!Z#\u0002\u0019-,\u0017p\u001d9bG\u0016t\u0015-\\3\u0016\u0003)\u0004\"a\u001b:\u000f\u00051\u0004\bCA7*\u001b\u0005q'BA84\u0003\u0019a$o\\8u}%\u0011\u0011/K\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002rS\u0005i1.Z=ta\u0006\u001cWMT1nK\u0002\n\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\u0015Q\f'\r\\3OC6,\u0007%\u0001\u0006u_.,gNU1oO\u0016$BA\u001f?\u0002\fA\u00111pB\u0007\u0002\u0001!)Q\u0010\u0004a\u0001}\u0006)!/\u00198hKB\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tAaY8sK*\u0019\u0011qA\u0011\u0002\r\u0011\u0014\u0018N^3s\u0013\r)\u0017\u0011\u0001\u0005\b\u0003\u001ba\u0001\u0019AA\b\u0003!iW\r^1eCR\f\u0007cA@\u0002\u0012%!\u00111CA\u0001\u0005!iU\r^1eCR\f\u0017\u0001\u00043fg\u000e\u0014\u0018NY3SS:<WCAA\r!\u0015\tY\"!\n{\u001d\u0011\ti\"!\t\u000f\u00075\fy\"C\u0001+\u0013\r\t\u0019#K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9#!\u000b\u0003\u0007M+\u0017OC\u0002\u0002$%\n\u0001d\u0019:fCR,Gk\\6f]J\u000bgnZ3Ta2LG\u000f^3s+\t\ty\u0003E\u0003`\u0003cIE+C\u0002\u00024e\u0011!\u0003V8lK:\u0014\u0016M\\4f'Bd\u0017\u000e\u001e;fe\u0006Q!/\u00198hKR{7)\u001d7\u0015\t\u0005e\u0012\u0011\t\t\u0007\u00037\t)#a\u000f\u0011\u000b}\u000bi$\u0013+\n\u0007\u0005}\u0012DA\u0007Dc2$vn[3o%\u0006tw-\u001a\u0005\u0006{>\u0001\rA_\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001cXCAA$!\u0019\tY\"!\n\u0002JA)q,a\u0013J)&\u0019\u0011QJ\r\u0003%\r\u000b7o]1oIJ\f\u0007+\u0019:uSRLwN\\\u000b\u0005\u0003#\n\u0019\u0007\u0006\u0003\u0002T\u0005\u001dECBA+\u0003O\n9\bE\u0003)\u0003/\nY&C\u0002\u0002Z%\u0012aa\u00149uS>t\u0007cB0\u0002^\u0005\u0005\u0014\nV\u0005\u0004\u0003?J\"\u0001F\"bgN\fg\u000e\u001a:b!\u0006\u0014H/\u001b;j_:,'\u000fE\u0002K\u0003G\"a!!\u001a\u0012\u0005\u0004i%aA&fs\"I\u0011\u0011N\t\u0002\u0002\u0003\u000f\u00111N\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBA7\u0003g\n\t'\u0004\u0002\u0002p)\u0019\u0011\u0011O\u0015\u0002\u000fI,g\r\\3di&!\u0011QOA8\u0005!\u0019E.Y:t)\u0006<\u0007\"CA=#\u0005\u0005\t9AA>\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0003{\n\u0019)!\u0019\u000e\u0005\u0005}$bAAA;\u00051qO]5uKJLA!!\"\u0002\u0000\t\u0001\"k\\<Xe&$XM\u001d$bGR|'/\u001f\u0005\b\u0003\u0013\u000b\u0002\u0019AAF\u0003%YW-_'baB,'\u000f\u0005\u0003\u0002\u000e\u0006=U\"A\u000f\n\u0007\u0005EUD\u0001\bD_2,XN\\*fY\u0016\u001cGo\u001c:\u00027\r\u000b7o]1oIJ\f\u0007+\u0019:uSRLwN\\$f]\u0016\u0014\u0018\r^8s!\ty6c\u0005\u0002\u0014OQ\u0011\u0011Q\u0013\u0019\u0005\u0003;\u000by\nE\u0002K\u0003?#!\"!)\u0016\u0003\u0003\u0005\tQ!\u0001N\u0005\u0005!\b\u0007BAS\u0003O\u00032ASAT\t-\t\tKFA\u0001\u0002\u0003\u0015\t!!+\u0012\u00079\u000bY\u000b\u0005\u0003E3\u00065\u0006cAAX+5\t1#A\u0003baBd\u0017\u0010\u0006\u0005\u00026\u0006}\u00161YAc)\u0011\t9,a/\u0011\r}\u0003\u0011QVA]!\r\tyK\u0006\u0005\u0007\u0005^\u0001\u001d!!0\u0011\r\u0011;\u0015QVA]\u0011\u0019\t\tm\u0006a\u0001i\u0005!1m\u001c8o\u0011\u0015Qt\u00031\u0001<\u0011\u0015qt\u00031\u0001@\u0001")
public class CassandraPartitionGenerator<V, T extends Token<V>>
implements Logging {
    private final CassandraConnector connector;
    private final TableDef tableDef;
    private final int splitCount;
    private final TokenFactory<V, T> tokenFactory;
    private final String keyspaceName;
    private final String tableName;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public static CassandraPartitionGenerator<Object, Token> apply(CassandraConnector cassandraConnector, TableDef tableDef, int n, TokenFactory<Object, Token> tokenFactory) {
        return CassandraPartitionGenerator$.MODULE$.apply(cassandraConnector, tableDef, n, tokenFactory);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private String keyspaceName() {
        return this.keyspaceName;
    }

    private String tableName() {
        return this.tableName;
    }

    private TokenRange<V, T> tokenRange(com.datastax.driver.core.TokenRange range, Metadata metadata) {
        T startToken = this.tokenFactory.tokenFromString(range.getStart().getValue().toString());
        T endToken = this.tokenFactory.tokenFromString(range.getEnd().getValue().toString());
        Set replicas = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(metadata.getReplicas(Metadata.quote(this.keyspaceName()), range)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAddress(), Set$.MODULE$.canBuildFrom())).toSet();
        return new TokenRange<V, T>(startToken, endToken, (Set<InetAddress>)replicas, this.tokenFactory);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TokenRange<V, T>> describeRing() {
        Seq seq;
        Seq ranges = (Seq)this.connector.withClusterDo((Function1 & Serializable & scala.Serializable)cluster -> {
            Metadata metadata = cluster.getMetadata();
            return (Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(metadata.getTokenRanges()).toSeq().map((Function1 & Serializable & scala.Serializable)tr -> this.tokenRange((com.datastax.driver.core.TokenRange)tr, metadata), Seq$.MODULE$.canBuildFrom());
        });
        if (this.splitCount == 1) {
            TokenRange[] tokenRangeArray = new TokenRange[1];
            TokenRange qual$1 = (TokenRange)ranges.head();
            T x$1 = this.tokenFactory.minToken();
            T x$2 = this.tokenFactory.minToken();
            Set<InetAddress> x$3 = qual$1.copy$default$3();
            TokenFactory x$4 = qual$1.copy$default$4();
            tokenRangeArray[0] = qual$1.copy(x$1, x$2, x$3, x$4);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tokenRangeArray));
        } else {
            void var1_1;
            seq = var1_1;
        }
        return seq;
    }

    private TokenRangeSplitter<V, T> createTokenRangeSplitter() {
        TokenRangeSplitter<BigInt, BigIntToken> tokenRangeSplitter;
        TokenFactory<V, T> tokenFactory = this.tokenFactory;
        if (TokenFactory$RandomPartitionerTokenFactory$.MODULE$.equals(tokenFactory)) {
            tokenRangeSplitter = new RandomPartitionerTokenRangeSplitter();
        } else if (TokenFactory$Murmur3TokenFactory$.MODULE$.equals(tokenFactory)) {
            tokenRangeSplitter = new Murmur3PartitionerTokenRangeSplitter();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(25).append("Unsupported TokenFactory ").append(this.tokenFactory).toString());
        }
        return tokenRangeSplitter;
    }

    private Seq<CqlTokenRange<V, T>> rangeToCql(TokenRange<V, T> range) {
        return (Seq)range.unwrap(this.tokenFactory).map((Function1 & Serializable & scala.Serializable)x$2 -> new CqlTokenRange(x$2, $this.tokenFactory), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<CassandraPartition<V, T>> partitions() {
        Seq<TokenRange<V, T>> tokenRanges = this.describeRing();
        int endpointCount = ((TraversableOnce)((TraversableOnce)tokenRanges.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.replicas(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> (Set)x$4.$plus$plus((GenTraversableOnce)x$5))).size();
        int maxGroupSize = tokenRanges.size() / endpointCount;
        TokenRangeSplitter<V, T> splitter = this.createTokenRangeSplitter();
        Seq splits = splitter.split((Iterable<TokenRange<V, T>>)tokenRanges, this.splitCount).toSeq();
        TokenRangeClusterer clusterer = new TokenRangeClusterer(this.splitCount, maxGroupSize);
        Seq[] tokenRangeGroups = (Seq[])clusterer.group(splits).toArray(ClassTag$.MODULE$.apply(Seq.class));
        CassandraPartition[] partitions = (CassandraPartition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokenRangeGroups)).map((Function1 & Serializable & scala.Serializable)group -> {
            Set replicas = (Set)((TraversableOnce)group.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.replicas(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> (Set)x$7.intersect((GenSet)x$8));
            BigInt rowCount = (BigInt)((TraversableOnce)group.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.rangeSize(), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.BigIntIsIntegral$.MODULE$);
            Seq cqlRanges = (Seq)group.flatMap((Function1 & Serializable & scala.Serializable)range -> this.rangeToCql((TokenRange)range), Seq$.MODULE$.canBuildFrom());
            return new CassandraPartition(0, (Iterable<InetAddress>)replicas, cqlRanges, rowCount.toLong());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CassandraPartition.class)));
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).sortBy((Function1 & Serializable & scala.Serializable)p -> new Tuple2.mcIJ.sp(p.endpoints().size(), -p.dataSize()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$)))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CassandraPartition p = (CassandraPartition)tuple2._1();
            int index = tuple2._2$mcI$sp();
            CassandraPartition cassandraPartition = p.copy(index, p.copy$default$2(), p.copy$default$3(), p.copy$default$4());
            return cassandraPartition;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public <Key> Option<CassandraPartitioner<Key, V, T>> partitioner(ColumnSelector keyMapper, ClassTag<Key> evidence$1, RowWriterFactory<Key> evidence$2) {
        Try part;
        block0: {
            part = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                CassandraPartitioner newPartitioner = new CassandraPartitioner($this.connector, $this.tableDef, this.partitions(), keyMapper, evidence$1, evidence$2, $this.tokenFactory);
                newPartitioner.verify(false);
                return newPartitioner;
            });
            if (!part.isFailure()) break block0;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Not able to automatically create a partitioner: ").append(((Throwable)part.failed().get()).getMessage()).toString());
        }
        return part.toOption();
    }

    public CassandraPartitionGenerator(CassandraConnector connector, TableDef tableDef, int splitCount, TokenFactory<V, T> tokenFactory) {
        this.connector = connector;
        this.tableDef = tableDef;
        this.splitCount = splitCount;
        this.tokenFactory = tokenFactory;
        Logging.$init$(this);
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
    }
}

