/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.PartitionKeyColumns$;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.BucketingRangeIndex;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartition;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitioner$;
import com.datastax.spark.connector.rdd.partitioner.MonotonicBucketing;
import com.datastax.spark.connector.rdd.partitioner.TokenGenerator;
import com.datastax.spark.connector.rdd.partitioner.TokenRangeWithPartitionIndex;
import com.datastax.spark.connector.rdd.partitioner.TokenRangeWithPartitionIndex$;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc!B\u0011#\u0001\u0019r\u0003\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011\u0002!\t\u0011\u001d\u0003!\u0011!Q\u0001\n\u0005C\u0001\u0002\u0013\u0001\u0003\u0006\u0004%I!\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0015\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003Q\u0011!I\bA!b\u0001\n\u0003Q\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u0015\u0005\u0005\u0001AaA!\u0002\u0017\t\u0019\u0001\u0003\u0006\u0002\u0016\u0001\u0011\t\u0011)A\u0006\u0003/A!\"a\u000b\u0001\u0005\u0003\u0005\u000b1BA\u0017\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u0015\u0005U\u0003\u0001#b\u0001\n\u0013\t9\u0006\u0003\u0006\u0002z\u0001A)\u0019!C\u0005\u0003wB!\"a#\u0001\u0011\u000b\u0007I\u0011BAG\u0011\u001d\t)\n\u0001C\u0001\u0003/C\u0011\"!+\u0001#\u0003%\t!a+\t\u0015\u0005\u0005\u0007\u0001#b\u0001\n\u0013\t\u0019-\u0002\u0004\u0002N\u0002!\u0011q\u001a\u0005\u000b\u0003+\u0004\u0001R1A\u0005\n\u0005]\u0007BCAq\u0001!\u0015\r\u0011\"\u0003\u0002d\"9\u0011Q\u001e\u0001\u0005B\u0005=\bbBA~\u0001\u0011\u0005\u0013Q \u0005\b\u0003\u007f\u0004A\u0011\tB\u0001\u0011\u001d\u00119\u0001\u0001C!\u0005\u00139!Ba\u0003#\u0003\u0003E\tA\nB\u0007\r%\t#%!A\t\u0002\u0019\u0012y\u0001C\u0004\u00024u!\tA!\b\t\u0013\t}Q$%A\u0005\u0002\t\u0005\u0002\"\u0003B\u001a;\u0005\u0005I\u0011\u0002B\u001b\u0005Q\u0019\u0015m]:b]\u0012\u0014\u0018\rU1si&$\u0018n\u001c8fe*\u00111\u0005J\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u0002&M\u0005\u0019!\u000f\u001a3\u000b\u0005\u001dB\u0013!C2p]:,7\r^8s\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u0005AA-\u0019;bgR\f\u0007PC\u0001.\u0003\r\u0019w.\\\u000b\u0006_\u0005EAm\\\n\u0004\u0001AJ\u0004CA\u00198\u001b\u0005\u0011$BA\u00154\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005a\u0012$a\u0003)beRLG/[8oKJ\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0014\u0002\tU$\u0018\u000e\\\u0005\u0003}m\u0012q\u0001T8hO&twm\u0001\u0001\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001\u0012\u0014\u0002\u0007\r\fH.\u0003\u0002G\u0007\n\u00112)Y:tC:$'/Y\"p]:,7\r^8s\u0003)\u0019wN\u001c8fGR|'\u000fI\u0001\ti\u0006\u0014G.\u001a#fMV\t!\n\u0005\u0002C\u0017&\u0011Aj\u0011\u0002\t)\u0006\u0014G.\u001a#fM\u0006IA/\u00192mK\u0012+g\rI\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001cX#\u0001)\u0011\u0007E[fL\u0004\u0002S1:\u00111KV\u0007\u0002)*\u0011QkP\u0001\u0007yI|w\u000e\u001e \n\u0003]\u000bQa]2bY\u0006L!!\u0017.\u0002\u000fA\f7m[1hK*\tq+\u0003\u0002];\n\u00191+Z9\u000b\u0005eS\u0006\u0003B0aE:l\u0011AI\u0005\u0003C\n\u0012!cQ1tg\u0006tGM]1QCJ$\u0018\u000e^5p]B\u00111\r\u001a\u0007\u0001\t\u0015)\u0007A1\u0001g\u0005\u00051\u0016CA4l!\tA\u0017.D\u0001[\u0013\tQ'LA\u0004O_RD\u0017N\\4\u0011\u0005!d\u0017BA7[\u0005\r\te.\u001f\t\u0003G>$Q\u0001\u001d\u0001C\u0002E\u0014\u0011\u0001V\t\u0003OJ\u00042a\u001d<c\u001b\u0005!(BA;#\u0003\r!\u0007\u000e^\u0005\u0003oR\u0014Q\u0001V8lK:\f1\u0002]1si&$\u0018n\u001c8tA\u0005Q1.Z=NCB\u0004\u0018N\\4\u0016\u0003m\u0004\"\u0001`?\u000e\u0003\u0019J!A \u0014\u0003\u001d\r{G.^7o'\u0016dWm\u0019;pe\u0006Y1.Z=NCB\u0004\u0018N\\4!\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003\u000b\tY!a\u0004\u000e\u0005\u0005\u001d!bAA\u00055\u00069!/\u001a4mK\u000e$\u0018\u0002BA\u0007\u0003\u000f\u0011\u0001b\u00117bgN$\u0016m\u001a\t\u0004G\u0006EAABA\n\u0001\t\u0007aMA\u0002LKf\f1A]<g!\u0019\tI\"a\b\u0002\u00105\u0011\u00111\u0004\u0006\u0004\u0003;1\u0013AB<sSR,'/\u0003\u0003\u0002\"\u0005m!\u0001\u0005*po^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:zQ\rQ\u0011Q\u0005\t\u0004Q\u0006\u001d\u0012bAA\u00155\nIAO]1og&,g\u000e^\u0001\ri>\\WM\u001c$bGR|'/\u001f\t\u0006g\u0006=\"M\\\u0005\u0004\u0003c!(\u0001\u0004+pW\u0016tg)Y2u_JL\u0018A\u0002\u001fj]&$h\b\u0006\u0006\u00028\u0005\u0005\u00131IA#\u0003\u000f\"\u0002\"!\u000f\u0002<\u0005u\u0012q\b\t\u0007?\u0002\tyA\u00198\t\u000f\u0005\u0005A\u0002q\u0001\u0002\u0004!9\u0011Q\u0003\u0007A\u0004\u0005]\u0001bBA\u0016\u0019\u0001\u000f\u0011Q\u0006\u0005\u0006O1\u0001\r!\u0011\u0005\u0006\u00112\u0001\rA\u0013\u0005\u0006\u001d2\u0001\r\u0001\u0015\u0005\bs2\u0001\n\u00111\u0001|\u000319\u0018\u000e\u001e5UC\ndW\rR3g)\u0011\tI$!\u0014\t\u000b!k\u0001\u0019\u0001&\u0002\u001d]LG\u000f[&fs6\u000b\u0007\u000f]5oOR!\u0011\u0011HA*\u0011\u0015Ih\u00021\u0001|\u0003E\u0001\u0018M\u001d;ji&|gnS3z\u001d\u0006lWm]\u000b\u0003\u00033\u0002b!a\u0017\u0002f\u0005%TBAA/\u0015\u0011\ty&!\u0019\u0002\u0013%lW.\u001e;bE2,'bAA25\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\u0004'\u0016$\b\u0003BA6\u0003grA!!\u001c\u0002pA\u00111KW\u0005\u0004\u0003cR\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002v\u0005]$AB*ue&twMC\u0002\u0002ri\u000b1\u0003]1si&$\u0018n\u001c8LKfl\u0015\r\u001d9j]\u001e,\"!! \u0011\r\u0005}\u0014\u0011QAC\u001b\t\t\t'\u0003\u0003\u0002\u0004\u0006\u0005$AC%oI\u0016DX\rZ*fcB\u0019A0a\"\n\u0007\u0005%eEA\u0005D_2,XN\u001c*fM\u0006\u0011\u0002/\u0019:uSRLwN\\&fs^\u0013\u0018\u000e^3s+\t\ty\t\u0005\u0004\u0002\u001a\u0005E\u0015qB\u0005\u0005\u0003'\u000bYBA\u0005S_^<&/\u001b;fe\u00061a/\u001a:jMf$B!!'\u0002 B\u0019\u0001.a'\n\u0007\u0005u%L\u0001\u0003V]&$\b\"CAQ%A\u0005\t\u0019AAR\u0003\rawn\u001a\t\u0004Q\u0006\u0015\u0016bAAT5\n9!i\\8mK\u0006t\u0017\u0001\u0005<fe&4\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiK\u000b\u0003\u0002$\u0006=6FAAY!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m&,\u0001\u0006b]:|G/\u0019;j_:LA!a0\u00026\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001dQ|7.\u001a8HK:,'/\u0019;peV\u0011\u0011Q\u0019\t\u0006?\u0006\u001d\u0017qB\u0005\u0004\u0003\u0013\u0014#A\u0004+pW\u0016tw)\u001a8fe\u0006$xN\u001d\u0015\u0004)\u0005\u0015\"aA%U%B)q,!5c]&\u0019\u00111\u001b\u0012\u00039Q{7.\u001a8SC:<WmV5uQB\u000b'\u000f^5uS>t\u0017J\u001c3fq\u0006\u0011\u0012N\u001c3fq\u0016$Gk\\6f]J\u000bgnZ3t+\t\tI\u000e\u0005\u0003R7\u0006m\u0007cAAo+5\t\u0001\u0001K\u0002\u0017\u0003K\tQ\u0003^8lK:\u0014\u0016M\\4f\u0019>|7.\u001e9UC\ndW-\u0006\u0002\u0002fB1q,a:\u0002\\:L1!!;#\u0005M\u0011UoY6fi&twMU1oO\u0016Le\u000eZ3yQ\r9\u0012QE\u0001\rO\u0016$\b+\u0019:uSRLwN\u001c\u000b\u0005\u0003c\f9\u0010E\u0002i\u0003gL1!!>[\u0005\rIe\u000e\u001e\u0005\u0007\u0003sD\u0002\u0019A6\u0002\u0007-,\u00170A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003c\fa!Z9vC2\u001cH\u0003BAR\u0005\u0007AaA!\u0002\u001b\u0001\u0004Y\u0017\u0001\u0002;iCR\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003c\fAcQ1tg\u0006tGM]1QCJ$\u0018\u000e^5p]\u0016\u0014\bCA0\u001e'\u0015i\"\u0011\u0003B\f!\rA'1C\u0005\u0004\u0005+Q&AB!osJ+g\rE\u0002i\u00053I1Aa\u0007[\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011i!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\t\u0005G\u00119C!\u000b\u0003,U\u0011!Q\u0005\u0016\u0004w\u0006=FABA\n?\t\u0007a\rB\u0003f?\t\u0007a\r\u0002\u0004q?\t\u0007!QF\t\u0004O\n=\u0002\u0003B:w\u0005c\u00012a\u0019B\u0015\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t]\u0002\u0003\u0002B\u001d\u0005\u0007j!Aa\u000f\u000b\t\tu\"qH\u0001\u0005Y\u0006twM\u0003\u0002\u0003B\u0005!!.\u0019<b\u0013\u0011\u0011)Ea\u000f\u0003\r=\u0013'.Z2u\u0001")
public class CassandraPartitioner<Key, V, T extends Token<V>>
extends Partitioner
implements Logging {
    private Set<String> partitionKeyNames;
    private IndexedSeq<ColumnRef> partitionKeyMapping;
    private RowWriter<Key> partitionKeyWriter;
    private transient TokenGenerator<Key> tokenGenerator;
    private transient Seq<TokenRangeWithPartitionIndex<V, T>> indexedTokenRanges;
    private transient BucketingRangeIndex<TokenRangeWithPartitionIndex<V, T>, T> tokenRangeLookupTable;
    private final CassandraConnector connector;
    private final TableDef tableDef;
    private final Seq<CassandraPartition<V, T>> partitions;
    private final ColumnSelector keyMapping;
    private final ClassTag<Key> evidence$1;
    private final transient RowWriterFactory<Key> rwf;
    private final TokenFactory<V, T> tokenFactory;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static <Key, V, T extends Token<V>> ColumnSelector $lessinit$greater$default$4() {
        return CassandraPartitioner$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private CassandraConnector connector() {
        return this.connector;
    }

    private TableDef tableDef() {
        return this.tableDef;
    }

    public Seq<CassandraPartition<V, T>> partitions() {
        return this.partitions;
    }

    public ColumnSelector keyMapping() {
        return this.keyMapping;
    }

    public CassandraPartitioner<Key, V, T> withTableDef(TableDef tableDef) {
        String string = tableDef.keyspaceName();
        String string2 = this.tableDef().keyspaceName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("Cannot apply partitioner from keyspace\n           |").append(this.tableDef().keyspaceName()).append(" to table\n           |").append(tableDef.keyspaceName()).append(".").append(tableDef.tableName()).append(" because the keyspaces do\n           |not match").toString())).stripMargin());
        }
        return new CassandraPartitioner<Key, V, T>(this.connector(), tableDef, this.partitions(), this.keyMapping(), this.evidence$1, this.rwf, this.tokenFactory);
    }

    public CassandraPartitioner<Key, V, T> withKeyMapping(ColumnSelector keyMapping) {
        return new CassandraPartitioner<Key, V, T>(this.connector(), this.tableDef(), this.partitions(), keyMapping, this.evidence$1, this.rwf, this.tokenFactory);
    }

    private Set<String> partitionKeyNames$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.partitionKeyNames = ((TraversableOnce)PartitionKeyColumns$.MODULE$.selectFrom(this.tableDef()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.columnName(), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.partitionKeyNames;
    }

    private Set<String> partitionKeyNames() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.partitionKeyNames$lzycompute() : this.partitionKeyNames;
    }

    private IndexedSeq<ColumnRef> partitionKeyMapping$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.partitionKeyMapping = (IndexedSeq)this.keyMapping().selectFrom(this.tableDef()).filter((Function1 & Serializable & scala.Serializable)colRef -> BoxesRunTime.boxToBoolean((boolean)CassandraPartitioner.$anonfun$partitionKeyMapping$1(this, colRef)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.partitionKeyMapping;
    }

    private IndexedSeq<ColumnRef> partitionKeyMapping() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.partitionKeyMapping$lzycompute() : this.partitionKeyMapping;
    }

    private RowWriter<Key> partitionKeyWriter$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("Building Partitioner with mapping\n         |").append(this.partitionKeyMapping().map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)x.columnName(), (Object)x.selectedAs()), scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).append("\n         |for table ").append(this.tableDef()).toString())).stripMargin());
                this.partitionKeyWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(this.rwf)).rowWriter(this.tableDef(), this.partitionKeyMapping());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.partitionKeyWriter;
    }

    private RowWriter<Key> partitionKeyWriter() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.partitionKeyWriter$lzycompute() : this.partitionKeyWriter;
    }

    public void verify(boolean log) {
        Try attempt = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.partitionKeyWriter());
        if (attempt.isFailure()) {
            if (log) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to build partition key writer CassandraPartitioner.", (Throwable)attempt.failed().get());
            }
            throw (Throwable)attempt.failed().get();
        }
    }

    public boolean verify$default$1() {
        return true;
    }

    private TokenGenerator<Key> tokenGenerator$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.tokenGenerator = new TokenGenerator<Key>(this.connector(), this.tableDef(), this.partitionKeyWriter());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.tokenGenerator;
    }

    private TokenGenerator<Key> tokenGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tokenGenerator$lzycompute() : this.tokenGenerator;
    }

    private Seq<TokenRangeWithPartitionIndex<V, T>> indexedTokenRanges$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.indexedTokenRanges = (Seq)this.partitions().flatMap((Function1 & Serializable & scala.Serializable)p -> (Iterable)p.tokenRanges().map((Function1 & Serializable & scala.Serializable)tr -> new TokenRangeWithPartitionIndex(tr.range(), p.index()), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.indexedTokenRanges;
    }

    private Seq<TokenRangeWithPartitionIndex<V, T>> indexedTokenRanges() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.indexedTokenRanges$lzycompute() : this.indexedTokenRanges;
    }

    private BucketingRangeIndex<TokenRangeWithPartitionIndex<V, T>, T> tokenRangeLookupTable$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                Ordering<T> tokenOrdering = this.tokenFactory.tokenOrdering();
                MonotonicBucketing<T> tokenBucketing = this.tokenFactory.tokenBucketing();
                this.tokenRangeLookupTable = new BucketingRangeIndex<TokenRangeWithPartitionIndex<V, T>, T>(this.indexedTokenRanges(), TokenRangeWithPartitionIndex$.MODULE$.rangeBounds(this.tokenFactory), tokenOrdering, tokenBucketing);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.tokenRangeLookupTable;
    }

    private BucketingRangeIndex<TokenRangeWithPartitionIndex<V, T>, T> tokenRangeLookupTable() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.tokenRangeLookupTable$lzycompute() : this.tokenRangeLookupTable;
    }

    public int getPartition(Object key) {
        Object object = key;
        Option option = this.evidence$1.unapply(object);
        if (option.isEmpty() || !(option.get() instanceof Object)) {
            throw new IllegalArgumentException(new StringBuilder(39).append("Couldn't determine the key from object ").append(object).toString());
        }
        com.datastax.driver.core.Token driverToken = this.tokenGenerator().getTokenFor(object);
        T connectorToken = this.tokenFactory.tokenFromString(driverToken.getValue().toString());
        int n = ((TokenRangeWithPartitionIndex)this.tokenRangeLookupTable().rangesContaining(connectorToken).head()).partitionIndex();
        return n;
    }

    public int numPartitions() {
        return this.partitions().length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof CassandraPartitioner)) return false;
        CassandraPartitioner cassandraPartitioner = (CassandraPartitioner)object;
        Seq<TokenRangeWithPartitionIndex<V, T>> seq = this.indexedTokenRanges();
        Seq<TokenRangeWithPartitionIndex<V, T>> seq2 = cassandraPartitioner.indexedTokenRanges();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        String string = this.tableDef().keyspaceName();
        String string2 = cassandraPartitioner.tableDef().keyspaceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        CassandraConnector cassandraConnector = this.connector();
        CassandraConnector cassandraConnector2 = cassandraPartitioner.connector();
        if (cassandraConnector == null) {
            if (cassandraConnector2 == null) return true;
            return false;
        } else {
            if (!cassandraConnector.equals(cassandraConnector2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return this.indexedTokenRanges().hashCode() + this.tableDef().keyspaceName().hashCode() * 31;
    }

    public static final /* synthetic */ boolean $anonfun$partitionKeyMapping$1(CassandraPartitioner $this, ColumnRef colRef) {
        return $this.partitionKeyNames().contains((Object)colRef.columnName());
    }

    public CassandraPartitioner(CassandraConnector connector, TableDef tableDef, Seq<CassandraPartition<V, T>> partitions, ColumnSelector keyMapping, ClassTag<Key> evidence$1, RowWriterFactory<Key> rwf, TokenFactory<V, T> tokenFactory) {
        this.connector = connector;
        this.tableDef = tableDef;
        this.partitions = partitions;
        this.keyMapping = keyMapping;
        this.evidence$1 = evidence$1;
        this.rwf = rwf;
        this.tokenFactory = tokenFactory;
        Logging.$init$(this);
    }
}

