/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartition;
import com.datastax.spark.connector.rdd.partitioner.TokenGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0012%\u0001EB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005{!A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!I\u0003A!b\u0001\n\u0003)\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011u\u0003!\u0011!Q\u0001\fyC\u0001b\u001c\u0001\u0003\u0002\u0003\u0006Y\u0001\u001d\u0005\u0006u\u0002!\ta\u001f\u0005\n\u0003\u001b\u0001!\u0019!C\u0001\u0003\u001fA\u0001\"a\u0006\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u00033\u0001!\u0019!C\u0001\u00037A\u0001\"a\t\u0001A\u0003%\u0011Q\u0004\u0005\f\u0003K\u0001\u0001R1A\u0005\u0002)\n9\u0003\u0003\u0006\u00022\u0001A)\u0019!C\u0005\u0003gA!\"a\u0012\u0001\u0011\u000b\u0007I\u0011BA%\u0011)\t\u0019\u0006\u0001EC\u0002\u0013%\u0011Q\u000b\u0005\n\u0003c\u0002!\u0019!C\u0005\u0003gB\u0001\"a$\u0001A\u0003%\u0011Q\u000f\u0005\n\u0003#\u0003!\u0019!C\u0005\u0003'C\u0001\"a'\u0001A\u0003%\u0011Q\u0013\u0005\n\u0003;\u0003!\u0019!C\u0005\u0003?Cq!!)\u0001A\u0003%A\nC\u0005\u0002$\u0002\u0011\r\u0011\"\u0003\u0002&\"A\u0011Q\u0018\u0001!\u0002\u0013\t9\u000bC\u0005\u0002@\u0002\u0011\r\u0011\"\u0003\u0002B\"A\u0011\u0011\u001a\u0001!\u0002\u0013\t\u0019\rC\u0005\u0002L\u0002\u0011\r\u0011\"\u0003\u0002N\"A\u0011\u0011\u001b\u0001!\u0002\u0013\ty\rC\u0004\u0002T\u0002!I!!6\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"9\u0011q\u001d\u0001\u0005B\u0005%\bbBAx\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003c\u0004A\u0011AAz\u0005I\u0011V\r\u001d7jG\u0006\u0004\u0016M\u001d;ji&|g.\u001a:\u000b\u0005\u00152\u0013a\u00039beRLG/[8oKJT!a\n\u0015\u0002\u0007I$GM\u0003\u0002*U\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\u0011\u0011\fG/Y:uCbT\u0011aL\u0001\u0004G>l7\u0001A\u000b\u0003e\u0019\u001c\"\u0001A\u001a\u0011\u0005QRT\"A\u001b\u000b\u0005-2$BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001eL!aO\u001b\u0003\u0017A\u000b'\u000f^5uS>tWM]\u0001\u0006i\u0006\u0014G.\u001a\t\u0003}\u001ds!aP#\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t\u0003\u0014A\u0002\u001fs_>$hHC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$D\u0003!YW-_:qC\u000e,\u0017a\u00069beRLG/[8ogB+'OU3qY&\u001c\u0017mU3u!\tie*D\u0001D\u0013\ty5IA\u0002J]R\f!\u0003]1si&$\u0018n\u001c8LKfl\u0015\r\u001d9feB\u0011!kU\u0007\u0002Q%\u0011A\u000b\u000b\u0002\u000f\u0007>dW/\u001c8TK2,7\r^8s+\u00051\u0006CA,[\u001b\u0005A&BA-)\u0003\r\u0019\u0017\u000f\\\u0005\u00037b\u0013!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\u0006Q1m\u001c8oK\u000e$xN\u001d\u0011\u0002\u0017\r,(O]3oiRK\b/\u001a\t\u0004?\n$W\"\u00011\u000b\u0005\u0005\u001c\u0015a\u0002:fM2,7\r^\u0005\u0003G\u0002\u0014\u0001b\u00117bgN$\u0016m\u001a\t\u0003K\u001ad\u0001\u0001B\u0003h\u0001\t\u0007\u0001NA\u0001U#\tIG\u000e\u0005\u0002NU&\u00111n\u0011\u0002\b\u001d>$\b.\u001b8h!\tiU.\u0003\u0002o\u0007\n\u0019\u0011I\\=\u0002\u0007I<h\rE\u0002ri\u0012l\u0011A\u001d\u0006\u0003g\"\naa\u001e:ji\u0016\u0014\u0018BA;s\u0005A\u0011vn^,sSR,'OR1di>\u0014\u0018\u0010\u000b\u0002\toB\u0011Q\n_\u0005\u0003s\u000e\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\rqJg.\u001b;?)-a\u00181AA\u0003\u0003\u000f\tI!a\u0003\u0015\tu|\u0018\u0011\u0001\t\u0004}\u0002!W\"\u0001\u0013\t\u000buK\u00019\u00010\t\u000b=L\u00019\u00019\t\u000bqJ\u0001\u0019A\u001f\t\u000b)K\u0001\u0019A\u001f\t\u000b-K\u0001\u0019\u0001'\t\u000bAK\u0001\u0019A)\t\u000b%J\u0001\u0019\u0001,\u0002\u0011Q\f'\r\\3EK\u001a,\"!!\u0005\u0011\u0007]\u000b\u0019\"C\u0002\u0002\u0016a\u0013\u0001\u0002V1cY\u0016$UMZ\u0001\ni\u0006\u0014G.\u001a#fM\u0002\n\u0011B]8x/JLG/\u001a:\u0016\u0005\u0005u\u0001\u0003B9\u0002 \u0011L1!!\ts\u0005%\u0011vn^,sSR,'/\u0001\u0006s_^<&/\u001b;fe\u0002\na\u0002^8lK:<UM\\3sCR|'/\u0006\u0002\u0002*A!a0a\u000be\u0013\r\ti\u0003\n\u0002\u000f)>\\WM\\$f]\u0016\u0014\u0018\r^8sQ\tqq/\u0001\u0005nKR\fG-\u0019;b+\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\t\r|'/\u001a\u0006\u0004\u0003\u007fa\u0013A\u00023sSZ,'/\u0003\u0003\u0002D\u0005e\"\u0001C'fi\u0006$\u0017\r^1)\u0005=9\u0018a\u00049s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005-\u0003\u0003BA\u001c\u0003\u001bJA!a\u0014\u0002:\ty\u0001K]8u_\u000e|GNV3sg&|g\u000e\u000b\u0002\u0011o\u0006)1\r\\1{uV\u0011\u0011q\u000b\u0019\u0005\u00033\nY\u0007\u0005\u0004\u0002\\\u0005\u0015\u0014\u0011N\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005!A.\u00198h\u0015\t\t\u0019'\u0001\u0003kCZ\f\u0017\u0002BA4\u0003;\u0012Qa\u00117bgN\u00042!ZA6\t)\ti'EA\u0001\u0002\u0003\u0015\t\u0001\u001b\u0002\u0004?\u0012\n\u0004FA\tx\u0003\u0015Awn\u001d;t+\t\t)\b\u0005\u0004\u0002x\u0005u\u00141\u0011\b\u0004\u001b\u0006e\u0014bAA>\u0007\u00069\u0001/Y2lC\u001e,\u0017\u0002BA@\u0003\u0003\u0013aAV3di>\u0014(bAA>\u0007B!\u0011QQAF\u001b\t\t9I\u0003\u0003\u0002\n\u0006\u0005\u0014a\u00018fi&!\u0011QRAD\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\u0002\r!|7\u000f^:!\u0003\u001dAwn\u001d;TKR,\"!!&\u0011\u000by\n9*a!\n\u0007\u0005e\u0015JA\u0002TKR\f\u0001\u0002[8tiN+G\u000fI\u0001\t]Vl\u0007j\\:ugV\tA*A\u0005ok6Dun\u001d;tA\u0005\u0001\u0002/\u0019:uSRLwN\\%oI\u0016DXm]\u000b\u0003\u0003O\u0003b!a\u001e\u0002*\u00065\u0016\u0002BAV\u0003\u0003\u0013A\u0001T5tiB)\u0011qVA]\u00196\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),A\u0005j[6,H/\u00192mK*\u0019\u0011qW\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0006E&AC%oI\u0016DX\rZ*fc\u0006\t\u0002/\u0019:uSRLwN\\%oI\u0016DXm\u001d\u0011\u0002\u000f!|7\u000f^'baV\u0011\u00111\u0019\t\t\u0003_\u000b)-a!\u0002.&!\u0011qYAY\u0005\ri\u0015\r]\u0001\tQ>\u001cH/T1qA\u0005A\u0011N\u001c3fq6\u000b\u0007/\u0006\u0002\u0002PB9\u0011qVAc\u0019\u0006\r\u0015!C5oI\u0016DX*\u00199!\u0003%\t'm]'pIVdw\u000eF\u0003M\u0003/\fY\u000e\u0003\u0004\u0002Zz\u0001\r\u0001T\u0001\tI&4\u0018\u000eZ3oI\"1\u0011Q\u001c\u0010A\u00021\u000bq\u0001Z5wSN|'/\u0001\u0006sC:$w.\u001c%pgR$B!a!\u0002d\"1\u0011Q]\u0010A\u00021\u000bQ!\u001b8eKb\fAbZ3u!\u0006\u0014H/\u001b;j_:$2\u0001TAv\u0011\u0019\ti\u000f\ta\u0001Y\u0006\u00191.Z=\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0003Q9W\r^#oIB|\u0017N\u001c;QCJ$\u0018\u000e^5p]R!\u0011Q_A~!\rq\u0018q_\u0005\u0004\u0003s$#\u0001\u0005*fa2L7-\u0019)beRLG/[8o\u0011\u001d\tiP\ta\u0001\u0003\u007f\f\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0007Q\u0012\t!C\u0002\u0003\u0004U\u0012\u0011\u0002U1si&$\u0018n\u001c8")
public class ReplicaPartitioner<T>
extends Partitioner {
    private transient TokenGenerator<T> tokenGenerator;
    private transient Metadata metadata;
    private transient ProtocolVersion protocolVersion;
    private transient Class<?> clazz;
    private final String keyspace;
    private final int partitionsPerReplicaSet;
    private final CassandraConnector connector;
    private final ClassTag<T> currentType;
    private final TableDef tableDef;
    private final RowWriter<T> rowWriter;
    private final Vector<InetAddress> hosts;
    private final scala.collection.immutable.Set<InetAddress> hostSet;
    private final int numHosts;
    private final List<IndexedSeq<Object>> partitionIndexes;
    private final Map<InetAddress, IndexedSeq<Object>> hostMap;
    private final Map<Object, InetAddress> indexMap;
    private volatile transient byte bitmap$trans$0;

    public CassandraConnector connector() {
        return this.connector;
    }

    public TableDef tableDef() {
        return this.tableDef;
    }

    public RowWriter<T> rowWriter() {
        return this.rowWriter;
    }

    private TokenGenerator<T> tokenGenerator$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.tokenGenerator = new TokenGenerator<T>(this.connector(), this.tableDef(), this.rowWriter());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.tokenGenerator;
    }

    public TokenGenerator<T> tokenGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tokenGenerator$lzycompute() : this.tokenGenerator;
    }

    private Metadata metadata$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.metadata = (Metadata)this.connector().withClusterDo((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getMetadata());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.metadata;
    }

    private Metadata metadata() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.metadata$lzycompute() : this.metadata;
    }

    private ProtocolVersion protocolVersion$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.protocolVersion = (ProtocolVersion)((Object)this.connector().withClusterDo((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getConfiguration().getProtocolOptions().getProtocolVersion()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.protocolVersion;
    }

    private ProtocolVersion protocolVersion() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.protocolVersion$lzycompute() : this.protocolVersion;
    }

    private Class<?> clazz$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.currentType)).runtimeClass();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.clazz;
    }

    private Class<?> clazz() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.clazz$lzycompute() : this.clazz;
    }

    private Vector<InetAddress> hosts() {
        return this.hosts;
    }

    private scala.collection.immutable.Set<InetAddress> hostSet() {
        return this.hostSet;
    }

    private int numHosts() {
        return this.numHosts;
    }

    private List<IndexedSeq<Object>> partitionIndexes() {
        return this.partitionIndexes;
    }

    private Map<InetAddress, IndexedSeq<Object>> hostMap() {
        return this.hostMap;
    }

    private Map<Object, InetAddress> indexMap() {
        return this.indexMap;
    }

    private int absModulo(int dividend, int divisor) {
        return Math.abs(dividend % divisor);
    }

    private InetAddress randomHost(int index) {
        return (InetAddress)this.hosts().apply(this.absModulo(index, this.hosts().length()));
    }

    public int getPartition(Object key) {
        int n;
        Object object = key;
        Option option = this.currentType.unapply(object);
        if (!option.isEmpty() && option.get() instanceof Object && this.clazz().isInstance(object)) {
            ByteBuffer keyBuffer = this.tokenGenerator().getPartitionKeyBufferFor(object);
            int keyHash = Math.abs(keyBuffer.hashCode());
            Set replicas = (Set)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(this.metadata().getReplicas(this.keyspace, keyBuffer)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getBroadcastAddress(), Set$.MODULE$.canBuildFrom());
            Vector replicaSetInDC = ((TraversableOnce)this.hostSet().$amp((GenSet)replicas)).toVector();
            if (replicaSetInDC.nonEmpty()) {
                InetAddress endpoint = (InetAddress)replicaSetInDC.apply(this.absModulo(keyHash, replicaSetInDC.size()));
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)endpoint)).apply(this.absModulo(keyHash, this.partitionsPerReplicaSet)));
            } else {
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)this.randomHost(keyHash))).apply(this.absModulo(keyHash, this.partitionsPerReplicaSet)));
            }
        } else {
            throw new IllegalArgumentException(new StringBuilder(119).append("ReplicaPartitioner can only determine the partition of a tuple whose key is a non-empty Set[InetAddress]. ").append("Invalid key: ").append(key).toString());
        }
        int n2 = n;
        return n2;
    }

    public int numPartitions() {
        return this.partitionsPerReplicaSet * this.numHosts();
    }

    public ReplicaPartition getEndpointPartition(Partition partition) {
        InetAddress endpoints = (InetAddress)this.indexMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)partition.index()), (Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(45).append(this.indexMap()).append(" : Can't get an endpoint for Partition ").append(partition).append(".index").toString());
        });
        return new ReplicaPartition(partition.index(), (scala.collection.immutable.Set<InetAddress>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{endpoints}))));
    }

    public static final /* synthetic */ boolean $anonfun$indexMap$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$indexMap$3(InetAddress ip$1, int partition) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ip$1);
    }

    public ReplicaPartitioner(String table, String keyspace, int partitionsPerReplicaSet, ColumnSelector partitionKeyMapper, CassandraConnector connector, ClassTag<T> currentType, RowWriterFactory<T> rwf) {
        this.keyspace = keyspace;
        this.partitionsPerReplicaSet = partitionsPerReplicaSet;
        this.connector = connector;
        this.currentType = currentType;
        this.tableDef = Schema$.MODULE$.tableFromCassandra(connector, keyspace, table);
        this.rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(rwf)).rowWriter(this.tableDef(), partitionKeyMapper.selectFrom(this.tableDef()));
        this.hosts = connector.hosts().toVector();
        this.hostSet = connector.hosts();
        this.numHosts = this.hosts().size();
        this.partitionIndexes = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionsPerReplicaSet * this.numHosts()).grouped(partitionsPerReplicaSet).toList();
        this.hostMap = ((TraversableOnce)this.hosts().zip(this.partitionIndexes(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.indexMap = (Map)this.hostMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaPartitioner.$anonfun$indexMap$1(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InetAddress ip = (InetAddress)tuple2._1();
            IndexedSeq partitions = (IndexedSeq)tuple2._2();
            IndexedSeq indexedSeq = (IndexedSeq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> ReplicaPartitioner.$anonfun$indexMap$3(ip, BoxesRunTime.unboxToInt((Object)partition)), IndexedSeq$.MODULE$.canBuildFrom());
            return indexedSeq;
        }, Map$.MODULE$.canBuildFrom());
    }
}

