/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3\u0011BB\u0004\u0011\u0002\u0007\u0005\u0011b\u0005(\t\u000bm\u0001A\u0011A\u000f\t\u0011\u0005\u0002\u0001R1A\u0005\u0004\tBQa\u000e\u0001\u0005\naBa\u0001\u0010\u0001\u0005\u0002%i\u0004\"B!\u0001\t\u0003\u0011%AE*qY&$8+\u001b>f\u000bN$\u0018.\\1u_JT!\u0001C\u0005\u0002\u0017A\f'\u000f^5uS>tWM\u001d\u0006\u0003\u0015-\t1A\u001d3e\u0015\taQ\"A\u0005d_:tWm\u0019;pe*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\t\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0002%\u0005\u00191m\\7\u0016\u0005Q)5C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A%\u001b8ji\u0012\u001a\u0001\u0001F\u0001\u001f!\t1r$\u0003\u0002!/\t!QK\\5u\u00031!xn[3o\r\u0006\u001cGo\u001c:z+\u0005\u0019\u0003\u0003\u0002\u0013(SAj\u0011!\n\u0006\u0003M\u001d\t1\u0001\u001a5u\u0013\tASE\u0001\u0007U_.,gNR1di>\u0014\u0018\u0010\u0005\u0002+[9\u0011AeK\u0005\u0003Y\u0015\nA\u0002V8lK:4\u0015m\u0019;pefL!AL\u0018\u0003\u0003YS!\u0001L\u0013\u0011\u0005)\n\u0014B\u0001\u001a0\u0005\u0005!\u0006F\u0001\u00025!\t1R'\u0003\u00027/\tIAO]1og&,g\u000e^\u0001\u0011KN$\u0018.\\1uK\u0012\u000bG/Y*ju\u0016,\u0012!\u000f\t\u0003-iJ!aO\f\u0003\t1{gnZ\u0001\u0012[&t\u0017.\\1m'Bd\u0017\u000e^\"pk:$X#\u0001 \u0011\u0005Yy\u0014B\u0001!\u0018\u0005\rIe\u000e^\u0001\u0013KN$\u0018.\\1uKN\u0003H.\u001b;D_VtG\u000f\u0006\u0002?\u0007\")A)\u0002a\u0001s\u0005I1\u000f\u001d7jiNK'0\u001a\u0003\u0006\r\u0002\u0011\ra\u0012\u0002\u0002%F\u0011\u0001j\u0013\t\u0003-%K!AS\f\u0003\u000f9{G\u000f[5oOB\u0011a\u0003T\u0005\u0003\u001b^\u00111!\u00118z%\ry\u0015+\u0016\u0004\u0005!\u0002\u0001aJ\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002S\u0001Mk\u0011a\u0002\t\u0003)\u0016c\u0001\u0001E\u0002W/Nk\u0011!C\u0005\u00031&\u0011AbQ1tg\u0006tGM]1S\t\u0012\u0003")
public interface SplitSizeEstimator<R> {
    public static /* synthetic */ TokenFactory tokenFactory$(SplitSizeEstimator $this) {
        return $this.tokenFactory();
    }

    default public TokenFactory<Object, Token> tokenFactory() {
        return TokenFactory$.MODULE$.forSystemLocalPartitioner(((CassandraRDD)((Object)this)).connector());
    }

    private long estimateDataSize() {
        return new DataSizeEstimates<Object, Token>(((CassandraRDD)((Object)this)).connector(), ((CassandraRDD)((Object)this)).keyspaceName(), ((CassandraRDD)((Object)this)).tableName(), this.tokenFactory()).dataSizeInBytes();
    }

    public static /* synthetic */ int minimalSplitCount$(SplitSizeEstimator $this) {
        return $this.minimalSplitCount();
    }

    default public int minimalSplitCount() {
        int coreCount = ((RDD)this).context().defaultParallelism();
        return 1 + coreCount * 2;
    }

    public static /* synthetic */ int estimateSplitCount$(SplitSizeEstimator $this, long splitSize) {
        return $this.estimateSplitCount(splitSize);
    }

    default public int estimateSplitCount(long splitSize) {
        int n;
        Predef$.MODULE$.require(splitSize > 0L, (Function0 & java.io.Serializable & Serializable)() -> "Split size must be greater than zero.");
        if (this.estimateDataSize() == Long.MAX_VALUE || this.estimateDataSize() < 0L) {
            ((Logging)this).logWarning((Function0 & java.io.Serializable & Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(355).append("Size Estimates has overflowed and calculated that the data size is Infinite.\n        |Falling back to ").append(this.minimalSplitCount()).append(" (2 * SparkCores + 1) Split Count.\n        |This is most likely occurring because you are reading size_estimates\n        |from a DataCenter which has very small primary ranges. Explicitly set\n        |the splitCount when reading to manually adjust this.").toString())).stripMargin());
            n = this.minimalSplitCount();
        } else {
            long splitCountEstimate = this.estimateDataSize() / splitSize;
            n = Math.max((int)splitCountEstimate, this.minimalSplitCount());
        }
        return n;
    }

    public static void $init$(SplitSizeEstimator $this) {
    }
}

