/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.util;

import com.datastax.spark.connector.cql.AuthConfFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.util.ConfigCheck$;
import com.datastax.spark.connector.util.ConfigParameter;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;

public final class RefBuilder$ {
    public static RefBuilder$ MODULE$;
    private final String Header;
    private final String Footer;
    private final String HtmlTableHeader;
    private final Set<ConfigParameter<?>> allConfigs;

    static {
        new RefBuilder$();
    }

    public String Header() {
        return this.Header;
    }

    public String Footer() {
        return this.Footer;
    }

    public String HtmlTableHeader() {
        return this.HtmlTableHeader;
    }

    public Set<ConfigParameter<?>> allConfigs() {
        return this.allConfigs;
    }

    public String getMarkDown() {
        Map configBySection = this.allConfigs().groupBy((Function1 & Serializable & scala.Serializable)x -> x.section());
        Seq sections = (Seq)configBySection.keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        Seq markdown = (Seq)sections.map((Function1 & Serializable & scala.Serializable)section -> {
            Set parameters = (Set)configBySection.get(section).get();
            String paramTable = ((TraversableOnce)((List)parameters.toList().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Object object;
                ConfigParameter configParameter;
                ConfigParameter configParameter2 = x0$1;
                if (configParameter2 != null) {
                    configParameter = configParameter2;
                    Object t = configParameter.default();
                    if (t instanceof CassandraConnectionFactory) {
                        Object t2 = t;
                        object = new StringOps(Predef$.MODULE$.augmentString(t2.getClass().getSimpleName())).stripSuffix("$");
                    } else if (t instanceof AuthConfFactory) {
                        Object t3 = t;
                        object = new StringOps(Predef$.MODULE$.augmentString(t3.getClass().getSimpleName())).stripSuffix("$");
                    } else if (t instanceof Seq) {
                        Object t4 = t;
                        object = ((TraversableOnce)t4).mkString(",");
                    } else if (t instanceof Some) {
                        Object defaultValue;
                        Some some = (Some)t;
                        object = defaultValue = some.value();
                    } else {
                        object = None$.MODULE$.equals(t) ? None$.MODULE$ : t;
                    }
                } else {
                    throw new MatchError((Object)configParameter2);
                }
                String string = object;
                String string2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("<tr>\n            |  <td><code>").append(new StringOps(Predef$.MODULE$.augmentString(configParameter.name())).stripPrefix("spark.cassandra.")).append("</code></td>\n            |  <td>").append((Object)string).append("</td>\n            |  <td>").append(configParameter.description()).append("</td>\n            |</tr>").toString())).stripMargin();
                return string2;
            }, List$.MODULE$.canBuildFrom())).mkString("\n");
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(151).append("\n         |## ").append((String)section).append("\n         |**All parameters should be prefixed with <code> spark.cassandra. </code>**\n         |\n         |").append(MODULE$.HtmlTableHeader()).append("\n         |").append(paramTable).append("\n         |</table>").toString())).stripMargin();
        }, Seq$.MODULE$.canBuildFrom());
        return new StringBuilder(0).append(this.Header()).append(markdown.mkString("\n\n")).append(this.Footer()).toString();
    }

    private RefBuilder$() {
        MODULE$ = this;
        this.Header = new StringOps(Predef$.MODULE$.augmentString("# Configuration Reference\n      |\n      |\n    ")).stripMargin();
        this.Footer = "\n";
        this.HtmlTableHeader = new StringOps(Predef$.MODULE$.augmentString("<table class=\"table\">\n      |<tr><th>Property Name</th><th>Default</th><th>Description</th></tr>")).stripMargin();
        this.allConfigs = ConfigCheck$.MODULE$.validStaticProperties();
    }
}

