/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.util;

import com.datastax.spark.connector.util.Reflect$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.ImplicitTags;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Mirrors;
import scala.reflect.api.Names;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ReflectionUtil$ {
    public static ReflectionUtil$ MODULE$;
    private final JavaUniverse.JavaMirror rm;
    private final TrieMap<String, Object> singletonCache;

    static {
        new ReflectionUtil$();
    }

    private JavaUniverse.JavaMirror rm() {
        return this.rm;
    }

    private TrieMap<String, Object> singletonCache() {
        return this.singletonCache;
    }

    private <T> Try<T> findScalaObject(String objectName, TypeTags.TypeTag<T> evidence$1) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Types.TypeApi targetType = ((TypeTags.WeakTypeTag)Predef$.MODULE$.implicitly((Object)evidence$1)).tpe();
            Symbols.ModuleSymbolApi module = ((Mirror)MODULE$.rm()).staticModule(objectName);
            if (!module.typeSignature().$less$colon$less(targetType)) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Object ").append(objectName).append(" is not instance of ").append(targetType).toString());
            }
            Mirrors.ModuleMirror moduleMirror = MODULE$.rm().reflectModule(module);
            return moduleMirror.instance();
        });
    }

    private <T> Try<T> findSingletonClassInstance(String className, TypeTags.TypeTag<T> evidence$2) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Types.TypeApi targetType = ((TypeTags.WeakTypeTag)Predef$.MODULE$.implicitly((Object)evidence$2)).tpe();
            Class targetClass = (Class)MODULE$.rm().runtimeClass(targetType.typeSymbol().asClass());
            Option option = MODULE$.singletonCache().get((Object)className);
            if (option instanceof Some) {
                Object obj;
                Some some = (Some)option;
                object = obj = some.value();
            } else if (None$.MODULE$.equals(option)) {
                Object object2;
                Object newInstance = Class.forName(className).getConstructor((Class[])Array$.MODULE$.empty(package$.MODULE$.universe().RuntimeClassTag())).newInstance(new Object[0]);
                Option option2 = MODULE$.singletonCache().putIfAbsent((Object)className, newInstance);
                if (None$.MODULE$.equals(option2)) {
                    object2 = newInstance;
                } else if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Object previousInstance = some.value();
                    object2 = previousInstance;
                } else {
                    throw new MatchError((Object)option2);
                }
                object = object2;
            } else {
                throw new MatchError((Object)option);
            }
            Object instance = object;
            if (!targetClass.isInstance(instance)) {
                throw new IllegalArgumentException(new StringBuilder(14).append("Class ").append(className).append(" is not ").append(targetType).toString());
            }
            return instance;
        });
    }

    public <T> T findGlobalObject(String objectName, TypeTags.TypeTag<T> evidence$3) {
        Object obj;
        Try<T> classInstance;
        Try<T> scalaObject = this.findScalaObject(objectName, evidence$3);
        Try try_ = scalaObject.orElse(() -> ReflectionUtil$.$anonfun$findGlobalObject$1(classInstance = this.findSingletonClassInstance(objectName, evidence$3)));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new IllegalArgumentException(new StringBuilder(32).append("Singleton object not available: ").append(objectName).toString(), e);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Object object = obj = success.value();
        return (T)object;
    }

    public Seq<Tuple2<String, Types.TypeApi>> constructorParams(Types.TypeApi tpe) {
        Symbols.MethodSymbolApi ctorSymbol = Reflect$.MODULE$.methodSymbol(tpe);
        Types.MethodTypeApi ctorMethod = (Types.MethodTypeApi)ctorSymbol.typeSignatureIn(tpe);
        return (Seq)ctorMethod.params().map((Function1 & Serializable & scala.Serializable)param -> new Tuple2((Object)param.name().toString(), (Object)param.typeSignature()), List$.MODULE$.canBuildFrom());
    }

    public <T> Seq<Tuple2<String, Types.TypeApi>> constructorParams(TypeTags.TypeTag<T> evidence$4) {
        return this.constructorParams(((TypeTags.WeakTypeTag)Predef$.MODULE$.implicitly(evidence$4)).tpe());
    }

    public Seq<Tuple2<String, Types.TypeApi>> getters(Types.TypeApi tpe) {
        Seq methods = (Seq)tpe.members().toSeq().withFilter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)ReflectionUtil$.$anonfun$getters$1(d))).map((Function1 & Serializable & scala.Serializable)d -> d.asMethod(), Seq$.MODULE$.canBuildFrom());
        return (Seq)methods.withFilter((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean((boolean)g.isGetter())).map((Function1 & Serializable & scala.Serializable)g -> {
            Types.TypeApi returnType = ((Types.NullaryMethodTypeApi)g.typeSignatureIn(tpe)).resultType();
            return new Tuple2((Object)g.name().toString(), (Object)returnType);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <T> Seq<Tuple2<String, Types.TypeApi>> getters(TypeTags.TypeTag<T> evidence$5) {
        return this.getters(((TypeTags.WeakTypeTag)Predef$.MODULE$.implicitly(evidence$5)).tpe());
    }

    public Types.TypeApi method(Types.TypeApi tpe, String methodName) {
        Symbols.SymbolApi member;
        Predef$.MODULE$.require(methodName != null, (Function0 & Serializable & scala.Serializable)() -> "Method name must not be null");
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(methodName)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Method name must not be empty");
        Symbols.SymbolApi symbolApi = member = tpe.member((Names.NameApi)((Names)package$.MODULE$.universe()).newTermName(methodName));
        Symbols.SymbolApi symbolApi2 = ((Symbols)package$.MODULE$.universe()).NoSymbol();
        Predef$.MODULE$.require(symbolApi == null ? symbolApi2 != null : !symbolApi.equals(symbolApi2), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Member ").append(methodName).append(" not found in ").append(tpe).toString());
        Predef$.MODULE$.require(member.isMethod(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Member ").append(methodName).append(" of type ").append(tpe).append(" is not a method").toString());
        return member.asMethod().typeSignatureIn(tpe);
    }

    public Seq<Types.TypeApi> methodParamTypes(Types.TypeApi tpe, String methodName) {
        Seq seq;
        Types.TypeApi typeApi = this.method(tpe, methodName);
        Option option = ((ImplicitTags)package$.MODULE$.universe()).MethodTypeTag().unapply((Object)typeApi);
        if (!option.isEmpty() && option.get() != null) {
            seq = (Seq)((Types.MethodTypeApi)typeApi).params().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.typeSignature(), List$.MODULE$.canBuildFrom());
        } else {
            Option option2 = ((ImplicitTags)package$.MODULE$.universe()).NullaryMethodTypeTag().unapply((Object)typeApi);
            if (!option2.isEmpty() && option2.get() != null) {
                seq = (Seq)Seq$.MODULE$.empty();
            } else {
                throw new MatchError((Object)typeApi);
            }
        }
        return seq;
    }

    public Types.TypeApi returnType(Types.TypeApi tpe, String methodName) {
        Types.TypeApi typeApi;
        Types.TypeApi typeApi2 = this.method(tpe, methodName);
        Option option = ((ImplicitTags)package$.MODULE$.universe()).MethodTypeTag().unapply((Object)typeApi2);
        if (!option.isEmpty() && option.get() != null) {
            typeApi = ((Types.MethodTypeApi)typeApi2).resultType();
        } else {
            Option option2 = ((ImplicitTags)package$.MODULE$.universe()).NullaryMethodTypeTag().unapply((Object)typeApi2);
            if (!option2.isEmpty() && option2.get() != null) {
                typeApi = ((Types.NullaryMethodTypeApi)typeApi2).resultType();
            } else {
                throw new MatchError((Object)typeApi2);
            }
        }
        return typeApi;
    }

    public Seq<Tuple2<String, Types.TypeApi>> setters(Types.TypeApi tpe) {
        Seq methods = (Seq)tpe.members().toSeq().withFilter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)ReflectionUtil$.$anonfun$setters$1(d))).map((Function1 & Serializable & scala.Serializable)d -> d.asMethod(), Seq$.MODULE$.canBuildFrom());
        return (Seq)methods.withFilter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.isSetter())).map((Function1 & Serializable & scala.Serializable)s -> {
            Types.TypeApi paramType = ((Symbols.SymbolApi)((Types.MethodTypeApi)s.typeSignatureIn(tpe)).params().head()).typeSignature();
            return new Tuple2((Object)s.name().toString(), (Object)paramType);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <T> Seq<Tuple2<String, Types.TypeApi>> setters(TypeTags.TypeTag<T> evidence$6) {
        return this.setters(((TypeTags.WeakTypeTag)Predef$.MODULE$.implicitly(evidence$6)).tpe());
    }

    public <T> TypeTags.TypeTag<T> typeToTypeTag(Types.TypeApi tpe) {
        JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        return ((TypeTags)package$.MODULE$.universe()).TypeTag().apply((Mirror)mirror, new TypeCreator(mirror, tpe){
            private final JavaUniverse.JavaMirror mirror$1;
            private final Types.TypeApi tpe$4;

            public <U extends Universe> Types.TypeApi apply(Mirror<U> m) {
                Predef$.MODULE$.assert(m == this.mirror$1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("TypeTag[").append($this.tpe$4).append("] defined in ").append($this.mirror$1).append(" cannot be migrated to ").append(m).append(".").toString());
                return this.tpe$4;
            }
            {
                this.mirror$1 = mirror$1;
                this.tpe$4 = tpe$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(com.datastax.spark.connector.util.ReflectionUtil$$anon$1 scala.reflect.api.Mirror )}, serializedLambda);
            }
        });
    }

    public <T> ClassTag<T> classTag(TypeTags.TypeTag<T> evidence$7) {
        return ClassTag$.MODULE$.apply((Class)((Mirrors.RuntimeMirror)((TypeTags)package$.MODULE$.universe()).typeTag(evidence$7).mirror()).runtimeClass(((TypeTags)package$.MODULE$.universe()).typeTag(evidence$7).tpe()));
    }

    public boolean isScalaTuple(Symbols.SymbolApi symbol) {
        return symbol.fullName().startsWith("scala.Tuple");
    }

    public boolean isScalaTuple(Types.TypeApi tpe) {
        return this.isScalaTuple(tpe.typeSymbol());
    }

    public static final /* synthetic */ Try $anonfun$findGlobalObject$1(Try classInstance$1) {
        return classInstance$1;
    }

    public static final /* synthetic */ boolean $anonfun$getters$1(Symbols.SymbolApi d) {
        return d.isMethod() && d.isPublic();
    }

    public static final /* synthetic */ boolean $anonfun$setters$1(Symbols.SymbolApi d) {
        return d.isMethod() && d.isPublic();
    }

    private ReflectionUtil$() {
        MODULE$ = this;
        this.rm = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        this.singletonCache = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

