/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.exceptions.BusyPoolException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.AsyncExecutor$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.concurrent.TrieMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Try;
import scala.util.Try$;
import shade.com.datastax.spark.connector.google.common.util.concurrent.FutureCallback;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Futures;
import shade.com.datastax.spark.connector.google.common.util.concurrent.ListenableFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.SettableFuture;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u000b\u0017\u0001\u0005B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003R\u0011\u0015Q\u0006\u0001\"\u0001}\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\u0005\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\u0002\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0010\u0011%\t)\u0004\u0001a\u0001\n\u0013\t9\u0004C\u0005\u0002T\u0001\u0001\r\u0011\"\u0003\u0002V!A\u00111\f\u0001!B\u0013\tI\u0004C\u0004\u0002f\u0001!\t!a\u001a\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005Mt!B,\u0017\u0011\u0003Af!B\u000b\u0017\u0011\u0003I\u0006\"\u0002.\u0012\t\u0003YV\u0001\u0002/\u0012\u0001uCq![\t\u0012\u0002\u0013\u0005!NA\u0007Bgft7-\u0012=fGV$xN\u001d\u0006\u0003/a\taa\u001e:ji\u0016\u0014(BA\r\u001b\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\u001c9\u0005)1\u000f]1sW*\u0011QDH\u0001\tI\u0006$\u0018m\u001d;bq*\tq$A\u0002d_6\u001c\u0001!F\u0002#k)\u001b2\u0001A\u0012*!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!&L\u0007\u0002W)\u0011A\u0006G\u0001\u0005kRLG.\u0003\u0002/W\t9Aj\\4hS:<\u0017aC1ts:\u001c\u0017i\u0019;j_:\u0004B\u0001J\u00194}%\u0011!'\n\u0002\n\rVt7\r^5p]F\u0002\"\u0001N\u001b\r\u0001\u0011)a\u0007\u0001b\u0001o\t\tA+\u0005\u00029wA\u0011A%O\u0005\u0003u\u0015\u0012qAT8uQ&tw\r\u0005\u0002%y%\u0011Q(\n\u0002\u0004\u0003:L\bcA H\u00136\t\u0001I\u0003\u0002B\u0005\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00051\u001a%B\u0001#F\u0003\u0019\u0019w.\\7p]*\u0011aIH\u0001\u0007O>|w\r\\3\n\u0005!\u0003%\u0001\u0005'jgR,g.\u00192mK\u001a+H/\u001e:f!\t!$\nB\u0003L\u0001\t\u0007qGA\u0001S\u0003Ii\u0017\r_\"p]\u000e,(O]3oiR\u000b7o[:\u0011\u0005\u0011r\u0015BA(&\u0005\rIe\u000e^\u0001\u000fgV\u001c7-Z:t\u0011\u0006tG\r\\3s!\r!#\u000bV\u0005\u0003'\u0016\u0012aa\u00149uS>t\u0007cA+\u0014g9\u0011a\u000bE\u0007\u0002-\u0005i\u0011i]=oG\u0016CXmY;u_J\u0004\"AV\t\u0014\u0005E\u0019\u0013A\u0002\u001fj]&$h\bF\u0001Y\u0005\u001dA\u0015M\u001c3mKJ,\"A\u00182\u0011\r\u0011z\u0016mY2g\u0013\t\u0001WEA\u0005Gk:\u001cG/[8ogA\u0011AG\u0019\u0003\u0006mM\u0011\ra\u000e\t\u0003I\u0011L!!Z\u0013\u0003\t1{gn\u001a\t\u0003I\u001dL!\u0001[\u0013\u0003\tUs\u0017\u000e^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0007-L(0F\u0001mU\ti\u0007O\u0004\u0002%]&\u0011q.J\u0001\u0005\u001d>tWmK\u0001r!\t\u0011x/D\u0001t\u0015\t!X/A\u0005v]\u000eDWmY6fI*\u0011a/J\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001=t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006mQ\u0011\ra\u000e\u0003\u0006\u0017R\u0011\raN\u0001\u000fM\u0006LG.\u001e:f\u0011\u0006tG\r\\3s)\u001dihp`A\u0001\u0003\u0007\u0001BA\u0016\u00014\u0013\")q&\u0002a\u0001a!)A*\u0002a\u0001\u001b\"9\u0001+\u0002I\u0001\u0002\u0004\t\u0006\"B>\u0006\u0001\u0004\t\u0016!C:f[\u0006\u0004\bn\u001c:f+\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\r\t\u0015q\u0002\u0006\u0004Y\u0005E!BAA\n\u0003\u0011Q\u0017M^1\n\t\u0005]\u0011Q\u0002\u0002\n'\u0016l\u0017\r\u001d5pe\u0016\f!b]3nCBDwN]3!\u00039\u0001XM\u001c3j]\u001e4U\u000f^;sKN,\"!a\b\u0011\u000f\u0005\u0005\u0012\u0011\u0006 \u0002.5\u0011\u00111\u0005\u0006\u0004\u0003\u0006\u0015\"bAA\u0014K\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u00121\u0005\u0002\b)JLW-T1q!\r!\u0013qF\u0005\u0004\u0003c)#a\u0002\"p_2,\u0017M\\\u0001\u0010a\u0016tG-\u001b8h\rV$XO]3tA\u0005yA.\u0019;fgR,\u0005pY3qi&|g.\u0006\u0002\u0002:A!AEUA\u001e!\u0011\ti$!\u0014\u000f\t\u0005}\u0012\u0011\n\b\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0011\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013bAA&K\u00059\u0001/Y2lC\u001e,\u0017\u0002BA(\u0003#\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005-S%A\nmCR,7\u000f^#yG\u0016\u0004H/[8o?\u0012*\u0017\u000fF\u0002g\u0003/B\u0011\"!\u0017\f\u0003\u0003\u0005\r!!\u000f\u0002\u0007a$\u0013'\u0001\tmCR,7\u000f^#yG\u0016\u0004H/[8oA!\u001aA\"a\u0018\u0011\u0007\u0011\n\t'C\u0002\u0002d\u0015\u0012\u0001B^8mCRLG.Z\u0001\u0013O\u0016$H*\u0019;fgR,\u0005pY3qi&|g\u000e\u0006\u0002\u0002:\u0005aQ\r_3dkR,\u0017i]=oGR\u0019a(!\u001c\t\r\u0005=d\u00021\u00014\u0003\u0011!\u0018m]6\u0002=]\f\u0017\u000e\u001e$pe\u000e+(O]3oi2LX\t_3dkRLgn\u001a+bg.\u001cH#\u00014")
public class AsyncExecutor<T, R>
implements Logging {
    private final Function1<T, ListenableFuture<R>> asyncAction;
    public final Option<Function3<T, Object, Object, BoxedUnit>> com$datastax$spark$connector$writer$AsyncExecutor$$successHandler;
    public final Option<Function3<T, Object, Object, BoxedUnit>> com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler;
    private final Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    private final TrieMap<ListenableFuture<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;
    private volatile Option<Throwable> com$datastax$spark$connector$writer$AsyncExecutor$$latestException;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public static <T, R> None$ $lessinit$greater$default$3() {
        return AsyncExecutor$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    }

    public TrieMap<ListenableFuture<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;
    }

    private Option<Throwable> com$datastax$spark$connector$writer$AsyncExecutor$$latestException() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException;
    }

    public void com$datastax$spark$connector$writer$AsyncExecutor$$latestException_$eq(Option<Throwable> x$1) {
        this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException = x$1;
    }

    public Option<Throwable> getLatestException() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException();
    }

    public ListenableFuture<R> executeAsync(T task) {
        long submissionTimestamp = System.nanoTime();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().acquire();
        SettableFuture settable = SettableFuture.create();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().put(settable, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        long executionTimestamp = System.nanoTime();
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(task, settable, submissionTimestamp, executionTimestamp);
    }

    public void waitForCurrentlyExecutingTasks() {
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().snapshot().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AsyncExecutor.$anonfun$waitForCurrentlyExecutingTasks$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ListenableFuture future = (ListenableFuture)tuple2._1();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> future.get());
            return try_;
        });
    }

    public final SettableFuture com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(Object task$1, SettableFuture settable$1, long submissionTimestamp$1, long executionTimestamp$1) {
        ListenableFuture future = (ListenableFuture)this.asyncAction.apply(task$1);
        Futures.addCallback(future, new FutureCallback<R>(this, settable$1, task$1, submissionTimestamp$1, executionTimestamp$1){
            private final /* synthetic */ AsyncExecutor $outer;
            private final SettableFuture settable$1;
            private final Object task$1;
            private final long submissionTimestamp$1;
            private final long executionTimestamp$1;

            private void release() {
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().release();
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().remove((Object)this.settable$1);
            }

            public void onSuccess(R result) {
                this.release();
                this.settable$1.set(result);
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$successHandler.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    $anon$1.$anonfun$onSuccess$1(this, x$1);
                    return BoxedUnit.UNIT;
                });
            }

            public void onFailure(Throwable throwable) {
                NoHostAvailableException noHostAvailableException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof NoHostAvailableException && ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((noHostAvailableException = (NoHostAvailableException)throwable2).getErrors()).asScala()).values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onFailure$1(x$2)))) {
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BusyPoolException ... Retrying");
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(this.task$1, this.settable$1, this.submissionTimestamp$1, this.executionTimestamp$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Failed to execute: ").append($this.task$1).toString(), throwable);
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$latestException_$eq((Option<Throwable>)new Some((Object)throwable));
                    this.release();
                    this.settable$1.setException(throwable);
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                        $anon$1.$anonfun$onFailure$4(this, x$3);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public static final /* synthetic */ void $anonfun$onSuccess$1($anon$1 $this, Function3 x$1) {
                x$1.apply($this.task$1, (Object)BoxesRunTime.boxToLong((long)$this.submissionTimestamp$1), (Object)BoxesRunTime.boxToLong((long)$this.executionTimestamp$1));
            }

            public static final /* synthetic */ boolean $anonfun$onFailure$1(Throwable x$2) {
                return x$2 instanceof BusyPoolException;
            }

            public static final /* synthetic */ void $anonfun$onFailure$4($anon$1 $this, Function3 x$3) {
                x$3.apply($this.task$1, (Object)BoxesRunTime.boxToLong((long)$this.submissionTimestamp$1), (Object)BoxesRunTime.boxToLong((long)$this.executionTimestamp$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.settable$1 = settable$1;
                this.task$1 = task$1;
                this.submissionTimestamp$1 = submissionTimestamp$1;
                this.executionTimestamp$1 = executionTimestamp$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onSuccess$1$adapted(com.datastax.spark.connector.writer.AsyncExecutor$$anon$1 scala.Function3 ), $anonfun$onFailure$1$adapted(java.lang.Throwable ), $anonfun$onFailure$2(), $anonfun$onFailure$3(com.datastax.spark.connector.writer.AsyncExecutor$$anon$1 ), $anonfun$onFailure$4$adapted(com.datastax.spark.connector.writer.AsyncExecutor$$anon$1 scala.Function3 )}, serializedLambda);
            }
        });
        return settable$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForCurrentlyExecutingTasks$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public AsyncExecutor(Function1<T, ListenableFuture<R>> asyncAction, int maxConcurrentTasks, Option<Function3<T, Object, Object, BoxedUnit>> successHandler, Option<Function3<T, Object, Object, BoxedUnit>> failureHandler) {
        this.asyncAction = asyncAction;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$successHandler = successHandler;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler = failureHandler;
        Logging.$init$(this);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore = new Semaphore(maxConcurrentTasks);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures = new TrieMap();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException = None$.MODULE$;
    }
}

